/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkPiecewiseFunctionShiftScale.h,v $
  Language:  C++
  Date:      $Date: 2005/03/11 02:32:16 $
  Version:   $Revision: 1.1 $

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

// .NAME vtkPiecewiseFunctionShiftScale -
// 
// .SECTION Description

#ifndef __vtkPiecewiseFunctionShiftScale_h
#define __vtkPiecewiseFunctionShiftScale_h

#include "vtkPiecewiseFunctionToPiecewiseFunctionFilter.h"

class vtkPiecewiseFunction;

class VTK_FILTERING_EXPORT vtkPiecewiseFunctionShiftScale : public vtkPiecewiseFunctionToPiecewiseFunctionFilter
{
public:
  static vtkPiecewiseFunctionShiftScale *New();
  vtkTypeRevisionMacro(vtkPiecewiseFunctionShiftScale, vtkPiecewiseFunctionToPiecewiseFunctionFilter);
  void PrintSelf(ostream& os, vtkIndent indent);
  
  vtkSetMacro(PositionShift, float);
  vtkSetMacro(PositionScale, float);
  vtkSetMacro(ValueShift, float);
  vtkSetMacro(ValueScale, float);
  
  vtkGetMacro(PositionShift, float);
  vtkGetMacro(PositionScale, float);
  vtkGetMacro(ValueShift, float);
  vtkGetMacro(ValueScale, float);
  
protected:
  vtkPiecewiseFunctionShiftScale();
  ~vtkPiecewiseFunctionShiftScale();
  
  void Execute();
  
  vtkPiecewiseFunction *Input;
  
  float PositionShift;
  float PositionScale;
  float ValueShift;
  float ValueScale;
  
private:
  vtkPiecewiseFunctionShiftScale(const vtkPiecewiseFunctionShiftScale&);  // Not implemented
  void operator=(const vtkPiecewiseFunctionShiftScale&);  // Not implemented
};

#endif
