class NameNode
UDEFS = {
  "Au" => "astronomical_unit",  "Bq" => "s-1",  "C" => "A.s",
  "F" => "C/V",  "G" => "gauss",  "Gal" => "cm s-2",  "Gy" => "J.kg-1",
  "H" => "Wb.A-1",  "Hz" => "1/s",  "J" => "N.m",  "L" => "litre",
  "N" => "kg.m.s-2",  "P" => "poise",  "Pa" => "N.m-2",  "S" => "A/V",
  "St" => "stokes",  "Sv" => "J.kg-1",  "T" => "Wb.m-2",  "V" => "J/C",
  "W" => "J/s",  "Wb" => "V.s",  "a" => "are",  "ac" => "acre",
  "acre" => "10 chain2",  "ampere" => "A",  "angstrom" => "1.0e-10 m",
  "are" => "100 m2",  "astronomical_unit" => "1.49597870e11 m",
  "astronomical_units" => "1.49597870e11 m",  "atm" => "atmosphere",
  "atmosphere" => "101325 Pa",  "bar" => "1e6 dyn.cm-2",
  "cal" => "calorie",  "calorie" => "4.18605 J",
  "century" => "100 year",  "chain" => "22 yard",  "coulomb" => "C",
  "d" => "24 hour",  "day" => "24 hour",  "degree" => "pi.rad/180",
  "degree_C" => "K @ 273.15",  "degree_E" => "degree",
  "degree_F" => "degree_R @ 459.67",  "degree_N" => "degree",
  "degree_R" => "K / 1.8",  "degree_S" => "degree",
  "degree_W" => "degree",  "degree_c" => "K @ 273.15",
  "degree_f" => "degree_R @ 459.67",  "dyn" => "g.cm.s-2",
  "dyne" => "g.cm.s-2",  "erg" => "dyn cm",  "feet" => "foot",
  "fermi" => "1.0e-15 m",  "foot" => "12 inch",
  "force" => "9.80665 m.s-2",  "g" => "kg/1000",  "gal" => "cm s-2",
  "gauss" => "T / 10000",  "gram" => "kg/1000",  "h" => "60 min",
  "hectare" => "100 are",  "hertz" => "Hz",
  "horse_power" => "75 m kilogram-force / s",  "hour" => "60 min",
  "hr" => "60 min",  "in" => "inch",  "inch" => "2.54 cm",
  "joule" => "J",  "kelvin" => "K",  "kgf" => "kilogram-force",
  "kilogram" => "kg",  "knot" => "nautical_mile / hour",
  "kph" => "km / hour",  "lb" => "pound",
  "light_speed" => "299792458 m/s",  "light_year" => "9.46e15 m",
  "light_years" => "9.46e15 m",  "litre" => "1.0e-3 m3",
  "lm" => "cd.sr",  "lx" => "lm.m-2",  "ly" => "light_year",
  "mb" => "bar / 1000",  "meter" => "metre",  "metre" => "m",
  "mgal" => "cm s-2 / 1000",  "micron" => "1.0e-6 m",
  "mile" => "1760 yard",  "min" => "60 s",  "minute" => "60 s",
  "minute_angle" => "pi.rad/180/60",  "mole" => "mol",
  "mon" => "month",  "month" => "6 pentad",  "mph" => "mile / hour",
  "nautical_mile" => "1852 m",  "nautical_miles" => "1852 m",
  "newton" => "N",  "ohm" => "V/A",  "ounce" => "pound / 16",
  "oz" => "ounce",  "parsec" => "3.0857e16 m",  "pascal" => "Pa",
  "pc" => "parsec",  "pi" => "3.141592653589793238462",
  "poise" => "dyn s / cm2",  "pound" => "453.6 g",
  "psi" => "pound-force / inch2",  "radian" => "rad",  "second" => "s",
  "second_angle" => "pi.rad/180/60/60",  "steradian" => "sr",
  "stokes" => "cm2 / s",  "t" => "ton",  "ton" => "1000 kg",
  "tonne" => "ton",  "torr" => "133.322 Pa",  "volt" => "V",
  "watt" => "W",  "yard" => "6 feet",  "yd" => "yard",
  "year" => "12 month",  "yr" => "year",
}
UALIASES = {
  "EA" => [18, "A"],  "EAu" => [18, "Au"],  "EBq" => [18, "Bq"],
  "EC" => [18, "C"],  "EF" => [18, "F"],  "EG" => [18, "G"],
  "EGal" => [18, "Gal"],  "EGy" => [18, "Gy"],  "EH" => [18, "H"],
  "EHz" => [18, "Hz"],  "EJ" => [18, "J"],  "EK" => [18, "K"],
  "EL" => [18, "L"],  "EN" => [18, "N"],  "EP" => [18, "P"],
  "EPa" => [18, "Pa"],  "ES" => [18, "S"],  "ESt" => [18, "St"],
  "ESv" => [18, "Sv"],  "ET" => [18, "T"],  "EV" => [18, "V"],
  "EW" => [18, "W"],  "EWb" => [18, "Wb"],  "Ea" => [18, "a"],
  "Eac" => [18, "ac"],  "Eatm" => [18, "atm"],  "Ebar" => [18, "bar"],
  "Ecal" => [18, "cal"],  "Ed" => [18, "d"],  "Edyn" => [18, "dyn"],
  "Eerg" => [18, "erg"],  "Eforce" => [18, "force"],  "Eg" => [18, "g"],
  "Eh" => [18, "h"],  "Ehr" => [18, "hr"],  "Ein" => [18, "in"],
  "Ekg" => [18, "kg"],  "Ekgf" => [18, "kgf"],  "Ekph" => [18, "kph"],
  "Elb" => [18, "lb"],  "Elm" => [18, "lm"],  "Elx" => [18, "lx"],
  "Ely" => [18, "ly"],  "Em" => [18, "m"],  "Emb" => [18, "mb"],
  "Emgal" => [18, "mgal"],  "Emin" => [18, "min"],
  "Emol" => [18, "mol"],  "Emon" => [18, "mon"],  "Emph" => [18, "mph"],
  "Eohm" => [18, "ohm"],  "Eoz" => [18, "oz"],  "Epc" => [18, "pc"],
  "Epsi" => [18, "psi"],  "Erad" => [18, "rad"],  "Es" => [18, "s"],
  "Esr" => [18, "sr"],  "Et" => [18, "t"],  "Eyr" => [18, "yr"],
  "GA" => [9, "A"],  "GAu" => [9, "Au"],  "GBq" => [9, "Bq"],
  "GC" => [9, "C"],  "GF" => [9, "F"],  "GG" => [9, "G"],
  "GGal" => [9, "Gal"],  "GGy" => [9, "Gy"],  "GH" => [9, "H"],
  "GHz" => [9, "Hz"],  "GJ" => [9, "J"],  "GK" => [9, "K"],
  "GL" => [9, "L"],  "GN" => [9, "N"],  "GP" => [9, "P"],
  "GPa" => [9, "Pa"],  "GS" => [9, "S"],  "GSt" => [9, "St"],
  "GSv" => [9, "Sv"],  "GT" => [9, "T"],  "GV" => [9, "V"],
  "GW" => [9, "W"],  "GWb" => [9, "Wb"],  "Ga" => [9, "a"],
  "Gac" => [9, "ac"],  "Gatm" => [9, "atm"],  "Gbar" => [9, "bar"],
  "Gcal" => [9, "cal"],  "Gd" => [9, "d"],  "Gdyn" => [9, "dyn"],
  "Gerg" => [9, "erg"],  "Gforce" => [9, "force"],  "Gg" => [9, "g"],
  "Gh" => [9, "h"],  "Ghr" => [9, "hr"],  "Gin" => [9, "in"],
  "Gkg" => [9, "kg"],  "Gkgf" => [9, "kgf"],  "Gkph" => [9, "kph"],
  "Glb" => [9, "lb"],  "Glm" => [9, "lm"],  "Glx" => [9, "lx"],
  "Gly" => [9, "ly"],  "Gm" => [9, "m"],  "Gmb" => [9, "mb"],
  "Gmgal" => [9, "mgal"],  "Gmin" => [9, "min"],  "Gmol" => [9, "mol"],
  "Gmon" => [9, "mon"],  "Gmph" => [9, "mph"],  "Gohm" => [9, "ohm"],
  "Goz" => [9, "oz"],  "Gpc" => [9, "pc"],  "Gpsi" => [9, "psi"],
  "Grad" => [9, "rad"],  "Gs" => [9, "s"],  "Gsr" => [9, "sr"],
  "Gt" => [9, "t"],  "Gyr" => [9, "yr"],  "MA" => [6, "A"],
  "MAu" => [6, "Au"],  "MBq" => [6, "Bq"],  "MC" => [6, "C"],
  "MF" => [6, "F"],  "MG" => [6, "G"],  "MGal" => [6, "Gal"],
  "MGy" => [6, "Gy"],  "MH" => [6, "H"],  "MHz" => [6, "Hz"],
  "MJ" => [6, "J"],  "MK" => [6, "K"],  "ML" => [6, "L"],
  "MN" => [6, "N"],  "MP" => [6, "P"],  "MPa" => [6, "Pa"],
  "MS" => [6, "S"],  "MSt" => [6, "St"],  "MSv" => [6, "Sv"],
  "MT" => [6, "T"],  "MV" => [6, "V"],  "MW" => [6, "W"],
  "MWb" => [6, "Wb"],  "Ma" => [6, "a"],  "Mac" => [6, "ac"],
  "Matm" => [6, "atm"],  "Mbar" => [6, "bar"],  "Mcal" => [6, "cal"],
  "Md" => [6, "d"],  "Mdyn" => [6, "dyn"],  "Merg" => [6, "erg"],
  "Mforce" => [6, "force"],  "Mg" => [6, "g"],  "Mh" => [6, "h"],
  "Mhr" => [6, "hr"],  "Min" => [6, "in"],  "Mkg" => [6, "kg"],
  "Mkgf" => [6, "kgf"],  "Mkph" => [6, "kph"],  "Mlb" => [6, "lb"],
  "Mlm" => [6, "lm"],  "Mlx" => [6, "lx"],  "Mly" => [6, "ly"],
  "Mm" => [6, "m"],  "Mmb" => [6, "mb"],  "Mmgal" => [6, "mgal"],
  "Mmin" => [6, "min"],  "Mmol" => [6, "mol"],  "Mmon" => [6, "mon"],
  "Mmph" => [6, "mph"],  "Mohm" => [6, "ohm"],  "Moz" => [6, "oz"],
  "Mpc" => [6, "pc"],  "Mpsi" => [6, "psi"],  "Mrad" => [6, "rad"],
  "Ms" => [6, "s"],  "Msr" => [6, "sr"],  "Mt" => [6, "t"],
  "Myr" => [6, "yr"],  "PA" => [15, "A"],  "PAu" => [15, "Au"],
  "PBq" => [15, "Bq"],  "PC" => [15, "C"],  "PF" => [15, "F"],
  "PG" => [15, "G"],  "PGal" => [15, "Gal"],  "PGy" => [15, "Gy"],
  "PH" => [15, "H"],  "PHz" => [15, "Hz"],  "PJ" => [15, "J"],
  "PK" => [15, "K"],  "PL" => [15, "L"],  "PN" => [15, "N"],
  "PP" => [15, "P"],  "PPa" => [15, "Pa"],  "PS" => [15, "S"],
  "PSt" => [15, "St"],  "PSv" => [15, "Sv"],  "PT" => [15, "T"],
  "PV" => [15, "V"],  "PW" => [15, "W"],  "PWb" => [15, "Wb"],
  "Pa" => [15, "a"],  "Pac" => [15, "ac"],  "Patm" => [15, "atm"],
  "Pbar" => [15, "bar"],  "Pcal" => [15, "cal"],  "Pd" => [15, "d"],
  "Pdyn" => [15, "dyn"],  "Perg" => [15, "erg"],
  "Pforce" => [15, "force"],  "Pg" => [15, "g"],  "Ph" => [15, "h"],
  "Phr" => [15, "hr"],  "Pin" => [15, "in"],  "Pkg" => [15, "kg"],
  "Pkgf" => [15, "kgf"],  "Pkph" => [15, "kph"],  "Plb" => [15, "lb"],
  "Plm" => [15, "lm"],  "Plx" => [15, "lx"],  "Ply" => [15, "ly"],
  "Pm" => [15, "m"],  "Pmb" => [15, "mb"],  "Pmgal" => [15, "mgal"],
  "Pmin" => [15, "min"],  "Pmol" => [15, "mol"],  "Pmon" => [15, "mon"],
  "Pmph" => [15, "mph"],  "Pohm" => [15, "ohm"],  "Poz" => [15, "oz"],
  "Ppc" => [15, "pc"],  "Ppsi" => [15, "psi"],  "Prad" => [15, "rad"],
  "Ps" => [15, "s"],  "Psr" => [15, "sr"],  "Pt" => [15, "t"],
  "Pyr" => [15, "yr"],  "TA" => [12, "A"],  "TAu" => [12, "Au"],
  "TBq" => [12, "Bq"],  "TC" => [12, "C"],  "TF" => [12, "F"],
  "TG" => [12, "G"],  "TGal" => [12, "Gal"],  "TGy" => [12, "Gy"],
  "TH" => [12, "H"],  "THz" => [12, "Hz"],  "TJ" => [12, "J"],
  "TK" => [12, "K"],  "TL" => [12, "L"],  "TN" => [12, "N"],
  "TP" => [12, "P"],  "TPa" => [12, "Pa"],  "TS" => [12, "S"],
  "TSt" => [12, "St"],  "TSv" => [12, "Sv"],  "TT" => [12, "T"],
  "TV" => [12, "V"],  "TW" => [12, "W"],  "TWb" => [12, "Wb"],
  "Ta" => [12, "a"],  "Tac" => [12, "ac"],  "Tatm" => [12, "atm"],
  "Tbar" => [12, "bar"],  "Tcal" => [12, "cal"],  "Td" => [12, "d"],
  "Tdyn" => [12, "dyn"],  "Terg" => [12, "erg"],
  "Tforce" => [12, "force"],  "Tg" => [12, "g"],  "Th" => [12, "h"],
  "Thr" => [12, "hr"],  "Tin" => [12, "in"],  "Tkg" => [12, "kg"],
  "Tkgf" => [12, "kgf"],  "Tkph" => [12, "kph"],  "Tlb" => [12, "lb"],
  "Tlm" => [12, "lm"],  "Tlx" => [12, "lx"],  "Tly" => [12, "ly"],
  "Tm" => [12, "m"],  "Tmb" => [12, "mb"],  "Tmgal" => [12, "mgal"],
  "Tmin" => [12, "min"],  "Tmol" => [12, "mol"],  "Tmon" => [12, "mon"],
  "Tmph" => [12, "mph"],  "Tohm" => [12, "ohm"],  "Toz" => [12, "oz"],
  "Tpc" => [12, "pc"],  "Tpsi" => [12, "psi"],  "Trad" => [12, "rad"],
  "Ts" => [12, "s"],  "Tsr" => [12, "sr"],  "Tt" => [12, "t"],
  "Tyr" => [12, "yr"],  "aA" => [-18, "A"],  "aAu" => [-18, "Au"],
  "aBq" => [-18, "Bq"],  "aC" => [-18, "C"],  "aF" => [-18, "F"],
  "aG" => [-18, "G"],  "aGal" => [-18, "Gal"],  "aGy" => [-18, "Gy"],
  "aH" => [-18, "H"],  "aHz" => [-18, "Hz"],  "aJ" => [-18, "J"],
  "aK" => [-18, "K"],  "aL" => [-18, "L"],  "aN" => [-18, "N"],
  "aP" => [-18, "P"],  "aPa" => [-18, "Pa"],  "aS" => [-18, "S"],
  "aSt" => [-18, "St"],  "aSv" => [-18, "Sv"],  "aT" => [-18, "T"],
  "aV" => [-18, "V"],  "aW" => [-18, "W"],  "aWb" => [-18, "Wb"],
  "aa" => [-18, "a"],  "aac" => [-18, "ac"],  "aatm" => [-18, "atm"],
  "abar" => [-18, "bar"],  "acal" => [-18, "cal"],
  "acres" => [0, "acre"],  "ad" => [-18, "d"],  "adyn" => [-18, "dyn"],
  "aerg" => [-18, "erg"],  "aforce" => [-18, "force"],
  "ag" => [-18, "g"],  "ah" => [-18, "h"],  "ahr" => [-18, "hr"],
  "ain" => [-18, "in"],  "akg" => [-18, "kg"],  "akgf" => [-18, "kgf"],
  "akph" => [-18, "kph"],  "alb" => [-18, "lb"],  "alm" => [-18, "lm"],
  "alx" => [-18, "lx"],  "aly" => [-18, "ly"],  "am" => [-18, "m"],
  "amb" => [-18, "mb"],  "amgal" => [-18, "mgal"],
  "amin" => [-18, "min"],  "amol" => [-18, "mol"],
  "amon" => [-18, "mon"],  "amperes" => [0, "ampere"],
  "amph" => [-18, "mph"],  "angstroms" => [0, "angstrom"],
  "aohm" => [-18, "ohm"],  "aoz" => [-18, "oz"],  "apc" => [-18, "pc"],
  "apsi" => [-18, "psi"],  "arad" => [-18, "rad"],
  "ares" => [0, "are"],  "as" => [-18, "s"],  "asr" => [-18, "sr"],
  "at" => [-18, "t"],  "atmospheres" => [0, "atmosphere"],
  "attoacre" => [-18, "acre"],  "attoampere" => [-18, "ampere"],
  "attoangstrom" => [-18, "angstrom"],  "attoare" => [-18, "are"],
  "attoatmosphere" => [-18, "atmosphere"],
  "attocalorie" => [-18, "calorie"],  "attocentury" => [-18, "century"],
  "attochain" => [-18, "chain"],  "attocoulomb" => [-18, "coulomb"],
  "attoday" => [-18, "day"],  "attodegree" => [-18, "degree"],
  "attodegree_C" => [-18, "degree_C"],
  "attodegree_E" => [-18, "degree_E"],
  "attodegree_F" => [-18, "degree_F"],
  "attodegree_N" => [-18, "degree_N"],
  "attodegree_R" => [-18, "degree_R"],
  "attodegree_S" => [-18, "degree_S"],
  "attodegree_W" => [-18, "degree_W"],
  "attodegree_c" => [-18, "degree_c"],
  "attodegree_f" => [-18, "degree_f"],  "attodyne" => [-18, "dyne"],
  "attoerg" => [-18, "erg"],  "attofermi" => [-18, "fermi"],
  "attogal" => [-18, "gal"],  "attogauss" => [-18, "gauss"],
  "attogram" => [-18, "gram"],  "attohectare" => [-18, "hectare"],
  "attohertz" => [-18, "hertz"],  "attohour" => [-18, "hour"],
  "attoinch" => [-18, "inch"],  "attojoule" => [-18, "joule"],
  "attokelvin" => [-18, "kelvin"],  "attokilogram" => [-18, "kilogram"],
  "attoknot" => [-18, "knot"],  "attolitre" => [-18, "litre"],
  "attometer" => [-18, "meter"],  "attometre" => [-18, "metre"],
  "attomicron" => [-18, "micron"],  "attomile" => [-18, "mile"],
  "attominute" => [-18, "minute"],
  "attominute_angle" => [-18, "minute_angle"],
  "attomole" => [-18, "mole"],  "attomonth" => [-18, "month"],
  "attonewton" => [-18, "newton"],  "attoounce" => [-18, "ounce"],
  "attoparsec" => [-18, "parsec"],  "attopascal" => [-18, "pascal"],
  "attopentad" => [-18, "pentad"],  "attopoise" => [-18, "poise"],
  "attopound" => [-18, "pound"],  "attoradian" => [-18, "radian"],
  "attosecond" => [-18, "second"],
  "attosecond_angle" => [-18, "second_angle"],
  "attosteradian" => [-18, "steradian"],
  "attostokes" => [-18, "stokes"],  "attoton" => [-18, "ton"],
  "attotonne" => [-18, "tonne"],  "attotorr" => [-18, "torr"],
  "attovolt" => [-18, "volt"],  "attowatt" => [-18, "watt"],
  "attoyard" => [-18, "yard"],  "attoyd" => [-18, "yd"],
  "attoyear" => [-18, "year"],  "ayr" => [-18, "yr"],
  "cA" => [-2, "A"],  "cAu" => [-2, "Au"],  "cBq" => [-2, "Bq"],
  "cC" => [-2, "C"],  "cF" => [-2, "F"],  "cG" => [-2, "G"],
  "cGal" => [-2, "Gal"],  "cGy" => [-2, "Gy"],  "cH" => [-2, "H"],
  "cHz" => [-2, "Hz"],  "cJ" => [-2, "J"],  "cK" => [-2, "K"],
  "cL" => [-2, "L"],  "cN" => [-2, "N"],  "cP" => [-2, "P"],
  "cPa" => [-2, "Pa"],  "cS" => [-2, "S"],  "cSt" => [-2, "St"],
  "cSv" => [-2, "Sv"],  "cT" => [-2, "T"],  "cV" => [-2, "V"],
  "cW" => [-2, "W"],  "cWb" => [-2, "Wb"],  "ca" => [-2, "a"],
  "cac" => [-2, "ac"],  "calories" => [0, "calorie"],
  "catm" => [-2, "atm"],  "cbar" => [-2, "bar"],  "ccal" => [-2, "cal"],
  "cd" => [-2, "d"],  "cdyn" => [-2, "dyn"],
  "centiacre" => [-2, "acre"],  "centiampere" => [-2, "ampere"],
  "centiangstrom" => [-2, "angstrom"],  "centiare" => [-2, "are"],
  "centiatmosphere" => [-2, "atmosphere"],
  "centicalorie" => [-2, "calorie"],  "centicentury" => [-2, "century"],
  "centichain" => [-2, "chain"],  "centicoulomb" => [-2, "coulomb"],
  "centiday" => [-2, "day"],  "centidegree" => [-2, "degree"],
  "centidegree_C" => [-2, "degree_C"],
  "centidegree_E" => [-2, "degree_E"],
  "centidegree_F" => [-2, "degree_F"],
  "centidegree_N" => [-2, "degree_N"],
  "centidegree_R" => [-2, "degree_R"],
  "centidegree_S" => [-2, "degree_S"],
  "centidegree_W" => [-2, "degree_W"],
  "centidegree_c" => [-2, "degree_c"],
  "centidegree_f" => [-2, "degree_f"],  "centidyne" => [-2, "dyne"],
  "centierg" => [-2, "erg"],  "centifermi" => [-2, "fermi"],
  "centigal" => [-2, "gal"],  "centigauss" => [-2, "gauss"],
  "centigram" => [-2, "gram"],  "centihectare" => [-2, "hectare"],
  "centihertz" => [-2, "hertz"],  "centihour" => [-2, "hour"],
  "centiinch" => [-2, "inch"],  "centijoule" => [-2, "joule"],
  "centikelvin" => [-2, "kelvin"],  "centikilogram" => [-2, "kilogram"],
  "centiknot" => [-2, "knot"],  "centilitre" => [-2, "litre"],
  "centimeter" => [-2, "meter"],  "centimetre" => [-2, "metre"],
  "centimicron" => [-2, "micron"],  "centimile" => [-2, "mile"],
  "centiminute" => [-2, "minute"],
  "centiminute_angle" => [-2, "minute_angle"],
  "centimole" => [-2, "mole"],  "centimonth" => [-2, "month"],
  "centinewton" => [-2, "newton"],  "centiounce" => [-2, "ounce"],
  "centiparsec" => [-2, "parsec"],  "centipascal" => [-2, "pascal"],
  "centipentad" => [-2, "pentad"],  "centipoise" => [-2, "poise"],
  "centipound" => [-2, "pound"],  "centiradian" => [-2, "radian"],
  "centisecond" => [-2, "second"],
  "centisecond_angle" => [-2, "second_angle"],
  "centisteradian" => [-2, "steradian"],
  "centistokes" => [-2, "stokes"],  "centiton" => [-2, "ton"],
  "centitonne" => [-2, "tonne"],  "centitorr" => [-2, "torr"],
  "centivolt" => [-2, "volt"],  "centiwatt" => [-2, "watt"],
  "centiyard" => [-2, "yard"],  "centiyd" => [-2, "yd"],
  "centiyear" => [-2, "year"],  "centuries" => [0, "century"],
  "cerg" => [-2, "erg"],  "cforce" => [-2, "force"],  "cg" => [-2, "g"],
  "ch" => [-2, "h"],  "chains" => [0, "chain"],  "chr" => [-2, "hr"],
  "cin" => [-2, "in"],  "ckg" => [-2, "kg"],  "ckgf" => [-2, "kgf"],
  "ckph" => [-2, "kph"],  "clb" => [-2, "lb"],  "clm" => [-2, "lm"],
  "clx" => [-2, "lx"],  "cly" => [-2, "ly"],  "cm" => [-2, "m"],
  "cmb" => [-2, "mb"],  "cmgal" => [-2, "mgal"],  "cmin" => [-2, "min"],
  "cmol" => [-2, "mol"],  "cmon" => [-2, "mon"],  "cmph" => [-2, "mph"],
  "cohm" => [-2, "ohm"],  "coulombs" => [0, "coulomb"],
  "coz" => [-2, "oz"],  "cpc" => [-2, "pc"],  "cpsi" => [-2, "psi"],
  "crad" => [-2, "rad"],  "cs" => [-2, "s"],  "csr" => [-2, "sr"],
  "ct" => [-2, "t"],  "cyr" => [-2, "yr"],  "dA" => [-1, "A"],
  "dAu" => [-1, "Au"],  "dBq" => [-1, "Bq"],  "dC" => [-1, "C"],
  "dF" => [-1, "F"],  "dG" => [-1, "G"],  "dGal" => [-1, "Gal"],
  "dGy" => [-1, "Gy"],  "dH" => [-1, "H"],  "dHz" => [-1, "Hz"],
  "dJ" => [-1, "J"],  "dK" => [-1, "K"],  "dL" => [-1, "L"],
  "dN" => [-1, "N"],  "dP" => [-1, "P"],  "dPa" => [-1, "Pa"],
  "dS" => [-1, "S"],  "dSt" => [-1, "St"],  "dSv" => [-1, "Sv"],
  "dT" => [-1, "T"],  "dV" => [-1, "V"],  "dW" => [-1, "W"],
  "dWb" => [-1, "Wb"],  "da" => [-1, "a"],  "daA" => [1, "A"],
  "daAu" => [1, "Au"],  "daBq" => [1, "Bq"],  "daC" => [1, "C"],
  "daF" => [1, "F"],  "daG" => [1, "G"],  "daGal" => [1, "Gal"],
  "daGy" => [1, "Gy"],  "daH" => [1, "H"],  "daHz" => [1, "Hz"],
  "daJ" => [1, "J"],  "daK" => [1, "K"],  "daL" => [1, "L"],
  "daN" => [1, "N"],  "daP" => [1, "P"],  "daPa" => [1, "Pa"],
  "daS" => [1, "S"],  "daSt" => [1, "St"],  "daSv" => [1, "Sv"],
  "daT" => [1, "T"],  "daV" => [1, "V"],  "daW" => [1, "W"],
  "daWb" => [1, "Wb"],  "daa" => [1, "a"],  "daac" => [1, "ac"],
  "daatm" => [1, "atm"],  "dabar" => [1, "bar"],  "dac" => [-1, "ac"],
  "dacal" => [1, "cal"],  "dad" => [1, "d"],  "dadyn" => [1, "dyn"],
  "daerg" => [1, "erg"],  "daforce" => [1, "force"],  "dag" => [1, "g"],
  "dah" => [1, "h"],  "dahr" => [1, "hr"],  "dain" => [1, "in"],
  "dakg" => [1, "kg"],  "dakgf" => [1, "kgf"],  "dakph" => [1, "kph"],
  "dalb" => [1, "lb"],  "dalm" => [1, "lm"],  "dalx" => [1, "lx"],
  "daly" => [1, "ly"],  "dam" => [1, "m"],  "damb" => [1, "mb"],
  "damgal" => [1, "mgal"],  "damin" => [1, "min"],
  "damol" => [1, "mol"],  "damon" => [1, "mon"],  "damph" => [1, "mph"],
  "daohm" => [1, "ohm"],  "daoz" => [1, "oz"],  "dapc" => [1, "pc"],
  "dapsi" => [1, "psi"],  "darad" => [1, "rad"],  "das" => [1, "s"],
  "dasr" => [1, "sr"],  "dat" => [1, "t"],  "datm" => [-1, "atm"],
  "dayr" => [1, "yr"],  "days" => [0, "day"],  "dbar" => [-1, "bar"],
  "dcal" => [-1, "cal"],  "dd" => [-1, "d"],  "ddyn" => [-1, "dyn"],
  "decaacre" => [1, "acre"],  "decaampere" => [1, "ampere"],
  "decaangstrom" => [1, "angstrom"],  "decaare" => [1, "are"],
  "decaatmosphere" => [1, "atmosphere"],
  "decacalorie" => [1, "calorie"],  "decacentury" => [1, "century"],
  "decachain" => [1, "chain"],  "decacoulomb" => [1, "coulomb"],
  "decaday" => [1, "day"],  "decadegree" => [1, "degree"],
  "decadegree_C" => [1, "degree_C"],  "decadegree_E" => [1, "degree_E"],
  "decadegree_F" => [1, "degree_F"],  "decadegree_N" => [1, "degree_N"],
  "decadegree_R" => [1, "degree_R"],  "decadegree_S" => [1, "degree_S"],
  "decadegree_W" => [1, "degree_W"],  "decadegree_c" => [1, "degree_c"],
  "decadegree_f" => [1, "degree_f"],  "decadyne" => [1, "dyne"],
  "decaerg" => [1, "erg"],  "decafermi" => [1, "fermi"],
  "decagal" => [1, "gal"],  "decagauss" => [1, "gauss"],
  "decagram" => [1, "gram"],  "decahectare" => [1, "hectare"],
  "decahertz" => [1, "hertz"],  "decahour" => [1, "hour"],
  "decainch" => [1, "inch"],  "decajoule" => [1, "joule"],
  "decakelvin" => [1, "kelvin"],  "decakilogram" => [1, "kilogram"],
  "decaknot" => [1, "knot"],  "decalitre" => [1, "litre"],
  "decameter" => [1, "meter"],  "decametre" => [1, "metre"],
  "decamicron" => [1, "micron"],  "decamile" => [1, "mile"],
  "decaminute" => [1, "minute"],
  "decaminute_angle" => [1, "minute_angle"],  "decamole" => [1, "mole"],
  "decamonth" => [1, "month"],  "decanewton" => [1, "newton"],
  "decaounce" => [1, "ounce"],  "decaparsec" => [1, "parsec"],
  "decapascal" => [1, "pascal"],  "decapentad" => [1, "pentad"],
  "decapoise" => [1, "poise"],  "decapound" => [1, "pound"],
  "decaradian" => [1, "radian"],  "decasecond" => [1, "second"],
  "decasecond_angle" => [1, "second_angle"],
  "decasteradian" => [1, "steradian"],  "decastokes" => [1, "stokes"],
  "decaton" => [1, "ton"],  "decatonne" => [1, "tonne"],
  "decatorr" => [1, "torr"],  "decavolt" => [1, "volt"],
  "decawatt" => [1, "watt"],  "decayard" => [1, "yard"],
  "decayd" => [1, "yd"],  "decayear" => [1, "year"],
  "deciacre" => [-1, "acre"],  "deciampere" => [-1, "ampere"],
  "deciangstrom" => [-1, "angstrom"],  "deciare" => [-1, "are"],
  "deciatmosphere" => [-1, "atmosphere"],
  "decicalorie" => [-1, "calorie"],  "decicentury" => [-1, "century"],
  "decichain" => [-1, "chain"],  "decicoulomb" => [-1, "coulomb"],
  "deciday" => [-1, "day"],  "decidegree" => [-1, "degree"],
  "decidegree_C" => [-1, "degree_C"],
  "decidegree_E" => [-1, "degree_E"],
  "decidegree_F" => [-1, "degree_F"],
  "decidegree_N" => [-1, "degree_N"],
  "decidegree_R" => [-1, "degree_R"],
  "decidegree_S" => [-1, "degree_S"],
  "decidegree_W" => [-1, "degree_W"],
  "decidegree_c" => [-1, "degree_c"],
  "decidegree_f" => [-1, "degree_f"],  "decidyne" => [-1, "dyne"],
  "decierg" => [-1, "erg"],  "decifermi" => [-1, "fermi"],
  "decigal" => [-1, "gal"],  "decigauss" => [-1, "gauss"],
  "decigram" => [-1, "gram"],  "decihectare" => [-1, "hectare"],
  "decihertz" => [-1, "hertz"],  "decihour" => [-1, "hour"],
  "deciinch" => [-1, "inch"],  "decijoule" => [-1, "joule"],
  "decikelvin" => [-1, "kelvin"],  "decikilogram" => [-1, "kilogram"],
  "deciknot" => [-1, "knot"],  "decilitre" => [-1, "litre"],
  "decimeter" => [-1, "meter"],  "decimetre" => [-1, "metre"],
  "decimicron" => [-1, "micron"],  "decimile" => [-1, "mile"],
  "deciminute" => [-1, "minute"],
  "deciminute_angle" => [-1, "minute_angle"],
  "decimole" => [-1, "mole"],  "decimonth" => [-1, "month"],
  "decinewton" => [-1, "newton"],  "deciounce" => [-1, "ounce"],
  "deciparsec" => [-1, "parsec"],  "decipascal" => [-1, "pascal"],
  "decipentad" => [-1, "pentad"],  "decipoise" => [-1, "poise"],
  "decipound" => [-1, "pound"],  "deciradian" => [-1, "radian"],
  "decisecond" => [-1, "second"],
  "decisecond_angle" => [-1, "second_angle"],
  "decisteradian" => [-1, "steradian"],  "decistokes" => [-1, "stokes"],
  "deciton" => [-1, "ton"],  "decitonne" => [-1, "tonne"],
  "decitorr" => [-1, "torr"],  "decivolt" => [-1, "volt"],
  "deciwatt" => [-1, "watt"],  "deciyard" => [-1, "yard"],
  "deciyd" => [-1, "yd"],  "deciyear" => [-1, "year"],
  "degrees" => [0, "degree"],  "degrees_C" => [0, "degree_C"],
  "degrees_E" => [0, "degree_E"],  "degrees_F" => [0, "degree_F"],
  "degrees_N" => [0, "degree_N"],  "degrees_R" => [0, "degree_R"],
  "degrees_S" => [0, "degree_S"],  "degrees_W" => [0, "degree_W"],
  "degrees_c" => [0, "degree_c"],  "degrees_f" => [0, "degree_f"],
  "derg" => [-1, "erg"],  "dforce" => [-1, "force"],  "dg" => [-1, "g"],
  "dh" => [-1, "h"],  "dhr" => [-1, "hr"],  "din" => [-1, "in"],
  "dkg" => [-1, "kg"],  "dkgf" => [-1, "kgf"],  "dkph" => [-1, "kph"],
  "dlb" => [-1, "lb"],  "dlm" => [-1, "lm"],  "dlx" => [-1, "lx"],
  "dly" => [-1, "ly"],  "dm" => [-1, "m"],  "dmb" => [-1, "mb"],
  "dmgal" => [-1, "mgal"],  "dmin" => [-1, "min"],
  "dmol" => [-1, "mol"],  "dmon" => [-1, "mon"],  "dmph" => [-1, "mph"],
  "dohm" => [-1, "ohm"],  "doz" => [-1, "oz"],  "dpc" => [-1, "pc"],
  "dpsi" => [-1, "psi"],  "drad" => [-1, "rad"],  "ds" => [-1, "s"],
  "dsr" => [-1, "sr"],  "dt" => [-1, "t"],  "dynes" => [0, "dyne"],
  "dyr" => [-1, "yr"],  "ergs" => [0, "erg"],
  "exaacre" => [18, "acre"],  "exaampere" => [18, "ampere"],
  "exaangstrom" => [18, "angstrom"],  "exaare" => [18, "are"],
  "exaatmosphere" => [18, "atmosphere"],
  "exacalorie" => [18, "calorie"],  "exacentury" => [18, "century"],
  "exachain" => [18, "chain"],  "exacoulomb" => [18, "coulomb"],
  "exaday" => [18, "day"],  "exadegree" => [18, "degree"],
  "exadegree_C" => [18, "degree_C"],  "exadegree_E" => [18, "degree_E"],
  "exadegree_F" => [18, "degree_F"],  "exadegree_N" => [18, "degree_N"],
  "exadegree_R" => [18, "degree_R"],  "exadegree_S" => [18, "degree_S"],
  "exadegree_W" => [18, "degree_W"],  "exadegree_c" => [18, "degree_c"],
  "exadegree_f" => [18, "degree_f"],  "exadyne" => [18, "dyne"],
  "exaerg" => [18, "erg"],  "exafermi" => [18, "fermi"],
  "exagal" => [18, "gal"],  "exagauss" => [18, "gauss"],
  "exagram" => [18, "gram"],  "exahectare" => [18, "hectare"],
  "exahertz" => [18, "hertz"],  "exahour" => [18, "hour"],
  "exainch" => [18, "inch"],  "exajoule" => [18, "joule"],
  "exakelvin" => [18, "kelvin"],  "exakilogram" => [18, "kilogram"],
  "exaknot" => [18, "knot"],  "exalitre" => [18, "litre"],
  "exameter" => [18, "meter"],  "exametre" => [18, "metre"],
  "examicron" => [18, "micron"],  "examile" => [18, "mile"],
  "examinute" => [18, "minute"],
  "examinute_angle" => [18, "minute_angle"],  "examole" => [18, "mole"],
  "examonth" => [18, "month"],  "exanewton" => [18, "newton"],
  "exaounce" => [18, "ounce"],  "exaparsec" => [18, "parsec"],
  "exapascal" => [18, "pascal"],  "exapentad" => [18, "pentad"],
  "exapoise" => [18, "poise"],  "exapound" => [18, "pound"],
  "exaradian" => [18, "radian"],  "exasecond" => [18, "second"],
  "exasecond_angle" => [18, "second_angle"],
  "exasteradian" => [18, "steradian"],  "exastokes" => [18, "stokes"],
  "exaton" => [18, "ton"],  "exatonne" => [18, "tonne"],
  "exatorr" => [18, "torr"],  "exavolt" => [18, "volt"],
  "exawatt" => [18, "watt"],  "exayard" => [18, "yard"],
  "exayd" => [18, "yd"],  "exayear" => [18, "year"],
  "fA" => [-15, "A"],  "fAu" => [-15, "Au"],  "fBq" => [-15, "Bq"],
  "fC" => [-15, "C"],  "fF" => [-15, "F"],  "fG" => [-15, "G"],
  "fGal" => [-15, "Gal"],  "fGy" => [-15, "Gy"],  "fH" => [-15, "H"],
  "fHz" => [-15, "Hz"],  "fJ" => [-15, "J"],  "fK" => [-15, "K"],
  "fL" => [-15, "L"],  "fN" => [-15, "N"],  "fP" => [-15, "P"],
  "fPa" => [-15, "Pa"],  "fS" => [-15, "S"],  "fSt" => [-15, "St"],
  "fSv" => [-15, "Sv"],  "fT" => [-15, "T"],  "fV" => [-15, "V"],
  "fW" => [-15, "W"],  "fWb" => [-15, "Wb"],  "fa" => [-15, "a"],
  "fac" => [-15, "ac"],  "fatm" => [-15, "atm"],
  "fbar" => [-15, "bar"],  "fcal" => [-15, "cal"],  "fd" => [-15, "d"],
  "fdyn" => [-15, "dyn"],  "femtoacre" => [-15, "acre"],
  "femtoampere" => [-15, "ampere"],
  "femtoangstrom" => [-15, "angstrom"],  "femtoare" => [-15, "are"],
  "femtoatmosphere" => [-15, "atmosphere"],
  "femtocalorie" => [-15, "calorie"],
  "femtocentury" => [-15, "century"],  "femtochain" => [-15, "chain"],
  "femtocoulomb" => [-15, "coulomb"],  "femtoday" => [-15, "day"],
  "femtodegree" => [-15, "degree"],
  "femtodegree_C" => [-15, "degree_C"],
  "femtodegree_E" => [-15, "degree_E"],
  "femtodegree_F" => [-15, "degree_F"],
  "femtodegree_N" => [-15, "degree_N"],
  "femtodegree_R" => [-15, "degree_R"],
  "femtodegree_S" => [-15, "degree_S"],
  "femtodegree_W" => [-15, "degree_W"],
  "femtodegree_c" => [-15, "degree_c"],
  "femtodegree_f" => [-15, "degree_f"],  "femtodyne" => [-15, "dyne"],
  "femtoerg" => [-15, "erg"],  "femtofermi" => [-15, "fermi"],
  "femtogal" => [-15, "gal"],  "femtogauss" => [-15, "gauss"],
  "femtogram" => [-15, "gram"],  "femtohectare" => [-15, "hectare"],
  "femtohertz" => [-15, "hertz"],  "femtohour" => [-15, "hour"],
  "femtoinch" => [-15, "inch"],  "femtojoule" => [-15, "joule"],
  "femtokelvin" => [-15, "kelvin"],
  "femtokilogram" => [-15, "kilogram"],  "femtoknot" => [-15, "knot"],
  "femtolitre" => [-15, "litre"],  "femtometer" => [-15, "meter"],
  "femtometre" => [-15, "metre"],  "femtomicron" => [-15, "micron"],
  "femtomile" => [-15, "mile"],  "femtominute" => [-15, "minute"],
  "femtominute_angle" => [-15, "minute_angle"],
  "femtomole" => [-15, "mole"],  "femtomonth" => [-15, "month"],
  "femtonewton" => [-15, "newton"],  "femtoounce" => [-15, "ounce"],
  "femtoparsec" => [-15, "parsec"],  "femtopascal" => [-15, "pascal"],
  "femtopentad" => [-15, "pentad"],  "femtopoise" => [-15, "poise"],
  "femtopound" => [-15, "pound"],  "femtoradian" => [-15, "radian"],
  "femtosecond" => [-15, "second"],
  "femtosecond_angle" => [-15, "second_angle"],
  "femtosteradian" => [-15, "steradian"],
  "femtostokes" => [-15, "stokes"],  "femtoton" => [-15, "ton"],
  "femtotonne" => [-15, "tonne"],  "femtotorr" => [-15, "torr"],
  "femtovolt" => [-15, "volt"],  "femtowatt" => [-15, "watt"],
  "femtoyard" => [-15, "yard"],  "femtoyd" => [-15, "yd"],
  "femtoyear" => [-15, "year"],  "ferg" => [-15, "erg"],
  "fermis" => [0, "fermi"],  "fforce" => [-15, "force"],
  "fg" => [-15, "g"],  "fh" => [-15, "h"],  "fhr" => [-15, "hr"],
  "fin" => [-15, "in"],  "fkg" => [-15, "kg"],  "fkgf" => [-15, "kgf"],
  "fkph" => [-15, "kph"],  "flb" => [-15, "lb"],  "flm" => [-15, "lm"],
  "flx" => [-15, "lx"],  "fly" => [-15, "ly"],  "fm" => [-15, "m"],
  "fmb" => [-15, "mb"],  "fmgal" => [-15, "mgal"],
  "fmin" => [-15, "min"],  "fmol" => [-15, "mol"],
  "fmon" => [-15, "mon"],  "fmph" => [-15, "mph"],
  "fohm" => [-15, "ohm"],  "foz" => [-15, "oz"],  "fpc" => [-15, "pc"],
  "fpsi" => [-15, "psi"],  "frad" => [-15, "rad"],  "fs" => [-15, "s"],
  "fsr" => [-15, "sr"],  "ft" => [-15, "t"],  "fyr" => [-15, "yr"],
  "gals" => [0, "gal"],  "gausses" => [0, "gauss"],
  "gigaacre" => [9, "acre"],  "gigaampere" => [9, "ampere"],
  "gigaangstrom" => [9, "angstrom"],  "gigaare" => [9, "are"],
  "gigaatmosphere" => [9, "atmosphere"],
  "gigacalorie" => [9, "calorie"],  "gigacentury" => [9, "century"],
  "gigachain" => [9, "chain"],  "gigacoulomb" => [9, "coulomb"],
  "gigaday" => [9, "day"],  "gigadegree" => [9, "degree"],
  "gigadegree_C" => [9, "degree_C"],  "gigadegree_E" => [9, "degree_E"],
  "gigadegree_F" => [9, "degree_F"],  "gigadegree_N" => [9, "degree_N"],
  "gigadegree_R" => [9, "degree_R"],  "gigadegree_S" => [9, "degree_S"],
  "gigadegree_W" => [9, "degree_W"],  "gigadegree_c" => [9, "degree_c"],
  "gigadegree_f" => [9, "degree_f"],  "gigadyne" => [9, "dyne"],
  "gigaerg" => [9, "erg"],  "gigafermi" => [9, "fermi"],
  "gigagal" => [9, "gal"],  "gigagauss" => [9, "gauss"],
  "gigagram" => [9, "gram"],  "gigahectare" => [9, "hectare"],
  "gigahertz" => [9, "hertz"],  "gigahour" => [9, "hour"],
  "gigainch" => [9, "inch"],  "gigajoule" => [9, "joule"],
  "gigakelvin" => [9, "kelvin"],  "gigakilogram" => [9, "kilogram"],
  "gigaknot" => [9, "knot"],  "gigalitre" => [9, "litre"],
  "gigameter" => [9, "meter"],  "gigametre" => [9, "metre"],
  "gigamicron" => [9, "micron"],  "gigamile" => [9, "mile"],
  "gigaminute" => [9, "minute"],
  "gigaminute_angle" => [9, "minute_angle"],  "gigamole" => [9, "mole"],
  "gigamonth" => [9, "month"],  "giganewton" => [9, "newton"],
  "gigaounce" => [9, "ounce"],  "gigaparsec" => [9, "parsec"],
  "gigapascal" => [9, "pascal"],  "gigapentad" => [9, "pentad"],
  "gigapoise" => [9, "poise"],  "gigapound" => [9, "pound"],
  "gigaradian" => [9, "radian"],  "gigasecond" => [9, "second"],
  "gigasecond_angle" => [9, "second_angle"],
  "gigasteradian" => [9, "steradian"],  "gigastokes" => [9, "stokes"],
  "gigaton" => [9, "ton"],  "gigatonne" => [9, "tonne"],
  "gigatorr" => [9, "torr"],  "gigavolt" => [9, "volt"],
  "gigawatt" => [9, "watt"],  "gigayard" => [9, "yard"],
  "gigayd" => [9, "yd"],  "gigayear" => [9, "year"],
  "grams" => [0, "gram"],  "hA" => [2, "A"],  "hAu" => [2, "Au"],
  "hBq" => [2, "Bq"],  "hC" => [2, "C"],  "hF" => [2, "F"],
  "hG" => [2, "G"],  "hGal" => [2, "Gal"],  "hGy" => [2, "Gy"],
  "hH" => [2, "H"],  "hHz" => [2, "Hz"],  "hJ" => [2, "J"],
  "hK" => [2, "K"],  "hL" => [2, "L"],  "hN" => [2, "N"],
  "hP" => [2, "P"],  "hPa" => [2, "Pa"],  "hS" => [2, "S"],
  "hSt" => [2, "St"],  "hSv" => [2, "Sv"],  "hT" => [2, "T"],
  "hV" => [2, "V"],  "hW" => [2, "W"],  "hWb" => [2, "Wb"],
  "ha" => [2, "a"],  "hac" => [2, "ac"],  "hatm" => [2, "atm"],
  "hbar" => [2, "bar"],  "hcal" => [2, "cal"],  "hd" => [2, "d"],
  "hdyn" => [2, "dyn"],  "hectares" => [0, "hectare"],
  "hectoacre" => [2, "acre"],  "hectoampere" => [2, "ampere"],
  "hectoangstrom" => [2, "angstrom"],  "hectoare" => [2, "are"],
  "hectoatmosphere" => [2, "atmosphere"],
  "hectocalorie" => [2, "calorie"],  "hectocentury" => [2, "century"],
  "hectochain" => [2, "chain"],  "hectocoulomb" => [2, "coulomb"],
  "hectoday" => [2, "day"],  "hectodegree" => [2, "degree"],
  "hectodegree_C" => [2, "degree_C"],
  "hectodegree_E" => [2, "degree_E"],
  "hectodegree_F" => [2, "degree_F"],
  "hectodegree_N" => [2, "degree_N"],
  "hectodegree_R" => [2, "degree_R"],
  "hectodegree_S" => [2, "degree_S"],
  "hectodegree_W" => [2, "degree_W"],
  "hectodegree_c" => [2, "degree_c"],
  "hectodegree_f" => [2, "degree_f"],  "hectodyne" => [2, "dyne"],
  "hectoerg" => [2, "erg"],  "hectofermi" => [2, "fermi"],
  "hectogal" => [2, "gal"],  "hectogauss" => [2, "gauss"],
  "hectogram" => [2, "gram"],  "hectohectare" => [2, "hectare"],
  "hectohertz" => [2, "hertz"],  "hectohour" => [2, "hour"],
  "hectoinch" => [2, "inch"],  "hectojoule" => [2, "joule"],
  "hectokelvin" => [2, "kelvin"],  "hectokilogram" => [2, "kilogram"],
  "hectoknot" => [2, "knot"],  "hectolitre" => [2, "litre"],
  "hectometer" => [2, "meter"],  "hectometre" => [2, "metre"],
  "hectomicron" => [2, "micron"],  "hectomile" => [2, "mile"],
  "hectominute" => [2, "minute"],
  "hectominute_angle" => [2, "minute_angle"],
  "hectomole" => [2, "mole"],  "hectomonth" => [2, "month"],
  "hectonewton" => [2, "newton"],  "hectoounce" => [2, "ounce"],
  "hectoparsec" => [2, "parsec"],  "hectopascal" => [2, "pascal"],
  "hectopentad" => [2, "pentad"],  "hectopoise" => [2, "poise"],
  "hectopound" => [2, "pound"],  "hectoradian" => [2, "radian"],
  "hectosecond" => [2, "second"],
  "hectosecond_angle" => [2, "second_angle"],
  "hectosteradian" => [2, "steradian"],  "hectostokes" => [2, "stokes"],
  "hectoton" => [2, "ton"],  "hectotonne" => [2, "tonne"],
  "hectotorr" => [2, "torr"],  "hectovolt" => [2, "volt"],
  "hectowatt" => [2, "watt"],  "hectoyard" => [2, "yard"],
  "hectoyd" => [2, "yd"],  "hectoyear" => [2, "year"],
  "herg" => [2, "erg"],  "hertzes" => [0, "hertz"],
  "hforce" => [2, "force"],  "hg" => [2, "g"],  "hh" => [2, "h"],
  "hhr" => [2, "hr"],  "hin" => [2, "in"],  "hkg" => [2, "kg"],
  "hkgf" => [2, "kgf"],  "hkph" => [2, "kph"],  "hlb" => [2, "lb"],
  "hlm" => [2, "lm"],  "hlx" => [2, "lx"],  "hly" => [2, "ly"],
  "hm" => [2, "m"],  "hmb" => [2, "mb"],  "hmgal" => [2, "mgal"],
  "hmin" => [2, "min"],  "hmol" => [2, "mol"],  "hmon" => [2, "mon"],
  "hmph" => [2, "mph"],  "hohm" => [2, "ohm"],  "hours" => [0, "hour"],
  "hoz" => [2, "oz"],  "hpc" => [2, "pc"],  "hpsi" => [2, "psi"],
  "hrad" => [2, "rad"],  "hs" => [2, "s"],  "hsr" => [2, "sr"],
  "ht" => [2, "t"],  "hyr" => [2, "yr"],  "inchs" => [0, "inch"],
  "joules" => [0, "joule"],  "kA" => [3, "A"],  "kAu" => [3, "Au"],
  "kBq" => [3, "Bq"],  "kC" => [3, "C"],  "kF" => [3, "F"],
  "kG" => [3, "G"],  "kGal" => [3, "Gal"],  "kGy" => [3, "Gy"],
  "kH" => [3, "H"],  "kHz" => [3, "Hz"],  "kJ" => [3, "J"],
  "kK" => [3, "K"],  "kL" => [3, "L"],  "kN" => [3, "N"],
  "kP" => [3, "P"],  "kPa" => [3, "Pa"],  "kS" => [3, "S"],
  "kSt" => [3, "St"],  "kSv" => [3, "Sv"],  "kT" => [3, "T"],
  "kV" => [3, "V"],  "kW" => [3, "W"],  "kWb" => [3, "Wb"],
  "ka" => [3, "a"],  "kac" => [3, "ac"],  "katm" => [3, "atm"],
  "kbar" => [3, "bar"],  "kcal" => [3, "cal"],  "kd" => [3, "d"],
  "kdyn" => [3, "dyn"],  "kelvins" => [0, "kelvin"],
  "kerg" => [3, "erg"],  "kforce" => [3, "force"],  "kh" => [3, "h"],
  "khr" => [3, "hr"],  "kiloacre" => [3, "acre"],
  "kiloampere" => [3, "ampere"],  "kiloangstrom" => [3, "angstrom"],
  "kiloare" => [3, "are"],  "kiloatmosphere" => [3, "atmosphere"],
  "kilocalorie" => [3, "calorie"],  "kilocentury" => [3, "century"],
  "kilochain" => [3, "chain"],  "kilocoulomb" => [3, "coulomb"],
  "kiloday" => [3, "day"],  "kilodegree" => [3, "degree"],
  "kilodegree_C" => [3, "degree_C"],  "kilodegree_E" => [3, "degree_E"],
  "kilodegree_F" => [3, "degree_F"],  "kilodegree_N" => [3, "degree_N"],
  "kilodegree_R" => [3, "degree_R"],  "kilodegree_S" => [3, "degree_S"],
  "kilodegree_W" => [3, "degree_W"],  "kilodegree_c" => [3, "degree_c"],
  "kilodegree_f" => [3, "degree_f"],  "kilodyne" => [3, "dyne"],
  "kiloerg" => [3, "erg"],  "kilofermi" => [3, "fermi"],
  "kilogal" => [3, "gal"],  "kilogauss" => [3, "gauss"],
  "kilogram" => [3, "gram"],  "kilograms" => [0, "kilogram"],
  "kilohectare" => [3, "hectare"],  "kilohertz" => [3, "hertz"],
  "kilohour" => [3, "hour"],  "kiloinch" => [3, "inch"],
  "kilojoule" => [3, "joule"],  "kilokelvin" => [3, "kelvin"],
  "kilokilogram" => [3, "kilogram"],  "kiloknot" => [3, "knot"],
  "kilolitre" => [3, "litre"],  "kilometer" => [3, "meter"],
  "kilometre" => [3, "metre"],  "kilomicron" => [3, "micron"],
  "kilomile" => [3, "mile"],  "kilominute" => [3, "minute"],
  "kilominute_angle" => [3, "minute_angle"],  "kilomole" => [3, "mole"],
  "kilomonth" => [3, "month"],  "kilonewton" => [3, "newton"],
  "kiloounce" => [3, "ounce"],  "kiloparsec" => [3, "parsec"],
  "kilopascal" => [3, "pascal"],  "kilopentad" => [3, "pentad"],
  "kilopoise" => [3, "poise"],  "kilopound" => [3, "pound"],
  "kiloradian" => [3, "radian"],  "kilosecond" => [3, "second"],
  "kilosecond_angle" => [3, "second_angle"],
  "kilosteradian" => [3, "steradian"],  "kilostokes" => [3, "stokes"],
  "kiloton" => [3, "ton"],  "kilotonne" => [3, "tonne"],
  "kilotorr" => [3, "torr"],  "kilovolt" => [3, "volt"],
  "kilowatt" => [3, "watt"],  "kiloyard" => [3, "yard"],
  "kiloyd" => [3, "yd"],  "kiloyear" => [3, "year"],
  "kin" => [3, "in"],  "kkg" => [3, "kg"],  "kkgf" => [3, "kgf"],
  "kkph" => [3, "kph"],  "klb" => [3, "lb"],  "klm" => [3, "lm"],
  "klx" => [3, "lx"],  "kly" => [3, "ly"],  "km" => [3, "m"],
  "kmb" => [3, "mb"],  "kmgal" => [3, "mgal"],  "kmin" => [3, "min"],
  "kmol" => [3, "mol"],  "kmon" => [3, "mon"],  "kmph" => [3, "mph"],
  "knots" => [0, "knot"],  "kohm" => [3, "ohm"],  "koz" => [3, "oz"],
  "kpc" => [3, "pc"],  "kpsi" => [3, "psi"],  "krad" => [3, "rad"],
  "ks" => [3, "s"],  "ksr" => [3, "sr"],  "kt" => [3, "t"],
  "kyr" => [3, "yr"],  "litres" => [0, "litre"],  "mA" => [-3, "A"],
  "mAu" => [-3, "Au"],  "mBq" => [-3, "Bq"],  "mC" => [-3, "C"],
  "mF" => [-3, "F"],  "mG" => [-3, "G"],  "mGal" => [-3, "Gal"],
  "mGy" => [-3, "Gy"],  "mH" => [-3, "H"],  "mHz" => [-3, "Hz"],
  "mJ" => [-3, "J"],  "mK" => [-3, "K"],  "mL" => [-3, "L"],
  "mN" => [-3, "N"],  "mP" => [-3, "P"],  "mPa" => [-3, "Pa"],
  "mS" => [-3, "S"],  "mSt" => [-3, "St"],  "mSv" => [-3, "Sv"],
  "mT" => [-3, "T"],  "mV" => [-3, "V"],  "mW" => [-3, "W"],
  "mWb" => [-3, "Wb"],  "ma" => [-3, "a"],  "mac" => [-3, "ac"],
  "matm" => [-3, "atm"],  "mbar" => [-3, "bar"],  "mcal" => [-3, "cal"],
  "md" => [-3, "d"],  "mdyn" => [-3, "dyn"],  "megaacre" => [6, "acre"],
  "megaampere" => [6, "ampere"],  "megaangstrom" => [6, "angstrom"],
  "megaare" => [6, "are"],  "megaatmosphere" => [6, "atmosphere"],
  "megacalorie" => [6, "calorie"],  "megacentury" => [6, "century"],
  "megachain" => [6, "chain"],  "megacoulomb" => [6, "coulomb"],
  "megaday" => [6, "day"],  "megadegree" => [6, "degree"],
  "megadegree_C" => [6, "degree_C"],  "megadegree_E" => [6, "degree_E"],
  "megadegree_F" => [6, "degree_F"],  "megadegree_N" => [6, "degree_N"],
  "megadegree_R" => [6, "degree_R"],  "megadegree_S" => [6, "degree_S"],
  "megadegree_W" => [6, "degree_W"],  "megadegree_c" => [6, "degree_c"],
  "megadegree_f" => [6, "degree_f"],  "megadyne" => [6, "dyne"],
  "megaerg" => [6, "erg"],  "megafermi" => [6, "fermi"],
  "megagal" => [6, "gal"],  "megagauss" => [6, "gauss"],
  "megagram" => [6, "gram"],  "megahectare" => [6, "hectare"],
  "megahertz" => [6, "hertz"],  "megahour" => [6, "hour"],
  "megainch" => [6, "inch"],  "megajoule" => [6, "joule"],
  "megakelvin" => [6, "kelvin"],  "megakilogram" => [6, "kilogram"],
  "megaknot" => [6, "knot"],  "megalitre" => [6, "litre"],
  "megameter" => [6, "meter"],  "megametre" => [6, "metre"],
  "megamicron" => [6, "micron"],  "megamile" => [6, "mile"],
  "megaminute" => [6, "minute"],
  "megaminute_angle" => [6, "minute_angle"],  "megamole" => [6, "mole"],
  "megamonth" => [6, "month"],  "meganewton" => [6, "newton"],
  "megaounce" => [6, "ounce"],  "megaparsec" => [6, "parsec"],
  "megapascal" => [6, "pascal"],  "megapentad" => [6, "pentad"],
  "megapoise" => [6, "poise"],  "megapound" => [6, "pound"],
  "megaradian" => [6, "radian"],  "megasecond" => [6, "second"],
  "megasecond_angle" => [6, "second_angle"],
  "megasteradian" => [6, "steradian"],  "megastokes" => [6, "stokes"],
  "megaton" => [6, "ton"],  "megatonne" => [6, "tonne"],
  "megatorr" => [6, "torr"],  "megavolt" => [6, "volt"],
  "megawatt" => [6, "watt"],  "megayard" => [6, "yard"],
  "megayd" => [6, "yd"],  "megayear" => [6, "year"],
  "merg" => [-3, "erg"],  "meters" => [0, "meter"],
  "metres" => [0, "metre"],  "mforce" => [-3, "force"],
  "mg" => [-3, "g"],  "mh" => [-3, "h"],  "mhr" => [-3, "hr"],
  "microacre" => [-6, "acre"],  "microampere" => [-6, "ampere"],
  "microangstrom" => [-6, "angstrom"],  "microare" => [-6, "are"],
  "microatmosphere" => [-6, "atmosphere"],
  "microcalorie" => [-6, "calorie"],  "microcentury" => [-6, "century"],
  "microchain" => [-6, "chain"],  "microcoulomb" => [-6, "coulomb"],
  "microday" => [-6, "day"],  "microdegree" => [-6, "degree"],
  "microdegree_C" => [-6, "degree_C"],
  "microdegree_E" => [-6, "degree_E"],
  "microdegree_F" => [-6, "degree_F"],
  "microdegree_N" => [-6, "degree_N"],
  "microdegree_R" => [-6, "degree_R"],
  "microdegree_S" => [-6, "degree_S"],
  "microdegree_W" => [-6, "degree_W"],
  "microdegree_c" => [-6, "degree_c"],
  "microdegree_f" => [-6, "degree_f"],  "microdyne" => [-6, "dyne"],
  "microerg" => [-6, "erg"],  "microfermi" => [-6, "fermi"],
  "microgal" => [-6, "gal"],  "microgauss" => [-6, "gauss"],
  "microgram" => [-6, "gram"],  "microhectare" => [-6, "hectare"],
  "microhertz" => [-6, "hertz"],  "microhour" => [-6, "hour"],
  "microinch" => [-6, "inch"],  "microjoule" => [-6, "joule"],
  "microkelvin" => [-6, "kelvin"],  "microkilogram" => [-6, "kilogram"],
  "microknot" => [-6, "knot"],  "microlitre" => [-6, "litre"],
  "micrometer" => [-6, "meter"],  "micrometre" => [-6, "metre"],
  "micromicron" => [-6, "micron"],  "micromile" => [-6, "mile"],
  "microminute" => [-6, "minute"],
  "microminute_angle" => [-6, "minute_angle"],
  "micromole" => [-6, "mole"],  "micromonth" => [-6, "month"],
  "micronewton" => [-6, "newton"],  "microns" => [0, "micron"],
  "microounce" => [-6, "ounce"],  "microparsec" => [-6, "parsec"],
  "micropascal" => [-6, "pascal"],  "micropentad" => [-6, "pentad"],
  "micropoise" => [-6, "poise"],  "micropound" => [-6, "pound"],
  "microradian" => [-6, "radian"],  "microsecond" => [-6, "second"],
  "microsecond_angle" => [-6, "second_angle"],
  "microsteradian" => [-6, "steradian"],
  "microstokes" => [-6, "stokes"],  "microton" => [-6, "ton"],
  "microtonne" => [-6, "tonne"],  "microtorr" => [-6, "torr"],
  "microvolt" => [-6, "volt"],  "microwatt" => [-6, "watt"],
  "microyard" => [-6, "yard"],  "microyd" => [-6, "yd"],
  "microyear" => [-6, "year"],  "miles" => [0, "mile"],
  "milliacre" => [-3, "acre"],  "milliampere" => [-3, "ampere"],
  "milliangstrom" => [-3, "angstrom"],  "milliare" => [-3, "are"],
  "milliatmosphere" => [-3, "atmosphere"],
  "millicalorie" => [-3, "calorie"],  "millicentury" => [-3, "century"],
  "millichain" => [-3, "chain"],  "millicoulomb" => [-3, "coulomb"],
  "milliday" => [-3, "day"],  "millidegree" => [-3, "degree"],
  "millidegree_C" => [-3, "degree_C"],
  "millidegree_E" => [-3, "degree_E"],
  "millidegree_F" => [-3, "degree_F"],
  "millidegree_N" => [-3, "degree_N"],
  "millidegree_R" => [-3, "degree_R"],
  "millidegree_S" => [-3, "degree_S"],
  "millidegree_W" => [-3, "degree_W"],
  "millidegree_c" => [-3, "degree_c"],
  "millidegree_f" => [-3, "degree_f"],  "millidyne" => [-3, "dyne"],
  "millierg" => [-3, "erg"],  "millifermi" => [-3, "fermi"],
  "milligal" => [-3, "gal"],  "milligauss" => [-3, "gauss"],
  "milligram" => [-3, "gram"],  "millihectare" => [-3, "hectare"],
  "millihertz" => [-3, "hertz"],  "millihour" => [-3, "hour"],
  "milliinch" => [-3, "inch"],  "millijoule" => [-3, "joule"],
  "millikelvin" => [-3, "kelvin"],  "millikilogram" => [-3, "kilogram"],
  "milliknot" => [-3, "knot"],  "millilitre" => [-3, "litre"],
  "millimeter" => [-3, "meter"],  "millimetre" => [-3, "metre"],
  "millimicron" => [-3, "micron"],  "millimile" => [-3, "mile"],
  "milliminute" => [-3, "minute"],
  "milliminute_angle" => [-3, "minute_angle"],
  "millimole" => [-3, "mole"],  "millimonth" => [-3, "month"],
  "millinewton" => [-3, "newton"],  "milliounce" => [-3, "ounce"],
  "milliparsec" => [-3, "parsec"],  "millipascal" => [-3, "pascal"],
  "millipentad" => [-3, "pentad"],  "millipoise" => [-3, "poise"],
  "millipound" => [-3, "pound"],  "milliradian" => [-3, "radian"],
  "millisecond" => [-3, "second"],
  "millisecond_angle" => [-3, "second_angle"],
  "millisteradian" => [-3, "steradian"],
  "millistokes" => [-3, "stokes"],  "milliton" => [-3, "ton"],
  "millitonne" => [-3, "tonne"],  "millitorr" => [-3, "torr"],
  "millivolt" => [-3, "volt"],  "milliwatt" => [-3, "watt"],
  "milliyard" => [-3, "yard"],  "milliyd" => [-3, "yd"],
  "milliyear" => [-3, "year"],  "min" => [-3, "in"],
  "minutes" => [0, "minute"],  "minutes_angle" => [0, "minute_angle"],
  "mkg" => [-3, "kg"],  "mkgf" => [-3, "kgf"],  "mkph" => [-3, "kph"],
  "mlb" => [-3, "lb"],  "mlm" => [-3, "lm"],  "mlx" => [-3, "lx"],
  "mly" => [-3, "ly"],  "mm" => [-3, "m"],  "mmb" => [-3, "mb"],
  "mmgal" => [-3, "mgal"],  "mmin" => [-3, "min"],
  "mmol" => [-3, "mol"],  "mmon" => [-3, "mon"],  "mmph" => [-3, "mph"],
  "mohm" => [-3, "ohm"],  "moles" => [0, "mole"],
  "months" => [0, "month"],  "moz" => [-3, "oz"],  "mpc" => [-3, "pc"],
  "mpsi" => [-3, "psi"],  "mrad" => [-3, "rad"],  "ms" => [-3, "s"],
  "msr" => [-3, "sr"],  "mt" => [-3, "t"],  "myr" => [-3, "yr"],
  "nA" => [-9, "A"],  "nAu" => [-9, "Au"],  "nBq" => [-9, "Bq"],
  "nC" => [-9, "C"],  "nF" => [-9, "F"],  "nG" => [-9, "G"],
  "nGal" => [-9, "Gal"],  "nGy" => [-9, "Gy"],  "nH" => [-9, "H"],
  "nHz" => [-9, "Hz"],  "nJ" => [-9, "J"],  "nK" => [-9, "K"],
  "nL" => [-9, "L"],  "nN" => [-9, "N"],  "nP" => [-9, "P"],
  "nPa" => [-9, "Pa"],  "nS" => [-9, "S"],  "nSt" => [-9, "St"],
  "nSv" => [-9, "Sv"],  "nT" => [-9, "T"],  "nV" => [-9, "V"],
  "nW" => [-9, "W"],  "nWb" => [-9, "Wb"],  "na" => [-9, "a"],
  "nac" => [-9, "ac"],  "nanoacre" => [-9, "acre"],
  "nanoampere" => [-9, "ampere"],  "nanoangstrom" => [-9, "angstrom"],
  "nanoare" => [-9, "are"],  "nanoatmosphere" => [-9, "atmosphere"],
  "nanocalorie" => [-9, "calorie"],  "nanocentury" => [-9, "century"],
  "nanochain" => [-9, "chain"],  "nanocoulomb" => [-9, "coulomb"],
  "nanoday" => [-9, "day"],  "nanodegree" => [-9, "degree"],
  "nanodegree_C" => [-9, "degree_C"],
  "nanodegree_E" => [-9, "degree_E"],
  "nanodegree_F" => [-9, "degree_F"],
  "nanodegree_N" => [-9, "degree_N"],
  "nanodegree_R" => [-9, "degree_R"],
  "nanodegree_S" => [-9, "degree_S"],
  "nanodegree_W" => [-9, "degree_W"],
  "nanodegree_c" => [-9, "degree_c"],
  "nanodegree_f" => [-9, "degree_f"],  "nanodyne" => [-9, "dyne"],
  "nanoerg" => [-9, "erg"],  "nanofermi" => [-9, "fermi"],
  "nanogal" => [-9, "gal"],  "nanogauss" => [-9, "gauss"],
  "nanogram" => [-9, "gram"],  "nanohectare" => [-9, "hectare"],
  "nanohertz" => [-9, "hertz"],  "nanohour" => [-9, "hour"],
  "nanoinch" => [-9, "inch"],  "nanojoule" => [-9, "joule"],
  "nanokelvin" => [-9, "kelvin"],  "nanokilogram" => [-9, "kilogram"],
  "nanoknot" => [-9, "knot"],  "nanolitre" => [-9, "litre"],
  "nanometer" => [-9, "meter"],  "nanometre" => [-9, "metre"],
  "nanomicron" => [-9, "micron"],  "nanomile" => [-9, "mile"],
  "nanominute" => [-9, "minute"],
  "nanominute_angle" => [-9, "minute_angle"],
  "nanomole" => [-9, "mole"],  "nanomonth" => [-9, "month"],
  "nanonewton" => [-9, "newton"],  "nanoounce" => [-9, "ounce"],
  "nanoparsec" => [-9, "parsec"],  "nanopascal" => [-9, "pascal"],
  "nanopentad" => [-9, "pentad"],  "nanopoise" => [-9, "poise"],
  "nanopound" => [-9, "pound"],  "nanoradian" => [-9, "radian"],
  "nanosecond" => [-9, "second"],
  "nanosecond_angle" => [-9, "second_angle"],
  "nanosteradian" => [-9, "steradian"],  "nanostokes" => [-9, "stokes"],
  "nanoton" => [-9, "ton"],  "nanotonne" => [-9, "tonne"],
  "nanotorr" => [-9, "torr"],  "nanovolt" => [-9, "volt"],
  "nanowatt" => [-9, "watt"],  "nanoyard" => [-9, "yard"],
  "nanoyd" => [-9, "yd"],  "nanoyear" => [-9, "year"],
  "natm" => [-9, "atm"],  "nbar" => [-9, "bar"],  "ncal" => [-9, "cal"],
  "nd" => [-9, "d"],  "ndyn" => [-9, "dyn"],  "nerg" => [-9, "erg"],
  "newtons" => [0, "newton"],  "nforce" => [-9, "force"],
  "ng" => [-9, "g"],  "nh" => [-9, "h"],  "nhr" => [-9, "hr"],
  "nin" => [-9, "in"],  "nkg" => [-9, "kg"],  "nkgf" => [-9, "kgf"],
  "nkph" => [-9, "kph"],  "nlb" => [-9, "lb"],  "nlm" => [-9, "lm"],
  "nlx" => [-9, "lx"],  "nly" => [-9, "ly"],  "nm" => [-9, "m"],
  "nmb" => [-9, "mb"],  "nmgal" => [-9, "mgal"],  "nmin" => [-9, "min"],
  "nmol" => [-9, "mol"],  "nmon" => [-9, "mon"],  "nmph" => [-9, "mph"],
  "nohm" => [-9, "ohm"],  "noz" => [-9, "oz"],  "npc" => [-9, "pc"],
  "npsi" => [-9, "psi"],  "nrad" => [-9, "rad"],  "ns" => [-9, "s"],
  "nsr" => [-9, "sr"],  "nt" => [-9, "t"],  "nyr" => [-9, "yr"],
  "ounces" => [0, "ounce"],  "pA" => [-12, "A"],  "pAu" => [-12, "Au"],
  "pBq" => [-12, "Bq"],  "pC" => [-12, "C"],  "pF" => [-12, "F"],
  "pG" => [-12, "G"],  "pGal" => [-12, "Gal"],  "pGy" => [-12, "Gy"],
  "pH" => [-12, "H"],  "pHz" => [-12, "Hz"],  "pJ" => [-12, "J"],
  "pK" => [-12, "K"],  "pL" => [-12, "L"],  "pN" => [-12, "N"],
  "pP" => [-12, "P"],  "pPa" => [-12, "Pa"],  "pS" => [-12, "S"],
  "pSt" => [-12, "St"],  "pSv" => [-12, "Sv"],  "pT" => [-12, "T"],
  "pV" => [-12, "V"],  "pW" => [-12, "W"],  "pWb" => [-12, "Wb"],
  "pa" => [-12, "a"],  "pac" => [-12, "ac"],
  "parsecs" => [0, "parsec"],  "pascals" => [0, "pascal"],
  "patm" => [-12, "atm"],  "pbar" => [-12, "bar"],
  "pcal" => [-12, "cal"],  "pd" => [-12, "d"],  "pdyn" => [-12, "dyn"],
  "pentads" => [0, "pentad"],  "perg" => [-12, "erg"],
  "petaacre" => [15, "acre"],  "petaampere" => [15, "ampere"],
  "petaangstrom" => [15, "angstrom"],  "petaare" => [15, "are"],
  "petaatmosphere" => [15, "atmosphere"],
  "petacalorie" => [15, "calorie"],  "petacentury" => [15, "century"],
  "petachain" => [15, "chain"],  "petacoulomb" => [15, "coulomb"],
  "petaday" => [15, "day"],  "petadegree" => [15, "degree"],
  "petadegree_C" => [15, "degree_C"],
  "petadegree_E" => [15, "degree_E"],
  "petadegree_F" => [15, "degree_F"],
  "petadegree_N" => [15, "degree_N"],
  "petadegree_R" => [15, "degree_R"],
  "petadegree_S" => [15, "degree_S"],
  "petadegree_W" => [15, "degree_W"],
  "petadegree_c" => [15, "degree_c"],
  "petadegree_f" => [15, "degree_f"],  "petadyne" => [15, "dyne"],
  "petaerg" => [15, "erg"],  "petafermi" => [15, "fermi"],
  "petagal" => [15, "gal"],  "petagauss" => [15, "gauss"],
  "petagram" => [15, "gram"],  "petahectare" => [15, "hectare"],
  "petahertz" => [15, "hertz"],  "petahour" => [15, "hour"],
  "petainch" => [15, "inch"],  "petajoule" => [15, "joule"],
  "petakelvin" => [15, "kelvin"],  "petakilogram" => [15, "kilogram"],
  "petaknot" => [15, "knot"],  "petalitre" => [15, "litre"],
  "petameter" => [15, "meter"],  "petametre" => [15, "metre"],
  "petamicron" => [15, "micron"],  "petamile" => [15, "mile"],
  "petaminute" => [15, "minute"],
  "petaminute_angle" => [15, "minute_angle"],
  "petamole" => [15, "mole"],  "petamonth" => [15, "month"],
  "petanewton" => [15, "newton"],  "petaounce" => [15, "ounce"],
  "petaparsec" => [15, "parsec"],  "petapascal" => [15, "pascal"],
  "petapentad" => [15, "pentad"],  "petapoise" => [15, "poise"],
  "petapound" => [15, "pound"],  "petaradian" => [15, "radian"],
  "petasecond" => [15, "second"],
  "petasecond_angle" => [15, "second_angle"],
  "petasteradian" => [15, "steradian"],  "petastokes" => [15, "stokes"],
  "petaton" => [15, "ton"],  "petatonne" => [15, "tonne"],
  "petatorr" => [15, "torr"],  "petavolt" => [15, "volt"],
  "petawatt" => [15, "watt"],  "petayard" => [15, "yard"],
  "petayd" => [15, "yd"],  "petayear" => [15, "year"],
  "pforce" => [-12, "force"],  "pg" => [-12, "g"],  "ph" => [-12, "h"],
  "phr" => [-12, "hr"],  "picoacre" => [-12, "acre"],
  "picoampere" => [-12, "ampere"],  "picoangstrom" => [-12, "angstrom"],
  "picoare" => [-12, "are"],  "picoatmosphere" => [-12, "atmosphere"],
  "picocalorie" => [-12, "calorie"],  "picocentury" => [-12, "century"],
  "picochain" => [-12, "chain"],  "picocoulomb" => [-12, "coulomb"],
  "picoday" => [-12, "day"],  "picodegree" => [-12, "degree"],
  "picodegree_C" => [-12, "degree_C"],
  "picodegree_E" => [-12, "degree_E"],
  "picodegree_F" => [-12, "degree_F"],
  "picodegree_N" => [-12, "degree_N"],
  "picodegree_R" => [-12, "degree_R"],
  "picodegree_S" => [-12, "degree_S"],
  "picodegree_W" => [-12, "degree_W"],
  "picodegree_c" => [-12, "degree_c"],
  "picodegree_f" => [-12, "degree_f"],  "picodyne" => [-12, "dyne"],
  "picoerg" => [-12, "erg"],  "picofermi" => [-12, "fermi"],
  "picogal" => [-12, "gal"],  "picogauss" => [-12, "gauss"],
  "picogram" => [-12, "gram"],  "picohectare" => [-12, "hectare"],
  "picohertz" => [-12, "hertz"],  "picohour" => [-12, "hour"],
  "picoinch" => [-12, "inch"],  "picojoule" => [-12, "joule"],
  "picokelvin" => [-12, "kelvin"],  "picokilogram" => [-12, "kilogram"],
  "picoknot" => [-12, "knot"],  "picolitre" => [-12, "litre"],
  "picometer" => [-12, "meter"],  "picometre" => [-12, "metre"],
  "picomicron" => [-12, "micron"],  "picomile" => [-12, "mile"],
  "picominute" => [-12, "minute"],
  "picominute_angle" => [-12, "minute_angle"],
  "picomole" => [-12, "mole"],  "picomonth" => [-12, "month"],
  "piconewton" => [-12, "newton"],  "picoounce" => [-12, "ounce"],
  "picoparsec" => [-12, "parsec"],  "picopascal" => [-12, "pascal"],
  "picopentad" => [-12, "pentad"],  "picopoise" => [-12, "poise"],
  "picopound" => [-12, "pound"],  "picoradian" => [-12, "radian"],
  "picosecond" => [-12, "second"],
  "picosecond_angle" => [-12, "second_angle"],
  "picosteradian" => [-12, "steradian"],
  "picostokes" => [-12, "stokes"],  "picoton" => [-12, "ton"],
  "picotonne" => [-12, "tonne"],  "picotorr" => [-12, "torr"],
  "picovolt" => [-12, "volt"],  "picowatt" => [-12, "watt"],
  "picoyard" => [-12, "yard"],  "picoyd" => [-12, "yd"],
  "picoyear" => [-12, "year"],  "pin" => [-12, "in"],
  "pkg" => [-12, "kg"],  "pkgf" => [-12, "kgf"],
  "pkph" => [-12, "kph"],  "plb" => [-12, "lb"],  "plm" => [-12, "lm"],
  "plx" => [-12, "lx"],  "ply" => [-12, "ly"],  "pm" => [-12, "m"],
  "pmb" => [-12, "mb"],  "pmgal" => [-12, "mgal"],
  "pmin" => [-12, "min"],  "pmol" => [-12, "mol"],
  "pmon" => [-12, "mon"],  "pmph" => [-12, "mph"],
  "pohm" => [-12, "ohm"],  "poises" => [0, "poise"],
  "pounds" => [0, "pound"],  "poz" => [-12, "oz"],
  "ppc" => [-12, "pc"],  "ppsi" => [-12, "psi"],
  "prad" => [-12, "rad"],  "ps" => [-12, "s"],  "psr" => [-12, "sr"],
  "pt" => [-12, "t"],  "pyr" => [-12, "yr"],
  "radians" => [0, "radian"],  "seconds" => [0, "second"],
  "seconds_angle" => [0, "second_angle"],
  "steradians" => [0, "steradian"],  "stokeses" => [0, "stokes"],
  "telaacre" => [12, "acre"],  "telaampere" => [12, "ampere"],
  "telaangstrom" => [12, "angstrom"],  "telaare" => [12, "are"],
  "telaatmosphere" => [12, "atmosphere"],
  "telacalorie" => [12, "calorie"],  "telacentury" => [12, "century"],
  "telachain" => [12, "chain"],  "telacoulomb" => [12, "coulomb"],
  "teladay" => [12, "day"],  "teladegree" => [12, "degree"],
  "teladegree_C" => [12, "degree_C"],
  "teladegree_E" => [12, "degree_E"],
  "teladegree_F" => [12, "degree_F"],
  "teladegree_N" => [12, "degree_N"],
  "teladegree_R" => [12, "degree_R"],
  "teladegree_S" => [12, "degree_S"],
  "teladegree_W" => [12, "degree_W"],
  "teladegree_c" => [12, "degree_c"],
  "teladegree_f" => [12, "degree_f"],  "teladyne" => [12, "dyne"],
  "telaerg" => [12, "erg"],  "telafermi" => [12, "fermi"],
  "telagal" => [12, "gal"],  "telagauss" => [12, "gauss"],
  "telagram" => [12, "gram"],  "telahectare" => [12, "hectare"],
  "telahertz" => [12, "hertz"],  "telahour" => [12, "hour"],
  "telainch" => [12, "inch"],  "telajoule" => [12, "joule"],
  "telakelvin" => [12, "kelvin"],  "telakilogram" => [12, "kilogram"],
  "telaknot" => [12, "knot"],  "telalitre" => [12, "litre"],
  "telameter" => [12, "meter"],  "telametre" => [12, "metre"],
  "telamicron" => [12, "micron"],  "telamile" => [12, "mile"],
  "telaminute" => [12, "minute"],
  "telaminute_angle" => [12, "minute_angle"],
  "telamole" => [12, "mole"],  "telamonth" => [12, "month"],
  "telanewton" => [12, "newton"],  "telaounce" => [12, "ounce"],
  "telaparsec" => [12, "parsec"],  "telapascal" => [12, "pascal"],
  "telapentad" => [12, "pentad"],  "telapoise" => [12, "poise"],
  "telapound" => [12, "pound"],  "telaradian" => [12, "radian"],
  "telasecond" => [12, "second"],
  "telasecond_angle" => [12, "second_angle"],
  "telasteradian" => [12, "steradian"],  "telastokes" => [12, "stokes"],
  "telaton" => [12, "ton"],  "telatonne" => [12, "tonne"],
  "telatorr" => [12, "torr"],  "telavolt" => [12, "volt"],
  "telawatt" => [12, "watt"],  "telayard" => [12, "yard"],
  "telayd" => [12, "yd"],  "telayear" => [12, "year"],
  "tonnes" => [0, "tonne"],  "tons" => [0, "ton"],
  "torrs" => [0, "torr"],  "uA" => [-6, "A"],  "uAu" => [-6, "Au"],
  "uBq" => [-6, "Bq"],  "uC" => [-6, "C"],  "uF" => [-6, "F"],
  "uG" => [-6, "G"],  "uGal" => [-6, "Gal"],  "uGy" => [-6, "Gy"],
  "uH" => [-6, "H"],  "uHz" => [-6, "Hz"],  "uJ" => [-6, "J"],
  "uK" => [-6, "K"],  "uL" => [-6, "L"],  "uN" => [-6, "N"],
  "uP" => [-6, "P"],  "uPa" => [-6, "Pa"],  "uS" => [-6, "S"],
  "uSt" => [-6, "St"],  "uSv" => [-6, "Sv"],  "uT" => [-6, "T"],
  "uV" => [-6, "V"],  "uW" => [-6, "W"],  "uWb" => [-6, "Wb"],
  "ua" => [-6, "a"],  "uac" => [-6, "ac"],  "uatm" => [-6, "atm"],
  "ubar" => [-6, "bar"],  "ucal" => [-6, "cal"],  "ud" => [-6, "d"],
  "udyn" => [-6, "dyn"],  "uerg" => [-6, "erg"],
  "uforce" => [-6, "force"],  "ug" => [-6, "g"],  "uh" => [-6, "h"],
  "uhr" => [-6, "hr"],  "uin" => [-6, "in"],  "ukg" => [-6, "kg"],
  "ukgf" => [-6, "kgf"],  "ukph" => [-6, "kph"],  "ulb" => [-6, "lb"],
  "ulm" => [-6, "lm"],  "ulx" => [-6, "lx"],  "uly" => [-6, "ly"],
  "um" => [-6, "m"],  "umb" => [-6, "mb"],  "umgal" => [-6, "mgal"],
  "umin" => [-6, "min"],  "umol" => [-6, "mol"],  "umon" => [-6, "mon"],
  "umph" => [-6, "mph"],  "uohm" => [-6, "ohm"],  "uoz" => [-6, "oz"],
  "upc" => [-6, "pc"],  "upsi" => [-6, "psi"],  "urad" => [-6, "rad"],
  "us" => [-6, "s"],  "usr" => [-6, "sr"],  "ut" => [-6, "t"],
  "uyr" => [-6, "yr"],  "volts" => [0, "volt"],  "watts" => [0, "watt"],
  "yards" => [0, "yard"],  "yds" => [0, "yd"],  "years" => [0, "year"],
}
UPLURALS = {
  "acres" => "acre",  "amperes" => "ampere",  "angstroms" => "angstrom",
  "ares" => "are",  "atmospheres" => "atmosphere",
  "calories" => "calorie",  "centuries" => "century",
  "chains" => "chain",  "coulombs" => "coulomb",  "days" => "day",
  "degrees" => "degree",  "degrees_C" => "degree_C",
  "degrees_E" => "degree_E",  "degrees_F" => "degree_F",
  "degrees_N" => "degree_N",  "degrees_R" => "degree_R",
  "degrees_S" => "degree_S",  "degrees_W" => "degree_W",
  "degrees_c" => "degree_c",  "degrees_f" => "degree_f",
  "dynes" => "dyne",  "ergs" => "erg",  "fermis" => "fermi",
  "gals" => "gal",  "gausses" => "gauss",  "grams" => "gram",
  "hectares" => "hectare",  "hertzes" => "hertz",  "hours" => "hour",
  "inchs" => "inch",  "joules" => "joule",  "kelvins" => "kelvin",
  "kilograms" => "kilogram",  "knots" => "knot",  "litres" => "litre",
  "meters" => "meter",  "metres" => "metre",  "microns" => "micron",
  "miles" => "mile",  "minutes" => "minute",
  "minutes_angle" => "minute_angle",  "moles" => "mole",
  "months" => "month",  "newtons" => "newton",  "ounces" => "ounce",
  "parsecs" => "parsec",  "pascals" => "pascal",  "pentads" => "pentad",
  "poises" => "poise",  "pounds" => "pound",  "radians" => "radian",
  "seconds" => "second",  "seconds_angle" => "second_angle",
  "steradians" => "steradian",  "stokeses" => "stokes",
  "tonnes" => "tonne",  "tons" => "ton",  "torrs" => "torr",
  "volts" => "volt",  "watts" => "watt",  "yards" => "yard",
  "yds" => "yd",  "years" => "year",
}
end
