
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of libdap, A C++ implementation of the OPeNDAP Data
// Access Protocol.

// Copyright (c) 2004 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef nc_util_h
#define nc_util_h 1

#include <list>

// These constants define the various netCDF types. They are ultimately 
// passed to Dtypelen.
#define Tvoid 0
#define Ttext 1
#define Tuchar 2
#define Tschar 3
#define Tshort 4
#define Tint 5
#define Tlong 6
#define Tfloat 7
#define Tdouble 8

#define STRING_AS_ARRAY 1
#define STRING_ARRAY_SIZE 128

typedef list<BaseType*> VarList;
typedef list<BaseType*>::iterator VarListIter;
typedef list<BaseType*>::const_iterator VarListCIter;

typedef list<AttrTable::entry> EntryList;

// Utility functions used by the netCDF CL code.

int copy_attributes(AttrTable &attr, AttrTable::Attr_iter &p, void *values) 
    throw(InternalErr);
EntryList *transfer_attributes_to_list(AttrTable *, const string &name = "");
AttrTable *attributes_list_to_table(EntryList *el);
void var_info(int cdfid, BaseType *bt, nc_type *typep, int *ndimsp, int dims[]) 
    throw(InternalErr);
int convert_nc_type(nc_type typep, int outtype, int nels, void *tmpbufin, 
    void *values);
int number_of_elements(const string &clause);
BaseType *find_ancestral_sequence(BaseType *child);

int DODvario(int cdfid, int varid, const size_t *start, const size_t *edges,
    const ptrdiff_t *stride, void *values, int outtype);
int GenRead(int cdfid, int varid, const size_t *start, const size_t *count,
    const ptrdiff_t *stride, const ptrdiff_t *imap, void *values, 
    int outtype);
    

// $Log: nc_util.h,v $
// Revision 1.8  2005/04/11 18:38:20  jimg
// Fixed a problem with NCSequence where nested sequences were not flagged
// but instead were translated. The extract_values software cannot process a
// nested sequence yet. Now the code inserts an attribute that notes that a
// nested sequence has been elided.
//
// Revision 1.7  2005/03/23 18:43:13  jimg
// Added prototypes for the new code to flatten AttrTables.
//
// Revision 1.6  2005/02/26 00:43:20  jimg
// Check point: This version of the CL can now translate strings from the
// server into char arrays. This is controlled by two things: First a
// compile-time directive STRING_AS_ARRAY can be used to remove/include
// this feature. When included in the code, only Strings associated with
// variables created by the translation process will be turned into char
// arrays. Other String variables are assumed to be single character strings
// (although there may be a bug with the way these are handled, see
// NCAccess::extract_values()).
//
// Revision 1.5  2004/11/30 22:11:35  jimg
// I replaced the flatten_*() functions with a flatten() method in
// NCAccess. The default version of this method is in NCAccess and works
// for the atomic types; constructors must provide a specialization.
// Then I removed the code that copied the variables from vectors to
// lists. The translation code in NCConnect was modified to use the
// new method.
//
// Revision 1.4  2004/11/08 20:20:21  jimg
// Added declarations for the list_to_variables() functions.
//
// Revision 1.3  2004/11/05 17:13:57  jimg
// Added code to copy the BaseType pointers from the vector container into
// a list. This will enable more efficient translation software to be
// written.
//
// Revision 1.2  2004/09/08 22:08:22  jimg
// More Massive changes: Code moved from the files that clone the netCDF
// function calls into NCConnect, NCAccess or nc_util.cc. Much of the
// translation functions are now methods. The netCDF type classes now
// inherit from NCAccess in addition to the DAP type classes.
//
#endif
