
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of libdap, A C++ implementation of the OPeNDAP Data
// Access Protocol.

// Copyright (c) 2002,2003 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// You can contact OPeNDAP, Inc. at PO Box 112, Saunderstown, RI. 02874-0112.

#ifndef cache_http_response_h
#define cache_http_response_h

#include <stdio.h>

#ifndef response_h
#include "Response.h"
#endif

#ifndef _debug_h
#include "debug.h"
#endif

/** Encapsulate a response. Instead of directly returning the FILE pointer
    from which a response is read, return an instance of this object. */
class HTTPCacheResponse : public HTTPResponse {
private:
    HTTPCache *d_cache;		// pointer to singleton instance

protected:
    /** @name Suppressed default methods */
    //@{
    HTTPCacheResponse() {}
    HTTPCacheResponse(const HTTPCacheResponse &rs) {}
    HTTPCacheResponse &operator=(const HTTPCacheResponse &rhs) {
	throw InternalErr(__FILE__, __LINE__, "Unimplemented assignment");
    }
    //@}

public:
    /** Build a Response object. Instances of this class are used to
	represent responses from a local HTTP/1.1 cache. The stream and
	headers pointer are passed to the parent (HTTPResponse); there's no
	temporary file for the parent to manage since the body is read from a
	file managed by the cache subsystem. This class releases the lock on
	the cache entry when the destructor is called. */
    HTTPCacheResponse(FILE *s, vector<string> *headers, HTTPCache *c) 
	: HTTPResponse(s, headers, ""), d_cache(c) {}

    /** Free the cache entry lock. Call the parent's destructor. */
    virtual ~HTTPCacheResponse() {
	DBG(cerr << "Freeing HTTPCache respources... ");
	d_cache->release_cached_response(get_stream());
	DBGN(cerr << endl);
    }
};

// $Log: HTTPCacheResponse.h,v $
// Revision 1.2  2003/12/08 18:02:29  edavis
// Merge release-3-4 into trunk
//
// Revision 1.1.2.1  2003/05/06 06:44:15  jimg
// Modified HTTPConnect so that the response headers are no longer a class
// member. This cleans up the class interface and paves the way for using
// the multi interface of libcurl. That'll have to wait for another day...
//
// Revision 1.1  2003/03/04 05:57:40  jimg
// Added.
//

#endif // cache_http_response_h
