begin
  require "numru/nusdas"
rescue LoadError
  module NumRu
    class NuSDaS
      class << self
        def new(path)
          raise "nusdas library is not found"
        end
	alias :open :new
        def is_a_NuSDaS?(path)
          return false
        end
      end
    end
  end
end
require "numru/gphys/varraynusdas"

module NumRu
  class GPhys

    module NuSDaS_IO

      def is_a_NuSDaS?(path)
        NuSDaS.is_a_NuSDaS?(path)
      end
      module_function :is_a_NuSDaS?

      def open(nusdas, varname)
        if String === nusdas
          nusdas = NuSDaS.new(nusdas)
        end
        unless NuSDaS === nusdas
          raise ArgumentError, "1st arg must be a NuSDaS of path name"
        end

        var = nusdas.var(varname)
        var.nil? && raise("#{varname} is not found")
        data = VArrayNuSDaS.new(var)

        axes = Array.new
        dns = var.dim_names
        lonlat = (dns.include?("lon") && dns.include?("lat"))
        dns.each{|dn|
          dim = var.dim(dn)
          attr = Hash.new
          dim.att_names.each{|an| attr[an] = dim.att(an)}
          dn << "_ref" if lonlat && /\A(lon|lat)\z/ =~ dn
          axpos = VArray.new(dim.val(:reference), attr, dn)
          axis = Axis.new(false, true)
          axis.set_pos(axpos)
          axes.push axis
        }
        grid = Grid.new(*axes)
        gphys = GPhys.new(grid, data)

        if lonlat
          x = gphys.axis("lon_ref")
          y = gphys.axis("lat_ref")
          xy = Grid.new(x,y)
          vlon = VArray.new(var.dim("lon").val(:full), y.pos.attr_copy, "lon")
          vlat = VArray.new(var.dim("lat").val(:full), y.pos.attr_copy, "lat")
          glon = GPhys.new(xy, vlon)
          glat = GPhys.new(xy, vlat)
          ary = [glon,glat]
          gphys.set_assoc_coords(ary)
        end

        return gphys
      end
      module_function :open

      def var_names(nusdas)
        opened = false
        case nusdas
        when String
          nusdas = NuSDaS.new(nusdas)
        when NuSDaS
          opened = true
        else
          raise ArgumentError, "arg must be NuSDaS or path name"
        end
        var_names = nusdas.var_names
        nusdas.close unless opened
        return var_names
      end
      module_function :var_names

      alias :var_names_except_coordinates :var_names
      module_function :var_names_except_coordinates

    end
  end
end

