subroutine DCCalDateCurrent1( date, err )
  !
  ! »֤ dc_calendar_types#DC_CAL_DATE 
  ! date ֤ޤ. 
  ! »֤ Fortran 90 ʹߤȤ߹ߥ֥롼Ǥ 
  ! date_and_time ޤ. 
  !
  ! Return actual time +date+ (type "dc_calendar_types#DC_CAL_DATE"). 
  ! The actual time is acquired by "date_and_time" that is 
  ! a built-in subroutine of Fortran 90 or more. 
  !
  use dc_calendar_generic, only: DCCalDateParseStr, DCCalDateCreate
  use dc_calendar_types, only: DC_CAL_DATE
  use dc_calendar_internal, only: default_date
  use dc_message, only: MessageNotify
  use dc_types, only: DP, TOKEN
  use dc_trace, only: BeginSub, EndSub
  use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, DC_EBADDATE
  use dc_types, only: STRING
  implicit none
  type(DC_CAL_DATE), intent(out):: date
                              ! »֤᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! date and time of actual time. 
  logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


  ! ѿ
  ! Work variables
  !
  integer :: date_time_values(1:8)
  character(5)  :: zone_raw

  integer:: year  ! ǯ. Year.
  integer:: month ! . Month.
  integer:: day   ! . Day.
  integer:: hour  ! . Hour.
  integer:: min   ! ʬ. Minute.
  real(DP):: sec  ! . Second.
  character(TOKEN):: zone
                  ! UTC λ. Time-zone.
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter:: subname = 'DCCalDateCurrent1'
continue
  call BeginSub( subname )
  stat = DC_NOERR
  cause_c = ''

!!$  ! Υå
!!$  ! Check initialization
!!$  !
!!$  if ( datep % initialized ) then
!!$    stat = DC_EALREADYINIT
!!$    cause_c = 'DC_CAL_DATE'
!!$    goto 999
!!$  end if


  ! date_and_time Ȥ߹ߥ֥롼Ѥ, 
  !  UTC λ. 
  !
  call date_and_time(zone=zone_raw, values=date_time_values)
  zone = zone_raw(1:3) // ":" // zone_raw(4:5)


  ! ֥Ȥκ
  ! Create an object
  !
  call DCCalDateCreate( &
    & date_time_values(1), date_time_values(2), date_time_values(3), & ! (in)
    & date_time_values(5), date_time_values(6), &                      ! (in)
    & real( date_time_values(7), DP ), & ! (in)
    & date, zone, err = err )            ! (out) optional
  if ( present(err) ) then
    if ( err ) then
      stat = DC_EBADDATE
      goto 999
    end if
  end if

  ! λ, 㳰
  ! Termination and Exception handling
  !
999 continue
  call StoreError( stat, subname, err, cause_c )
  call EndSub( subname )
end subroutine DCCalDateCurrent1
