=begin JA

= ǥХå

# *  (odakker)
#   * $Id: dc_trace.rd,v 1.3 2009-02-28 13:36:32 morikawa Exp $

=end JA
=begin EN

= Debug support

# *  (odakker)
#   * $Id: dc_trace.rd,v 1.3 2009-02-28 13:36:32 morikawa Exp $

=end EN

=begin JA

gtool5 饤֥ˤ, 
ǥХåθפ륵֥롼󶡤⥸塼 
((<dc_trace|URL:../code_reference/classes/dc_trace.html>)) Ѱդ
Ƥޤ. ѤȥǥХåΥץפŪưפ
ԤȤǽȤʤޤ. 

Ȥ, 
((<"Fortran 90/95 ѥ⥸塼: åν"|URL:dc_message.htm>)) 
Ѥ((<ץץ|URL:dc_message/diffusion_4.f90>))
ǥХåϤäץ򼨤ޤ 
(ɤ((<|URL:dc_trace/diffusion_6.f90>))). 
ֻ(顼Ǥʤϥܡ) dc_trace ˴طƤսǤ.

=end JA
=begin EN

((<Dc_trace|URL:../code_reference/classes/dc_trace.html>)) module of 
gtool5 provides subroutines useful for debugging user's programs.
By using dc_trace module, it is easy to trace user's program in debugging.

For example, a sample program using the dc_clock module
(((<diffusion_6.f90|URL:dc_trace/diffusion_6.f90>))) is shown here, which are
modified from ((<diffusion_4.f90|URL:dc_message/diffusion_4.f90>)) in ((<"
Fortran 90/95 general-purpose modules: Message
dump"|URL:dc_message.htm.en>)).  Statements with colored font (or bold
font) are associated with the dc_clock module.

=end EN



=begin HTML
<pre style="background-color: #FFFFFF; color: blue; border-style: groove; border-width: 2">
!= Sample program for gtool_history/gtool5
!
! * 2007/06/27 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_6

  use gtool_history                                   ! Access module (⥸塼)
  use dc_types, only : DP                           ! Access module (⥸塼)
  use dc_message, only : MessageNotify              ! Access module (⥸塼)
  <b><font color="red">use dc_trace, only : SetDebug, DbgMessage         ! Access module (⥸塼)</font></b>

  integer, parameter     :: nx=30                   ! Grid number (åɿ)
  integer, parameter     :: nt=200                  ! Time step number (֥ƥå׿)
  integer, parameter     :: ndisp=10                ! Output interval (ϴֳ)
  real(DP), parameter    :: dx=1.0/(nx-1)           ! Grid interval (åɴֳ)
  real(DP), parameter    :: dt=0.0005               ! Time step (ֳִ)
  real(DP), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! X coordinate (ɸѿ)
  real(DP), dimension(nx):: temp                    ! Temperature ()
  real(DP), parameter    :: kappa=1.0               ! Diffusion coefficient (ǮȻ)
  real(DP)               :: sigma                   ! Parameter (׻ѥ᥿)

  <b><font color="red">call SetDebug                                     ! Debug mode on 
                                                    ! (ǥХå⡼ɥ)

  call DbgMessage(fmt="*** Debug Message [diffusion_6] *** Debug Message On")
                                                    ! Debug message dump 
                                                    ! (ǥХå)  </font></b>

  tinit = 0.0                                       ! Set initial time 
                                                    ! ()

  sigma = kappa*dt/dx**2.0d0

  if ( sigma >= 0.5d0 ) then
    call MessageNotify( "E", &amp;                      ! Error mesage dump 
      &amp;                 "diffusion_6", &amp;            !(顼å )
      &amp;                 "dt is too large: k*dt/(dx)^2 = %f", &amp;
      &amp;                  d=(/sigma/) )
  else if ( sigma >= 0.4d0 ) then
    call MessageNotify( "W", &amp;                      ! Warning message dump
      &amp;                 "diffusion_6", &amp;            ! (ٹå)
      &amp;                 "dt is moderately large: k*dt/(dx)^2 = %f", &amp;
      &amp;                 d=(/sigma/) )
  else
    call MessageNotify( "M", &amp;                      ! Message dump 
      &amp;                 "diffusion_6", &amp;            ! (å) 
      &amp;                 "dt is sufficiently small: k*dt/(dx)^2 = %f", &amp;
      &amp;                  d=(/sigma/) )
  end if
    
  temp = exp(-((x-0.5)/0.1)**2)                     ! Set initial value 
                                                    ! ()

  call HistoryCreate( &amp;                             ! Create output file 
    &amp; file='diffusion_6.nc', &amp;                      ! (ҥȥ꡼)
    &amp; title='Diffusion equation',                        &amp;
    &amp; source='Sample program of gtool_history/gtool5',   &amp;
    &amp; institution='GFD_Dennou Club davis project',       &amp;
    &amp; dims=(/'x','t'/), dimsizes=(/nx,0/),               &amp;
    &amp; longnames=(/'X-coordinate','time        '/),       &amp;
    &amp; units=(/'m','s'/),                                 &amp;
    &amp; origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                            ! Output 'x' (ѿ)

  call HistoryAddVariable( &amp;                        ! Set output variable 
    &amp; varname='temp', dims=(/'x','t'/), &amp;           ! (ѿ)
    &amp; longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! Output 'temp' (ѿ)

  
    <b><font color="red">call DbgMessage(fmt="*** Debug Message [diffusion_6] *** Begin time integration")
                                                    ! Debug message dump
                                                    ! (ǥХå) </font></b>
  
    do it=1,nt
  
      temp(2:nx-1) = temp(2:nx-1) &amp;                 ! Time integration (ʬ)
        &amp; + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt
  
      if ( mod(it,ndisp) == 0 ) then
        call HistoryPut('temp',temp)                ! Output 'temp (ѿ)
      endif
  
      <b><font color="red">call DbgMessage(fmt="*** Debug Message [diffusion_6] *** it=%d, &amp;
        &amp;             i= (/it/) )               
                                                    ! Debug message dump
                                                    ! (ǥХå) </font></b>
  
    end do
  
    <b><font color="red">call DbgMessage(fmt="*** Debug Message [diffusion_6] *** End time integration")                           
                                                    ! Debug message dump
                                                    ! (ǥХå) </font></b>
  
  call HistoryClose
  
  stop
  end program diffusion_6
  
</pre>
=end HTML
  
=begin JA
  
ΥץǤ, ʬ롼ʬȥ롼˥å
Ƥޤ. åɸ२顼Ϥ˽Ϥޤ. ϰʲǤ. 
gtool5 饤֥󶡤륵֥롼ΥǥХåϤ⥪ˤʤޤ.

=end JA
=begin EN

In this program, debug messages are dumped before and after the loop
of time integration. The messages are displayed on standard error out as
follows. Debug messages included subroutines of gtool5 library are
also dumped.

=endn EN

=begin  
  
    #SetDebug: dbg = 0
    #*** Debug Message [diffusion_5] *** Debug Message On
     *** WARNING [diffusion_6] ***  dt is moderately large: k*dt/(dx)^2 = 0.4205000231056476
    #call HistoryCreate1 version=<$Name: gtool5-20090302 $$Id: dc_trace.rd,v 1.3 2009-02-28 13:36:32 morikawa Exp $> : file=diffusion_6.nc ndims=2
    #|-dims(:)=x, t, dimsizes(:)=30, 0, longnames(:)=X-coordinate, time, units(:)=m, s
    #| call DCDateTimeCreate1 : current_time_used=<yes>
    #| end DCDateTimeCreate1 : time (caltype=4, day=733253, sec=5976., zone=+09:00, day_seconds=86400.)
    #| call DCDateTimeEval1
    #| end DCDateTimeEval1
    #| call GTVarCreateD version=<$Name: gtool5-20090302 $$Id: dc_trace.rd,v 1.3 2009-02-28 13:36:32 morikawa Exp $> : url=<diffusion_6.nc@x> length=30
    #| | call ANVarCreateD : url=<diffusion_6.nc@x>, xtype=<>, length=<30>
    #| | | call ANFileOpen : writable=yes overwrite=yes file=diffusion_6.nc
     *** MESSAGE [ANFileOpen] ***  diffusion_6.nc is overwritten.
    #| | | end ANFileOpen : id=4 stat=0
    #| | |-anfiledefinemode 4
    #| | |-an_vartable.add: added 1
    #| | end ANVarCreateD : stat=0
    #| |-[gt_variable 1: ndims=1, map.size=1]
    #| |-[dim1 dimno=1 ofs=0 step=1 all=30 start=1 count=30 stride=1 url=]
    #| |-[vartable 1: class=netcdf cid=1 ref=1]
    #| |-[AN_VARIABLE(file=4, var=1, dim=1)]
    #| end GTVarCreateD : class=netcdf mapid=1
  
=end 

  
=begin JA

ʲǤ dc_trace ⥸塼 ֥롼󤬹ԤäƤ뤳Ȥޤޤ.
ǰäƤʤ֥롼εǽޤܤ
((<ե󥹥ޥ˥奢|URL:../code_reference/classes/dc_trace.html>)) 
򻲾ȤƤ.
  
: use dc_trace
 
  ⥸塼λѤޤ. Fortran90 ᥤץƬˤ
  ޤ礦. Ǥ only ʸѤɬפʥ֥롼򻲾Ȥޤ. 
  
  
: SetDebug
  
  ǥХå⡼ɤ򥪥ˤޤ. ˤ, DbgMessage, BeginSub, EndSub
  ʤɤΥ֥롼ͭˤʤޤ. 
  
  
: DbgMessage(fmt, [i], [r], [d], [L], [n], [c1], [c2], [c3], [ca])
  
  SetDebug  call 줿,  ((*fmt*)) Ϳ줿ʸ
  ɸ२顼Ϥ˽Ϥޤ. ((*fmt*)) ѿͤޤ뤳ȤǤޤ.
  ξ, ץб뷿ѿꤷޤ.
  
  ưΰ̣ϰʲ̤Ǥ. 
    
  * ((*fmt*)) Ͻ񼰤ꤹǤ.
    Ǥѿ it ͤϤ뤿, ѿؼ ((*%i*)) 
    ѤƤޤ. 
    ѿؼξܺ٤ˤĤƤ ((<dcstringprintf.f90|URL:../code_reference/files/dcstringsprintf_f90.html>)) 򻲾ȤƤ.

  * ((*[i], [r], [d], [L], [n], [c1], [c2], [c3]*)) ϥץ, 
    ((*fmt*)) ѿͤꤷޤ. 
    ǤѿѤΥץ ((*[d]*)) 
    ѿ it Ƥޤ. ץξܺ٤ˤĤƤ
    ((<dc_string|URL:../code_reference/classes/dc_string.html>)) 
    ⥸塼
    ((<Cprintf|URL:../code_reference/classes/dc_string.html#M000818>)) 
    ؿ򻲾ȤƤ.


=end JA
=begin EN

Summary of dc_drace module and its subroutines used in the sample
program are as follows. In detail, please see ((<gtool5 reference
manual|URL:../code_reference/classes/dc_trace.html>)).

  
: use dc_trace

  Access dc_trace module. This statement is located at the beginning
  of main program. In this case, ONLY option is used.
  
  
: SetDebug

  Turn on debug mode. By calling this subroutine, DbgMessage, BeginSub, and 
  EndSub subroutines of dc_trace module can be used.
  
  
: DbgMessage(fmt, [i], [r], [d], [L], [n], [c1], [c2], [c3], [ca])

  Dump string given as argument ((*fmt*)) on standard error out 
  when SetDebug subroutine is called.
  The argument ((*fmt*)) can include variables which are specified 
  by corresponding type optional arguments.

  Descriptions of each argument are as follows. 

  * ((*fmt*)) specifies format of dumped string. 
    In this case,
    integer literal constant "it" 
    is included in the dump message by using 
    assignment argument ((*%d*)). 
    In details of assignment arguments, please see ((<dcstringprintf.f90|URL:../code_reference/files/dcstringsprintf_f90.html>)).

  * ((*[i], [r], [d], [L], [n], [c1], [c2], [c3]*)) are optional arguments
    which specify the variable included in the string assigned in
    ((*fmt*)).
    In this case, optional argument ((*[i]*)) for 
    integer literal constant is used.
    In details of the optional arguments, 
    please see 
    ((<Cprintf|URL:../code_reference/classes/dc_string.html#M000818>)) 
    subroutine of 
    ((<dc_string|URL:../code_reference/classes/dc_string.html>)) module.


=end EN





=begin HTML
<hr /> <small>
  $Id: dc_trace.rd,v 1.3 2009-02-28 13:36:32 morikawa Exp $
</small>
=end HTML
