!= Module StoreSet
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: storeset2.f90,v 1.2 2006/11/22 15:38:22 sugiyama Exp $ 
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ѻͤݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module storeset2
  !
  !ѻͤݴɤ뤿ѿ⥸塼.
  !

  !⥸塼ɤ߹
  use gridset, only:   DimXMin,     & ! x β
    &                  DimXMax,     & ! x ξ
    &                  DimZMin,     & ! z β
    &                  DimZMax,     & ! z ξ
    &                  SpcNum,      & ! number of species
    &                  RegXMin,     & ! x ʪΰβ
    &                  RegXMax        ! x ʪΰξ
  use TimeSet, only:   TimeDisp,    & ! ϻֳִ
    &                  DelTimeLong    ! Ĺ֥ƥå

  !ۤηػ
  implicit none

  !°λ
  private

  !
  public Store2Set_Init, Store2MeanX, Store2Clean
  public za_Adv,  za_Turb,  za_Diff, za_Flux, za_Rain, &
    &    za_Cond, za_Fill1, za_Fill2
  public Store2Adv, Store2Turb, Store2Diff, Store2Flux, Store2Rain, &
    &    Store2Cond, Store2Fill1, Store2Fill2

  !ѿ
  real(8), allocatable :: za_Adv(:,:)
  real(8), allocatable :: za_Turb(:,:)
  real(8), allocatable :: za_Diff(:,:)
  real(8), allocatable :: za_Flux(:,:)
  real(8), allocatable :: za_Rain(:,:)
  real(8), allocatable :: za_Fill1(:,:)
  real(8), allocatable :: za_Fill2(:,:)
  real(8), allocatable :: za_Cond(:,:)
!  real(8), allocatable :: za_Asln(:,:)
  real(8), allocatable :: xza_Adv(:,:,:)
  real(8), allocatable :: xza_Turb(:,:,:)
  real(8), allocatable :: xza_Diff(:,:,:)
  real(8), allocatable :: xza_Flux(:,:,:)
  real(8), allocatable :: xza_Rain(:,:,:)
  real(8), allocatable :: xza_Fill1(:,:,:)
  real(8), allocatable :: xza_Fill2(:,:,:)
  real(8), allocatable :: xza_Cond(:,:,:)
!  real(8), allocatable :: xza_Asln(:,:,:)
!  real(8)              :: CalNum

  save xza_Adv,  xza_Turb,  xza_Diff, xza_Flux, xza_Rain, &
    &  xza_Cond, xza_Fill1, xza_Fill2
  
contains

  subroutine Store2Set_Init( )
    !롼

    allocate(     &
      & za_Adv(DimZMin:DimZMax, SpcNum),   & 
      & za_Turb(DimZMin:DimZMax, SpcNum),  &
      & za_Diff(DimZMin:DimZMax, SpcNum),  &
      & za_Flux(DimZMin:DimZMax, SpcNum),  &
      & za_Rain(DimZMin:DimZMax, SpcNum),  &
      & za_Fill1(DimZMin:DimZMax, SpcNum), &
      & za_Fill2(DimZMin:DimZMax, SpcNum), &
!      & za_Asln(DimZMin:DimZMax, SpcNum), &
      & za_Cond(DimZMin:DimZMax, SpcNum), &
      & xza_Adv(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   & 
      & xza_Turb(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),  &
      & xza_Diff(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),  &
      & xza_Flux(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),  &
      & xza_Rain(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),  &
      & xza_Fill1(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum), &
      & xza_Fill2(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum), &
!      & xza_Asln(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum), &
      & xza_Cond(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum) &
      &  )
    
    za_Adv  = 0.0d0
    za_Turb = 0.0d0
    za_Diff = 0.0d0
    za_Flux = 0.0d0
    za_Rain = 0.0d0
    za_Fill1 = 0.0d0
    za_Fill2 = 0.0d0
    za_Cond = 0.0d0
!    za_Asln = 0.0d0

    xza_Adv  = 0.0d0
    xza_Turb = 0.0d0
    xza_Diff = 0.0d0
    xza_Flux = 0.0d0
    xza_Rain = 0.0d0
    xza_Fill1 = 0.0d0
    xza_Fill2 = 0.0d0
    xza_Cond = 0.0d0
!    xza_Asln = 0.0d0

!    CalNum  = 1.0d-40   !ػ
  end subroutine Store2Set_Init


  subroutine Store2Clean( )
    !ݴɤͤΥꥢ
    
    za_Adv  = 0.0d0
    za_Turb = 0.0d0
    za_Diff = 0.0d0
    za_Flux = 0.0d0
    za_Rain = 0.0d0
    za_Fill1 = 0.0d0
    za_Fill2 = 0.0d0
    za_Cond = 0.0d0
!    za_Asln = 0.0d0

    xza_Adv  = 0.0d0
    xza_Turb = 0.0d0
    xza_Diff = 0.0d0
    xza_Flux = 0.0d0
    xza_Rain = 0.0d0
    xza_Fill1 = 0.0d0
    xza_Fill2 = 0.0d0
    xza_Cond = 0.0d0
!    xza_Asln = 0.0d0

!    CalNum  = 1.0d-40   !ػ
  end subroutine Store2Clean


  subroutine Store2MeanX( )
    !ݴɤͤοʿʿ
 
    real(8) :: CalNum

    CalNum = TimeDisp / DelTimeLong
   
    za_Adv  = aa_MeanX_aaa( xza_Adv ) / CalNum
    za_Turb = aa_MeanX_aaa( xza_Turb ) / CalNum
    za_Diff = aa_MeanX_aaa( xza_Diff ) / CalNum
    za_Flux = aa_MeanX_aaa( xza_Flux ) / CalNum
    za_Rain = aa_MeanX_aaa( xza_Rain ) / CalNum
    za_Fill1 = aa_MeanX_aaa( xza_Fill1  ) / CalNum
    za_Fill2 = aa_MeanX_aaa( xza_Fill2 ) / CalNum
    za_Cond = aa_MeanX_aaa( xza_Cond ) / CalNum
!    za_Asln = aa_MeanX_aaa( xza_Asln ) / CalNum

  end subroutine Store2MeanX


  subroutine Store2Adv( Work )
    !ήݴ

    implicit none

    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    Work2  = xza_Adv + Work
    xza_Adv = Work2

!    CalNum = CalNum + 1

  end subroutine Store2Adv


  subroutine Store2Turb( Work )
    !ήݴ

    implicit none

    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    Work2   = xza_Turb + Work
    xza_Turb = Work2

  end subroutine Store2Turb


  subroutine Store2Diff( Work )
    !ͳȻݴ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    Work2   = xza_Diff + Work
    xza_Diff = Work2

  end subroutine Store2Diff


  subroutine Store2Rain( Work )
    !߱νȼѲ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    Work2   = xza_Rain + Work
    xza_Rain = Work2

  end subroutine Store2Rain


  subroutine Store2Flux( Work )
    !ɽ̥եåˤѲ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    Work2  = xza_Flux + Work
    xza_Flux = Work2

  end subroutine Store2Flux


  subroutine Store2Cond( Work )
    !ŷȼѲ

    implicit none
    
    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    Work2   = xza_Cond + Work
    xza_Cond = Work2

  end subroutine Store2Cond


!  subroutine Store2Asln( Work )
!    !å֥ե륿ȼѲ̤ݴ
!
!    implicit none
!    
!    real(8), intent(in)  :: Work(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
!    real(8)              :: Work2(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
!
!    Work2   = xza_Asln + Work
!    xza_Asln = Work2
!
!  end subroutine Store2Asln


  subroutine Store2Fill1( Work1 )
    !ץˤѲ

    implicit none
    
    real(8), intent(in)  :: Work1(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: WorkA(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    WorkA     = Work1 + xza_Fill1
    xza_Fill1 = WorkA

  end subroutine Store2Fill1


  subroutine Store2Fill2( Work1 )
    !ץ(2)ˤѲ

    implicit none
    
    real(8), intent(in)  :: Work1(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)              :: WorkA(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    WorkA      = Work1 + xza_Fill2
    xza_Fill2  = WorkA

  end subroutine Store2Fill2


  function aa_MeanX_aaa( var ) 
    !
    ! ʿʿͤη׻
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: var(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                     !ʿѱ黻оݤȤʤѿ
    real(8)              :: aa_MeanX_aaa(DimZMin:DimZMax, SpcNum)
                                     !ʿʿ

    aa_MeanX_aaa = sum( var(RegXMin+1:RegXMax,:,:), 1 ) &
      &           / real(RegXMax - RegXMin, 8) 
    
  end function aa_MeanX_aaa
  
  
end module storeset2
