!= Module Radiation
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: radiation.f90,v 1.10 2006/10/18 07:38:49 odakker Exp $
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ǥͲ׻뤿Υѥå⥸塼
!Ūˤϰʲι׻뤿δؿǼ.  
!  * 
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!
!== Future Plans
!
!

module Radiation
  !
  !ǥͲ׻뤿Υѥå⥸塼
  !Ūˤϰʲι׻뤿δؿǼ.  
  !  * 
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use GridSet,  only: DimXMin,     & !x β
    &                 DimXMax,     & !x ξ
    &                 DimZMin,     & !z β
    &                 DimZMax,     & !z ξ
    &                 s_Z            !Z ɸ(顼ʻ)
  use TimeSet,  only: DayTime        ! 1 Ĺ [s]
  use basicset, only: xz_ExnerBasicZ !ʡؿδܾ
  use StoreSet, only: StoreRad, StoreDamp
  
  !ۤηػ
  implicit none

  !private °
  private

  !ؿ public ˤ. 
  public Radiation_init
  public xz_RadHeatConst
  public xz_NewtonCool

  !ѿ
  real(8)              :: RadHeatRate  = 0.0d0 !ͲǮΨ [K/day]
  real(8), allocatable :: xz_RadHeight(:,:)    !ͲǮ¸ߤΰ
  
  !save °
  save RadHeatRate, xz_RadHeight

contains

!!!------------------------------------------------------------------------!!!
  subroutine Radiation_init(cfgfile)
    !
    !NAMELIST Ͷ
    !

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile
    real(8)                  :: RadHeightUp   !ͶͿľΰξ
    real(8)                  :: RadHeightDown !ͶͿľΰβ
    integer                  :: k             !롼ѿ

    ! NAMELIST 
    NAMELIST /radiation/ RadHeatRate, RadHeightUp, RadHeightDown

    open (10, FILE=cfgfile)
    read(10, NML=radiation)
    close(10)

    allocate( xz_RadHeight(DimXMin:DimXMax, DimZMin:DimZMax) )

    ! Ͷ¸ߤΰ
    ! RadHeightDown < s_Z < RadHeightUp ϰϤǤͤ 1 Ȥʤ
    ! Ѱդ.
    !
    xz_RadHeight = 1.0d0    

    do k = DimZMin, DimZMax
      if ( s_Z(k) <= RadHeightDown  ) then
        xz_RadHeight(:,k) = 0.0d0 
      elseif( s_Z(k) >= RadHeightUp ) then
        xz_RadHeight(:,k) = 0.0d0 
      end if
    end do

    call MessageNotify( "M", &
      & "Radiation", "RadHeatRate = %f", d=(/RadHeatRate/))
    call MessageNotify( "M", &
      & "Radiation", "RadHeightUp = %f", d=(/RadHeightUP/))
    call MessageNotify( "M", &
      & "Radiation", "RadHeightDown= %f", d=(/RadHeightDown/))
    
  end subroutine Radiation_init


!!!------------------------------------------------------------------------!!!
  function xz_RadHeatConst(xz_Exner)
    !
    ! ̤Ͷ. 
    ! ɽ̤ RadHeight ǻꤵ줿٤ޤǤδ֤ǰѤͿ. 
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                       !ʡؿξ
    real(8)               :: xz_RadHeatConst(DimXMin:DimXMax, DimZMin:DimZMax)
                                       !Ͷ

    xz_RadHeatConst = &
      & xz_RadHeight * RadHeatRate  &
      & / ( ( xz_ExnerBasicZ + xz_Exner ) * DayTime )

    call StoreRad( xz_RadHeatConst )
    
  end function xz_RadHeatConst
  
  
  
!!!------------------------------------------------------------------------!!!
  function xz_NewtonCool(xz_PotTemp)
    !
    ! ̤Ͷ. 
    ! ɽ̤ RadHeight ǻꤵ줿٤ޤǤδ֤ǰѤͿ. 
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                       !̤ξ
    real(8)               :: xz_NewtonCool(DimXMin:DimXMax, DimZMin:DimZMax)
                                       !Ͷ
    real(8)               :: xz_PotTempMean(DimXMin:DimXMax, DimZMin:DimZMax)
                                       !̾ʿ
    real(8)               :: EFTime    !ʹ»
    integer               :: k

    !ʹ»֤ 5 
    EFTime = 5.0d0 * DayTime  
    
    do k = DimZMin, DimZMax
      xz_PotTempMean(:,k) = sum( xz_PotTemp(:,k) ) / real(DimXMax - DimXMin + 1)
    end do
    
    xz_NewtonCool = - xz_PotTempMean / EFTime 
    
    call StoreDamp( xz_NewtonCool )

  end function xz_NewtonCool
  
end module Radiation
