# Title: Ruby script drawing contour map for deepconv/arare5 output data 
#
# History: 2011/09/27 (Masatsugu Odaka)
#
require "numru/ggraph"
include NumRu

file = 'denscurrent-dry_Exner.nc'
varname = 'Exner'

var = GPhys::IO.open(file, varname)
time  = GPhys::IO.open(file, 't').val

GGraph.set_linear_contour_options( 'interval'=>2.5e-4 )  
GGraph.set_linear_tone_options( 'min'=>-2.0e-3, 'max'=>1.0e-3, \
                                   'interval'=>5.0e-5 )  

# <Open DCL>
#DCL.swlset( 'ldump', true )
DCL.sgpset( 'lfull', true )
DCL.uzfact(0.7)
DCL.gropn(1)
GGraph.set_fig('viewport'=>[0.1,0.85,0.3,0.5])

for i in 0...time.length do
# <Drawing data by GGraph>
  GGraph.tone( var.cut(25600..44800,0,0..6400, time[i]), true, \
               'title'=>'Nondimentional Pressure', 'annot'=>true)
  GGraph.contour( var.cut(25600..44800,0,0..6400, time[i]), false, 'label'=>true )
  GGraph.color_bar('labelintv'=>20,'tickintv'=>5, 'landscape'=>true )
end

# <Close DCL>
DCL.grcls
