.TH SRSCL l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
SRSCL - multiplie an n-element real vector x by the real scalar 1/a
.SH SYNOPSIS
.TP 18
SUBROUTINE SRSCL(
N, SA, SX, INCX )
.TP 18
.ti +4
INTEGER
INCX, N
.TP 18
.ti +4
REAL
SA
.TP 18
.ti +4
REAL
SX( * )
.SH PURPOSE
SRSCL multiplies an n-element real vector x by the real scalar 1/a. This is done without overflow or underflow as long as
.br
the final result x/a does not overflow or underflow.
.br

.SH ARGUMENTS
.TP 8
N       (input) INTEGER
The number of components of the vector x.
.TP 8
SA      (input) REAL
The scalar a which is used to divide each component of x.
SA must be >= 0, or the subroutine will divide by zero.
.TP 8
SX      (input/output) REAL array, dimension
(1+(N-1)*abs(INCX))
The n-element vector x.
.TP 8
INCX    (input) INTEGER
The increment between successive values of the vector SX.
> 0:  SX(1) = X(1) and SX(1+(i-1)*INCX) = x(i),     1< i<= n
