--- timing/lin/linsrc/cgelsd.f	Thu Dec  5 19:45:18 2002
+++ debian/updates/timing/lin/linsrc/cgelsd.f	Wed Dec  4 15:23:42 2002
@@ -1,10 +1,10 @@
       SUBROUTINE CGELSD( M, N, NRHS, A, LDA, B, LDB, S, RCOND, RANK,
      $                   WORK, LWORK, RWORK, IWORK, INFO )
 *
-*  -- LAPACK driver routine (version 3.0) --
+*  -- LAPACK driver routine (instrumented to count ops, version 3.0) --
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
-*     October 31, 1999
+*     July 10, 2001
 *
 *     .. Scalar Arguments ..
       INTEGER            INFO, LDA, LDB, LWORK, M, N, NRHS, RANK
@@ -15,6 +15,17 @@
       REAL               RWORK( * ), S( * )
       COMPLEX            A( LDA, * ), B( LDB, * ), WORK( * )
 *     ..
+*     Common blocks to return operation counts and timings.
+*     .. Common blocks ..
+      COMMON             / LATIME / OPS, ITCNT
+      COMMON             / LSTIME / OPCNT, TIMNG
+*     ..
+*     .. Scalars in Common ..
+      REAL               ITCNT, OPS
+*     ..
+*     .. Arrays in Common ..
+      REAL               OPCNT( 6 ), TIMNG( 6 )
+*     ..
 *
 *  Purpose
 *  =======
@@ -151,10 +162,11 @@
 *     ..
 *     .. Local Scalars ..
       LOGICAL            LQUERY
-      INTEGER            IASCL, IBSCL, IE, IL, ITAU, ITAUP, ITAUQ,
-     $                   LDWORK, MAXMN, MAXWRK, MINMN, MINWRK, MM,
-     $                   MNTHR, NRWORK, NWORK, SMLSIZ
-      REAL               ANRM, BIGNUM, BNRM, EPS, SFMIN, SMLNUM
+      INTEGER            GEBRD, GELQF, GELSD, GEQRF, IASCL, IBSCL, IE,
+     $                   IL, ITAU, ITAUP, ITAUQ, LALSD, LDWORK, MAXMN,
+     $                   MAXWRK, MINMN, MINWRK, MM, MNTHR, NB, NRWORK,
+     $                   NWORK, SMLSIZ, UNMBR, UNMLQ, UNMQR
+      REAL               ANRM, BIGNUM, BNRM, EPS, SFMIN, SMLNUM, T1, T2
 *     ..
 *     .. External Subroutines ..
       EXTERNAL           CGEBRD, CGELQF, CGEQRF, CLACPY,
@@ -164,11 +176,18 @@
 *     ..
 *     .. External Functions ..
       INTEGER            ILAENV
-      REAL               CLANGE, SLAMCH
-      EXTERNAL           CLANGE, SLAMCH, ILAENV
+      REAL               CLANGE, SECOND, SLAMCH, SOPLA,
+     $                   SOPLA2
+      EXTERNAL           CLANGE, SECOND, SLAMCH, SOPLA,
+     $                   SOPLA2, ILAENV
 *     ..
 *     .. Intrinsic Functions ..
-      INTRINSIC          CMPLX, MAX, MIN
+      INTRINSIC          CMPLX, MAX, MIN, REAL
+*     ..
+*     .. Data statements ..
+      DATA               GEBRD / 3 /, GELQF / 2 /, GELSD / 1 /,
+     $                   GEQRF / 2 /, LALSD / 5 /, UNMBR / 4 /,
+     $                   UNMLQ / 4 /, UNMQR / 2 /
 *     ..
 *     .. Executable Statements ..
 *
@@ -285,6 +304,7 @@
 *
       EPS = SLAMCH( 'P' )
       SFMIN = SLAMCH( 'S' )
+      OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( 2 )
       SMLNUM = SFMIN / EPS
       BIGNUM = ONE / SMLNUM
       CALL SLABAD( SMLNUM, BIGNUM )
@@ -297,12 +317,14 @@
 *
 *        Scale matrix norm up to SMLNUM
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( 6*M*N )
          CALL CLASCL( 'G', 0, 0, ANRM, SMLNUM, M, N, A, LDA, INFO )
          IASCL = 1
       ELSE IF( ANRM.GT.BIGNUM ) THEN
 *
 *        Scale matrix norm down to BIGNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( 6*M*N )
          CALL CLASCL( 'G', 0, 0, ANRM, BIGNUM, M, N, A, LDA, INFO )
          IASCL = 2
       ELSE IF( ANRM.EQ.ZERO ) THEN
@@ -323,12 +345,14 @@
 *
 *        Scale matrix norm up to SMLNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( 6*M*NRHS )
          CALL CLASCL( 'G', 0, 0, BNRM, SMLNUM, M, NRHS, B, LDB, INFO )
          IBSCL = 1
       ELSE IF( BNRM.GT.BIGNUM ) THEN
 *
 *        Scale matrix norm down to BIGNUM.
 *
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( 6*M*NRHS )
          CALL CLASCL( 'G', 0, 0, BNRM, BIGNUM, M, NRHS, B, LDB, INFO )
          IBSCL = 2
       END IF
@@ -357,15 +381,27 @@
 *           (RWorkspace: need N)
 *           (CWorkspace: need N, prefer N*NB)
 *
+            NB = ILAENV( 1, 'CGEQRF', ' ', M, N, -1, -1 )
+            OPCNT( GEQRF ) = OPCNT( GEQRF ) +
+     $                       SOPLA( 'CGEQRF', M, N, 0, 0, NB )
+            T1 = SECOND( )
             CALL CGEQRF( M, N, A, LDA, WORK( ITAU ), WORK( NWORK ),
      $                   LWORK-NWORK+1, INFO )
+            T2 = SECOND( )
+            TIMNG( GEQRF ) = TIMNG( GEQRF ) + ( T2-T1 )
 *
 *           Multiply B by transpose(Q).
 *           (RWorkspace: need N)
 *           (CWorkspace: need NRHS, prefer NRHS*NB)
 *
+            NB = ILAENV( 1, 'CUNMQR', 'LC', M, NRHS, N, -1 )
+            OPCNT( UNMQR ) = OPCNT( UNMQR ) +
+     $                       SOPLA( 'CUNMQR', M, NRHS, N, 0, NB )
+            T1 = SECOND( )
             CALL CUNMQR( 'L', 'C', M, NRHS, N, A, LDA, WORK( ITAU ), B,
      $                   LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+            T2 = SECOND( )
+            TIMNG( UNMQR ) = TIMNG( UNMQR ) + ( T2-T1 )
 *
 *           Zero out below R.
 *
@@ -385,29 +421,52 @@
 *        (RWorkspace: need N)
 *        (CWorkspace: need 2*N+MM, prefer 2*N+(MM+N)*NB)
 *
+         NB = ILAENV( 1, 'CGEBRD', ' ', MM, N, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    SOPLA( 'CGEBRD', MM, N, 0, 0, NB )
+         T1 = SECOND( )
          CALL CGEBRD( MM, N, A, LDA, S, RWORK( IE ), WORK( ITAUQ ),
      $                WORK( ITAUP ), WORK( NWORK ), LWORK-NWORK+1,
      $                INFO )
+         T2 = SECOND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors of R.
 *        (CWorkspace: need 2*N+NRHS, prefer 2*N+NRHS*NB)
 *
+         NB = ILAENV( 1, 'CUNMBR', 'QLC', MM, NRHS, N, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'CUNMBR', 'QLC', MM, NRHS, N, 0, NB )
+         T1 = SECOND( )
          CALL CUNMBR( 'Q', 'L', 'C', MM, NRHS, N, A, LDA, WORK( ITAUQ ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = 0
+         T1 = SECOND( )
          CALL CLALSD( 'U', SMLSIZ, N, NRHS, S, RWORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), RWORK( NRWORK ),
      $                IWORK, INFO )
+         T2 = SECOND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of R.
 *
+         NB = ILAENV( 1, 'CUNMBR', 'PLN', N, NRHS, N, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'CUNMBR', 'PLN', N, NRHS, N, 0, NB )
+         T1 = SECOND( )
          CALL CUNMBR( 'P', 'L', 'N', N, NRHS, N, A, LDA, WORK( ITAUP ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
       ELSE IF( N.GE.MNTHR .AND. LWORK.GE.4*M+M*M+
      $         MAX( M, 2*M-4, NRHS, N-3*M ) ) THEN
@@ -424,8 +483,14 @@
 *        Compute A=L*Q.
 *        (CWorkspace: need 2*M, prefer M+M*NB)
 *
+         NB = ILAENV( 1, 'CGELQF', ' ', M, N, -1, -1 )
+         OPCNT( GELQF ) = OPCNT( GELQF ) +
+     $                    SOPLA( 'CGELQF', M, N, 0, 0, NB )
+         T1 = SECOND( )
          CALL CGELQF( M, N, A, LDA, WORK( ITAU ), WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( GELQF ) = TIMNG( GELQF ) + ( T2-T1 )
          IL = NWORK
 *
 *        Copy L to WORK(IL), zeroing out above its diagonal.
@@ -443,31 +508,54 @@
 *        (RWorkspace: need M)
 *        (CWorkspace: need M*M+4*M, prefer M*M+4*M+2*M*NB)
 *
+         NB = ILAENV( 1, 'CGEBRD', ' ', M, M, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    SOPLA( 'CGEBRD', M, M, 0, 0, NB )
+         T1 = SECOND( )
          CALL CGEBRD( M, M, WORK( IL ), LDWORK, S, RWORK( IE ),
      $                WORK( ITAUQ ), WORK( ITAUP ), WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors of L.
 *        (CWorkspace: need M*M+4*M+NRHS, prefer M*M+4*M+NRHS*NB)
 *
+         NB = ILAENV( 1, 'CUNMBR', 'QLC' , M, NRHS, M, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'CUNMBR', 'QLC', M, NRHS, M, 0, NB )
+         T1 = SECOND( )
          CALL CUNMBR( 'Q', 'L', 'C', M, NRHS, M, WORK( IL ), LDWORK,
      $                WORK( ITAUQ ), B, LDB, WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = 0
+         T1 = SECOND( )
          CALL CLALSD( 'U', SMLSIZ, M, NRHS, S, RWORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), RWORK( NRWORK ),
      $                IWORK, INFO )
+         T2 = SECOND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of L.
 *
+         NB = ILAENV( 1, 'CUNMBR', 'PLN', M, NRHS, M, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'CUNMBR', 'PLN', M, NRHS, M, 0, NB )
+         T1 = SECOND( )
          CALL CUNMBR( 'P', 'L', 'N', M, NRHS, M, WORK( IL ), LDWORK,
      $                WORK( ITAUP ), B, LDB, WORK( NWORK ),
      $                LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
 *        Zero out below first M rows of B.
 *
@@ -477,8 +565,14 @@
 *        Multiply transpose(Q) by B.
 *        (CWorkspace: need NRHS, prefer NRHS*NB)
 *
+         NB = ILAENV( 1, 'CUNMLQ', 'LC', N, NRHS, M, -1 )
+         OPCNT( UNMLQ ) = OPCNT( UNMLQ ) +
+     $                    SOPLA( 'CUNMLQ', N, NRHS, M, 0, NB )
+         T1 = SECOND( )
          CALL CUNMLQ( 'L', 'C', N, NRHS, M, A, LDA, WORK( ITAU ), B,
      $                LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( UNMLQ ) = TIMNG( UNMLQ ) + ( T2-T1 )
 *
       ELSE
 *
@@ -494,46 +588,73 @@
 *        (RWorkspace: need M)
 *        (CWorkspace: need 2*M+N, prefer 2*M+(M+N)*NB)
 *
+         NB = ILAENV( 1, 'CGEBRD', ' ', M, N, -1, -1 )
+         OPCNT( GEBRD ) = OPCNT( GEBRD ) +
+     $                    SOPLA( 'CGEBRD', M, N, 0, 0, NB )
+         T1 = SECOND( )
          CALL CGEBRD( M, N, A, LDA, S, RWORK( IE ), WORK( ITAUQ ),
      $                WORK( ITAUP ), WORK( NWORK ), LWORK-NWORK+1,
      $                INFO )
+         T2 = SECOND( )
+         TIMNG( GEBRD ) = TIMNG( GEBRD ) + ( T2-T1 )
 *
 *        Multiply B by transpose of left bidiagonalizing vectors.
 *        (CWorkspace: need 2*M+NRHS, prefer 2*M+NRHS*NB)
 *
+         NB = ILAENV( 1, 'CUNMBR', 'QLC', M, NRHS, N, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'CUNMBR', 'QLC', M, NRHS, N, 0, NB )
+         T1 = SECOND( )
          CALL CUNMBR( 'Q', 'L', 'C', M, NRHS, N, A, LDA, WORK( ITAUQ ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
 *        Solve the bidiagonal least squares problem.
 *
+         OPS = 0
+         T1 = SECOND( )
          CALL CLALSD( 'L', SMLSIZ, M, NRHS, S, RWORK( IE ), B, LDB,
      $                RCOND, RANK, WORK( NWORK ), RWORK( NRWORK ),
      $                IWORK, INFO )
+         T2 = SECOND( )
+         TIMNG( LALSD ) = TIMNG( LALSD ) + ( T2-T1 )
+         OPCNT( LALSD ) = OPCNT( LALSD ) + OPS
          IF( INFO.NE.0 ) THEN
             GO TO 10
          END IF
 *
 *        Multiply B by right bidiagonalizing vectors of A.
 *
+         NB = ILAENV( 1, 'CUNMBR', 'PLN', N, NRHS, M, -1 )
+         OPCNT( UNMBR ) = OPCNT( UNMBR ) +
+     $                    SOPLA2( 'CUNMBR', 'PLN', N, NRHS, M, 0, NB )
+         T1 = SECOND( )
          CALL CUNMBR( 'P', 'L', 'N', N, NRHS, M, A, LDA, WORK( ITAUP ),
      $                B, LDB, WORK( NWORK ), LWORK-NWORK+1, INFO )
+         T2 = SECOND( )
+         TIMNG( UNMBR ) = TIMNG( UNMBR ) + ( T2-T1 )
 *
       END IF
 *
 *     Undo scaling.
 *
       IF( IASCL.EQ.1 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( 6*N*NRHS + MINMN )
          CALL CLASCL( 'G', 0, 0, ANRM, SMLNUM, N, NRHS, B, LDB, INFO )
          CALL SLASCL( 'G', 0, 0, SMLNUM, ANRM, MINMN, 1, S, MINMN,
      $                INFO )
       ELSE IF( IASCL.EQ.2 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( 6*N*NRHS + MINMN )
          CALL CLASCL( 'G', 0, 0, ANRM, BIGNUM, N, NRHS, B, LDB, INFO )
          CALL SLASCL( 'G', 0, 0, BIGNUM, ANRM, MINMN, 1, S, MINMN,
      $                INFO )
       END IF
       IF( IBSCL.EQ.1 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( 6*N*NRHS )
          CALL CLASCL( 'G', 0, 0, SMLNUM, BNRM, N, NRHS, B, LDB, INFO )
       ELSE IF( IBSCL.EQ.2 ) THEN
+         OPCNT( GELSD ) = OPCNT( GELSD ) + REAL( 6*N*NRHS )
          CALL CLASCL( 'G', 0, 0, BIGNUM, BNRM, N, NRHS, B, LDB, INFO )
       END IF
 *
