--- src/sgelss.f	Thu Dec  5 19:51:37 2002
+++ debian/updates/src/sgelss.f	Wed Dec  4 15:23:42 2002
@@ -4,7 +4,7 @@
 *  -- LAPACK driver routine (version 3.0) --
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
-*     October 31, 1999
+*     April 25, 2001 
 *
 *     .. Scalar Arguments ..
       INTEGER            INFO, LDA, LDB, LWORK, M, N, NRHS, RANK
@@ -86,10 +86,9 @@
 *          LWORK >= 3*min(M,N) + max( 2*min(M,N), max(M,N), NRHS )
 *          For good performance, LWORK should generally be larger.
 *
-*          If LWORK = -1, then a workspace query is assumed; the routine
-*          only calculates the optimal size of the WORK array, returns
-*          this value as the first entry of the WORK array, and no error
-*          message related to LWORK is issued by XERBLA.
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
 *
 *  INFO    (output) INTEGER
 *          = 0:  successful exit
@@ -156,7 +155,7 @@
 *       following subroutine, as returned by ILAENV.)
 *
       MINWRK = 1
-      IF( INFO.EQ.0 .AND. ( LWORK.GE.1 .OR. LQUERY ) ) THEN
+      IF( INFO.EQ.0 ) THEN
          MAXWRK = 0
          MM = M
          IF( M.GE.N .AND. M.GE.MNTHR ) THEN
@@ -229,20 +228,18 @@
          END IF
          MAXWRK = MAX( MINWRK, MAXWRK )
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY )
+     $      INFO = -12
       END IF
 *
-      MINWRK = MAX( MINWRK, 1 )
-      IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY )
-     $   INFO = -12
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'SGELSS', -INFO )
          RETURN
       ELSE IF( LQUERY ) THEN
          RETURN
       END IF
-*
-*     Quick return if possible
-*
       IF( M.EQ.0 .OR. N.EQ.0 ) THEN
          RANK = 0
          RETURN
@@ -491,8 +488,8 @@
             DO 40 I = 1, NRHS, CHUNK
                BL = MIN( NRHS-I+1, CHUNK )
                CALL SGEMM( 'T', 'N', M, BL, M, ONE, WORK( IL ), LDWORK,
-     $                     B( 1, I ), LDB, ZERO, WORK( IWORK ), N )
-               CALL SLACPY( 'G', M, BL, WORK( IWORK ), N, B( 1, I ),
+     $                     B( 1, I ), LDB, ZERO, WORK( IWORK ), M )
+               CALL SLACPY( 'G', M, BL, WORK( IWORK ), M, B( 1, I ),
      $                      LDB )
    40       CONTINUE
          ELSE
