--- src/sggevx.f	Thu Dec  5 20:18:11 2002
+++ debian/updates/src/sggevx.f	Wed Dec  4 15:23:42 2002
@@ -7,6 +7,7 @@
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     June 30, 1999
+*     8-15-00:  Improve consistency of WS calculations (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          BALANC, JOBVL, JOBVR, SENSE
@@ -212,10 +213,9 @@
 *          If SENSE = 'E', LWORK >= 12*N.
 *          If SENSE = 'V' or 'B', LWORK >= 2*N*N+12*N+16.
 *
-*          If LWORK = -1, then a workspace query is assumed; the routine
-*          only calculates the optimal size of the WORK array, returns
-*          this value as the first entry of the WORK array, and no error
-*          message related to LWORK is issued by XERBLA.
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
 *
 *  IWORK   (workspace) INTEGER array, dimension (N+6)
 *          If SENSE = 'E', IWORK is not referenced.
@@ -262,12 +262,14 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       REAL               ZERO, ONE
       PARAMETER          ( ZERO = 0.0E+0, ONE = 1.0E+0 )
 *     ..
 *     .. Local Scalars ..
-      LOGICAL            ILASCL, ILBSCL, ILV, ILVL, ILVR, LQUERY, PAIR,
-     $                   WANTSB, WANTSE, WANTSN, WANTSV
+      LOGICAL            ILASCL, ILBSCL, ILV, ILVL, ILVR, PAIR, WANTSB,
+     $                   WANTSE, WANTSN, WANTSV
       CHARACTER          CHTEMP
       INTEGER            I, ICOLS, IERR, IJOBVL, IJOBVR, IN, IROWS,
      $                   ITAU, IWRK, IWRK1, J, JC, JR, M, MAXWRK,
@@ -327,7 +329,6 @@
 *     Test the input arguments
 *
       INFO = 0
-      LQUERY = ( LWORK.EQ.-1 )
       IF( .NOT.( LSAME( BALANC, 'N' ) .OR. LSAME( BALANC,
      $    'S' ) .OR. LSAME( BALANC, 'P' ) .OR. LSAME( BALANC, 'B' ) ) )
      $     THEN
@@ -360,7 +361,7 @@
 *       computed assuming ILO = 1 and IHI = N, the worst case.)
 *
       MINWRK = 1
-      IF( INFO.EQ.0 .AND. ( LWORK.GE.1 .OR. LQUERY ) ) THEN
+      IF( INFO.EQ.0 ) THEN
          MAXWRK = 5*N + N*ILAENV( 1, 'SGEQRF', ' ', N, 1, N, 0 )
          MINWRK = MAX( 1, 6*N )
          IF( WANTSE ) THEN
@@ -370,24 +371,19 @@
             MAXWRK = MAX( MAXWRK, 2*N*N+12*N+16 )
          END IF
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. LWORK.NE.LQUERV )
+     $      INFO = -26
       END IF
 *
-      IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY ) THEN
-         INFO = -26
-      END IF
+*     Quick returns
 *
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'SGGEVX', -INFO )
          RETURN
-      ELSE IF( LQUERY ) THEN
-         RETURN
       END IF
-*
-*     Quick return if possible
-*
+      IF( LWORK.EQ.LQUERV ) RETURN
       IF( N.EQ.0 )
      $   RETURN
-*
 *
 *     Get machine constants
 *
