!c Description: 
!c   ɸѥ⥸塼
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2004, All rights reserved

module gridset
  !--- ۤηػ
  implicit none

  !--- save °
  save

  !--- ѿ
  real(8)               :: Xmin, Xmax    ! x ɸλ
  real(8)               :: Zmin, Zmax    ! z ɸλ
  real(8)               :: DelX, DelZ    !ʻҴֳ
  integer               :: NX, NZ        !ʻ
  integer               :: DimXMin       ! x β
  integer               :: DimXMax       ! x ξ
  integer               :: DimZMin       ! z β
  integer               :: DimZMax       ! z ξ
  integer               :: RegXMin       ! x ʪΰβ
  integer               :: RegXMax       ! x ʪΰξ
  integer               :: RegZMin       ! z ʪΰβ
  integer               :: RegZMax       ! z ʪΰξ
  integer, parameter    :: Margin = 5    !Υåɿ
  integer, parameter    :: kind = 8      !٤ɽ
  real(8), allocatable  :: s_X(:)
  real(8), allocatable  :: f_X(:)
  real(8), allocatable  :: s_Z(:)
  real(8), allocatable  :: f_Z(:)
  character(3)          :: ss_Bc        !(顼)
  character(3)          :: fs_Bc        !(٥ȥ u)
  character(3)          :: sf_Bc        !(٥ȥ w)
  
contains
  subroutine gridset_init
    !--- ⥸塼ɤ߹
    use fileset, only: cfgfile
    
    !--- ѿ
    integer            :: i, k
    character(1)       :: BcX
    character(1)       :: BcZ
    
    !--- NAMELIST 
    NAMELIST /gridset/ &
         & NX, NZ, Xmin, Xmax, Zmin, Zmax, BcX, BcZ
    
    !---ѿμФ
    open (10, FILE=cfgfile)
    read(10, NML=gridset)
    close(10)

    !--- ʻֳַ׻
    DelX = (Xmax - Xmin) / real(NX, kind)
    DelZ = (Zmax - Zmin) / real(NZ, kind)
    
    !--- ʪŪ˰̣Τΰξ¡¤
    RegXMin = 0
    RegXMax = NX
    RegZMin = 0
    RegZMax = NZ

    !--- ξ¡¤
    DimXMin = RegXMin - Margin
    DimXMax = RegXMax + Margin
    DimZMin = RegZMin - Margin
    DimZMax = RegZMax + Margin

    !--- åɤ
    allocate( f_X(DimXMin:DimXMax), f_Z(DimZMin:DimZMax) )
    do i = DimXMin, DimXMax
       f_X(i) = Xmin + DelX * ( real(i, kind) - RegXMin )
    end do
    do k = DimZMin, DimZMax
       f_Z(k) = Zmin + DelZ * ( real(k, kind) - RegZMin )
    end do
    
    !--- ȾʻҤ줿åɤ. ֳ֤ˤƤ.
    allocate( s_X(DimXMin: DimXMax), s_Z(DimZMin: DimZMax) )
    s_X(DimXMin+1:DimXMax) =            &
         &  (                     &
         &     f_X(DimXMin+1:DimXMax)     &
         &   + f_X(DimXMin:DimXMax-1)     &
         &  ) * 5.0d-1
    s_X(DimXMin) = s_X(DimXMin+1) - DelX
    
    s_Z(DimZMin+1:DimZMax) =             &
         &  (                     &
         &     f_Z(DimZMin+1:DimZMax)     &
         &   + f_Z(DimZMin:DimZMax-1)     &
         &  ) * 5.0d-1
    s_Z(DimZMin) = s_Z(DimZMin+1) - DelZ
    
    !--- Υפ (boundary.f90 )
    if (trim(BcX) == "C" .AND. trim(BcZ) == "R") then        
       ss_Bc = "CsS"   
       fs_Bc = "CsA"
       sf_Bc = "CfA"
    else 
       write(*,*) "gridset.f90, unknown boundary condition" 
    end if
    
  end subroutine gridset_init
  
end module gridset
