!c Description: 
!c   $BCO7A$N8z2L$N7W;;(B
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-01    $B9b66$3$&;R(B $B:n@.(B
!c   1.1        2003-11-12    $B?y;39L0lO/(B $B=$@5(B
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module jacobian
  implicit none
  real(8), allocatable  :: jcb(:,:)    ! $B%d%3%S%"%s$N(B1/2$B>h(B
  real(8), allocatable  :: jcb_bz(:,:)
  real(8), allocatable  :: g13(:,:)  ! $B%d%3%S%"%s$N(B13$B@.J,(B
  real(8), allocatable  :: g13_bx(:,:)
  real(8), allocatable  :: g13_bz(:,:)
  real(8), allocatable  :: g13_bxbz(:,:)  

contains

  subroutine jacobian_init
    use gridset
!    use if_heikin

    !--- $BG[Ns$NDj5A(B
    allocate(jcb(-bm:im+bm,-bm:km+bm), &
         &   g13(-bm:im+bm,-bm:km+bm))

    !--- $B8=:_$O%U%i%C%H$JCO7A$r2>Dj(B
    jcb = 1.0d0
    g13 = 0.0d0

    !--- $BJ?6Q2=(B, $BHyJ,(B
    allocate(jcb_bz(-bm:im+bm,-bm:km+bm), &
         &   g13_bx(-bm:im+bm,-bm:km+bm), &
         &   g13_bz(-bm:im+bm,-bm:km+bm), &
         &   g13_bxbz(-bm:im+bm,-bm:km+bm))
    jcb_bz = 1.0d0 
    g13_bx = 0.0d0 
    g13_bz = 0.0d0 
    g13_bxbz = 0.0d0 

!    call heikin(31, jcb, jcb_bz)
!    call heikin(14, g13, g13_bxbz)
!    call heikin(24, g13, g13_bz)
!    call heikin(34, g13, g13_bx)
    
    !  g(i,k) =  (h - zs(i))/h
    !  g13(i,k) = (z(i,k) - h)/(h - zs(i))   &
    !       &     *(zs(i) - zs(i-1))/dx
    !  g_z(i,k) = (g(i,k+1) + g(i,k))/2.0d0
    !  
    !  g13_x(i,k) = (g13(i+1,k) + g13(i,k))/2
    !  
    !  g13_z(i,k) = (g13(i,k+1) + g13(i,k))/2
    !  
    !  g13_xz(i,k) = (                              &
    !       &        g13(i+1,k+1) + g13(i-1,k+1)    &
    !       &        + g13(i+1,k-1) + g13(i-1,k-1)  &
    !       &       )/4.0d0

  end subroutine jacobian_init
  
end module jacobian

