!c Description: 
!c   2 ϳإǥ
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-11    ⶶ 
!c   1.1        2003-11-12    ̰ϯ 
!c   1.1        2003-11-17    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

program arare
  use gtool_history
  use fileset
  use gridset
  use integrt
  use physprm
  use expname
  use prm
  use jacobian
  use if_heikin
  use if_cori_u
  use if_adv_u
  use if_trb_u
  use if_snddiv
  use if_vel_u
  use if_omega
  use if_adv_w

  !--- ۤηػ
  implicit none

  !--- 롼פ󤹤Τ˻Ȥѿ
  integer :: i, k

  !--- ѿ
  real(8), allocatable :: pi(:,:)      ! ʡؿ
  real(8), allocatable :: pres(:,:)    ! 
  real(8), allocatable :: temp(:,:)    ! 
  real(8), allocatable :: vtemp(:,:)   !  
  real(8), allocatable :: theta(:,:)   ! 
  real(8), allocatable :: vtheta(:,:)  ! 
  real(8), allocatable :: vtheta_bs(:,:) ! 
  real(8), allocatable :: dens(:,:)    ! ̩
  real(8), allocatable :: qv(:,:)      ! 
  real(8), allocatable :: e_sub(:,:)   ! ֥åɱưͥ륮
  real(8), allocatable :: km_sub(:,:)  ! 緸 K_{m}
  real(8), allocatable :: mxrt(:,:)    ! ˰º
  real(8), allocatable :: div(:,:)     ! ȸ

  !--- ®ٴϢѿ
  real(8), allocatable :: u(:,:)       ! x ®
  real(8), allocatable :: u_adv(:,:)   ! ή
  real(8), allocatable :: u_cori(:,:)   ! ꥪ 
  real(8), allocatable :: u_trb(:,:)   ! Ȼ
  real(8), allocatable :: omg(:,:)     ! z* ®
  real(8), allocatable :: w(:,:)       ! z ®
  real(8), allocatable :: w_adv(:,:)   ! ή
  real(8), allocatable :: w_cor(:,:)   ! ꥪ 
  real(8), allocatable :: w_trb(:,:)   ! Ȼ
  real(8), allocatable :: w_dif(:,:)   ! ȸ
  real(8), allocatable :: w_byc(:,:)   ! ȸ

  !--- å
  real(8), allocatable :: x(:)
  real(8), allocatable :: z(:)
  real(8), allocatable :: xs(:)
  real(8), allocatable :: zs(:)

  !--- gtool4
  type(gt_history) :: vector, scaler
  
  !----------------------------------------------
  !⥸塼ν
  !----------------------------------------------
  call fileset_init
  call gridset_init
  call integrt_init
  call physprm_init
  call expname_init
  call prm_init


  !-------------------------------------------------
  ! ϷϢ
  !-------------------------------------------------
  allocate(x(-bm:im+bm), z(-bm:km+bm))
  do i = -bm, im+bm
     x(i) = xmin + dx * real(i, 8)
  end do
  do k = -bm, km+bm
     z(k) = zmin + dz * real(k, 8)
  end do
  call heikin(12, x, xs)
  call heikin(13, z, zs)

  call jacobian_init

  !-------------------------------------------------
  ! gtool_history ν
  !-------------------------------------------------
  call output_gtool4_init


  !-------------------------------------------------
  ! ܾ
  !-------------------------------------------------
  allocate(pi(-bm:im+bm,-bm:km+bm), &
       &   pres(-bm:im+bm,-bm:km+bm), &
       &   temp(-bm:im+bm,-bm:km+bm), &
       &   vtemp(-bm:im+bm,-bm:km+bm), &
       &   theta(-bm:im+bm,-bm:km+bm), &
       &   vtheta(-bm:im+bm,-bm:km+bm), &
       &   vtheta_bs(-bm:im+bm,-bm:km+bm), &
       &   dens(-bm:im+bm,-bm:km+bm), &
       &   qv(-bm:im+bm,-bm:km+bm), &
       &   e_sub(-bm:im+bm,-bm:km+bm), &
       &   km_sub(-bm:im+bm,-bm:km+bm), &
       &   mxrt(-bm:im+bm,-bm:km+bm), &
       &   div(-bm:im+bm, -bm:km+bm), &
       &   u(-bm:im+bm, -bm:km+bm), &
       &   w(-bm:im+bm, -bm:km+bm))

  !--- ٤ϼǮΨǸ
  do i = -bm, km+bm
     temp(:,i) = temp_sfc - dtdz * z(i) 
  end do
  
  !--- ȤꤢͤˤƤã
  qv = 0.0d0
  u = 0.0d0
  w = 0.0d0
  e_sub = 0.0d0
  km_sub = 0.0d0
  
  !--- ɽ̤Ǥγ
  !---- 
  pres(:,-bm) = pres_sfc  
  !---- ̵
  pi(:,-bm) = (pres(:,-bm) / pres_sfc) ** ((gasr / rho) / cp)
  !---- 
  vtemp(:,-bm) = temp(:,-bm)
  !---- 
  theta(:,-bm) = temp(:,-bm) / pi(:,-bm)
  !---- 
  vtheta(:,-bm) = vtemp(:,-bm) / pi(:,-bm)
  !---- ̩ ()
  dens(:,-bm) = (pres_sfc / ((gasr / rho) * vtheta(:,-bm))) &
       & * (pi(:,-bm)) ** (cp / (gasr / rho)) 
  
  !--- ɽ̤Ǥγ
  do k = -bm+1, km+bm
     do i = -bm, im+bm
        !----  (ſ尵ʿ) 
        pres(i,k) = pres(i,k-1) - dens(i,k-1) * grav * jcb(i, k) * dz
        !---- ̵ (ſ尵ʿ)
        pi(i,k) = pi(i,k-1) - dz * jcb(i,k) * grav / (cp * vtheta(i,k-1))
        !---- 
        theta(i,k) = temp(i,k) / pi(i,k)
        !---- 
        vtheta(i,k) = theta(i,k) * (1.0d0 + 6.1d-1 * qv(i,k))
        !---- ̩
        dens(i,k) = (pres_sfc / ((gasr / rho) * vtheta(i,k))) &
             & * (pi(i,k)) ** (cp/(gasr / rho)) 
     end do
  end do

  !---- ͤݴ
  vtheta_bs = vtheta
  
  !---- ®٤
  call adv_u(u, w, u_adv)
  call cori_u(u, w, u_cori)
  call trb_u(u, w, u_trb)
  call snddiv(u, w, div)
  call vel_u(vtheta_bs, pi, div, u_adv, u_cori, u_trb, u)
  call omega(u, w, omg)
  call adv_w(u, w, omg, w_adv)
  call byc_w(vtheta, qv, w_byc)
  call trb_w(u, w, w_trb)

  
  !--- 
  call output_gtool4
  
  !--- ʬ
!  do t = 1, nts
!     call vel_u()
!     call 
!  end do
  
  call close_gtool4

contains

  !--- gtool4 ϴϢ
  subroutine output_gtool4_init
    ! ҥȥ꡼
    call HistoryCreate(                                    &
         & file = vncfile,                                &
         & title = exptitle,                             &
         & source = expsrc,                              &
         & institution = expinst,                        &
         & dims=(/'x','z','t'/),                           &
!         & dimsizes=(/im+2*bm+1, km+2*bm+1, 0/),         &
         & dimsizes=(/im+1, km+1, 0/),         &
         & longnames=(/'X-coordinate','Z-coordinate',      &
         &             'Time        '/),                   &
         & units=(/'m','m','s'/), origin=0.0,              &
         & interval=real(dts), &
         & history = vector)
    
    ! ѿ
    call HistoryPut('x',x(0:im),vector)
    call HistoryPut('z',z(0:km),vector)

    ! ҥȥ꡼
    call HistoryCreate(                                  &
         & file = sncfile,                               &
         & title = exptitle,                             &
         & source = expsrc,                              &
         & institution = expinst,                        &
         & dims=(/'x','z','t'/),                         &
!         & dimsizes=(/im+2*bm+1, km+2*bm+1, 0/),         &
         & dimsizes=(/im, km, 0/),         &
         & longnames=(/'X-coordinate','Z-coordinate',    &
         &             'Time        '/),                 &
         & units=(/'m','m','s'/), origin=0.0,            &
         & interval=real(dts),                           &
         & history = scaler)
    
    ! ѿ
    call HistoryPut('x',xs(1:im),scaler)
    call HistoryPut('z',zs(1:km),scaler)
    
    ! 
    call HistoryAddVariable(                            &
         & varname='pres', dims=(/'x','z'/),             &
         & longname='pressure', units='Pa',  &
         & xtype='double',                & 
         & history = scaler)    
    ! ̵
    call HistoryAddVariable(                            &
         & varname='pi', dims=(/'x','z'/),             &
         & longname='nondimensional pressure', units='1',&
         & xtype='double',                & 
         & history = scaler)    
    ! ̩
    call HistoryAddVariable(                            &
         & varname='dens', dims=(/'x','z'/),             &
         & longname='density', units='kg/m3',           &
         & xtype='double',                & 
         & history = scaler)    
    ! 
    call HistoryAddVariable(                            &
         & varname='qv', dims=(/'x','z'/),             &
         & longname='mixing ratio of water vapor',      &
         &  units='g/g', xtype='double',                & 
         & history = scaler)    
    ! 
    call HistoryAddVariable(                            &
         & varname='temp', dims=(/'x','z'/),             &
         & longname='temperature',                      &
         & units='K', xtype='double',                   &
         & history = scaler)    
    ! 
    call HistoryAddVariable(                            &
         & varname='theta', dims=(/'x','z'/),             &
         & longname='potential temperature',         &
         & units='K', xtype='double', &
         & history = scaler)    
    ! ®
    call HistoryAddVariable(                            &
         & varname='u', dims=(/'x','z'/),             &
         & longname='zonal velocity',         &
         & units='m/s', xtype='double',                & 
         & history = vector)        
    ! ®
    call HistoryAddVariable(                            &
         & varname='w', dims=(/'x','z'/),             &
         & longname='vertical velocity',         &
         & units='m/s', xtype='double',                & 
         & history = vector)    
    ! ƥ
    call HistoryAddVariable(                            &
         & varname='u_adv', dims=(/'x','z'/),             &
         & longname='zonal velocity',         &
         & units='m/s', xtype='double',                & 
         & history = vector)        
    ! ƥ
    call HistoryAddVariable(                            &
         & varname='div', dims=(/'x','z'/),             &
         & longname='zonal velocity',         &
         & units='m/s', xtype='double',                & 
         & history = scaler)        
    
  end subroutine output_gtool4_init


  subroutine output_gtool4
    call HistoryPut('pres', pres(1:im,1:km), scaler)
    call HistoryPut('pi', pi(1:im,1:km), scaler)
    call HistoryPut('dens', dens(1:im,1:km), scaler)
    call HistoryPut('qv', qv(1:im,1:km), scaler)
    call HistoryPut('temp', temp(1:im,1:km), scaler)
    call HistoryPut('theta', theta(1:im,1:km), scaler)
    call HistoryPut('u', u(0:im,0:km), vector)
    call HistoryPut('w', w(0:im,0:km), vector)
    call HistoryPut('u_adv', u_adv(0:im,0:km), vector)
    call HistoryPut('div', div(1:im,1:km), scaler)
  end subroutine output_gtool4

  subroutine close_gtool4
    call HistoryClose(scaler)
    call HistoryClose(vector)
  end subroutine close_gtool4
end program arare

