!= Nakajima et al. (1992) Ѥ˰漾λ
!
!= Evaluate saturation specific humidity with Nakajima et al. (1992)
!
! Authors::   Masaki ISHIWATARI, Yasuhiro MORIKAWA
! Version::   $Id: phy_saturate_nha92.f90,v 1.7 2008-04-20 18:44:16 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_saturate_nha92
  !
  != Nakajima et al. (1992) Ѥ˰漾λ
  !
  != Evaluate saturation specific humidity with Nakajima et al. (1992)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Nakajima et al. (1992) Ѥ줿˰¾ $ p^{*} $ ˴ؤʲμ
  ! Ѥ, ˰漾˰漾βʬͤ򻻽Фޤ. 
  !
  ! Saturation specific humidity and temperature derivative of it 
  ! are calculated with a folloing formula for saturation watar vapor pressure 
  ! $ p^{*} $ in Nakajima et al. (1992). 
  ! 
  ! \[
  !    p^{*} (T) = p_0^{*} \exp \left( - \frac{l}{RT} \right). 
  ! \]
  !
  ! , $ T $ ϲ, $ R $ ׵Ǥ. 
  ! $ R $ Ǯ $ l $ , 
  ! ˰¶ $ p_0^{*} $ ϰʲΤ褦Ϳޤ. 
  !
  ! where $ T $ is temperature, $ R $ is the gas constant. 
  ! $ R $ and latent heat $ l $ , 
  ! constant for the water vapor saturation curve $ p_0^{*} $ are as follows.
  ! 
  ! * $ R = 8.314 $ [J mol-1 K-1]
  ! * $ l = 43655 $ [J mol-1]
  ! * $ p_0^{*} = 1.4 \times 10^{11} $ [Pa]
  !
  ! ˰¿˰漾 $ q^{*} $ ݤˤ, ʲμѤޤ. 
  !
  ! Saturation specific humidity $ q^{*} $ is calculated from 
  ! saturation watar vapor pressure as follows.
  !
  ! \[
  !    q^{*} (T, P) = \varepsilon \frac{p^{*} (T)}{p}
  ! \]
  !
  !  $ \varepsilon $ ϶ŷʬ絤ʬ, 
  ! $ p $ ϵǤ. 
  !
  ! where $ \varepsilon $ is molecular weight ratio of water vapor to air, 
  ! $ p $ is air pressure. 
  ! 
  ! ä, ˰漾, ˰漾βѲ뼰ϰʲΤ褦
  ! ʤޤ. 
  !
  ! Therefore, saturation specific humidity and temperature derivative of it 
  ! are calculated as follows. 
  !
  ! \[
  !    q^{*} (T, P) = \varepsilon \frac{p_0^{*}}{p} \exp \left( - \frac{l}{RT} \right), \] \[
  !    \DP{q^{*} (T, P)}{T} = \varepsilon \frac{p_0^{*}}{p} \frac{l}{RT^2} \exp \left( - \frac{l}{RT} \right).
  ! \]
  !
  !== Procedures List
  !
  ! PhySatNhaCreate        :: PHYSATNHA ѿν
  ! CalcQVapSat            :: ˰漾η׻
  ! CalcDQVapSatDTemp      :: ˰漾βʬη׻
  ! PhySatNhaClose         :: PHYSATNHA ѿνλ
  ! PhySatNhaPutLine       :: PHYSATNHA ѿ˳ǼƤΰ
  ! PhySatNhainitialized   :: PHYSATNHA ѿꤵƤ뤫ݤ
  !--
  ! PhySatNhaSetTime       :: 
  !++
  ! ------------  :: ------------
  ! PhySatNhaCreate        :: Constructor of "PHYSATNHA"
  ! CalcQVapSat            :: Calculate saturation specific humidity
  ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
  ! PhySatNhaClose         :: Deconstructor of "PHYSATNHA"
  ! PhySatNhaPutLine       :: Print information of "PHYSATNHA"
  ! PhySatNhainitialized   :: Check initialization of "PHYSATNHA"
  !--
  ! PhySatNhaSetTime       :: Configure time
  !++
  !
  !== Usage
  !
  ! Ϥ, PHYSATNHA ѿ, 
  ! PhySatNhaCreate ǽԤޤ.
  ! ˰漾η׻ˤϥ֥롼 CalcQVapSat , 
  ! ˰漾βʬη׻ˤϥ֥롼 CalcDQVapSatDTemp 
  ! ѤƤ. 
  ! PHYSATNHA ѿνλˤ
  ! PhySatNhaClose ѤƤ.
  !
  ! First, initialize "PHYSATNHA" by "PhySatNhaCreate".
  ! Use a subroutine "CalcQVapSat" for saturation specific humidity, 
  ! or a subroutine "CalcDQVapSatDTemp" for temperature derivative of 
  ! saturation specific humidity. 
  ! In order to terminate "PHYSATNHA", use "PhySatNhaClose". 
  !
  !== References
  !
  ! * Nakajima, S., Hayashi, Y.-Y., Abe, Y., 1992: 
  !   A study on the "runaway greenhouse effect" 
  !   with a one dimensional radiative convective equilibrium model. 
  !   <i>J. Atmos. Sci.</i>, <b>49</b>, 2256--2266.

  use dc_types, only: DP, TOKEN, STRING
  use dc_date_types, only: DC_DIFFTIME
  use gt4_history_nmlinfo, only: GTHST_NMLINFO
  implicit none
  private
  public:: PHYSATNHA
  public:: PhySatNhaCreate, CalcQVapSat, CalcDQVapSatDTemp
  public:: PhySatNhaClose, PhySatNhaPutLine
  public:: PhySatNhaInitialized
!!$  public:: PhySatNhaSetTime

  type PHYSATNHA
    !
    ! ޤ, PhySatNhaCreate  "PHYSATNHA" 
    ! ѿꤷƲ. 
    ! ꤵ줿 "PHYSATNHA" ѿѤݤˤ,
    ! PhySatNhaClose ˤäƽλԤäƤ.
    !
    ! Initialize "PHYSATNHA" variable by 
    ! "PhySatNhaCreate" before usage.
    ! If you reuse "PHYSATNHA" variable again for another application, 
    ! terminate by "PhySatNhaClose".
    !
    logical:: initialized = .false.
                              ! ե饰. 
                              ! Initialization flag

    !-----------------------------------------------------------------
    !  ʻȿ
    !  Grid points and maximum truncated wavenumber
    !-----------------------------------------------------------------
    integer:: imax            ! ٳʻ. 
                              ! Number of grid points in longitude
    integer:: jmax            ! ٳʻ. 
                              ! Number of grid points in latitude
    integer:: kmax            ! ľؿ. 
                              ! Number of vertical level

    !-----------------------------------------------------------------
    !  ǡ
    !  Axes data
    !-----------------------------------------------------------------
!!$    real(DP), pointer:: x_Lon (:)
!!$                              ! . Longitude
!!$    real(DP), pointer:: y_Lat (:) =>null()
!!$                              ! . Latitude
!!$    real(DP), pointer:: z_Sigma (:) =>null()
!!$                              ! $ \sigma $ ٥ (). 
!!$                              ! Full $ \sigma $ level

    !-----------------------------------------------------------------
    !  
    !  Coefficients
    !-----------------------------------------------------------------
    real(DP):: EpsV = 0.62264642082430_DP
                              ! $ \epsilon_v $ .
                              ! ʬ. 
                              ! ǥեͤϵ. 
                              ! 
                              ! Molecular weight ratio of water vapor. 
                              ! Default value is a value on Earch. 
    real(DP):: RUniv = 8.314_DP
                              ! $ R $ [J mol-1 K-1]. 
                              ! ׵. Universal gas constant
    real(DP):: LatHeat = 43655_DP
                              ! $ l $ [J mol-1]. 
                              ! ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: P0 = 1.4e+11_DP
                              ! $ p_0^{*} $ [Pa]. 
                              ! ˰¶. constant for water vapor saturation curve

    !-----------------------------------------------------------------
    !  
    !  Time control
    !-----------------------------------------------------------------
!!$    type(DC_DIFFTIME):: current_time
!!$                              ! ߻. Current time.
!!$    type(DC_DIFFTIME):: delta_time
!!$                              ! $ \Delta t $ . ॹƥå. Time step

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    !-----------------------------------------------------------------
!!$    type(GTHST_NMLINFO):: gthstnml
!!$                              ! NAMELIST#phy_saturate_nha92_history_nml 
!!$                              ! ꤵ̤ΥǡϾ. 
!!$                              ! 
!!$                              ! Individual data output information from 
!!$                              ! "NAMELIST#phy_saturate_nha92_history_nml". 
  end type PHYSATNHA


  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: phy_saturate_nha92.f90,v 1.7 2008-04-20 18:44:16 morikawa Exp $'

  !-----------------------------------------------------------------
  !  ³
  !  Public procedures
  !-----------------------------------------------------------------

  interface PhySatNhaCreate
    module procedure PhySatNhaCreate
  end interface

  interface CalcQVapSat
    module procedure PhySatNhaCalcQVapSat3  !:doc-priority 40:
    module procedure PhySatNhaCalcQVapSat2  !:doc-priority 50:
    module procedure PhySatNhaCalcQVapSat0  !:doc-priority 60:
  end interface

  interface CalcDQVapSatDTemp
    module procedure PhySatNhaCalcDQVapSatDTemp3  !:doc-priority 40:
    module procedure PhySatNhaCalcDQVapSatDTemp2  !:doc-priority 50:
    module procedure PhySatNhaCalcDQVapSatDTemp0  !:doc-priority 60:
  end interface

!!$  interface PhySatNhaSample
!!$    module procedure PhySatNhaSample
!!$  end interface

  interface PhySatNhaClose
    module procedure PhySatNhaClose
  end interface

  interface PhySatNhaPutLine
    module procedure PhySatNhaPutLine
  end interface

  interface PhySatNhainitialized
    module procedure PhySatNhaInitialized
  end interface

!!$  interface PhySatNhaSetTime
!!$    module procedure PhySatNhaSetTime
!!$  end interface

  !-----------------------------------------------------------------
  !  ³
  !  Private procedures
  !-----------------------------------------------------------------

  interface NmlRead
    module procedure PhySatNhaNmlRead
  end interface

contains

  subroutine PhySatNhaCreate( phy_sat_nha, &
    & imax, jmax, kmax, &
    & EpsV, &
!!$    & x_Lon, y_Lat, &
!!$    & CoefAlpha, DelTime, &
!!$    & current_time_value, current_time_unit, &
!!$    & history_varlist, &
!!$    & history_interval_value, history_interval_unit, &
!!$    & history_precision, history_fileprefix, &
    & nmlfile, err )
    !
    ! PHYSATNHA ѿνԤޤ. 
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä 
    ! PHYSATNHA ѿꤷƤ. 
    !
    ! ʤ, Ϳ줿 *phy_sat_nha* ˽ꤵƤ, 
    ! ץϥ顼ȯޤ. 
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_saturate_nha92_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYSATNHA". 
    ! Initialize *phy_sat_nha* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_sat_nha* is already initialized 
    ! by this procedure, error is occurred. 
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_saturate_nha92_nml" 
    ! for details about a NAMELIST group. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD, USR_ERRNO
    use dc_date, only: DCDiffTimeCreate
    use dc_hash, only: HASH, DCHashPut, DCHashRewind, DCHashNext, DCHashDelete
    use gt4_history_nmlinfo, only: HstNmlInfoCreate, HstNmlInfoAdd, &
      & HstNmlInfoEndDefine, HstNmlInfoPutLine
    use gt4_history, only: GT_HISTORY, &
      & HistoryAddVariable, HistoryAddAttr
    implicit none
    type(PHYSATNHA), intent(inout):: phy_sat_nha
    integer, intent(in):: imax
                              ! ٳʻ. 
                              ! Number of grid points in longitude
    integer, intent(in):: jmax
                              ! ٳʻ. 
                              ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in):: EpsV
                              ! $ \epsilon_v $ .
                              ! ʬ. Molecular weight ratio of water vapor
!!$    real(DP), intent(in):: x_Lon (0:imax-1)
!!$                              ! . Longitude
!!$    real(DP), intent(in):: y_Lat (0:jmax-1)
!!$                              ! . Latitude
!!$    real(DP), intent(in):: CoefAlpha
!!$                              ! $ \alpha $ . . Coefficient
!!$    real(DP), intent(in):: DelTime
!!$                              ! $ \Delta t $ . ॹƥå. Time step
!!$    real, intent(in), optional:: current_time_value
!!$                              ! ߻ο. Numerical value of current time
!!$    character(*), intent(in), optional:: current_time_unit
!!$                              ! ߻ñ. Unit of current time
!!$    character(*), intent(in), optional:: history_varlist
!!$                              ! ҥȥǡνѿꥹ. 
!!$                              ! ޤǶڤä¤٤. 
!!$                              ! (: "Data1,Data2" ). 
!!$                              ! 
!!$                              ! List of variables output to history data. 
!!$                              ! Delimiter is comma. 
!!$                              ! (exp. "Data1,Data2" ). 
!!$                              ! 
!!$    real, intent(in), optional:: history_interval_value
!!$                              ! ҥȥǡνϴֳ֤ο. 
!!$                              ! Numerical value for interval of history data output
!!$    character(*), intent(in), optional:: history_interval_unit
!!$                              ! ҥȥǡνϴֳ֤ñ. 
!!$                              ! Unit for interval of history data output
!!$    character(*), intent(in), optional:: history_precision
!!$                              ! ҥȥǡ. 
!!$                              ! Precision of history data
!!$    character(*), intent(in), optional:: history_fileprefix
!!$                              ! ҥȥǡΥե̾Ƭ. 
!!$                              ! Prefix of history data filenames

    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ. 
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_saturate_nha92_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to 
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_saturate_nha92_nml" 
                              ! for details about a NAMELIST group. 
                              ! 

    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
!!$    character(STRING):: name = ''
!!$                              ! ѿ̾. Variable identifier
!!$    character(STRING):: longname = ''
!!$                              ! ѿεŪ̾. Descriptive name of variables
!!$    character(STRING), allocatable:: dims(:)
!!$                              ! ɸ̾. Name of axes
!!$    character(STRING):: units = ''
!!$                              ! ñ. Units
!!$    type(GT_HISTORY), pointer:: gthist =>null()
!!$                              ! gt4_history ⥸塼ѹ¤. 
!!$                              ! Derived type for "gt4_history" module
!!$    character(TOKEN):: precision
!!$                              ! ҥȥǡ. 
!!$                              ! Precision of history data
!!$    logical:: average
!!$                              ! ϥǡʿѲե饰. 
!!$                              ! Flag for average of output data
!!$    type(HASH):: registered_varnames
!!$                              ! Υ⥸塼뤫Ϥѿ̾Υꥹ.
!!$                              ! 
!!$                              ! List of names of variables output 
!!$                              ! from this module. 
!!$    logical:: end

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhySatNhaCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_sat_nha % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYSATNHA'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validate arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if
    if (EpsV < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'EpsV'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȿʻ
    !  Configure wave number and grid point
    !-----------------------------------------------------------------
    phy_sat_nha % imax = imax
    phy_sat_nha % jmax = jmax
    phy_sat_nha % kmax = kmax

    !-----------------------------------------------------------------
    !  ɸ
    !  Configure axes
    !-----------------------------------------------------------------
!!$    allocate( phy_sat_nha % x_Lon (0:imax-1) )
!!$    phy_sat_nha % x_Lon = x_Lon
!!$
!!$    allocate( phy_sat_nha % y_Lat (0:jmax-1) )
!!$    phy_sat_nha % y_Lat = y_Lat

    !-----------------------------------------------------------------
    !  ʪ
    !  Configure physical constants
    !-----------------------------------------------------------------
    phy_sat_nha % EpsV = EpsV

    !-----------------------------------------------------------------
    !  
    !  Time control
    !-----------------------------------------------------------------
!!$    if ( present(current_time_value) .and. present(current_time_unit) ) then
!!$      call DCDiffTimeCreate( &
!!$        & diff = phy_sat_nha % current_time, &  ! (out)
!!$        & value = real( current_time_value, DP ), & ! (in)
!!$        & unit = current_time_unit )                ! (in)
!!$    else
!!$      call DCDiffTimeCreate( &
!!$        & diff = phy_sat_nha % current_time, & ! (out)
!!$        & value = 0.0_DP, &    ! (in)
!!$        & unit = 'sec' )       ! (in)
!!$    end if

!!$    call DCDiffTimeCreate( &
!!$      & diff = phy_sat_nha % delta_time, & ! (out)
!!$      & value = DelTime, &             ! (in)
!!$      & unit = 'sec' )                 ! (in)

    !-----------------------------------------------------------------
    !  "PHYSATNHA" 
    !  Configure the settings for "PHYSATNHA"
    !-----------------------------------------------------------------
!!$    phy_sat_nha % CoefAlpha = CoefAlpha
!!$    phy_sat_nha % key00     = ''

!!$    !-----------------------------------------------------------------
!!$    !  ҥȥեؤΥǡ
!!$    !  Configure the settings for history data output
!!$    !-----------------------------------------------------------------
!!$
!!$    !-------------------------
!!$    !  ǥե
!!$    !  Default values
!!$    call HstNmlInfoCreate( gthstnml = phy_sat_nha % gthstnml ) ! (inout)
!!$
!!$    !-------------------------
!!$    !  ץʥ
!!$    !  Values from optional arguments
!!$    call HstNmlInfoAdd( &
!!$      & gthstnml = phy_sat_nha % gthstnml, &   ! (inout)
!!$      & name = '', &                               ! (in)
!!$      & interval_value = history_interval_value, & ! (in)
!!$      & interval_unit = history_interval_unit, &   ! (in)
!!$      & precision = history_precision, &           ! (in)
!!$      & average = .false., &                       ! (in)
!!$      & fileprefix = history_fileprefix )          ! (in)
!!$
!!$    if ( present(history_varlist) ) then
!!$      call HstNmlInfoAdd( &
!!$        & gthstnml = phy_sat_nha % gthstnml, & ! (inout)
!!$        & name = history_varlist )                 ! (in)
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  NAMELIST ͤɤ߹
!!$    !  Load values from NAMELIST
!!$    !-----------------------------------------------------------------
!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1 = trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &          ! (in)
!!$!!        & CoefAlpha   = phy_sat_nha % CoefAlpha, & ! (inout)
!!$!!        & key00_      = phy_sat_nha % key00, &     ! (inout)
!!$        & gthstnml    = phy_sat_nha % gthstnml, &  ! (inout)
!!$        & err = err )                              ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1 = trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if
!!$
!!$    call HstNmlInfoEndDefine( &
!!$      & gthstnml = phy_sat_nha % gthstnml, & ! (inout)
!!$      & err = err )                              ! (out)
!!$    if ( present_and_true( err ) ) then
!!$      stat = USR_ERRNO
!!$      goto 999
!!$    end if


    !-----------------------------------------------------------------
    !  ǡϤν
    !  Initialize data output
    !-----------------------------------------------------------------

!!$    !-------------------------
!!$    !  x_Data1 ν
!!$    !  Configure the settings for "x_Data1" output
!!$    name = 'Data1'
!!$    longname = 'Sample data (1)'
!!$    units = '1'
!!$    allocate( dims(2) )
!!$    dims = StoA( 'lon', 'time' )
!!$
!!$    ! ϥեν.
!!$    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
!!$    ! Initialize output file.
!!$    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
!!$    call output_init  ! ֥롼. This is an internal subroutine
!!$
!!$    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
!!$    ! Describe codes as follows in order to add attributes etc.
!!$    if ( associated( gthist ) ) then
!!$      call HistoryAddAttr( &
!!$        & history = gthist, &                           ! (inout)
!!$        & varname = name, attrname = 'missing_value', & ! (in)
!!$        &   value = 9999.0 )                            ! (in)
!!$    end if
!!$    deallocate( dims )
!!$
!!$    !-------------------------
!!$    !  y_Data2 ν
!!$    !  Configure the settings for "y_Data2" output
!!$    name = 'Data2'
!!$    longname = 'Sample data (2)'
!!$    units = '1'
!!$    allocate( dims(2) )
!!$    dims = StoA( 'lat', 'time' )
!!$
!!$    ! ϥեν.
!!$    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
!!$    ! Initialize output file.
!!$    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
!!$    call output_init  ! ֥롼. This is an internal subroutine
!!$    deallocate( dims )

    !-----------------------------------------------------------------
    !  Υ⥸塼뤫Ϥѿ̾ΥꥹȤɽ
    !  Print list of names of variables output from this module
    !-----------------------------------------------------------------
!!$    call Printf( STDOUT, &
!!$      & ' *** MESSAGE *** +---- "%c" module output varnames list -----', &
!!$      & c1 = 'phy_saturate_nha92' )
!!$    call DCHashRewind( hashv = registered_varnames ) ! (inout)
!!$    do
!!$      call DCHashNext( hashv = registered_varnames, & ! (inout)
!!$        & key = name, value = longname, end = end )   ! (out)
!!$      if ( end ) exit
!!$      call Printf( STDOUT, &
!!$        & ' *** MESSAGE *** |      "%c" (%c)', &
!!$        & c1 = trim(name), c2 = trim(longname) )
!!$    enddo
!!$    call DCHashDelete( hashv = registered_varnames ) ! (inout)
!!$    call Printf( STDOUT, &
!!$      & ' *** MESSAGE *** `----------------------------------------' )

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( phy_sat_nha % CoefAlpha < 0.0_DP ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'CoefAlpha'
!!$      goto 999
!!$    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_sat_nha % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )

!!$  contains
!!$
!!$    subroutine output_init
!!$      !
!!$      ! ѿ *name* ˴ؤƽϥեνԤޤ. 
!!$      ! ϥե̾ϴֳ֤ʤɤξ phy_sat_nha % gthstnml 
!!$      ! Фޤ. 
!!$      ! 
!!$      ! ѿ *name* ˴ؤƽϤԤˤ, 
!!$      ! *gthist* ˽ե gt4_history#GT_HISTORY
!!$      ! ѿ礵ޤ. Ǥʤ, *gthist* ֤ˤޤ. 
!!$      !
!!$      ! ޤ, ϥǡ٤ precision , 
!!$      ! ϥǡʿѲβݤ average ꤷޤ. 
!!$      ! 
!!$      ! ɸϤɽѿꥹ *registered_varnames* 
!!$      ! *name*, *longname*, *dims*, *units* Ͽޤ. 
!!$      !
!!$      ! An output file is initialized for a variable *name*. 
!!$      ! Information such as the output filename and output intervals 
!!$      ! is taken out of "phy_sat_nha % gthstnml". 
!!$      !
!!$      ! When output is done for the variable *name*, *gthist* is 
!!$      ! associated with the "gt4_history#GT_HISTORY" variable of 
!!$      ! the output file. Otherwise, *gthist* is nullified. 
!!$      !
!!$      ! Moreover, the accuracy of output data is set to *precision*, and 
!!$      ! right or wrong of averaging the output data is set to *average*. 
!!$      !
!!$      ! *name*, *longname*, *dims*, *units* are registered to 
!!$      ! a list of variables *registered_varnames* that is printed to 
!!$      ! standard output. 
!!$      !
!!$      use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit
!!$      use gt4_history_nmlinfo, only: GTHST_NMLINFO, &
!!$        & HstNmlInfoInitialized, HstNmlInfoInquire, &
!!$        & HstNmlInfoOutputValid, HstNmlInfoAssocGtHist, HstNmlInfoPutLine
!!$      use gt4_history, only: GT_HISTORY, &
!!$        & HistoryCreate, HistoryAddVariable, HistoryPut, &
!!$        & HistoryAddAttr, HistoryInitialized
!!$
!!$      !-----------------------------------
!!$      !  ѿ
!!$      !  Work variables
!!$      character(STRING):: file
!!$                                ! ҥȥǡΥե̾. 
!!$                                ! History data filenames
!!$      character(STRING):: dims_str
!!$                                ! ɸΥꥹ. 
!!$                                ! List of axes
!!$      real:: interval_value
!!$                                ! ҥȥǡνϴֳ֤ο. 
!!$                                ! Numerical value for interval of history data output
!!$      character(TOKEN):: interval_unit
!!$                                ! ҥȥǡνϴֳ֤ñ. 
!!$                                ! Unit for interval of history data output
!!$!!!$      real(DP), parameter:: PI = 3.1415926535897930_DP
!!$!!!$                                ! $ \pi $ . ߼Ψ. Circular constant
!!$    continue
!!$      !-----------------------------------------------------------------
!!$      !  ɸϤɽѿϿ
!!$      !  Register a variable name for print to standard output
!!$      !-----------------------------------------------------------------
!!$      if ( allocated(dims) ) then
!!$        dims_str = JoinChar( dims, ',' )
!!$      else
!!$        dims_str = ''
!!$      end if
!!$      call DCHashPut( hashv = registered_varnames, &     ! (inout)
!!$        & key = name, &                                  ! (in)
!!$        & value = trim( longname ) // ' [' // &
!!$        &         trim( units ) // '] {' // &
!!$        &         trim( dims_str ) // '}' ) ! (in)
!!$
!!$      !-----------------------------------------------------------------
!!$      !  ѿν
!!$      !  Initialize variable
!!$      !-----------------------------------------------------------------
!!$      nullify( gthist )
!!$      precision = 'float'
!!$      average = .false.
!!$
!!$      !-----------------------------------------------------------------
!!$      !  Ϥͭɤǧ
!!$      !  Confirm whether the output is effective
!!$      !-----------------------------------------------------------------
!!$      if ( .not. HstNmlInfoOutputValid( phy_sat_nha % gthstnml, name ) ) then
!!$        return
!!$      end if
!!$
!!$      !-----------------------------------------------------------------
!!$      !  GT_HISTORY ѿμ
!!$      !  Get "GT_HISTORY" variable
!!$      !-----------------------------------------------------------------
!!$      call HstNmlInfoAssocGtHist( &
!!$        & gthstnml = phy_sat_nha % gthstnml, & ! (in)
!!$        & name = name, &                       ! (in)
!!$        & history = gthist, &                  ! (out)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true( err ) ) return
!!$
!!$      call HstNmlInfoInquire( &
!!$        & gthstnml = phy_sat_nha % gthstnml, & ! (in)
!!$        & name = name, &                       ! (in)
!!$        & precision = precision, &             ! (out)
!!$        & average = average, &                 ! (out)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true( err ) ) return
!!$
!!$      !-----------------------------------------------------------------
!!$      !  GT_HISTORY ѿνγǧ
!!$      !  Check initialization of "GT_HISTORY" variable
!!$      !-----------------------------------------------------------------
!!$      if ( HistoryInitialized( gthist ) ) then
!!$
!!$        !---------------------------------------------------------------
!!$        !  HistoryAddVariable ˤѿ
!!$        !  A variable is created by "HistoryAddVariable"
!!$        !---------------------------------------------------------------
!!$        call HistoryAddVariable( &
!!$          &  history = gthist, &                       ! (inout)
!!$          &  varname = name,         dims = dims, &    ! (in)
!!$          & longname = longname,    units = units, &   ! (in)
!!$          &    xtype = precision, average = average )  ! (in)
!!$        return
!!$      end if
!!$
!!$      !-----------------------------------------------------------------
!!$      !  HistoryCreate Τͤμ
!!$      !  Get the settings for "HistoryCreate"
!!$      !-----------------------------------------------------------------
!!$      call HstNmlInfoInquire( &
!!$        & gthstnml = phy_sat_nha % gthstnml, & ! (in)
!!$        & name = name, &                       ! (in)
!!$        & file = file, &                       ! (out)
!!$        & interval_unit = interval_unit, &     ! (out)
!!$        & interval_value = interval_value, &   ! (out)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true( err ) ) return
!!$
!!$      !-----------------------------------------------------------------
!!$      !  HistoryCreate ˤե
!!$      !  Files are created by "HistoryCreate"
!!$      !-----------------------------------------------------------------
!!$!!!$      call HistoryCreate( &
!!$!!!$        & history = gthist, &   ! (out)
!!$!!!$        & file = file, &        ! (in)
!!$!!!$        & title = 'Sample program of dcmodel programming guideline', &  ! (in)
!!$!!!$        & source = 'dcmodel project : ' // trim(version), &             ! (in)
!!$!!!$        & institution = 'GFD Dennou Club', &                     ! (in)
!!$!!!$        & dims = StoA( 'lon', 'lat', 'time' ), &                 ! (in)
!!$!!!$        & dimsizes = (/ phy_sat_nha % imax, phy_sat_nha % jmax, 0 /), & ! (in)
!!$!!!$        & longnames = StoA( 'longitude', 'latitude', 'time' ), & ! (in)
!!$!!!$        & units = StoA( 'degree_east', 'degree_north', &
!!$!!!$        &                interval_unit ), &                      ! (in)
!!$!!!$        & origin = real( EvalbyUnit( phy_sat_nha % current_time, &
!!$!!!$        &                            interval_unit) ), &         ! (in)
!!$!!!$        & interval = interval_value, &                           ! (in)
!!$!!!$        & err = err )                                            ! (out)
!!$!!!$      if ( present_and_true( err ) ) then
!!$!!!$        nullify( gthist )
!!$!!!$        return
!!$!!!$      end if
!!$!!!$
!!$!!!$      call HistoryAddAttr( &
!!$!!!$        & history = gthist, &                            ! (inout)
!!$!!!$        & varname = 'lon', attrname = 'standard_name', & ! (in)
!!$!!!$        & value = 'longitude' )                          ! (in)
!!$!!!$      call HistoryAddAttr( &
!!$!!!$        & history = gthist, &                            ! (inout)
!!$!!!$        & varname = 'lat', attrname = 'standard_name', & ! (in)
!!$!!!$        & value = 'latitude' )                           ! (in)
!!$!!!$      call HistoryAddAttr( &
!!$!!!$        & history = gthist, &                             ! (inout)
!!$!!!$        & varname = 'time', attrname = 'standard_name', & ! (in)
!!$!!!$        & value = 'time' )                                ! (in)
!!$!!!$
!!$!!!$      call HistoryPut( &
!!$!!!$        & history = gthist, &                           ! (inout)
!!$!!!$        & varname = 'lon', &                            ! (in)
!!$!!!$        & array = phy_sat_nha % x_Lon / PI * 180.0_DP ) ! (in)
!!$!!!$      call HistoryPut( &
!!$!!!$        & history = gthist, &                           ! (inout)
!!$!!!$        & varname = 'lat', &                            ! (in)
!!$!!!$        & array = phy_sat_nha % y_Lat / PI * 180.0_DP ) ! (in)
!!$
!!$      !-----------------------------------------------------------------
!!$      !  HistoryAddVariable ˤѿ
!!$      !  A variable is created by "HistoryAddVariable"
!!$      !-----------------------------------------------------------------
!!$      if ( HistoryInitialized( gthist ) ) then
!!$        call HistoryAddVariable( &
!!$          &  history = gthist, &                       ! (inout)
!!$          &  varname = name,         dims = dims, &    ! (in)
!!$          & longname = longname,    units = units, &   ! (in)
!!$          &    xtype = precision, average = average )  ! (in)
!!$      else
!!$        nullify( gthist )
!!$      end if
!!$
!!$    end subroutine output_init

  end subroutine PhySatNhaCreate

  subroutine PhySatNhaCalcQVapSat3( phy_sat_nha, &
    & xyz_Temp, xyz_Press, &
    & xyz_QVapSat, &
!!$    & historyput_flag, &
    & err )
    !
    !  *xyz_Temp* ȵ *xyz_Press* Ѥ, ˰漾 *xyz_QVapSat* ޤ. 
    !
    ! ǡǤϤʤ顼ǡͿˤϲ
    ! ֥롼ѤƤ. 
    !
    ! ʤ, Ϳ줿 *phy_sat_nha*  PhySatNhaCreate 
    ! ˤäƽꤵƤʤ, ץϥ顼ȯޤ. 
    !
    ! Calculate saturation specific humidity *xyz_QVapSat* using
    ! temperature *xyz_Temp* and air pressure *xyz_Press*. 
    !
    ! If scalar data is given instead of array data, 
    ! use a following subroutine. 
    !
    ! If *phy_sat_nha* is not initialized 
    ! by "PhySatNhaCreate" yet, error is occurred. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_true
    use dc_date, only: mod, operator(+), operator(==), EvalbyUnit, EvalSec
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, USR_ERRNO
    use gt4_history_nmlinfo, only: HstNmlInfoInquire, &
      & HstNmlInfoOutputValid, HstNmlInfoAssocGtHist, HstNmlInfoPutLine
    use gt4_history, only: GT_HISTORY, HistoryPut, HistoryInitialized
    implicit none
    type(PHYSATNHA), intent(inout):: phy_sat_nha
    real(DP), intent(in):: xyz_Temp (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1, 0:phy_sat_nha%kmax-1)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_Press (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1, 0:phy_sat_nha%kmax-1)
                              ! $ p $ . . 
                              ! Air pressure
    real(DP), intent(out):: xyz_QVapSat (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1, 0:phy_sat_nha%kmax-1)
                              ! $ q^{*} $ . ˰漾. 
                              ! Saturation specific humidity. 
!!$    logical, intent(in), optional:: historyput_flag
!!$                              ! ǡϤΥե饰. 
!!$                              ! SetTime ˤäƻŪ
!!$                              ! ꤷˤ, ΰ
!!$                              ! .true. ޤ .false. ꤹ
!!$                              ! ȤǥǡϤΥ󥪥դ
!!$                              ! Ū˻ꤹɬפޤ. 
!!$                              ! ǥեȤ .false. Ǥ. 
!!$                              ! 
!!$                              ! Data output flag. 
!!$                              ! When time is specified by "SetTime", 
!!$                              ! explicit specification of data output 
!!$                              ! on/off by specifying ".true." or ".false." 
!!$                              ! to this argument. 
!!$                              ! Default value is ".false.". 
!!$                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
!!$    character(STRING):: name = ''
!!$                              ! ѿ̾. Variable identifier
!!$    real:: time
!!$                              ! . Time
!!$    type(GT_HISTORY), pointer:: gthist =>null()
!!$                              ! gt4_history ⥸塼ѹ¤. 
!!$                              ! Derived type for "gt4_history" module

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: i, j, k         ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhySatNhaCalcQVapSat3'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_sat_nha % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYSATNHA'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ˰漾η׻
    !  Calculate saturation specific humidity
    !-----------------------------------------------------------------
    do i = 0, phy_sat_nha%imax-1
      do j = 0, phy_sat_nha%jmax-1
        do k = 0, phy_sat_nha%kmax-1
          call CalcQVapSat( phy_sat_nha = phy_sat_nha,  & ! (inout)
            &    Temp = xyz_Temp(i,j,k), &                ! (in)
            &   Press = xyz_Press(i,j,k), &               ! (in)
            & QVapSat = xyz_QVapSat(i,j,k) )              ! (out)
        end do
      end do
    end do

    !----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  History data output
    !----------------------------------------------------------------

!!$    !-----------------------------------
!!$    !  x_Data1 ν
!!$    !  Output "x_Data1"
!!$    name = 'Data1'
!!$
!!$    ! ϤΥå. 
!!$    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
!!$    ! Check for output.
!!$    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
!!$    call output_check ! ֥롼. This is an internal subroutine
!!$
!!$    ! ϥǡ array Ϥ.
!!$    ! Give output data to argument "array"
!!$    if ( associated( gthist ) ) then
!!$      call HistoryPut( &
!!$        & history = gthist, &                ! (inout)
!!$        & varname = name, array = x_Data1, & ! (in)
!!$        & time = time, quiet = .false., &    ! (in)
!!$        & err = err )                        ! (out)
!!$    end if
!!$
!!$    !-----------------------------------
!!$    !  y_Data2 ν
!!$    !  Output "y_Data2"
!!$    name = 'Data2'
!!$
!!$    ! ϤΥå. 
!!$    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
!!$    ! Check for output.
!!$    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
!!$    call output_check ! ֥롼. This is an internal subroutine
!!$
!!$    ! ϥǡ array Ϥ.
!!$    ! Give output data to argument "array"
!!$    if ( associated( gthist ) ) then
!!$      call HistoryPut( &
!!$        & history = gthist, &                ! (inout)
!!$        & varname = name, array = y_Data2, & ! (in)
!!$        & time = time, quiet = .false., &    ! (in)
!!$        & err = err )                        ! (out)
!!$    end if

    !-----------------------------------------------------------------
    !  ι
    !  Update time
    !-----------------------------------------------------------------
!!$    phy_sat_nha % current_time = &
!!$      & phy_sat_nha % current_time + phy_sat_nha % delta_time

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )

!!$  contains
!!$
!!$    subroutine output_check
!!$      !
!!$      ! ѿ *name* Ϥ뤫ɤåޤ. 
!!$      ! Ϥ˴ؤ dcm_sam_cod % gthstnml Фޤ. 
!!$      !
!!$      ! ѿ *name* ˴ؤƽϤ褦ꤵƤˤ, 
!!$      ! *gthist* ˽ե gt4_history#GT_HISTORY
!!$      ! ѿ礵ޤ. Ǥʤ, *gthist* ֤ˤޤ. 
!!$      !
!!$      ! ޤ, ߻ *time* ꤷޤ. 
!!$      !
!!$      ! Check whether to output variable *name*. 
!!$      ! Information about output is taken out of "dcm_sam_cod % gthstnml". 
!!$      !
!!$      ! When output is done for the variable *name*, *gthist* is 
!!$      ! associated with "gt4_history#GT_HISTORY" variable of
!!$      ! the output file. Otherwise, *gthist* is nullified. 
!!$      !
!!$      ! Moreover, current time is set to *time*. 
!!$      !
!!$      character(TOKEN):: interval_unit
!!$                                ! ҥȥǡνϴֳ֤ñ. 
!!$                                ! Unit for interval of history data output
!!$    continue
!!$
!!$      nullify( gthist )
!!$      time = 0.0
!!$
!!$      if ( HstNmlInfoOutputValid( phy_sat_nha % gthstnml, name ) ) then
!!$        call HstNmlInfoInquire( &
!!$          & gthstnml = phy_sat_nha % gthstnml, & ! (in)
!!$          & name = name, &                           ! (in)
!!$          & interval_unit = interval_unit )          ! (out)
!!$
!!$        time = real( EvalbyUnit( phy_sat_nha % current_time, interval_unit ) )
!!$        if ( present_and_true( historyput_flag ) ) time = 0.0
!!$
!!$        call HstNmlInfoAssocGtHist( & 
!!$          & gthstnml = phy_sat_nha % gthstnml, & ! (in)
!!$          & name = name, &                           ! (in)
!!$          & history = gthist, err = err )            ! (out)
!!$        if ( present_and_true( err ) ) then
!!$          nullify( gthist )
!!$          return
!!$        end if
!!$
!!$        if ( .not. HistoryInitialized( gthist ) ) nullify( gthist )
!!$      end if
!!$
!!$    end subroutine output_check
  end subroutine PhySatNhaCalcQVapSat3

  subroutine PhySatNhaCalcQVapSat2( phy_sat_nha, &
    & xy_Temp, xy_Press, xy_QVapSat, &
    & err )
    !
    !  *xy_Temp* ȵ *xy_Press* Ѥ, ˰漾 *xy_QVapSat* ޤ. 
    !
    ! ǡǤϤʤ顼ǡͿˤϲ
    ! ֥롼ѤƤ. 
    !
    ! ʤ, Ϳ줿 *phy_sat_nha*  PhySatNhaCreate 
    ! ˤäƽꤵƤʤ, ץϥ顼ȯޤ. 
    !
    ! Calculate saturation specific humidity *xy_QVapSat* using
    ! temperature *xy_Temp* and air pressure *xy_Press*. 
    !
    ! If scalar data is given instead of array data, 
    ! use a following subroutine. 
    !
    ! If *phy_sat_nha* is not initialized 
    ! by "PhySatNhaCreate" yet, error is occurred. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, USR_ERRNO
    implicit none
    type(PHYSATNHA), intent(inout):: phy_sat_nha
    real(DP), intent(in):: xy_Temp (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xy_Press (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1)
                              ! $ p $ . . 
                              ! Air pressure
    real(DP), intent(out):: xy_QVapSat (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1)
                              ! $ q^{*} $ . ˰漾. 
                              ! Saturation specific humidity. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: i, j            ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhySatNhaCalcQVapSat2'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_sat_nha % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYSATNHA'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ˰漾η׻
    !  Calculate saturation specific humidity
    !-----------------------------------------------------------------
    do i = 0, phy_sat_nha%imax-1
      do j = 0, phy_sat_nha%jmax-1
        call CalcQVapSat( phy_sat_nha = phy_sat_nha,  & ! (inout)
          &    Temp = xy_Temp(i,j), &                   ! (in)
          &   Press = xy_Press(i,j), &                  ! (in)
          & QVapSat = xy_QVapSat(i,j) )                 ! (out)
      end do
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhySatNhaCalcQVapSat2

  subroutine PhySatNhaCalcQVapSat0( phy_sat_nha, &
    & Temp, Press, QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, ˰漾 *QVapSat* ޤ. 
    !
    ! 顼ǡǤϤʤǡͿˤϾ嵭
    ! ֥롼ѤƤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !
    ! If array data is given instead of scalar data, 
    ! use a above subroutine. 
    !
    implicit none
    type(PHYSATNHA), intent(in):: phy_sat_nha
    real(DP), intent(in):: Temp
                              ! $ T $ . . Temperature
    real(DP), intent(in):: Press
                              ! $ p $ . . 
                              ! Air pressure
    real(DP), intent(out):: QVapSat
                              ! $ q^{*} $ . ˰漾. 
                              ! Saturation specific humidity. 

    !-----------------------------------
    !  *phy_sat_nha* Ф
    !  Setting values fetched from *phy_sat_nha*
    real(DP):: EpsV
                              ! $ \epsilon_v $ .
                              ! ʬ. Molecular weight ratio of water vapor
    real(DP):: RUniv
                              ! $ R $ [J mol-1 K-1]. 
                              ! ׵. Universal gas constant
    real(DP):: LatHeat
                              ! $ l $ [J mol-1]. 
                              ! ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: P0
                              ! $ p_0^{*} $ [Pa]. 
                              ! ˰¶. constant for water vapor saturation curve

    !-----------------------------------
    !  ѿ
    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhySatNhaCalcQVapSat0'
  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
!!$    if ( .not. phy_sat_nha % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYSATNHA'
!!$      goto 999
!!$    end if

    !-----------------------------------------------------------------
    !  *phy_sat_nha* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_sat_nha*
    !-----------------------------------------------------------------
    EpsV    = phy_sat_nha % EpsV
    RUniv   = phy_sat_nha % RUniv  
    LatHeat = phy_sat_nha % LatHeat
    P0      = phy_sat_nha % P0     

    !-----------------------------------------------------------------
    !  ˰漾η׻
    !  Calculate saturation specific humidity
    !-----------------------------------------------------------------
    QVapSat = EpsV * ( P0 / Press ) * exp ( - LatHeat / ( RUniv * Temp ) )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
  end subroutine PhySatNhaCalcQVapSat0

  subroutine PhySatNhaCalcDQVapSatDTemp3( phy_sat_nha, &
    & xyz_Temp, xyz_Press, &
    & xyz_DQVapSatDTemp, &
    & err )
    !
    !  *xyz_Temp* ȵ *xyz_Press* Ѥ, 
    ! ˰漾βʬ *xyz_DQVapSatDTemp* ޤ. 
    !
    ! ǡǤϤʤ顼ǡͿˤϲ
    ! ֥롼ѤƤ. 
    !
    ! ʤ, Ϳ줿 *phy_sat_nha*  PhySatNhaCreate 
    ! ˤäƽꤵƤʤ, ץϥ顼ȯޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *xyz_DQVapSatDTemp* using
    ! temperature *xyz_Temp* and air pressure *xyz_Press*. 
    !
    ! If scalar data is given instead of array data, 
    ! use a following subroutine. 
    !
    ! If *phy_sat_nha* is not initialized 
    ! by "PhySatNhaCreate" yet, error is occurred. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYSATNHA), intent(inout):: phy_sat_nha
    real(DP), intent(in):: xyz_Temp (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1, 0:phy_sat_nha%kmax-1)
                              ! $ T $ .     . Temperature
    real(DP), intent(in):: xyz_Press (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1, 0:phy_sat_nha%kmax-1)
                              ! $ p $ . . 
                              ! Air pressure
    real(DP), intent(out):: xyz_DQVapSatDTemp (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1, 0:phy_sat_nha%kmax-1)
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: i, j, k         ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhySatNhaCalcDQVapSatDTemp3'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_sat_nha % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYSATNHA'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ˰漾βʬη׻
    !  Calculate temperature derivative of saturation specific humidity
    !-----------------------------------------------------------------
    do i = 0, phy_sat_nha%imax-1
      do j = 0, phy_sat_nha%jmax-1
        do k = 0, phy_sat_nha%kmax-1
          call CalcDQVapSatDTemp( phy_sat_nha = phy_sat_nha,  & ! (inout)
            &          Temp = xyz_Temp(i,j,k), &                ! (in)
            &         Press = xyz_Press(i,j,k), &               ! (in)
            & DQVapSatDTemp = xyz_DQVapSatDTemp(i,j,k) )       ! (out)
        end do
      end do
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )

  end subroutine PhySatNhaCalcDQVapSatDTemp3

  subroutine PhySatNhaCalcDQVapSatDTemp2( phy_sat_nha, &
    & xy_Temp, xy_Press, xy_DQVapSatDTemp, & 
    & err )
    !
    !  *xy_Temp* ȵ *xy_Press* Ѥ, 
    ! ˰漾βʬ *xy_DQVapSatDTemp* ޤ. 
    !
    ! ǡǤϤʤ顼ǡͿˤϲ
    ! ֥롼ѤƤ. 
    !
    ! ʤ, Ϳ줿 *phy_sat_nha*  PhySatNhaCreate 
    ! ˤäƽꤵƤʤ, ץϥ顼ȯޤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *xy_DQVapSatDTemp* using
    ! temperature *xy_Temp* and air pressure *xy_Press*. 
    !
    ! If scalar data is given instead of array data, 
    ! use a following subroutine. 
    !
    ! If *phy_sat_nha* is not initialized 
    ! by "PhySatNhaCreate" yet, error is occurred. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, USR_ERRNO
    implicit none
    type(PHYSATNHA), intent(inout):: phy_sat_nha
    real(DP), intent(in):: xy_Temp (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xy_Press (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1)
                              ! $ p $ . . 
                              ! Air pressure
    real(DP), intent(out):: xy_DQVapSatDTemp (0:phy_sat_nha%imax-1, 0:phy_sat_nha%jmax-1)
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: i, j            ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhySatNhaCalcDQVapSatDTemp2'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_sat_nha % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYSATNHA'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ˰漾η׻
    !  Calculate saturation specific humidity
    !-----------------------------------------------------------------
    do i = 0, phy_sat_nha%imax-1
      do j = 0, phy_sat_nha%jmax-1
        call CalcDQVapSatDTemp( phy_sat_nha = phy_sat_nha,  & ! (inout)
          &          Temp = xy_Temp(i,j), &                   ! (in)
          &         Press = xy_Press(i,j), &                  ! (in)
          & DQVapSatDTemp = xy_DQVapSatDTemp(i,j) )           ! (out)
      end do
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhySatNhaCalcDQVapSatDTemp2

  subroutine PhySatNhaCalcDQVapSatDTemp0( phy_sat_nha, &
    & Temp, Press, DQVapSatDTemp )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾βʬ *DQVapSatDTemp* ޤ. 
    !
    ! 顼ǡǤϤʤǡͿˤϾ嵭
    ! ֥롼ѤƤ. 
    !
    ! Calculate temperature derivative of saturation specific humidity 
    ! *DQVapSatDTemp* using
    ! temperature *Temp* and air pressure *Press*. 
    !
    ! If array data is given instead of scalar data, 
    ! use a above subroutine. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_true
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, USR_ERRNO
    implicit none
    type(PHYSATNHA), intent(in):: phy_sat_nha
    real(DP), intent(in):: Temp
                              ! $ T $ . . Temperature
    real(DP), intent(in):: Press
                              ! $ p $ . . 
                              ! Air pressure
    real(DP), intent(out):: DQVapSatDTemp
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

    !-----------------------------------
    !  *phy_sat_nha* Ф
    !  Setting values fetched from *phy_sat_nha*
    real(DP):: EpsV
                              ! $ \epsilon_v $ .
                              ! ʬ. Molecular weight ratio of water vapor
    real(DP):: RUniv
                              ! $ R $ [J mol-1 K-1]. 
                              ! ׵. Universal gas constant
    real(DP):: LatHeat
                              ! $ l $ [J mol-1]. 
                              ! ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: P0
                              ! $ p_0^{*} $ [Pa]. 
                              ! ˰¶. constant for water vapor saturation curve

    !-----------------------------------
    !  ѿ
    !  Work variables

!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhySatNhaCalcDQVapSatDTemp0'
  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
!!$    if ( .not. phy_sat_nha % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYSATNHA'
!!$      goto 999
!!$    end if

    !-----------------------------------------------------------------
    !  *phy_sat_nha* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_sat_nha*
    !-----------------------------------------------------------------
    EpsV    = phy_sat_nha % EpsV
    RUniv   = phy_sat_nha % RUniv  
    LatHeat = phy_sat_nha % LatHeat
    P0      = phy_sat_nha % P0     

    !-----------------------------------------------------------------
    !  ˰漾η׻
    !  Calculate saturation specific humidity
    !-----------------------------------------------------------------
    DQVapSatDTemp = &
      & EpsV * ( P0 / Press ) &
      &   * ( LatHeat / ( RUniv * Temp**2 ) ) &
      &   * exp ( - LatHeat / ( RUniv * Temp ) )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
  end subroutine PhySatNhaCalcDQVapSatDTemp0


!!$  subroutine PhySatNhaSample( phy_sat_nha, err )
!!$    !--
!!$    ! PhySatNhaSample 򵭽ҤƤ. 
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_sat_nha*  PhySatNhaCreate 
!!$    ! ˤäƽꤵƤʤ, ץϥ顼ȯޤ. 
!!$    !--
!!$    ! Describe brief of "PhySatNhaSample". 
!!$    !++
!!$    ! If *phy_sat_nha* is not initialized 
!!$    ! by "PhySatNhaCreate" yet, error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYSATNHA), intent(inout):: phy_sat_nha
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰. 
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ. 
!!$                              !  *err* Ϳ, 
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ. 
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$    !-----------------------------------
!!$    !  *phy_sat_nha* Ф
!!$    !  Setting values fetched from *phy_sat_nha*
!!$!!$    real(DP):: CoefAlpha      ! $ \alpha $ . . Coefficient
!!$!!$    real(DP):: DelTime        ! $ \Delta t $ . ॹƥå. Time step
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhySatNhaSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_sat_nha % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYSATNHA'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_sat_nha* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_sat_nha*
!!$    !-----------------------------------------------------------------
!!$!!$    CoefAlpha = phy_sat_nha % CoefAlpha
!!$!!$    DelTime   = phy_sat_nha % DelTime
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$
!!$  end subroutine PhySatNhaSample

  subroutine PhySatNhaClose( phy_sat_nha, err )
    !
    ! PHYSATNHA ѿνλԤޤ. 
    ! ʤ, Ϳ줿 *phy_sat_nha*  PhySatNhaCreate 
    ! ˤäƽꤵƤʤ, ץϥ顼ȯޤ. 
    !
    ! Deconstructor of "PHYSATNHA". 
    ! Note that if *phy_sat_nha* is not initialized 
    ! by "PhySatNhaCreate" yet, error is occurred. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use gt4_history_nmlinfo, only: HstNmlInfoClose, HstNmlInfoNames, &
      & HstNmlInfoAssocGtHist, HstNmlInfoPutLine
    use gt4_history, only: GT_HISTORY, HistoryClose, HistoryInitialized
    implicit none
    type(PHYSATNHA), intent(inout):: phy_sat_nha
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
!!$    character(STRING):: name = ''
!!$                              ! ѿ̾. Variable identifier
!!$    character(STRING):: varnames
!!$                              ! ѿ̾ꥹ. 
!!$                              ! List of variables
!!$    character(TOKEN), pointer:: varnames_array(:) =>null()
!!$                              ! ѿ̾ꥹ. 
!!$                              ! List of variables (array) 
!!$    integer:: i, vnmax
!!$    type(GT_HISTORY), pointer:: gthist =>null()
!!$                              ! gt4_history ⥸塼ѹ¤. 
!!$                              ! Derived type for "gt4_history" module

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhySatNhaClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_sat_nha % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYSATNHA'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYSATNHA" ξõ
    !  Clear the settings for "PHYSATNHA"
    !-----------------------------------------------------------------
!!$    deallocate( phy_sat_nha % x_Lon )
!!$    deallocate( phy_sat_nha % y_Lat )

!!$    !-----------------------------------------------------------------
!!$    !  ҥȥեؤΥǡϤνλ
!!$    !  Terminate the settings for history data output
!!$    !-----------------------------------------------------------------
!!$    varnames = HstNmlInfoNames( phy_sat_nha % gthstnml )
!!$    call Split( str = varnames, sep = ',', & ! (in)
!!$      & carray = varnames_array )            ! (out)
!!$    vnmax = size( varnames_array )
!!$
!!$    do i = 1, vnmax
!!$      name = varnames_array(i)
!!$      if ( trim( name ) == '' ) exit
!!$      nullify( gthist )
!!$      call HstNmlInfoAssocGtHist( & 
!!$        & gthstnml = phy_sat_nha % gthstnml, & ! (in)
!!$        & name = name, &                           ! (in)
!!$        & history = gthist, &                      ! (out)
!!$        & err = err )                              ! (out)
!!$      if ( HistoryInitialized( gthist ) ) then
!!$
!!$        call HistoryClose( history = gthist, & ! (inout)
!!$          & err = err )                        ! (out)
!!$
!!$      end if
!!$    end do

!!$    !-----------------------------------------------------------------
!!$    !  ҥȥեؤΥǡγղ
!!$    !  Deallocate the settings for history data output
!!$    !-----------------------------------------------------------------
!!$    call HstNmlInfoClose( &
!!$      & phy_sat_nha % gthstnml, & ! (inout)
!!$      & err = err )                   ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_sat_nha % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )

  end subroutine PhySatNhaClose

  subroutine PhySatNhaPutLine( phy_sat_nha, unit, indent, err )
    !
    !  *phy_sat_nha* ꤵƤޤ. 
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ. 
    !
    ! Print information of *phy_sat_nha*. 
    ! By default messages are output to standard output. 
    ! Unit number for output can be changed by *unit* argument. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_date, only: EvalSec
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use gt4_history_nmlinfo, only: GTHST_NMLINFO, HstNmlInfoPutLine
    implicit none
    type(PHYSATNHA), intent(in):: phy_sat_nha
    integer, intent(in), optional:: unit
                              ! ֹ. 
                              ! ǥեȤνɸ. 
                              !
                              ! Unit number for output. 
                              ! Default value is standard output. 
    character(*), intent(in), optional:: indent
                              ! ɽåλ. 
                              !
                              ! Indent of displayed messages. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhySatNhaPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  ֹȻ
    !  Configure output unit number and indents
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if

    !-----------------------------------------------------------------
    !  "PHYSATNHA" ΰ
    !  Print the settings for "PHYSATNHA"
    !-----------------------------------------------------------------
    if ( phy_sat_nha % initialized ) then
      call Printf( unit = out_unit, &                 ! (in)
        & fmt = indent_str(1:indent_len) // & 
        &       '#<PHYSATNHA:: @initialized=%y', & ! (in)
        & l = (/phy_sat_nha % initialized/) )     ! (in)

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i=(/phy_sat_nha % imax, phy_sat_nha % jmax, phy_sat_nha % kmax/) )

      call Printf( unit = out_unit, &      ! (in)
        & fmt = indent_str(1:indent_len) // &
        &       ' @EpsV=%f', &             ! (in)
        & d = (/phy_sat_nha % EpsV/) )     ! (in)

      call Printf( unit = out_unit, &      ! (in)
        & fmt = indent_str(1:indent_len) // &
        &       ' @RUniv=%f @LatHeat=%f @P0=%f', & ! (in)
        & d = (/phy_sat_nha % RUniv, &
        &       phy_sat_nha % LatHeat, &
        &       phy_sat_nha % P0/) )               ! (in)

!!$      call Printf( unit = out_unit, &                             ! (in)
!!$        & fmt = indent_str(1:indent_len) // &
!!$        &       ' @current_time=%f [sec] @delta_time=%f [sec]', & ! (in)
!!$        & d = (/ EvalSec( phy_sat_nha % current_time ), &
!!$        &        EvalSec( phy_sat_nha % delta_time ) /) )      ! (in)
!!$
!!$      call Printf( unit = out_unit, &            ! (in)
!!$        & fmt = indent_str(1:indent_len) // &
!!$        &       ' @key00=%c', &                  ! (in)
!!$        & c1 = trim( phy_sat_nha % key00 ) ) ! (in)
!!$
!!$      call PutLine( array = phy_sat_nha % x_Lon, & ! (in)
!!$        & unit = out_unit, &                           ! (in)
!!$        & lbounds = lbound(phy_sat_nha % x_Lon), & ! (in)
!!$        & ubounds = ubound(phy_sat_nha % x_Lon), & ! (in)
!!$        & indent = indent_str(1:indent_len) // &
!!$        &          ' @x_Lon=' )                        ! (in)
!!$
!!$      call PutLine( array = phy_sat_nha % y_Lat, & ! (in)
!!$        & unit = out_unit, &                           ! (in)
!!$        & lbounds = lbound(phy_sat_nha % y_Lat), & ! (in)
!!$        & ubounds = ubound(phy_sat_nha % y_Lat), & ! (in)
!!$        & indent = indent_str(1:indent_len) // &
!!$        &          ' @y_Lat=' )                        ! (in)
!!$
!!$      call Printf( unit = out_unit, &         ! (in)
!!$        & fmt = indent_str(1:indent_len) // &
!!$        &       ' @gthstnml=' )               ! (in)
!!$      call HstNmlInfoPutLine( &
!!$        & gthstnml = phy_sat_nha % gthstnml, &    ! (in)
!!$        & unit = out_unit, &                          ! (in)
!!$        & indent = indent_str(1:indent_len) // '  ' ) ! (in)

      call Printf( unit = out_unit, &             ! (in)
        & fmt = indent_str(1:indent_len) // '>' ) ! (in)
    else
      call Printf( unit = out_unit, &                   ! (in)
        & fmt = indent_str(1:indent_len) // &           ! (in)
        &       '#<PHYSATNHA:: @initialized=%y>', &  ! (in)
        & l = (/phy_sat_nha % initialized/) )       ! (in)
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )

  end subroutine PhySatNhaPutLine

  logical function PhySatNhaInitialized( phy_sat_nha ) result(result)
    !
    ! *phy_sat_nha* ꤵƤˤ .true. , 
    ! ꤵƤʤˤ .false. ֤ޤ. 
    !
    ! If *phy_sat_nha* is initialized, .true. is returned. 
    ! If *phy_sat_nha* is not initialized, .false. is returned. 
    !
    implicit none
    type(PHYSATNHA), intent(in):: phy_sat_nha
  continue
    result = phy_sat_nha % initialized
  end function PhySatNhaInitialized

!!$  subroutine PhySatNhaSetTime( phy_sat_nha, &
!!$    & current_time_value, current_time_unit, &
!!$    & err )
!!$    !
!!$    ! *phy_sat_nha* ФƻԤޤ. 
!!$    !
!!$    ! ҥȥǡϤƤˤ, 
!!$    ! ҥȥǡνϻꤷޤ. 
!!$    ! ٤Ǥ⤳Υ֥롼Ƥˤ, 
!!$    ! ʸΥҥȥǡˤΥ֥롼ƤӽФ, 
!!$    ! ԤäƤ. 
!!$    ! ޤ, ǡϤ륵֥롼ФƤ 
!!$    ! ץʥ historyput_flag  .true. ͿƤ. 
!!$    !
!!$    ! ʤ, Ϳ줿 *phy_sat_nha*  PhySatNhaCreate 
!!$    ! ˤäƽꤵƤʤ, ץϥ顼ȯޤ. 
!!$    !
!!$    ! Set time to *phy_sat_nha*. 
!!$    !
!!$    ! When history data are output, 
!!$    ! the output time of history data are specified. 
!!$    ! Once this subroutine is called, the time of history data must be 
!!$    ! specified by this routine before history data output. 
!!$    ! In additional, give ".true." to an optional argument 
!!$    ! "historyput_flag" of a data output subroutine. 
!!$    !
!!$    ! If *phy_sat_nha* is not initialized 
!!$    ! by "PhySatNhaCreate" yet, error is occurred. 
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_date, only: DCDiffTimeCreate, EvalbyUnit
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    use gt4_history_nmlinfo, only: HstNmlInfoAdd, HstNmlInfoInquire, &
!!$      & HstNmlInfoNames, HstNmlInfoAssocGtHist, &
!!$      & HstNmlInfoOutputStepDisable, HstNmlInfoPutLine
!!$    use gt4_history, only: GT_HISTORY, HistorySetTime, HistoryInitialized
!!$    implicit none
!!$    type(PHYSATNHA), intent(inout):: phy_sat_nha
!!$    real, intent(in):: current_time_value
!!$                              ! ߻ο. Numerical value of current time
!!$    character(*), intent(in):: current_time_unit
!!$                              ! ߻ñ. Unit of current time
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰. 
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ. 
!!$                              !  *err* Ϳ, 
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ. 
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$    !-----------------------------------
!!$    !  ҥȥեؤΥǡ
!!$    !  Configure the settings for history data output
!!$    character(STRING):: name = ''
!!$                              ! ѿ̾. Variable identifier
!!$    character(TOKEN):: interval_unit
!!$                              ! ҥȥǡνϴֳ֤ñ. 
!!$                              ! Unit for interval of history data output
!!$    character(STRING):: varnames
!!$                              ! ѿ̾ꥹ. 
!!$                              ! List of variables
!!$    character(TOKEN), pointer:: varnames_array(:) =>null()
!!$                              ! ѿ̾ꥹ. 
!!$                              ! List of variables (array) 
!!$    integer:: i, vnmax
!!$    type(GT_HISTORY), pointer:: gthist =>null()
!!$                              ! gt4_history ⥸塼ѹ¤. 
!!$                              ! Derived type for "gt4_history" module
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhySatNhaSetTime'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_sat_nha % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYSATNHA'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  
!!$    !  Configure time
!!$    !-----------------------------------------------------------------
!!$    call DCDiffTimeCreate( &
!!$      & diff = phy_sat_nha % current_time, &  ! (out)
!!$      & value = real( current_time_value, DP ), & ! (in)
!!$      & unit = current_time_unit )                ! (in)
!!$
!!$    !-----------------------------------------------------------------
!!$    !  ҥȥեؤΥǡλ
!!$    !  Configure the time of history data
!!$    !-----------------------------------------------------------------
!!$    varnames = HstNmlInfoNames( phy_sat_nha % gthstnml )
!!$    call Split( str = varnames, sep = ',', & ! (in)
!!$      & carray = varnames_array )            ! (out)
!!$    vnmax = size( varnames_array )
!!$
!!$    do i = 1, vnmax
!!$      name = varnames_array(i)
!!$      if ( trim( name ) == '' ) exit
!!$
!!$      call HstNmlInfoOutputStepDisable( & 
!!$        & gthstnml = phy_sat_nha % gthstnml, & ! (inout)
!!$        & name = name, &                           ! (in)
!!$        & err = err )                              ! (out)
!!$
!!$      nullify( gthist )
!!$      call HstNmlInfoAssocGtHist( & 
!!$        & gthstnml = phy_sat_nha % gthstnml, & ! (in)
!!$        & name = name, &                           ! (in)
!!$        & history = gthist, &                      ! (out)
!!$        & err = err )                              ! (out)
!!$
!!$      if ( HistoryInitialized( gthist ) ) then
!!$        call HstNmlInfoInquire( &
!!$          & gthstnml = phy_sat_nha % gthstnml, & ! (in)
!!$          & name = name, &                           ! (in)
!!$          & interval_unit = interval_unit )          ! (out)
!!$
!!$        call HistorySetTime( &
!!$          & history = gthist, &                     ! (inout)
!!$          & time = &
!!$          &   real( EvalbyUnit( phy_sat_nha % current_time, &
!!$          &                     interval_unit) ) ) ! (in)
!!$      end if
!!$
!!$    end do
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$
!!$  end subroutine PhySatNhaSetTime

  subroutine PhySatNhaNmlRead( nmlfile, &
!!$    & CoefAlpha, &
!!$    & key00_, &
    & gthstnml, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. PhySatNhaCreate 
    ! ǸƤӽФ뤳ȤꤷƤޤ. 
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ, 
    ! Ϥ줿ͤΤޤ֤ޤ. 
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ. 
    !
    ! This is a subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be 
    ! called by "PhySatNhaCreate". 
    !
    ! A value not specified in NAMELIST file is returned 
    ! without change. 
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_date, only: DCDiffTimeCreate
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD, DC_ENOTINIT
    use gt4_history_nmlinfo, only: GTHST_NMLINFO, HstNmlInfoAdd, &
      & HstNmlInfoInquire, HstNmlInfoInitialized, HstNmlInfoPutLine
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name

!!$    real(DP), intent(inout):: CoefAlpha
!!$                              ! $ \alpha $ . . Coefficient
!!$
!!$    character(*), intent(inout):: key00_
!!$    character(TOKEN):: key00
!!$                              ! . Keyword
!!$
    type(GTHST_NMLINFO), intent(inout):: gthstnml
                              ! NAMELIST#phy_saturate_nha92_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              ! 
                              ! ǥեͤʤɤ
                              ! ԤäͿ뤳. 
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#phy_saturate_nha92_history_nml". 
                              ! 
                              ! Before this argument is given to 
                              ! this procedure, initialize and 
                              ! configure the defaut settings. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_saturate_nha92_nml/ &
!!$      & CoefAlpha, key00
!!$                              ! phy_saturate_nha92 ⥸塼
!!$                              ! NAMELIST ѿ̾. 
!!$                              !
!!$                              ! phy_saturate_nha92#PhySatNhaCreate 
!!$                              ! Ѥݤ, ץʥ *nmlfile* 
!!$                              !  NAMELIST ե̾ꤹ뤳Ȥ, 
!!$                              ! Υե뤫餳 NAMELIST ѿ
!!$                              ! ɤ߹ߤޤ. 
!!$                              !
!!$                              ! NAMELIST group name for 
!!$                              ! "phy_saturate_nha92" module. 
!!$                              ! 
!!$                              ! If a NAMELIST filename is specified to 
!!$                              ! an optional argument *nmlfile* when 
!!$                              ! "phy_saturate_nha92#PhySatNhaCreate" 
!!$                              ! is used, this NAMELIST group is 
!!$                              ! loaded from the file. 

    character(STRING):: name
                              ! ѿ̾. 
                              ! ξˤ, ¾ͤ
                              ! phy_saturate_nha92 ⥸塼ˤ
                              ! ϤǡƤ
                              ! ǥեͤȤʤޤ. 
                              ! 
                              ! "Data1,Data2" Τ褦˥ޤǶڤäʣ
                              ! ѿꤹ뤳ȤǽǤ. 
                              ! 
                              ! Variable identifier. 
                              ! If blank is given, other values are 
                              ! used as default values of output data 
                              ! in "phy_saturate_nha92". 
                              ! 
                              ! Multiple variables can be specified 
                              ! as "Data1,Data2" too. Delimiter is comma. 
    character(STRING):: file
                              ! ϥե̾. 
                              ! ϥǥեͤȤƤϻѤޤ. 
                              ! *name* ͤꤵƤΤͭǤ. 
                              ! 
                              ! Output file name. 
                              ! This is not used as default value. 
                              ! This value is valid only when *name* is 
                              ! specified. 

    real:: interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! Numerical value for interval of history data output
                              ! Negative values suppresses output.
    character(TOKEN):: interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(TOKEN):: precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical:: average
                              ! ϥǡʿѲե饰. 
                              ! Flag for average of output data
    character(STRING):: fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames

    namelist /phy_saturate_nha92_history_nml/ &
      & name, &
      & file, &
      & interval_value, &
      & interval_unit, &
      & precision, &
      & fileprefix, &
      & average
                              ! phy_saturate_nha92 ⥸塼Υҥȥǡ
                              ! NAMELIST ѿ̾. 
                              !
                              ! phy_saturate_nha92#PhySatNhaCreate 
                              ! Ѥݤ, ץʥ *nmlfile* 
                              !  NAMELIST ե̾ꤹ뤳Ȥ, 
                              ! Υե뤫餳 NAMELIST ѿ
                              ! ɤ߹ߤޤ. 
                              !
                              ! NAMELIST group name for 
                              ! history data of "phy_saturate_nha92" module. 
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* when 
                              ! "phy_saturate_nha92#PhySatNhaCreate" 
                              ! is used, this NAMELIST group is 
                              ! loaded from the file. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(TOKEN):: pos_nml
                              ! NAMELIST ɤ߹߻Υե. 
                              ! File position of NAMELIST read
    character(*), parameter:: subname = 'PhySatNhaNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------

    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    key00       = key00_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if

    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------

    !-------------------------
    !  ʤɤμ
    !  Get coefficients etc.
!!$    rewind( unit_nml )
!!$    read( unit = unit_nml, &         ! (in)
!!$      &    nml = phy_saturate_nha92_nml, & ! (out)
!!$      & iostat = iostat_nml )        ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'phy_saturate_nha92_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = phy_saturate_nha92_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'phy_saturate_nha92_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if
!!$
    !-------------------------
    !  ϥǡθ̾μ
    !  Get individual information of output data
    rewind( unit_nml )
    iostat_nml = 0
    pos_nml = ''
    do while ( trim(pos_nml) /= 'APPEND' .and. iostat_nml == 0 )

      name                   = ''
      file                   = ''
      call HstNmlInfoInquire( &
        & gthstnml = gthstnml, &             ! (in)
        & interval_value = interval_value, & ! (out)
        & interval_unit = interval_unit, &   ! (out)
        & precision = precision, &           ! (out)
        & average = average, &               ! (out)
        & fileprefix = fileprefix )          ! (out)

      read( unit = unit_nml, &                 ! (in)
        &    nml = phy_saturate_nha92_history_nml, & ! (out)
        & iostat = iostat_nml )                ! (out)
      inquire( unit = unit_nml, & ! (in)
        &  position = pos_nml )   ! (out)

      if ( iostat_nml == 0 ) then
        call MessageNotify( 'M', subname, &
          & 'NAMELIST group "%c" is loaded from "%c".', &
          & c1='phy_saturate_nha92_history_nml', c2=trim(nmlfile) )
        write(STDOUT, nml = phy_saturate_nha92_history_nml)

        call HstNmlInfoAdd( &
          & gthstnml = gthstnml, &             ! (in)
          & name = name, &                     ! (in)
          & file = file, &                     ! (in)
          & interval_value = interval_value, & ! (in)
          & interval_unit = interval_unit, &   ! (in)
          & precision = precision, &           ! (in)
          & average = average, &               ! (in)
          & fileprefix = fileprefix )          ! (in)

      else
        call MessageNotify( 'W', subname, &
          & 'NAMELIST group "%c" is not found in "%c" any more (iostat=%d).', &
          & c1='phy_saturate_nha92_history_nml', c2=trim(nmlfile), &
          & i = (/iostat_nml/) )
      end if
    end do

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    key00_       = key00

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )

  end subroutine PhySatNhaNmlRead

end module phy_saturate_nha92
