!= phy_ape ⥸塼Υƥȥץ
!
!= Test program for "phy_ape"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_ape_test.f90,v 1.9 2008-03-02 05:39:52 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_ape ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_ape" module.
! Confirm compilation and execution of this program.
!

program phy_ape_test
  use phy_ape, only: PHYAPE, Create, Close, &
    & PutLine, initialized, PhysicsAPE, PhysicsAdjust
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use dc_args, only: ARGS, DCArgsOpen, DCArgsHelpMsg, DCArgsOption, &
    & DCArgsDebug, DCArgsHelp, DCArgsStrict, DCArgsClose
  use dc_date_types, only: DC_DIFFTIME
  use dc_date, only: DCDiffTimeCreate, EvalSec, EvalMin
  use gt4_history, only: HistoryGet
  use gt4_history, only: GT_HISTORY, &
    & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
    & HistoryAddAttr
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_ape_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "phy_ape" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: imax = 64         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 32         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, parameter:: kmax = 20         ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
  real(DP):: RAir       ! $ R $ .      絤.   Gas constant of air
  real(DP):: Grav       ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
  real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
  real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
  real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturated vapor pressure at 0 degrees C
  real(DP):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant
  real(DP):: FKarm     ! $ k $ .                 ޥ.   Karman constant
  !---------------------------------------------------------
  !  
  !  Time
  !---------------------------------------------------------
  type(DC_DIFFTIME):: delta_time
                            ! $ \Delta t$ . . Time


  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP):: x_Lon (0:imax-1)
                              ! . Longitude
  real(DP):: x_Lon_Weight(0:imax-1)
                   ! ٺɸŤ. 
                   ! Weight of longitude
  real(DP):: y_Lat (0:jmax-1)
                              ! . Latitude
  real(DP):: y_Lat_Weight(0:jmax-1)
                   ! ٺɸŤ. 
                   ! Weight of latitude
  real(DP):: z_Sigma (0:kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP):: r_Sigma (0:kmax)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP):: xyz_U (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ U $ . ®. Zonal wind
  real(DP):: xyz_V (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ V $ . ®. Meridional wind

  real(DP):: xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T $ .     . Temperature
  real(DP):: xy_Ps (0:imax-1, 0:jmax-1)
                              ! $ P_s $ .   ɽ̵. Surface pressure
  real(DP):: xyz_QVap (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q $ .     漾. Specific humidity
  real(DP):: xyz_DUDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \DP{U}{t} $ . 
                              ! ®Ѳ. 
                              ! Zonal wind tendency
  real(DP):: xyz_DVDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \DP{V}{t} $ . 
                              ! ®Ѳ. 
                              ! Meridional wind tendency
  real(DP):: xyz_DTempDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \DP{T}{t} $ . 
                              ! Ѳ. 
                              ! Temperature tendency
  real(DP):: xyz_DQVapDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \DP{q}{t} $ . 
                              ! 漾Ѳ. 
                              ! Temperature tendency

  real(DP):: xyz_UAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ U $ . ®. Zonal wind
  real(DP):: xyz_VAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ V $ . ®. Meridional wind

  real(DP):: xyz_TempAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T $ .     . Temperature
  real(DP):: xy_PsAns (0:imax-1, 0:jmax-1)
                              ! $ P_s $ .   ɽ̵. Surface pressure
  real(DP):: xyz_QVapAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q $ .     漾. Specific humidity
  real(DP):: xyz_DUDtAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \DP{U}{t} $ . 
                              ! ®Ѳ. 
                              ! Zonal wind tendency
  real(DP):: xyz_DVDtAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \DP{V}{t} $ . 
                              ! ®Ѳ. 
                              ! Meridional wind tendency
  real(DP):: xyz_DTempDtAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \DP{T}{t} $ . 
                              ! Ѳ. 
                              ! Temperature tendency
  real(DP):: xyz_DQVapDtAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ \DP{q}{t} $ . 
                              ! 漾Ѳ. 
                              ! Temperature tendency


  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYAPE):: phy_ape00, phy_ape01, phy_ape02, phy_ape03
  logical:: err
  type(GT_HISTORY):: gthist
  character(*), parameter:: subname = 'dyn_spectral_as83_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line options handling
  !---------------------------------------------------------
  call cmdline_optparse ! ֥롼. This is internal subroutine

  !---------------------------------------------------------
  !  ʪ
  !  Configure a physical constant
  !---------------------------------------------------------
  call Create( constant = const_earth )               ! (inout)
  call Get( constant = const_earth, &                 ! (inout)
    & PI = PI, &                                      ! (out)
    & RAir = RAir, Grav = Grav, Cp = Cp, &            ! (out)
    & EL = EL, RVap = RVap, EpsV = EpsV, ES0 = ES0, & ! (out)
    & StB = StB, FKarm = FKarm )                      ! (out)

  call DCDiffTimeCreate( &
    &  diff = delta_time, & ! (out)
    & value = 20.0_DP, &    ! (in)
    &  unit = 'min' )       ! (in)

  !---------------------------------------------------------
  !  ǡ
  !  Get axes data
  !---------------------------------------------------------
  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'lon', & ! (in)
    & array = x_Lon )                                ! (out)
  x_Lon = x_Lon * PI / 180.0_DP

  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'lon_weight', & ! (in)
    & array = x_Lon_Weight )                       ! (out)

  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'lat', & ! (in)
    & array = y_Lat )                                ! (out)
  y_Lat = y_Lat * PI / 180.0_DP

  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'lat_weight', & ! (in)
    & array = y_Lat_Weight )                       ! (out)

  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'sig', & ! (in)
    & array = z_Sigma )                     ! (out)

  call HistoryGet ( &
    & file = 'phy_ape_test01.nc', varname = 'sigm', & ! (in)
    & array = r_Sigma )                      ! (out)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call Create( phy_ape = phy_ape00, &                           ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, &                  ! (in)
    & x_Lon = x_Lon, y_Lat = y_Lat, &                           ! (in)
    & z_Sigma = z_Sigma, r_Sigma = r_Sigma, &                   ! (in)
    & PI = PI, &                                                ! (in)
    & RAir = RAir, Grav = Grav, Cp = Cp, &                      ! (in)
    & EL = EL, RVap = RVap, EpsV = EpsV, ES0 = ES0, &           ! (in)
    & StB = StB, FKarm = FKarm, &                               ! (in)
    & DelTime = EvalSec ( delta_time ), &                       ! (in)
    & x_Lon_Weight = x_Lon_Weight, &                            ! (in)
    & y_Lat_Weight = y_Lat_Weight, &                            ! (in)
    & current_time_value = 360.0_DP, current_time_unit = 'sec', & ! (in)
    & nmlfile = VAL_namelist )                                  ! (in)

  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = initialized(phy_ape00) )
  call PutLine( phy_ape = phy_ape00 ) ! (in)

  !---------------------------------------------------------
  !  PhysicsAPE ƥ
  !  PhysicsAPE test
  !---------------------------------------------------------
  call HistoryGet( &
    & file = 'phy_ape_test01.nc', & ! (in)
    & varname = 'U', &              ! (in)
    & array = xyz_U )               ! (out)

  call HistoryGet( &
    & file = 'phy_ape_test01.nc', & ! (in)
    & varname = 'V', &              ! (in)
    & array = xyz_V )               ! (out)

  call HistoryGet( &
    & file = 'phy_ape_test01.nc', & ! (in)
    & varname = 'Temp', &           ! (in)
    & array = xyz_Temp )            ! (out)

  call HistoryGet( &
    & file = 'phy_ape_test01.nc', & ! (in)
    & varname = 'QVap', &           ! (in)
    & array = xyz_QVap )            ! (out)

  call HistoryGet( &
    & file = 'phy_ape_test01.nc', & ! (in)
    & varname = 'Ps', &             ! (in)
    & array = xy_Ps )               ! (out)

  xyz_TempAns = xyz_Temp

!!$  call output_init
!!$  call output_addvar1
!!$  call output_addvar2

  call PhysicsAPE( phy_ape = phy_ape00, &   ! (inout)
    &       xyz_U = xyz_U,       xyz_V = xyz_V, & ! (in)
    &    xyz_Temp = xyz_Temp,    xy_Ps = xy_Ps, & ! (in)
    &    xyz_QVap = xyz_QVap, &                   ! (in)
    &    xyz_DUDt = xyz_DUDt, &                   ! (out)
    &    xyz_DVDt = xyz_DVDt, &                   ! (out)
    & xyz_DTempDt = xyz_DTempDt, &                ! (out)
    & xyz_DQVapDt = xyz_DQVapDt )                 ! (out)

  call HistoryGet( &
    & file = 'phy_ape_test02.nc', varname = 'DUDt', & ! (in)
    & array = xyz_DUDtAns )                           ! (out)
  call HistoryGet( &
    & file = 'phy_ape_test02.nc', varname = 'DVDt', & ! (in)
    & array = xyz_DVDtAns )                           ! (out)
  call HistoryGet( &
    & file = 'phy_ape_test02.nc', varname = 'DTempDt', & ! (in)
    & array = xyz_DTempDtAns )                           ! (out)
  call HistoryGet( &
    & file = 'phy_ape_test02.nc', varname = 'DQVapDt', & ! (in)
    & array = xyz_DQVapDtAns )                           ! (out)

  call AssertEqual( 'PhysicsAPE test 1', &
    & answer = xyz_DUDtAns, check = xyz_DUDt, &
    & significant_digits = 15, ignore_digits = -15 )
  call AssertEqual( 'PhysicsAPE test 2', &
    & answer = xyz_DVDtAns, check = xyz_DVDt, &
    & significant_digits = 15, ignore_digits = -15 )
  call AssertEqual( 'PhysicsAPE test 3', &
    & answer = xyz_DTempDtAns, check = xyz_DTempDt, &
    & significant_digits = 15, ignore_digits = -15 )
  call AssertEqual( 'PhysicsAPE test 4', &
    & answer = xyz_DQVapDtAns, check = xyz_DQVapDt, &
    & significant_digits = 15, ignore_digits = -15 )

  !---------------------------------------------------------
  !  PhysicsAdjust ƥ
  !  PhysicsAdjust test
  !---------------------------------------------------------
  call PhysicsAdjust( phy_ape = phy_ape00, & ! (inout)
    & xyz_Temp = xyz_Temp, xy_Ps = xy_Ps, &  ! (inout)
    & xyz_QVap = xyz_QVap )                  ! (inout)

  call HistoryGet( &
    & file = 'phy_ape_test03.nc', varname = 'Temp', & ! (in)
    & array = xyz_TempAns )                           ! (out)
  call HistoryGet( &
    & file = 'phy_ape_test03.nc', varname = 'QVap', & ! (in)
    & array = xyz_QVapAns )                           ! (out)
  call HistoryGet( &
    & file = 'phy_ape_test03.nc', varname = 'Ps', & ! (in)
    & array = xy_PsAns )                            ! (out)

  call AssertEqual( 'PhysicsAdjust test 1', &
    & answer = xyz_TempAns, check = xyz_Temp, &
    & significant_digits = 15, ignore_digits = -15 )
  call AssertEqual( 'PhysicsAdjust test 2', &
    & answer = xyz_QVapAns, check = xyz_QVap, &
    & significant_digits = 15, ignore_digits = -15 )
  call AssertEqual( 'PhysicsAdjust test 3', &
    & answer = xy_PsAns, check = xy_Ps, &
    & significant_digits = 15, ignore_digits = -15 )

!!$  call output_put1
!!$  call output_put2
!!$  call output_close

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call Close( phy_ape = phy_ape00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = initialized(phy_ape00) )
  call PutLine( phy_ape = phy_ape00 ) ! (in)

  call Close( phy_ape = phy_ape02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )


contains

  subroutine output_init
    call HistoryCreate( &
      & file = 'phy_ape_test02.nc', &                 ! (in)
!!$      & file = 'phy_ape_test03.nc', &                 ! (in)
      & title = 'aqua planet experiments module test', &         ! (in)
      & source = 'dcpam4 (see http://www.gfd-dennou.org) ' , &   ! (in)
      & institution = 'GFD Dennou Club', &                       ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'sigm', 'time'), &      ! (in)
      & dimsizes = (/imax, jmax, kmax, kmax + 1, 0/), &          ! (in)
      & longnames = StoA('longitude', 'latitude', &
      &                  'sigma at layer midpoints', &
      &                  'sigma at layer end-points (half level)', &
      &                  'time'), &                              ! (in)
      & units = StoA('degree_east', 'degree_north', &
      &              '1', '1', 'min'), &                         ! (in)
      & origin = 0.0 , &                                         ! (in)
      & interval = real( EvalMin( delta_time ) ) )               ! (in)

    call HistoryAddAttr( &
      & varname = 'lon', attrname = 'standard_name', & ! (in)
      & value = 'longitude' )                          ! (in)
    call HistoryAddAttr( &
      & varname = 'lat', attrname = 'standard_name', & ! (in)
      & value = 'latitude' )                           ! (in)
    call HistoryAddAttr( &
      & varname = 'sig', attrname = 'standard_name', &   ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & varname = 'time', attrname = 'standard_name', & ! (in)
      & value = 'time' )                                ! (in)
    call HistoryAddAttr( &
      & varname = 'sig', attrname = 'positive', &   ! (in)
      & value = 'down' )                            ! (in)
    call HistoryAddAttr( &
      & varname = 'sigm', attrname = 'positive', &  ! (in)
      & value = 'down' )                            ! (in)

    call HistoryPut( &
      & varname = 'lon', &              ! (in)
      & array = x_Lon / PI * 180.0_DP ) ! (in)
    call HistoryPut( &
      & varname = 'lat', &              ! (in)
      & array = y_Lat / PI * 180.0_DP ) ! (in)
    call HistoryPut( &
      & varname = 'sig', array = z_Sigma ) ! (in)
    call HistoryPut( &
      & varname = 'sigm', array = r_Sigma ) ! (in)

  end subroutine output_init

  subroutine output_addvar1
    call HistoryAddVariable( &
      & varname = 'DUDt', &                           ! (in)
      & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
      & longname = 'eastward wind tendency', &        ! (in)
      & units = 'm s-1', xtype = 'double' )           ! (in)

    call HistoryAddVariable( &
      & varname = 'DVDt', &                           ! (in)
      & dims = StoA('lon', 'lat', 'sig'), &           ! (in)
      & longname = 'northward wind tendency', &       ! (in)
      & units = 'm s-1', xtype = 'double' )           ! (in)

    call HistoryAddVariable( &
      & varname = 'DTempDt', &                ! (in)
      & dims = StoA('lon', 'lat', 'sig' ), &  ! (in)
      & longname = 'temperature tendency', &  ! (in)
      & units = 'K s-1', xtype = 'double' )   ! (in)

    call HistoryAddVariable( &
      & varname = 'DQVapDt', &                     ! (in)
      & dims = StoA('lon', 'lat', 'sig' ), &       ! (in)
      & longname = 'specific humidity tendency', & ! (in)
      & units = 's-1', xtype = 'double' )          ! (in)

  end subroutine output_addvar1

  subroutine output_addvar2
    call HistoryAddVariable( &
      & varname = 'Temp', &                           ! (in)
      & dims = StoA('lon', 'lat', 'sig' ), &          ! (in)
      & longname = 'temperature', &                   ! (in)
      & units = 'K', xtype = 'double' )               ! (in)
    call HistoryAddAttr( &
      & varname = 'Temp', attrname = 'standard_name', & ! (in)
      & value = 'air_temperature' )                     ! (in)

    call HistoryAddVariable( &
      & varname = 'QVap', &                           ! (in)
      & dims = StoA('lon', 'lat', 'sig' ), &          ! (in)
      & longname = 'specific humidity', &             ! (in)
      & units = '1', xtype = 'double' )               ! (in)
    call HistoryAddAttr( &
      & varname = 'QVap', attrname = 'standard_name', & ! (in)
      & value = 'specific_humidity' )                   ! (in)

    call HistoryAddVariable( &
      & varname = 'Ps', &                 ! (in)
      & dims = StoA('lon', 'lat'), &      ! (in)
      & longname = 'surface pressure', &  ! (in)
      & units = 'Pa', xtype = 'double' )  ! (in)
    call HistoryAddAttr( &
      & varname = 'Ps', attrname = 'standard_name', & ! (in)
      & value = 'surface_air_pressure' )              ! (in)
  end subroutine output_addvar2

  subroutine output_put1
    call HistoryPut( &
      & varname = 'DUDt', array = xyz_DUDt ) ! (in)
    call HistoryPut( &
      & varname = 'DVDt', array = xyz_DVDt ) ! (in)
    call HistoryPut( &
      & varname = 'DTempDt', array = xyz_DTempDt ) ! (in)
    call HistoryPut( &
      & varname = 'DQVapDt', array = xyz_DQVapDt ) ! (in)
  end subroutine output_put1

  subroutine output_put2
    call HistoryPut( &
      & varname = 'Temp', array = xyz_Temp ) ! (in)
    call HistoryPut( &
      & varname = 'Ps', array = xy_Ps ) ! (in)
    call HistoryPut( &
      & varname = 'QVap', array = xyz_QVap ) ! (in)
  end subroutine output_put2

  subroutine output_close
     call HistoryClose
  end subroutine output_close


  subroutine cmdline_optparse
    !
    ! ޥɥ饤νԤޤ
    !
    ! Handle command line options
    !
    call DCArgsOpen( arg = arg )               ! (out)

    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Title', msg = title )      ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Usage', &                  ! (in)
      & msg = './' // trim(subname) // &
      &       ' [Options]' )                   ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Source', msg = source )    ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Institution', &            ! (in)
      & msg = institution )                    ! (in)

    call DCArgsOption( arg = arg, &           ! (inout)
      & options = StoA('-N', '--namelist'), & ! (in)
      & flag = OPT_namelist, &                ! (out)
      & value = VAL_namelist, &               ! (out)
      & help = "Namelist filename")           ! (in)

    call DCArgsDebug( arg = arg )  ! (inout)
    call DCArgsHelp( arg = arg )   ! (inout)
    call DCArgsStrict( arg = arg ) ! (inout)

    call DCArgsClose( arg = arg )  ! (inout)
  end subroutine cmdline_optparse

end program phy_ape_test
