#= Rules for GNU make
#
# Authors::   Yasuhiro MORIKAWA
# Version::   $Id: rules.make,v 1.9 2008-01-30 11:16:22 morikawa Exp $
# Tag Name::  $Name: dcpam4-20080427 $
# Copyright:: Copyright (C) GFD Dennou Club, 2006-. All rights reserved.
# License::   See COPYRIGHT[link:COPYRIGHT]
#
#== Overview
#
# This file provides general rules for Makefiles.
# To use, "include" this file.
#
# [JAPANESE]
# Υեˤ Makefile ƤӽФ붦̥롼뤬
# ҤƤޤ. ΥեѤˤ,  Makefile 
# Υե include Ƥ.
#
############################################################

%.o: %.f90
	$(FC) -o $@ -c $(FFLAGS) -I$(MODDIR) $(SYSFFLAGS) $<
	@if [ -f $(MODFILE) ]; then \
	    test -d $(MODDIR) || $(INSTALLDIR) $(MODDIR) ;\
	    $(CP) $(MODFILE) $(MODDIR) ;\
	    if [ ! `dirname $@` = "." ]; then \
		$(MV) $(MODFILE) `dirname $@` ;\
	    fi ;\
	fi

%: %.o
	$(LINKF) -o $@ $+ $(SYSLDFLAGS) $(SYSLDLIBS)

$(LIBDIR)/$(DCPAMLIB): $(OBJS)
	test -d $(LIBDIR) || $(INSTALLDIR) $(LIBDIR)
	test -z "$+" || $(AR) $(ARFLAGS) $@ $+
	test -f $@ && $(RANLIB) $@ || true
	test -d $(MODDIR) || $(INSTALLDIR) $(MODDIR)
	test -z "`ls $(CLEAN_MODS)`" || $(INSTALL) $(CLEAN_MODS) $(MODDIR)

test:
	@for i in $(TESTS) ; do \
	  $(SH) ./$$i || \
	    eval " echo ; echo \"  *** Error is occured in $$i ***\" ; echo  ; exit 1" ; \
	done

clean:
	-$(RM) $(CLEAN_MODS) $(OBJS) $(CLEAN_TESTS) $(TARGETS) $(TMPFILES) *~
	-$(RM) $(OBJS:%.o=$(MODDIR)/%$(MODSUFFIX))
	-$(RMDIR) $(MODDIR)

clean.lib:
	-$(RM) $(LIBDIR)/$(DCPAMLIB)
	-$(RM) $(MODDIR)/$(CLEAN_MODS)

clean.bin:
	-cd $(BINDIR) ; $(RM) $(TARGETS)

clean.rb2f90:
	-$(RM) $(RB2F90)

depend: $(F90DEPEND) Makefile
	$(RUBY) $(RUBYVERCHECK) > /dev/null 2>&1 && \
	    $(RUBY) $< $(F90DEPENDOPTS) *.f90 ../*/*.f90 > $@ || \
	    touch $@

template:
	$(RUBY) $(RUBYVERCHECK) > /dev/null 2>&1 && \
	    $(RUBY) $(F90TEMPLATE) -E module


######################################################################
#== Mode setting for Emacs
#Local Variables:
#mode: makefile
#End:
#
