module fft_rotate

  use ffts

contains

subroutine fft_rotate_allocate()
!-- allocating rotate array
  use fft_saveval_define
  implicit none

  allocate(omegaxjbr(0:jxnt-1,0:jxnt-1))
  allocate(omegaxjnr(0:jxnt-1,0:jxnt-1))
  allocate(omegaxjbi(0:jxnt-1,0:jxnt-1))
  allocate(omegaxjni(0:jxnt-1,0:jxnt-1))
  allocate(omegayjbr(0:jynt-1,0:jynt-1))
  allocate(omegayjnr(0:jynt-1,0:jynt-1))
  allocate(omegayjbi(0:jynt-1,0:jynt-1))
  allocate(omegayjni(0:jynt-1,0:jynt-1))
  allocate(omegax1br(0:nx-1,0:nx-1))
  allocate(omegax1nr(0:nx-1,0:nx-1))
  allocate(omegax1bi(0:nx-1,0:nx-1))
  allocate(omegax1ni(0:nx-1,0:nx-1))
  allocate(omegay1br(0:ny-1,0:ny-1))
  allocate(omegay1nr(0:ny-1,0:ny-1))
  allocate(omegay1bi(0:ny-1,0:ny-1))
  allocate(omegay1ni(0:ny-1,0:ny-1))

  omegaxjbr=0.0d0
  omegaxjnr=0.0d0
  omegaxjbi=0.0d0
  omegaxjni=0.0d0
  omegayjbr=0.0d0
  omegayjnr=0.0d0
  omegayjbi=0.0d0
  omegayjni=0.0d0
  omegax1br=0.0d0
  omegax1nr=0.0d0
  omegax1bi=0.0d0
  omegax1ni=0.0d0
  omegay1br=0.0d0
  omegay1nr=0.0d0
  omegay1bi=0.0d0
  omegay1ni=0.0d0

end subroutine fft_rotate_allocate


subroutine fft_rotate_calc()
!-- calculating rotate array
  use fft_saveval_define
  implicit none

  call rotate_calc_d( jxnt, 'r', pxfact,  &
  &                 omegaxjbr(0:pxfact(5)-1,0:pxfact(5)-1),  &
  &                 omegaxjnr(0:jxnt-1,0:jxnt-1) )
  call rotate_calc_d( jxnt, 'i', pxfact,  &
  &                 omegaxjbi(0:pxfact(5)-1,0:pxfact(5)-1),  &
  &                 omegaxjni(0:jxnt-1,0:jxnt-1) )
  call rotate_calc_d( jynt, 'r', pyfact,  &
  &                 omegayjbr(0:pyfact(5)-1,0:pyfact(5)-1),  &
  &                 omegayjnr(0:jynt-1,0:jynt-1) )
  call rotate_calc_d( jynt, 'i', pyfact,  &
  &                 omegayjbi(0:pyfact(5)-1,0:pyfact(5)-1),  &
  &                 omegayjni(0:jynt-1,0:jynt-1) )
  call rotate_calc_d( nx, 'r', p1xfact,  &
  &                 omegax1br(0:p1xfact(5)-1,0:p1xfact(5)-1),  &
  &                 omegax1nr(0:nx-1,0:nx-1) )
  call rotate_calc_d( nx, 'i', p1xfact,  &
  &                 omegax1bi(0:p1xfact(5)-1,0:p1xfact(5)-1),  &
  &                 omegax1ni(0:nx-1,0:nx-1) )
  call rotate_calc_d( ny, 'r', p1yfact,  &
  &                 omegay1br(0:p1yfact(5)-1,0:p1yfact(5)-1),  &
  &                 omegay1nr(0:ny-1,0:ny-1) )
  call rotate_calc_d( ny, 'i', p1yfact,  &
  &                 omegay1bi(0:p1yfact(5)-1,0:p1yfact(5)-1),  &
  &                 omegay1ni(0:ny-1,0:ny-1) )

end subroutine fft_rotate_calc


end module fft_rotate
