program sound_stat
! 大量のサウンディングデータから統計処理をするプログラム.
  use basis
  use file_operate
  use statistics
  use max_min

  implicit none

  integer, parameter :: ncmax=100
  integer, parameter :: nqmax=100
  integer, parameter :: axmax=1000
  ! namelist variables
  integer :: nc, calnum, axord, lskip, naxv, nq
  integer, dimension(ncmax) :: calord
  real :: undef
  real, dimension(nqmax) :: qval
  real, dimension(axmax) :: axv
  character(1000) :: list, cundef
  character(1000), dimension(ncmax) :: ofile
  logical :: revflag

  ! internal variables
  integer :: i, j, k, l, m, nl, nll, itmpz, itmp
  real :: tmpz1, tmpz2
  real, allocatable, dimension(:) :: maxv, minv, midv, avev, axerev
  real, allocatable, dimension(:,:) :: rval, qv
  real, allocatable, dimension(:,:,:) :: statv
  character(100) :: forma
  character(1000), allocatable, dimension(:) :: flist
  character(100), allocatable, dimension(:,:) :: cval

  namelist /input /list, cundef, nc, calnum, calord, ofile, lskip, undef, nq, qval
  namelist /axinfo /naxv, axord, axv, revflag
  read(5,nml=input)
  read(5,nml=axinfo)

  allocate(maxv(naxv))
  allocate(minv(naxv))
  allocate(avev(naxv))
  allocate(midv(naxv))
  allocate(qv(naxv,nq))

  nl=line_number_counter( trim(adjustl(list)) )
  allocate(flist(nl))
  allocate(statv(nl,calnum,naxv))

  call read_file_text( trim(adjustl(list)), 1, nl, flist )

  do i=1,nl
     nll=line_number_counter( trim(adjustl(flist(i))) )-lskip
     allocate(cval(nc,nll))
     allocate(rval(nc,nll))
     allocate(axerev(nll))
     call read_file_text( trim(adjustl(flist(i))), nc, nll, cval, skip=lskip )
     call c2r_convert_array( cval, rval, cundef, undef )
     if(revflag.eqv..true.)then
        call array_rev( rval(axord,1:nll), axerev(1:nll) )
        rval(axord,1:nll)=axerev(1:nll)
     end if
     do j=1,calnum
        if(revflag.eqv..true.)then
           call array_rev( rval(j,1:nll), axerev(1:nll) )
           rval(j,1:nll)=axerev(1:nll)
        end if
        do k=1,naxv
           statv(i,j,k)=undef
           call interpo_search_1d( rval(axord,1:nll), axv(k), itmpz )
           if(itmpz>0.and.itmpz<nll)then
              if(rval(calord(j),itmpz)/=undef.and.  &
  &              rval(calord(j),itmpz+1)/=undef)then
                 tmpz1=rval(axord,itmpz)
                 tmpz2=rval(axord,itmpz+1)
                 call interpolation_1d( (/tmpz1,tmpz2/),  &
  &                                     rval(calord(j),itmpz:itmpz+1),  &
  &                                     axv(k), statv(i,j,k) )
              end if
           end if
        end do
     end do
     deallocate(cval)
     deallocate(rval)
     deallocate(axerev)
  end do

  forma='(1P'//trim(adjustl(i2c_convert(5+nq)))//'E16.8)'

  do j=1,calnum
     open(unit=100+j,file=trim(adjustl(ofile(j))),status='unknown')
     do k=1,naxv
        call max_val_1d( statv(1:nl,j,k), itmp, maxv(k), undef=undef )
        call min_val_1d( statv(1:nl,j,k), itmp, minv(k), undef=undef )
        call Mean_1d( statv(1:nl,j,k), avev(k), error=undef )
        call Median_1d( statv(1:nl,j,k), midv(k), error=undef )
        do l=1,nq
           call Quantile_1d( qval(l), statv(1:nl,j,k), qv(k,l), error=undef )
        end do
        write(100+j,trim(adjustl(forma))) axv(k), maxv(k), minv(k),  &
  &                                       avev(k), midv(k), qv(k,1:nq)
     end do
     close(unit=100+j)
  end do

contains

subroutine c2r_convert_array( cival, roval, charundef, rundef )

  implicit none

  character(*), intent(in) :: cival(:,:)
  real, intent(inout) :: roval(size(cival,1),size(cival,2))
  character(*), intent(in) :: charundef
  real, intent(in) :: rundef
  integer :: ii, jj, ix, jy

  ix=size(cival,1)
  jy=size(cival,2)
  roval=rundef

  do jj=1,jy
     do ii=1,ix
        if(trim(adjustl(cival(ii,jj)))/=trim(adjustl(charundef)))then
           roval(ii,jj)=c2r_convert( trim(adjustl(cival(ii,jj))) )
        end if
     end do
  end do

end subroutine c2r_convert_array

subroutine array_rev( ival, oval )

  implicit none

  real, intent(in) :: ival(:)
  real, intent(inout) :: oval(size(ival))
  integer :: ii, ix

  ix=size(ival)

  do ii=1,ix
     oval(ix-ii+1)=ival(ii)
  end do

end subroutine array_rev

end program sound_stat
