module val_init
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new

  use val_define
  use read_namelist

  implicit none

contains

subroutine val_initialize()

  use val_define

  implicit none

  r_i=0.0      ! 動径座標
  z_i=0.0      ! 鉛直座標
  sst_i=0.0    ! sst 初期データ
  r_u=0.0      ! 動径座標
  r_s=0.0      ! 動径座標
  z_w=0.0      ! 鉛直座標
  z_s=0.0      ! 鉛直座標
  sst_u=0.0    ! sst u
  sst_s=0.0    ! sst s
  pts=0.0      ! 海面温位
  qvs=0.0      ! 海面水蒸気混合比
  ps=0.0       ! 海面気圧
  us_dmp=0.0   ! surface 動径風速 dmp
  vs_dmp=0.0   ! surface 接線風速 dmp
  ws_dmp=0.0   ! surface 鉛直風速 dmp
  ps_dmp=0.0   ! surface 規格化圧力 dmp
  ts_dmp=0.0   ! surface 温位 dmp
  qvs_dmp=0.0  ! surface 水蒸気 dmp
  qts_dmp=0.0  ! surface 凝結水 dmp
  Tsurf=0.0    ! surface temp.

!-- 2d val (prognostic value)
  u_dmp=0.0   ! 動径風速 dmp
  v_dmp=0.0   ! 接線風速 dmp
  w_dmp=0.0   ! 鉛直風速 dmp
  p_dmp=0.0   ! 規格化圧力 dmp
  t_dmp=0.0   ! 温位 dmp
  qv_dmp=0.0  ! 水蒸気 dmp
  qc_dmp=0.0  ! 凝結水 dmp
  ql_dmp=0.0  ! 凝結水 dmp
  u_old=0.0   ! 動径風速 old
  v_old=0.0   ! 接線風速 old
  w_old=0.0   ! 鉛直風速 old
  p_old=0.0   ! 規格化圧力 old
  t_old=0.0   ! 温位 old
  qv_old=0.0  ! 水蒸気 old
  qc_old=0.0  ! 凝結水 old
  ql_old=0.0  ! 凝結水 old
  u_new=0.0   ! 動径風速 new
  v_new=0.0   ! 接線風速 new
  w_new=0.0   ! 鉛直風速 new
  p_new=0.0   ! 規格化圧力 new
  t_new=0.0   ! 温位 new
  qv_new=0.0  ! 水蒸気 new
  qc_new=0.0  ! 凝結水 new
  ql_new=0.0  ! 凝結水 new
  u_tmp=0.0   ! 動径風速 tmp
  v_tmp=0.0   ! 接線風速 tmp
  w_tmp=0.0   ! 鉛直風速 tmp
  p_tmp=0.0   ! 規格化圧力 tmp
  t_tmp=0.0   ! 温位 tmp
  qv_tmp=0.0  ! 水蒸気 tmp
  qc_tmp=0.0  ! 凝結水 tmp
  ql_tmp=0.0  ! 凝結水 tmp

!-- 2d val (working value)
  u_u=0.0   ! 動径風速 u
  v_u=0.0   ! 接線風速 u
  w_u=0.0   ! 鉛直風速 u
  p_u=0.0   ! 規格化圧力 u
  t_u=0.0   ! 温位 u
  qv_u=0.0  ! 水蒸気 u
  qc_u=0.0  ! 凝結水 u
  ql_u=0.0  ! 凝結水 u
  u_s=0.0   ! 動径風速 s
  v_s=0.0   ! 接線風速 s
  w_s=0.0   ! 鉛直風速 s
  p_s=0.0   ! 規格化圧力 s
  t_s=0.0   ! 温位 s
  qv_s=0.0  ! 水蒸気 s
  qc_s=0.0  ! 凝結水 s
  ql_s=0.0  ! 凝結水 s
  u_w=0.0   ! 動径風速 w
  v_w=0.0   ! 接線風速 w
  w_w=0.0   ! 鉛直風速 w
  p_w=0.0   ! 規格化圧力 w
  t_w=0.0   ! 温位 w
  qv_w=0.0  ! 水蒸気 w
  qc_w=0.0  ! 凝結水 w
  ql_w=0.0  ! 凝結水 w
  u_c=0.0   ! 動径風速 c
  v_c=0.0   ! 接線風速 c
  w_c=0.0   ! 鉛直風速 c
  p_c=0.0   ! 規格化圧力 c
  t_c=0.0   ! 温位 c
  qv_c=0.0  ! 水蒸気 c
  qc_c=0.0  ! 凝結水 c
  ql_c=0.0  ! 凝結水 c

!-- 2d val (diagnostic value)
  ub_u=0.0     ! 動径初期風速 u
  vb_s=0.0     ! 接線初期風速 s
  wb_w=0.0     ! 鉛直初期風速 w
  pb_s=0.0     ! 圧力初期 s
  ptb_u=0.0    ! 温位初期 u
  ptb_s=0.0    ! 温位初期 s
  ptb_w=0.0    ! 温位初期 w
  pti_u=0.0    ! 温位初期 u for BUOY
  pti_s=0.0    ! 温位初期 s for BUOY
  pti_w=0.0    ! 温位初期 w for BUOY
  qvb_u=0.0    ! 水蒸気混合比初期 u
  qvb_s=0.0    ! 水蒸気混合比初期 s
  qvb_w=0.0    ! 水蒸気混合比初期 w
  qtb_s=0.0    ! 凝結水混合比初期 s
  ptv_u=0.0    ! 仮温位 u
  ptv_s=0.0    ! 仮温位 s
  ptv_w=0.0    ! 仮温位 w
  ptv_c=0.0    ! 仮温位 c
  ptvb_s=0.0   ! 仮温位 s
  ptvb_u=0.0   ! 仮温位 u
  ptvb_w=0.0   ! 仮温位 w
  pte_u=0.0    ! 相当温位 u
  pte_s=0.0    ! 相当温位 s
  pte_w=0.0    ! 相当温位 w
  pte_c=0.0    ! 相当温位 c
  rhob_u=0.0   ! 密度 u
  rhob_s=0.0   ! 密度 s
  rhob_w=0.0   ! 密度 w
  temp_u=0.0   ! 温度 u
  temp_s=0.0   ! 温度 s
  temp_w=0.0   ! 温度 w
  temp_c=0.0   ! 温度 c
  tempb_s=0.0  ! 温度
  tempb_w=0.0  ! 温度
  u_i=0.0        ! 動径初期速度初期データ
  v_i=0.0        ! 接線初期速度初期データ
  w_i=0.0        ! 鉛直初期速度初期データ
  p_i=0.0        ! 圧力初期データ
  t_i=0.0        ! 温位初期データ
  qv_i=0.0       ! 水蒸気初期データ
  qc_i=0.0       ! 凝結物初期データ
  ql_i=0.0       ! 凝結物初期データ

!-- 2d val (force term)
  force_u=0.0   ! u forcing term
  force_v=0.0   ! v forcing term
  force_w=0.0   ! w forcing term
  force_p=0.0   ! p forcing term
  force_t=0.0   ! t forcing term
  force_qv=0.0  ! qv forcing term
  force_qc=0.0  ! qt forcing term
  force_ql=0.0  ! qt forcing term
  forcea_u=0.0  ! u forcing term
  forcea_v=0.0  ! v forcing term
  forcea_w=0.0  ! w forcing term
  forcea_p=0.0  ! p forcing term
  forcea_t=0.0  ! t forcing term
  forcea_qv=0.0 ! qv forcing term
  forcea_qc=0.0 ! qt forcing term
  forcea_ql=0.0 ! qt forcing term
  ADV_u=0.0     ! ADV u
  ADV_v=0.0     ! ADV v
  ADV_w=0.0     ! ADV w
  ADV_t=0.0     ! ADV t
  ADV_qv=0.0    ! ADV qv
  ADV_qc=0.0    ! ADV qt
  ADV_ql=0.0    ! ADV qt
  DIFF_u=0.0    ! DIFF u
  DIFF_v=0.0    ! DIFF v
  DIFF_w=0.0    ! DIFF w
  DIFF_t=0.0    ! DIFF t
  DIFF_qv=0.0   ! DIFF qv
  DIFF_qc=0.0   ! DIFF qt
  DIFF_ql=0.0   ! DIFF qt
  NUMD_u=0.0    ! NUMDIFF u
  NUMD_v=0.0    ! NUMDIFF v
  NUMD_w=0.0    ! NUMDIFF w
  NUMD_t=0.0    ! NUMDIFF t
  NUMD_qv=0.0   ! NUMDIFF qv
  NUMD_qc=0.0   ! NUMDIFF qt
  NUMD_ql=0.0   ! NUMDIFF qt
  GRADP_u=0.0   ! GRADP u
  GRADP_w=0.0   ! GRADP w
  FLUX_s=0.0    ! FLUX s
  SPG_u=0.0     ! sponge u
  SPG_v=0.0     ! sponge v
  SPG_w=0.0     ! sponge w
  SPG_t=0.0     ! sponge t
  SPG_qv=0.0    ! sponge qv
  SPG_qc=0.0    ! sponge qt
  SPG_ql=0.0    ! sponge qt
  RAD_t=0.0     ! radiation t
  BUOY_w=0.0    ! Buoyancy w
  CLOUD_pt=0.0  ! Cloud physics pt
  CLOUD_qv=0.0  ! Cloud physics qv
  CLOUD_qc=0.0  ! Cloud physics qc
  CLOUD_ql=0.0  ! Cloud physics ql
  CC_u=0.0      ! Cori + Centri u
  CC_v=0.0      ! Cori + Centri v

end subroutine

end module
