program spline
! ASCII Υǡɤ߹, ֳ֤κɸǤͤ򥹥ץ饤֤ˤä
! ޤץ.

  use Basis
  use file_operate
  use statistics

  implicit none

  integer :: i, nxi, nxo
  real :: dx
  real, allocatable, dimension(:) :: xi, yi, xo, yo
  character(100), allocatable, dimension(:,:) :: cval
  character(1000) :: fname, oname

  write(*,*) "Input file name (input and output)."
  read(*,*) fname, oname
  write(*,*) "Input grid number."
  read(*,*) nxo

  nxi=line_number_counter( trim(adjustl(fname)) )
  allocate(cval(2,nxi))
  call read_file_text( trim(adjustl(fname)), 2, nxi, cval )

  allocate(xi(nxi))
  allocate(yi(nxi))
  allocate(xo(nxo))
  allocate(yo(nxo))

  do i=1,nxi
     xi(i)=c2r_convert( trim(adjustl(cval(1,i))) )
     yi(i)=c2r_convert( trim(adjustl(cval(2,i))) )
  end do

  dx=(xi(nxi)-xi(1))/real(nxo-1)
  xo=(/((xi(1)+dx*real(i-1)),i=1,nxo)/)

  call spline_3( xi, xo, yi, yo )

  open(unit=10,file=trim(adjustl(oname)),status='unknown')

  write(10,'(a32)') 'X-coordinate,   Y-coordinate    '
  write(10,'(a32)') 'X-coordinate,   Y-coordinate    '

  do i=1,nxo
     write(10,'(1P2E16.8)') xo(i), yo(i)
  end do

  close(unit=10)

end program
