module sub_calc
! ֽ롼

  use Derivation

contains

subroutine calc_wind( x, y, psi, u, v, undef )
! x, y ήؿʿ®׻롼

  implicit none

  real, intent(in) :: x(:)  ! x κɸ [m]
  real, intent(in) :: y(:)  ! y κɸ [m]
  real, intent(in) :: psi(size(x),size(y))  ! ήؿ [m2/s]
  real, intent(inout) :: u(size(x),size(y))  ! x ® [m/s]
  real, intent(inout) :: v(size(x),size(y))  ! y ® [m/s]
  real, intent(in), optional :: undef  ! ̤

  integer :: i, j, k, nx, ny

  nx=size(x)
  ny=size(y)

  do j=1,ny
     call grad_1d( x, psi(:,j), v(:,j), undef=undef )
  end do

  do i=1,nx
     call grad_1d( y, psi(i,:), u(i,:), undef=undef )
  end do

  do j=1,ny
     do i=1,nx
        if(psi(i,j)/=undef)then
           v(i,j)=-v(i,j)
        else
           v(i,j)=undef
        end if
     end do
  end do

end subroutine

subroutine bound_set( x, y, val, ib, bnd, undef )
! ꤹ.
  implicit none
  real, intent(in) :: x(:)  ! x ɸ [m]
  real, intent(in) :: y(:)  ! y ɸ [m]
  real, intent(inout) :: val(size(x),size(y))  ! ꤹѿ
  integer, intent(in) :: ib(size(x),size(y))  ! ޤ
  real, intent(in) :: bnd(size(x),size(y))  ! 
  real, intent(in) :: undef  ! ׻ΰǤ̤.

  integer :: i, j, nx, ny
  real, allocatable, dimension(:) :: dx, dy

  nx=size(x)
  ny=size(y)

  allocate(dx(nx))
  allocate(dy(ny))

  do i=2,nx-1
     dx(i)=0.5*(x(i+1)-x(i-1))
  end do

  do j=2,ny-1
     dy(j)=0.5*(y(j+1)-y(j-1))
  end do

  do j=1,ny
     do i=1,nx
        select case (ib(i,j))
        case(1)
           val(i,j)=bnd(i,j)
        case(2)
           val(i,j)=val(i+1,j)-bnd(i,j)*dx(i)
        case(-2)
           val(i,j)=val(i-1,j)+bnd(i,j)*dx(i)
        case(4)
           val(i,j)=val(i,j+1)-bnd(i,j)*dy(j)
        case(-4)
           val(i,j)=val(i,j-1)+bnd(i,j)*dy(j)
        case (8)  ! ξեåǺѤ
           if(i==1.and.j==1)then  ! -- ɾ 1
              val(i,j)=val(i+1,j+1)-0.5*(bnd(i+1,j)*dy(j)+bnd(i,j+1)*dx(i))

           else if(i==nx.and.j==ny)then  ! -- ɾ 2
              val(i,j)=val(i-1,j-1)+0.5*(bnd(i-1,j)*dy(j)+bnd(i,j-1)*dx(i))

           else if(ib(i-1,j)==10.or.ib(i,j-1)==10)then
              ! -- ɾ 1 Ʊ
              val(i,j)=val(i+1,j+1)-0.5*(bnd(i+1,j)*dy(j)+bnd(i,j+1)*dx(i))

           else if(ib(i+1,j)==10.or.ib(i,j+1)==10)then
              ! -- ɾ 2 Ʊ
              val(i,j)=val(i-1,j-1)+0.5*(bnd(i-1,j)*dy(j)+bnd(i,j-1)*dx(i))

           end if

        case (-8)  ! ξեåǱѤ
           if(i==1.and.j==ny)then  ! -- ɾ 1
              val(i,j)=val(i+1,j+1)+0.5*(bnd(i+1,j)*dy(j)-bnd(i,j-1)*dx(i))

           else if(i==nx.and.j==1)then  ! -- ɾ 2
              val(i,j)=val(i-1,j-1)+0.5*(-bnd(i-1,j)*dy(j)+bnd(i,j+1)*dx(i))

           else if(ib(i-1,j)==10.or.ib(i,j+1)==10)then
              ! -- ɾ 1 Ʊ
              val(i,j)=val(i+1,j+1)+0.5*(bnd(i+1,j)*dy(j)-bnd(i,j-1)*dx(i))

           else if(ib(i+1,j)==10.or.ib(i,j-1)==10)then
              ! -- ɾ 2 Ʊ
              val(i,j)=val(i-1,j-1)+0.5*(-bnd(i-1,j)*dy(j)+bnd(i,j+1)*dx(i))

           end if
        end select
     end do
  end do

end subroutine

subroutine set_omega_inner( x, y, psi, inner_bound, omega )
! psi ͤȤ, omega ͤꤹ.
  implicit none
  real, intent(in) :: x(:)  ! x ɸ [m]
  real, intent(in) :: y(:)  ! y ɸ [m]
  real, intent(in) :: psi(size(x),size(y))  ! ˤĤƤλѿ
  integer, intent(in) :: inner_bound(size(x),size(y))  ! ޤ
  real, intent(inout) :: omega(size(x),size(y))  ! ꤹ붭ͤ

  integer :: i, j, nx, ny
  real, allocatable, dimension(:) :: dx, dy

  nx=size(x)
  ny=size(y)

  allocate(dx(nx))
  allocate(dy(ny))

  do i=2,nx-1
     dx(i)=0.5*(x(i+1)-x(i-1))
  end do

  do j=2,ny-1
     dy(j)=0.5*(y(j+1)-y(j-1))
  end do

!-- ˡ
!--  (+),  (-) : ɤǤ®٤.
!-- omega_ = -du/dy = -(u_{j+1}/dy), -(-u_{j-1}/dy)
!-- u_{j+1} = dp/dy = (psi_{j+2}-psi_)/(2dy)
!-- u_{j-1} = dp/dy = (psi_-psi_{j-2})/(2dy)
!-- ޤȤ, omega_ = -(psi_{j+-2}-psi_)/(2dy^2)
!--  (+),  (-) : ɤǤ®٤.
!-- omega_ = dv/dx = (v_{i+1}/dx), (-v_{i-1}/dx)
!-- v_{i+1} = -dp/dx = -(psi_{i+2}-psi_)/(2dx)
!-- v_{i-1} = -dp/dx = -(psi_-psi_{i-2})/(2dx)
!-- ޤȤ, omega_ = -(psi_{i+-2}-psi_)/(2dx^2)

  do j=2,ny-1
     do i=2,nx-1
        if(inner_bound(i,j)==1)then
           if(inner_bound(i-1,j)==10)then
              omega(i,j)=0.5*(psi(i,j)-psi(i+2,j))/(dx(i)*dx(i))
           else if(inner_bound(i+1,j)==10)then
              omega(i,j)=0.5*(psi(i,j)-psi(i-2,j))/(dx(i)*dx(i))
           else if(inner_bound(i,j-1)==10)then
              omega(i,j)=0.5*(psi(i,j)-psi(i,j+2))/(dy(j)*dy(j))
           else if(inner_bound(i,j+1)==10)then
              omega(i,j)=0.5*(psi(i,j)-psi(i,j-2))/(dy(j)*dy(j))
           else if(inner_bound(i,j-1)==1.and.inner_bound(i+1,j)==1)then  ! 
              omega(i,j)=0.25*((psi(i,j)-psi(i,j+2))/(dy(j)*dy(j))  &
  &                           +(psi(i,j)-psi(i-2,j))/(dx(i)*dx(i)))
           else if(inner_bound(i,j-1)==1.and.inner_bound(i-1,j)==1)then  ! 
              omega(i,j)=0.25*((psi(i,j)-psi(i,j+2))/(dy(j)*dy(j))  &
  &                           +(psi(i,j)-psi(i+2,j))/(dx(i)*dx(i)))
           else if(inner_bound(i,j+1)==1.and.inner_bound(i+1,j)==1)then  ! 
              omega(i,j)=0.25*((psi(i,j)-psi(i,j-2))/(dy(j)*dy(j))+  &
  &                            (psi(i,j)-psi(i-2,j))/(dx(i)*dx(i)))
           else if(inner_bound(i,j+1)==1.and.inner_bound(i-1,j)==1)then  ! 
              omega(i,j)=0.25*((psi(i,j)-psi(i,j-2))/(dy(j)*dy(j))  &
  &                           +(psi(i,j)-psi(i+2,j))/(dx(i)*dx(i)))
           end if
        end if
     end do
  end do

end subroutine

end module
