#
# install.com by TOYODA Eizi, 1998
# htroff installer
#

$MSDOS = &MSDOS;
$DIRSEP = $MSDOS ? "\\" : "/";
&initFindPath;
$MACROSRC = ".";

while ($_ = shift) {
	/^-/ || last;
	/^-c/ && ($MACROTYPE = 'common');
	/^-b/ && ($MACROTYPE = 'builtin');
	/^-m/ && ($MACROSRC = shift);
}

$BINDIR = $ARGV[0] || &getBinDir;

if ($MACROTYPE eq 'common') {
	$MACDIR = $BINDIR;
} else if ($MACROTYPE eq 'builtin') {
	$MACDIR = $BINDIR;
} else {
	$MACDIR = &getMacDir unless $MACDIR;
}

&InstallFile("$BINDIR/htroff.com", 0, "empty.com", 

print "#$MSDOS/$BINDIR $MACROTYPE\n";
exit 0;

sub InstallFile {
	local($dest, $append, @files) = @_;
	unlink $dest unless $append;
	foreach (@files) {
		&AppendFile($_, $dest);
	}
	return 0;
}

sub AppendFile {
	local($from, $to) = @_;
	open(SOURCE, "<$from") || return warn "$from: cannot open\n";
	open(DESTIN, ">>$to") || return warn "$to: cannot open\n";
	while (<SOURCE>) {
		print DESTIN;
	}
	close(SOURCE);
	close(DESTIN);
	return 0;
}

sub getBinDir {
	local($i);
	print "where do you want to install HTROFF?\n";
	for ($i = 0; $i <= $#FINDPATH; $i++) {
		print "\t$i\t$FINDPATH[$i]\n";
	}

	print "type number or directory:";
	local($_) = scalar <STDIN>;
	s/^\s+//;
	s/\s+$//;

	return $FINDPATH[$_] if (/^\s*[0-9]/);
	return $_;
}

sub initFindPath {
	# path delimiter
	$PATHDELIM = $MSDOS ? ";" : ":";
	@FINDPATH = split(/$PATHDELIM/, $ENV{"PATH"});
	if (-e $0) {
		# pattern for directory last part
		$SUBPAT = $MSDOS ? '[/\\\\]([^/\\\\]+)$' : '/([^/]+)$';
		($basedir = $0) =~ s/$SUBPAT//;
		unshift(@FINDPATH, $basedir);
	}
}

sub MSDOS {
	# MS-DOS has no /dev/null.
	return 0 if ( -c '/dev/null' );
	# MS-DOS has /DEV/CON even in drive without /DEV.
	return 1 if ( -f '/DEV/CoN' && ! -d '/DEV' );
	# MS-DOS allows CON or NUL have extension.
	return 2 if ( -f '/coN.3b7' && -f '/NuL.j0Q' && -f '/nUl.!#$' );
	0;
}

