!----------------------------------------------------------------------
!     Copyright (c) 2009 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  w_zonal_module ƥȥץ :: ִؿΥƥ
!
!  2009/09/22  ݹ
!
program w_zonal_module_interpolate_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use w_zonal_module
  implicit none

  integer, parameter :: im=1, jm=16, nm=10

  real(8), dimension(nm+1)        ::  w_data
  real(8), dimension(0:im-1,1:jm) ::  xy_data

  ! Ƚ
  integer, parameter :: check_digits = 11
  integer, parameter :: ignore = -12

  real(8) :: Alon
  real(8) :: Alat
  real(8) :: xy_data_sol
  real(8) :: error
  real(8) :: pi

  pi = atan(1.0D0)*4.0D0
  Alon = pi/5 ; Alat = pi/3

  call w_Initial( nm, im, jm )

  call MessageNotify('M','w_zonal_module_interpolate_test', &
                         'w_zonal_module interpolate function tests') 


  !---- Y_1^0 Υƥ ----
  xy_data = sqrt(3.0D0)*sin(xy_Lat)                      ! Y_1^0
  xy_data_sol = sqrt(3.0D0)*sin(ALat)
  w_data = w_xy(xy_data)

  call AssertEqual(&
    message='Y_1^0 Test of interpolate function',                 &
    answer = xy_data_sol,                                         &
    check = Interpolate_w(w_data,alon,alat),                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
 
  !---- Y_2^0 Υƥ ----
  xy_data = sqrt(5.0D0)*(3.0/2*sin(xy_Lat)**2-1/2.0)                 ! Y_2^0
  xy_data_sol = sqrt(5.0D0)*(3.0/2*sin(alat)**2-1.0/2)
  w_data = w_xy(xy_data)

  call AssertEqual(&
    message='Y_2^0 Test of interpolate function',                 &
    answer = xy_data_sol,                                         &
    check = Interpolate_w(w_data,alon,alat),                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- ŪʴؿΥƥ ----
  xy_data = (sin(xy_Lat)-1)**2*(sin(xy_Lat)-0.5)*(sin(xy_Lat)+1)
  xy_data_sol = (sin(ALat)-1)**2*(sin(ALat)-0.5)*(sin(ALat)+1)
  w_data = w_xy(xy_data)

  call AssertEqual(&
    message='general function Test of interpolate function',      &
    answer = xy_data_sol,                                         &
    check = Interpolate_w(w_data,alon,alat),                      &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','w_zonal_module_interpolate_test', &
       'w_zonal_module interpolate function tests succeeded!') 

end program w_zonal_module_interpolate_test
