!--
!----------------------------------------------------------------------
! Copyright(C) 2005-2009 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_spectrum_module
!
!  spml/w_spectrum_module ⥸塼ϵ̾Ǥ 2 ήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 w_module β⥸塼Ǥ, 
!  ڥȥϷ׻Τ Fortran90 ؿ󶡤. 
!
!   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!
!  2005/04/23  ݹ 
!      2005/05/16  ݹ ؿ̾û
!      2006/03/08  ݹ  Ȥ RDoc Ѥ˽
!      2008/06/25  ʿ Ȥ RDoc Ѥ˽
!      2009/01/29  ʿ Ȥ RDoc Ѥ
!      2009/07/30  ݹ   DO ѿѹ(for OpenMP)
!
!++
module w_spectrum_module
  !
  !=  w_spectrum_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: w_spectrum_module.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/w_spectrum_module ⥸塼ϵ̾Ǥ 2 ήαư
  ! ĴȡѤڥȥˡˤäƿͷ׻뤿 
  ! ⥸塼 w_module β⥸塼Ǥ, 
  ! ڥȥϷ׻Τ Fortran90 ؿ󶡤. 
  !
  !  ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  ! ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use w_base_module, only : nm, l_nm

  implicit none

  private
 
  public nm_EnergyFromStreamfunc_w          ! ͥ륮ڥȥ           
                                            ! (ʿȿ n, Ӿȿ m )
  public n_EnergyFromStreamfunc_w           ! ͥ륮ڥȥ
                                            ! (ʿȿ n ) 
  public nm_EnstrophyFromStreamfunc_w       ! 󥹥ȥեڥȥ     
                                            ! (ʿȿ n, Ӿȿ m )
  public n_EnstrophyFromStreamfunc_w        ! 󥹥ȥեڥȥ  
                                            !  (ʿȿ n )
  public w_spectrum_VMiss                   ! »

  real(8) :: w_spectrum_VMiss = -999.000    ! »ͽ

  contains

  !--------------- ͥ륮ڥȥ׻ -----------------
    function nm_EnergyFromStreamfunc_w(w_Strfunc)
      ! 
      ! ήؿΥڥȥǡ饨ͥ륮εĴȡʬ
      ! (ڥȥ)׻(1 ).
      !
      !  * ȿ n, Ӿȿ m ήؿΥڥȥʬ(n,m) 
      !    ͥ륮ڥȥ (1/2)n(n+1)(n,m)^2 ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤4Ф򤫤Τ̾Ǥ
      !    ͥ륮.
      !
      !  * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !    »ͤͤϥ⥸塼ѿ w_spectrum_VMiss ˤäǤ
      !    (ͤ -999.0)
      !
      real(8), intent(in)   :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm,-nm:nm) :: nm_EnergyFromStreamfunc_w
      !(out) ͥ륮ڥȥ(ʿȿ n, Ӿȿ m )

      integer n,m                               ! DO ѿ

      nm_EnergyFromStreamfunc_w = w_spectrum_VMiss

      do n=0,nm
         do m=-n,n
            nm_EnergyFromStreamfunc_w(n,m) &
                 = 0.5 * n*(n+1) * w_Strfunc(l_nm(n,m))**2
         enddo
      enddo
    end function nm_EnergyFromStreamfunc_w

    function n_EnergyFromStreamfunc_w(w_Strfunc)
      !
      ! ήؿΥڥȥǡȿΥͥ륮ʬ(ڥȥ)
      ! ׻(1 ).
      !
      !  * ȿ n ήؿΥڥȥʬ(n,m) 
      !    ͥ륮ڥȥϦ[m=-nm]^nm(1/2)n(n+1)(n,m)^2 
      !    ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤ 4Ф򤫤Τ
      !    ̾Ǥͥ륮.
      !

      real(8), intent(in)      :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm) :: n_EnergyFromStreamfunc_w
      !(out) ͥ륮ڥȥ (ʿȿ n ) 

      integer n,m                                 ! DO ѿ

      do n=0,nm
         n_EnergyFromStreamfunc_w(n)  &
              = 0.5 * n*(n+1) &
                * sum(w_StrFunc(l_nm(n,(/(m,m=-n,n)/)))**2,1)
      enddo

    end function n_EnergyFromStreamfunc_w

  !--------------- 󥹥ȥեڥȥ׻ -----------------
    function nm_EnstrophyFromStreamfunc_w(w_Strfunc)
      !
      ! ήؿΥڥȥǡ饨󥹥ȥեεĴȡʬ
      ! (ڥȥ)׻(1 ). 
      !
      ! * ȿ n, Ӿȿ m ήؿΥڥȥʬ(n,m) 
      !    󥹥ȥեڥȥ (1/2)n^2(n+1)^2(n,m)^2 ȷ׻.
      !
      ! * ƤΥ󥹥ȥեڥȥʬ¤4/R^2򤫤Τ
      !   ̾Ǥ󥹥ȥե.  R ϵ̤Ⱦ¤Ǥ.
      !
      ! * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !   »ͤͤϥ⥸塼ѿ w_spectrum_VMiss ˤäǤ
      !   (ͤ -999.0)
      !
      real(8), intent(in)   :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm,-nm:nm) :: nm_EnstrophyFromStreamfunc_w
      ! 󥹥ȥեڥȥ (ʿȿ n, Ӿȿ m )

      integer n,m                               ! DO ѿ

      nm_EnstrophyFromStreamfunc_w = w_spectrum_VMiss

      do n=0,nm
         do m=-n,n
            nm_EnstrophyFromStreamfunc_w(n,m) &
                 = 0.5 * n**2 * (n+1)**2 &
                    * w_Strfunc(l_nm(n,m))**2
         enddo
      enddo
    end function nm_EnstrophyFromStreamfunc_w

    function n_EnstrophyFromStreamfunc_w(w_Strfunc)
      !
      ! ήؿΥڥȥǡȿΥͥ륮ʬ(ڥȥ)
      ! ׻(1 )
      !
      ! * ȿ n ήؿΥڥȥʬ(n,m) 饨󥹥ȥե
      !   ڥȥϦ[m=-nm]^nm(1/2)n^2(n+1)^2(n,m)^2 ȷ׻.
      !    
      ! * ƤΥͥ륮ڥȥʬ¤ 4/R^2 򤫤Τ
      !   ̾Ǥ󥹥ȥե.
      !
      real(8), intent(in)      :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm) :: n_EnstrophyFromStreamfunc_w  
      !(out) 󥹥ȥեڥȥ(ʿȿ n )

      integer n,m                                ! DO ѿ

      do n=0,nm
         n_EnstrophyFromStreamfunc_w(n)  &
              = 0.5 * n**2 * (n+1)**2 &
                * sum(w_StrFunc(l_nm(n,(/(m,m=-n,n)/)))**2,1)
      enddo
    end function n_EnstrophyFromStreamfunc_w

end module w_spectrum_module
