# Library for data analysis with GPhys
# 
# To use NumRu::GAnalysis, require it in your code as
# 
#    require "numru/ganalysis"
#
# Or you can require specific library(ies) such as
#
#    require "numru/ganalysis/planet"
#    require "numru/ganalysis/covariance"
#
# Available files in this way are currently 
# "numru/ganalysis/covariance",
# "numru/ganalysis/eof",
# "numru/ganalysis/histogram",
# "numru/ganalysis/planet",
# "numru/ganalysis/met", 
# "numru/ganalysis/sigma_coord", 
# and "numru/ganalysis/met_z".
# 
# Note that the first three (covariance, eof, histogram) define
# methods directly underneath NumRu::GAnalysis, while others introduce
# sub-modules (e.g., NumRu::GAnalysis::Planet).
# 
# ==== !! For developers: Please introduce sub-modules if you create a new library.
# 
# == License
# http://www.gfd-dennou.org/library/ruby/products/gphys/LICENSE.txt



require "numru/gphys"

module NumRu
  module GAnalysis
  end
end      

require "numru/ganalysis/covariance"
require "numru/ganalysis/eof"
require "numru/ganalysis/histogram"
require "numru/ganalysis/planet"
require "numru/ganalysis/met"
require "numru/ganalysis/sigma_coord"
require "numru/ganalysis/met_z"
