!--
!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_interpolate_module_sjpack_cuda
!
!  spml/wa_interpolate_module_sjpack_cuda ⥸塼ϵ̾Ǥήαư
!  ĴȡѤڥȥˡˤäƿͷ׻뤿 
!  ⥸塼 wa_module_sjpack_cuda β⥸塼Ǥ, ڥȥˡˤ
!  ַ׻Τ Fortran90 ؿ󶡤. 
!
!  ̾ 1 إǥ w_interpolate_module_sjpack_cuda ⥸塼
!  ¿إǥѤ˳ĥΤǤ, ƱʣĤΥڥȥǡ
!  Ѥַ׻Ԥ.
!
!  ַ׻ˡˤĤƤ doc/w_module_sjpack.tex 򻲾ȤΤ. 
!  Υ֥롼 ISPACK  SJPACK Υ֥롼
!  ƤǤʤ. 
!
!
!  2011/03/12  ݹ wa_interpolate_module_sjpack  CUDA Ѥ˲¤
!
!      
!      * Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
!++
module wa_interpolate_module_sjpack_cuda
  !
  != wa_interpolate_module_cuda
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: wa_interpolate_module_sjpack_cuda.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  !  spml/wa_interpolate_module_sjpack ⥸塼ϵ̾Ǥήαư
  !  ĴȡѤڥȥˡˤäƿͷ׻뤿 
  !  ⥸塼 wa_module_sjpack β⥸塼Ǥ, ڥȥˡˤ
  !  ַ׻Τ Fortran90 ؿ󶡤. 
  !
  !  ̾ 1 إǥ w_interpolate_module_sjpack ⥸塼
  !  ¿إǥѤ˳ĥΤǤ, ƱʣĤΥڥȥǡ
  !  Ѥַ׻Ԥ.
  !
  !  ַ׻ˡˤĤƤ doc/w_module_sjpack.tex 򻲾ȤΤ. 
  !  Υ֥롼 ISPACK  SJPACK Υ֥롼
  !  ƤǤʤ. 
  !
  use dc_message, only : MessageNotify
  use w_base_module_sjpack_cuda, only : nm=>nn, l_nm
  implicit none
  private

  public a_Interpolate_wa                        ! ִؿ

  interface a_Interpolate_wa
     !
     !  alon,  alat ˤؿͤ
     ! ĴѴ wa_data ַ׻
     !
     ! Ϥٷٺɸϣ 1 
     !
     module procedure a_Interpolate_array00_wa
  end interface

  interface alpha
     module procedure alpha_array0
  end interface

  interface Pmm
     module procedure Pmm_array0
  end interface

  contains

  !--------------- ַ׻ -----------------
    function a_Interpolate_array00_wa(wa_data,alon,alat)
      !
      !  alon,  alat ˤؿͤ
      ! εĴѴ wa_data ַ׻
      !
      real(8), intent(IN) :: wa_data(:,:)             ! ڥȥǡ
      real(8), intent(IN) :: alon                     ! ֤()
      real(8), intent(IN) :: alat                     ! ֤()
      real(8) :: a_Interpolate_array00_wa(size(wa_data,2))   ! ֤
      
      real(8) :: mu
      real(8), dimension(size(wa_data,2)) :: y0, y1, y2, AnmPnm
      integer :: k,m

      mu = sin(alat)
      a_Interpolate_array00_wa = 0.0D0

      !---- a_n^0 P_n^0 η׻
      y2 = 0.0D0 ; y1 = 0.0D0
      do k=nm,1,-1
         y0 = alpha(k,0,mu) * y1 + beta(k+1,0)*y2 + wa_data(l_nm(k,0),:)
         y2 = y1 ; y1 = y0
      enddo
      a_Interpolate_array00_wa = (  beta(1,0) * y2 + mu*sqrt(3.0D0) * y1 &
                       + wa_data(l_nm(0,0),:)  ) * Pmm(0,mu)

      !---- cos m a_n^m P_n^m η׻
      do m=1,nm
         y2 = 0.0D0 ; y1 = 0.0D0
         do k=nm,m+1,-1
            y0 = alpha(k,m,mu) * y1 + beta(k+1,m) * y2 + wa_data(l_nm(k,m),:)
            y2 = y1 ; y1 = y0
         enddo

         AnmPnm =(wa_data(l_nm(m,m),:) + beta(m+1,m)*y2 &
                   + mu*sqrt(2.0D0*m+3)*y1 ) * Pmm(m,mu)

         a_Interpolate_array00_wa = a_Interpolate_array00_wa &
                                 + AnmPnm * 2.0D0 * cos(m*alon)
      end do

      !---- sin  a_n^m P_n^m η׻n
      do m=1,nm
         y2 = 0.0D0 ; y1 = 0.0D0
         do k=nm,m+1,-1
            y0 = alpha(k,m,mu) * y1 + beta(k+1,m)*y2 + wa_data(l_nm(k,-m),:)
            y2 = y1 ; y1 = y0
         enddo

         AnmPnm =(wa_data(l_nm(m,-m),:) + beta(m+1,m)*y2 &
                   + mu*sqrt(2.0D0*m+3)*y1 ) * Pmm(m,mu)


         a_Interpolate_array00_wa = a_Interpolate_array00_wa &
                                 - AnmPnm * 2.0D0 * sin(m*alon)
      end do
      
    end function a_Interpolate_array00_wa

  !--------------- 롼 -----------------
    function alpha_array0(n,m,x)
      !
      !   P_n^m η
      !
      integer, intent(IN) :: n,m 
      real(8), intent(IN) :: x
      real(8)             :: alpha_array0

      alpha_array0 = sqrt( (2.0D0*n+3)*(2.0D0*n+1)/((n-m+1)*(n+m+1)) ) * x
    end function alpha_array0

    function beta(n,m)
      !
      !   P_{n-1}^m η
      !
      integer, intent(IN) :: n,m 
      real(8)             :: beta

      beta = - sqrt( (2.0D0*n+3)*(n+m)*(n-m)/((2*n-1)*(n+m+1)*(n-m+1)) )
    end function beta

    function Pmm_array0(m,x)
      !
      ! 른ɥȡ P_m^m(x) η׻
      !         sqrt( factrl(2*m+1) )/(2.0D0**m * factrl(m)) &
      !          * (1-x**2)**(m/2.0D0)
      !
      ! ȯʤ褦пǷ׻
      !
      integer, intent(IN) :: m           ! 른ɥȡμ
      real(8), intent(IN) :: x           ! 
      real(8)             :: Pmm_array0  ! 른ɥȡ
      real(8)             :: gammaln     ! ؿп

      if ( m < 0 ) call MessageNotify('E','Pmm in w_Intepolate_module',&
                                'order m should be larger equal to zero')

      Pmm_array0 = 1.0
      if ( m > 0 )then
            Pmm_array0 = &
                 exp(gammaln(2.0D0*m+2.0)/2.0D0 - m*log(2.0D0) - gammaln(m+1.0D0)) &
                 * (1-x**2)**(m/2.0D0)
      endif
    end function Pmm_array0

end module wa_interpolate_module_sjpack_cuda
