#
# uipk02.rb
#
# $Id$
#

require "numru/dcl"

include NumRu
include Math


nx = 50
ny = 50

z = NArray.sfloat(nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    z[i,j] = - (i-(nx-1)/2.0)**2 - (j-(ny-1)/2.0)**2
  end
end

#-- graph ---
DCL::swiset('WINDOW_HEIGHT', 500)
DCL::swiset('WINDOW_WIDTH', 500)

iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i

DCL::gropn iws

for i in 0..1
  DCL::grfrm
  DCL::grswnd(-1.0, 1.0, -1.0, 1.0)
  DCL::grsvpt(0.1, 0.9, 0.1, 0.9)
  DCL::grstrn(1)
  DCL::grstrf

  if i==0
    DCL::uilset('lcellx',true)
    DCL::uilset('lcelly',true)
  else
    DCL::uilset('lcellx',false)
    DCL::uilset('lcelly',false)
  end

  DCL::uipdat(z)

  DCL::uxaxdv('t', 0.1, 0.5)
  DCL::uxaxdv('b', 0.1, 0.5)
  DCL::uyaxdv('l', 0.1, 0.5)
  DCL::uyaxdv('r', 0.1, 0.5)
end

DCL::grcls
