=begin JA

= gtool 変数 - 概念

# * 豊田 英司 (toyoda), 森川 靖大 (morikawa)
#   * $Id: lib-gtoolvar1.rd,v 1.1 2008-09-23 09:55:27 morikawa Exp $

=end JA

=begin JA

本稿では gtool 変数という概念について簡潔に説明します。

== 変数は配列

* gtool 変数は任意次元の配列です。0次元の配列とは、スカラのことです。

* 配列要素には型（((<外部型|URL:lib-datatypes.htm>))）があります。

* 外部型が何であるかによらず、サポートされている数値型
  （((<内部型|URL:lib-datatypes.htm>))）であればどのような型の
  （Fortran の）配列にでも gtool 変数へ値を入出力する
  ことができます。

* 変数は URI で指定されるファイル名と変数名で識別されます。
  両者を連結したものを((*変数 URI *))とよびます。
  変数 URI の書式に関しては ((<gtool4 netCDF 規約|URL:xref.htm#label-6>))
  の「5. 各種の文字列書式」を参照してください。

== 変数の次元

* 配列の各次元には 1 で始まる格子番号がついています。変数の次元の順序
  には意味があるので、N 次元変数の要素は N 個の整数の組を用いて
  (i_1, i_2, i_3, .... i_N) 番目の要素というように指定できます。
  (_<数字> は下付き文字をあらわしています)

* 配列の各次元は1次元の gtool 変数に対応しています。

== 変数の作成

* 0次元の gtool 変数は名前と外部型だけを指定すれば作成できます。

* 1次元の gtool 変数は名前と外部型と長さだけを指定すれば作成できます。

* N 次元（N ≧1）の gtool 変数は名前と外部型とN 個の 1次元 gtool 変数
  を指定すると作成できます。このとき i 番目の次元として指定された変数
  を i 番目の次元変数と呼び、多次元変数について次元順序番号を指定する
  ことで再び次元変数を得ることができます。


== 変数の属性

* 変数には属性として情報を付加することができます。

* 属性は変数と名前で識別されます。

* 属性は数値型の配列か、文字列です。形式的にいえば属性には（数値型か文
  字型の）外部型と長さという特性があります。数値型の場合長さは配列長です
  し、文字列の長さは文字数です。

* 属性に関しても任意の外部型と内部型の組み合わせについて入出力を行うこ
  とができます。

* 数値型配列の文字型としての読み取りは各要素を文字列化したものをコンマ
  で区切った結果を与え、文字列の数値型としての読み取りは文字列をコンマ
  で区切ったものを各々配列要素として解釈した結果を与えます。


== 変数の次元構成操作

上記のほかに、変数については以下のような操作ができます。

* ある次元をみかけ上存在しないようにできます。

* 次元の順序を入れ替えることができます。


== 変数の入出力

変数の入出力には Get または Put サブルーチンを使います。どちらも、
デフォルトでは変数全体を入出力対象とします。

入出力範囲を限定したい場合は Limit を使ってください。 

入出力範囲を限定したいが、次に別の範囲を読み取るというような場合は 
Slice を使ってください。Slice_Next を使うと変数全体を順次読み取ること
ができます。

Limit を呼んだ後で Slice と Slice_Next を使うと、Limit された範囲を順
に読み取ります。

=end JA


=begin HTMLJA
<div align="right">
 <p align="right"><a href="lib-gtoolvar2.htm">次のページ</a>
</div>

<hr />
<small>
  $Id: lib-gtoolvar1.rd,v 1.1 2008-09-23 09:55:27 morikawa Exp $
</small>
=end HTMLJA
