% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_graph_series.R
\name{filter_graph_series}
\alias{filter_graph_series}
\title{Subset a graph series object}
\usage{
filter_graph_series(graph_series, by = "number", values, tz = NULL)
}
\arguments{
\item{graph_series}{A graph series object of type \code{dgr_graph_1D}.}

\item{by}{Either \code{number}, which allows for subsetting of the graph series by
graph indices, or \code{time} which for graph series objects of type \code{temporal}
allows for a subsetting of graphs by a date-time or time range.}

\item{values}{Where the subsetting of the graph series by to occur via graph
indices (where \code{by = number}), provide a vector of those indices; when
subsetting by time (where \code{by = time}), a range of times can be provided as
a vector.}

\item{tz}{The time zone (\code{tz}) corresponding to dates or date-time string
provided in \code{values} (if \code{by = "date"}).}
}
\value{
A graph series object of type \code{dgr_graph_1D}.
}
\description{
Subsetting a graph series by the graphs' index positions in the graph series
or through selection via graphs' date-time attributes.
}
\examples{
# Create three graphs
graph_time_1 <-
  create_graph(
    graph_name = "graph_with_time_1") \%>\%
  set_graph_time(
    time = "2015-03-25 03:00",
    tz = "GMT")

graph_time_2 <-
  create_graph(
    graph_name = "graph_with_time_2") \%>\%
  set_graph_time(
    time = "2015-03-26 03:00",
    tz = "GMT")

graph_time_3 <-
  create_graph(
    graph_name = "graph_with_time_3") \%>\%
  set_graph_time(
    time = "2015-03-27 15:00",
    tz = "GMT")

# Create an empty graph series and add
# the graphs
series_temporal <-
  create_graph_series(
    series_type = "temporal") \%>\%
  add_graph_to_graph_series(
    graph = graph_time_1) \%>\%
  add_graph_to_graph_series(
    graph = graph_time_2) \%>\%
  add_graph_to_graph_series(
    graph = graph_time_3)

# Subset graph series by sequence
series_sequence_subset <-
  filter_graph_series(
    graph_series = series_temporal,
    by = "number",
    values = 2)

# Get a count of graphs in
# the series
series_sequence_subset \%>\%
  count_graphs_in_graph_series()

# Subset graph series by date-time
series_time_subset <-
  filter_graph_series(
    graph_series = series_temporal,
    by = "time",
    values = c("2015-03-25 12:00",
               "2015-03-26 12:00"),
    tz = "GMT")

# Get a count of graphs in
# the series
series_time_subset \%>\%
  count_graphs_in_graph_series()

}
