# coding: utf-8

"""
    CLOUD API

     IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class FlowLogProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'name': 'str',

        'action': 'str',

        'direction': 'str',

        'bucket': 'str',
    }

    attribute_map = {

        'name': 'name',

        'action': 'action',

        'direction': 'direction',

        'bucket': 'bucket',
    }

    def __init__(self, name=None, action=None, direction=None, bucket=None, local_vars_configuration=None):  # noqa: E501
        """FlowLogProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._action = None
        self._direction = None
        self._bucket = None
        self.discriminator = None

        self.name = name
        self.action = action
        self.direction = direction
        self.bucket = bucket


    @property
    def name(self):
        """Gets the name of this FlowLogProperties.  # noqa: E501

        The resource name.  # noqa: E501

        :return: The name of this FlowLogProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this FlowLogProperties.

        The resource name.  # noqa: E501

        :param name: The name of this FlowLogProperties.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def action(self):
        """Gets the action of this FlowLogProperties.  # noqa: E501

        Specifies the traffic action pattern.  # noqa: E501

        :return: The action of this FlowLogProperties.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this FlowLogProperties.

        Specifies the traffic action pattern.  # noqa: E501

        :param action: The action of this FlowLogProperties.  # noqa: E501
        :type action: str
        """
        if self.local_vars_configuration.client_side_validation and action is None:  # noqa: E501
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501
        allowed_values = ["ACCEPTED", "REJECTED", "ALL"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and action not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def direction(self):
        """Gets the direction of this FlowLogProperties.  # noqa: E501

        Specifies the traffic direction pattern.  # noqa: E501

        :return: The direction of this FlowLogProperties.  # noqa: E501
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """Sets the direction of this FlowLogProperties.

        Specifies the traffic direction pattern.  # noqa: E501

        :param direction: The direction of this FlowLogProperties.  # noqa: E501
        :type direction: str
        """
        if self.local_vars_configuration.client_side_validation and direction is None:  # noqa: E501
            raise ValueError("Invalid value for `direction`, must not be `None`")  # noqa: E501
        allowed_values = ["INGRESS", "EGRESS", "BIDIRECTIONAL"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and direction not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `direction` ({0}), must be one of {1}"  # noqa: E501
                .format(direction, allowed_values)
            )

        self._direction = direction

    @property
    def bucket(self):
        """Gets the bucket of this FlowLogProperties.  # noqa: E501

        The bucket name of an existing IONOS Cloud Object storage bucket.  # noqa: E501

        :return: The bucket of this FlowLogProperties.  # noqa: E501
        :rtype: str
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """Sets the bucket of this FlowLogProperties.

        The bucket name of an existing IONOS Cloud Object storage bucket.  # noqa: E501

        :param bucket: The bucket of this FlowLogProperties.  # noqa: E501
        :type bucket: str
        """
        if self.local_vars_configuration.client_side_validation and bucket is None:  # noqa: E501
            raise ValueError("Invalid value for `bucket`, must not be `None`")  # noqa: E501

        self._bucket = bucket
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FlowLogProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FlowLogProperties):
            return True

        return self.to_dict() != other.to_dict()
