// Minimal symmetric quadrature rules for a tetrahedron from https://doi.org/10.1002/nme.6528
// This file was generated by lib/petsc/bin/maint/petscdt_create_quadrature_headers.py
#ifndef PETSCDTTETQUADRULES_H
#define PETSCDTTETQUADRULES_H

#include <petscsys.h>

static const PetscReal PetscDTJSTetQuad_1_weights[] = {PetscRealConstant(1.33333333333333333333333333333333327e+00)};

static const PetscReal PetscDTJSTetQuad_1_orbits[] = {PetscRealConstant(2.50000000000000000000000000000000000e-01)};

static const PetscReal PetscDTJSTetQuad_2_weights[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01)};

static const PetscReal PetscDTJSTetQuad_2_orbits[] = {PetscRealConstant(1.38196601125010515179541316563436184e-01), PetscRealConstant(5.85410196624968454461376050309691448e-01)};

static const PetscReal PetscDTJSTetQuad_3_weights[] = {PetscRealConstant(1.69988415410008565599458654763498652e-01), PetscRealConstant(1.63344917923324767733874678569834689e-01)};

static const PetscReal PetscDTJSTetQuad_3_orbits[] = {PetscRealConstant(3.28681146665348992972216372652797476e-01), PetscRealConstant(1.39565600039530210833508820416076171e-02), PetscRealConstant(1.11920727509291548465190720602080709e-01), PetscRealConstant(6.64237817472125354604427838193757860e-01)};

static const PetscReal PetscDTJSTetQuad_4_weights[] = {PetscRealConstant(8.72122181792695758866227436116007919e-02), PetscRealConstant(7.91403523080063410727656700436480263e-02), PetscRealConstant(1.11320508564038277582629946452056341e-01)};

static const PetscReal PetscDTJSTetQuad_4_orbits[] = {PetscRealConstant(3.09582165317951906864488291152538126e-01), PetscRealConstant(7.12535040461442794065351265423856708e-02), PetscRealConstant(8.34427723039775721273639008660933238e-02),
                                                      PetscRealConstant(7.49671683088067283617908297401720041e-01), PetscRealConstant(7.72209540700586657574996641570491105e-02), PetscRealConstant(4.22779045929941334242500335842950878e-01)};

static const PetscReal PetscDTJSTetQuad_5_weights[] = {PetscRealConstant(1.50250567624021134398914203111048437e-01), PetscRealConstant(9.79907241551492660582802739817700077e-02), PetscRealConstant(5.67280277027752885840925708270099233e-02)};

static const PetscReal PetscDTJSTetQuad_5_orbits[] = {PetscRealConstant(3.10885919263300609797345733763457841e-01), PetscRealConstant(6.73422422100981706079627987096264998e-02), PetscRealConstant(9.27352503108912264023239137370306083e-02),
                                                      PetscRealConstant(7.21794249067326320793028258788908175e-01), PetscRealConstant(4.55037041256496494918805262793394378e-02), PetscRealConstant(4.54496295874350350508119473720660550e-01)};

static const PetscReal PetscDTJSTetQuad_6_weights[] = {PetscRealConstant(1.34362814070941905973509832612491508e-02), PetscRealConstant(7.38095753915396294602043704716346888e-02), PetscRealConstant(5.32303336775566561329208367433066386e-02), PetscRealConstant(6.42857142857142857142857142857142922e-02)};

static const PetscReal PetscDTJSTetQuad_6_orbits[] = {PetscRealConstant(4.06739585346113531155794489564100590e-02), PetscRealConstant(8.77978124396165940653261653130769811e-01), PetscRealConstant(3.22337890142275510343994470762492129e-01),
                                                      PetscRealConstant(3.29863295731734689680165877125236243e-02), PetscRealConstant(2.14602871259152029288839219386284987e-01), PetscRealConstant(3.56191386222543912133482341841145015e-01),
                                                      PetscRealConstant(6.36610018750175252992355276057269854e-02), PetscRealConstant(2.69672331458315808034097805727606344e-01), PetscRealConstant(6.03005664791649141367431139060939661e-01)};

static const PetscReal PetscDTJSTetQuad_7_weights[] = {PetscRealConstant(1.27313719285507798480771248156301843e-01), PetscRealConstant(5.64394416132893721017148943980623138e-02), PetscRealConstant(4.25292371104767732456997654439232765e-02), PetscRealConstant(1.08143611065377887548045779881287193e-02), PetscRealConstant(4.96095076377794951594874149219748218e-02)};

static const PetscReal PetscDTJSTetQuad_7_orbits[] = {PetscRealConstant(2.50000000000000000000000000000000000e-01), PetscRealConstant(3.15701149778202799423429999593311505e-01), PetscRealConstant(5.28965506653916017297100012200655326e-02),
                                                      PetscRealConstant(5.04898225983963687630538229865624674e-02), PetscRealConstant(4.49510177401603631236946177013437527e-01), PetscRealConstant(2.12654725414832459888361014998199407e-02),
                                                      PetscRealConstant(1.46638813818484946904222417152127717e-01), PetscRealConstant(8.10830241098548561118105379848232426e-01), PetscRealConstant(1.88833831026001047736431103854585764e-01),
                                                      PetscRealConstant(4.71607003609978810438962152685209702e-02), PetscRealConstant(5.75171637587000023483241577022307495e-01)};

static const PetscReal PetscDTJSTetQuad_8_weights[] = {PetscRealConstant(6.37506507124088731362704352369181979e-02), PetscRealConstant(3.96371387823922970866392292011306873e-02), PetscRealConstant(5.80364322919670189681332163549898121e-02),
                                                       PetscRealConstant(1.15103146944199661574784958767109210e-02), PetscRealConstant(4.91873883598218169012586276601732229e-02), PetscRealConstant(1.93293689478126737421328901373892878e-02),
                                                       PetscRealConstant(9.54320248965814380217511492038533974e-03)};

static const PetscReal PetscDTJSTetQuad_8_orbits[] = {PetscRealConstant(1.86812758270720971293100377386007294e-01), PetscRealConstant(4.39561725187837086120698867841978069e-01), PetscRealConstant(1.14462406761230491922613070156895615e-01),
                                                      PetscRealConstant(6.56612779716308524232160789529313107e-01), PetscRealConstant(3.13806592272401620271942164961413846e-01), PetscRealConstant(5.85802231827951391841735051157584741e-02),
                                                      PetscRealConstant(4.45773794488462481180375037808192682e-02), PetscRealConstant(8.66267861653461255645887488657542147e-01), PetscRealConstant(6.54834905438423946511580844664723113e-02),
                                                      PetscRealConstant(4.34516509456157605348841915533527701e-01), PetscRealConstant(2.03893174662110274586449492644381014e-01), PetscRealConstant(5.07332075042159031040669808694536759e-03),
                                                      PetscRealConstant(5.87140329925357860516694316624292593e-01), PetscRealConstant(2.12477796695716737760909209401364860e-02), PetscRealConstant(2.42827514267551765255758562257815948e-01),
                                                      PetscRealConstant(7.14676926393304887192059595861911080e-01)};

static const PetscReal PetscDTJSTetQuad_9_weights[] = {PetscRealConstant(7.58221656714023044350318861859448273e-02), PetscRealConstant(3.42590355860309008539804688977192142e-02), PetscRealConstant(3.06523113737115978336318611897891505e-03),
                                                       PetscRealConstant(4.06080515567880105121402734243629114e-02), PetscRealConstant(9.49829645365184104022991185024804646e-03), PetscRealConstant(4.91248739745918427243732268229877185e-02),
                                                       PetscRealConstant(1.37627423762797950642034648592010341e-02), PetscRealConstant(1.01798495386411394197736640410936005e-02), PetscRealConstant(2.71440301583300924987900981867241865e-02)};

static const PetscReal PetscDTJSTetQuad_9_orbits[] = {PetscRealConstant(2.50000000000000000000000000000000000e-01), PetscRealConstant(1.67906605236742789400412492735389152e-01), PetscRealConstant(4.96280184289771631798762521793832567e-01),
                                                      PetscRealConstant(9.14362705140762585678674601820542449e-02), PetscRealConstant(7.25691188457771224296397619453837313e-01), PetscRealConstant(3.21855664817653266116655222446142564e-01),
                                                      PetscRealConstant(3.44330055470402016500343326615722657e-02), PetscRealConstant(4.18376959003656023187643283102808801e-02), PetscRealConstant(8.74486912298903193043707015069157360e-01),
                                                      PetscRealConstant(1.06729438574846360771696560980154841e-01), PetscRealConstant(3.93270561425153639228303439019845171e-01), PetscRealConstant(3.39571681830888857948565533025282121e-02),
                                                      PetscRealConstant(2.13692569652397829383039599940526261e-01), PetscRealConstant(7.18393093981424399027247293454417363e-01), PetscRealConstant(4.60658181054777632724569389480023731e-01),
                                                      PetscRealConstant(3.41375680369336314245730557694732986e-09), PetscRealConstant(7.86836344766879308574980785826469540e-02), PetscRealConstant(1.84387943500015203783943300351668968e-01),
                                                      PetscRealConstant(3.40133902381196610832298093755009405e-02), PetscRealConstant(5.97210722761849931348883589921161135e-01)};

static const PetscReal PetscDTJSTetQuad_10_weights[] = {PetscRealConstant(6.88678563414632903913874726454308736e-02), PetscRealConstant(1.79572968955470153208629625836486013e-02), PetscRealConstant(3.52892256662527130924850265681015226e-02),
                                                        PetscRealConstant(6.80939710419136727783433930439824916e-03), PetscRealConstant(3.15333282109941279309439258805399781e-02), PetscRealConstant(3.37564888679576249551226018994373168e-02),
                                                        PetscRealConstant(7.22168454326390182551494060210896743e-03), PetscRealConstant(1.08715453494056353500913676469479144e-02), PetscRealConstant(1.48346290128170368711921384115001647e-02),
                                                        PetscRealConstant(1.76757179768564750106931085427835174e-03)};

static const PetscReal PetscDTJSTetQuad_10_orbits[] = {PetscRealConstant(2.50000000000000000000000000000000000e-01), PetscRealConstant(7.25517574174378012796694400528975332e-02), PetscRealConstant(7.82344727747686596160991679841307388e-01),
                                                       PetscRealConstant(3.07895947866922893779487411149697385e-01), PetscRealConstant(7.63121563992313186615377665509078325e-02), PetscRealConstant(2.37191396072209285499945543297403682e-02),
                                                       PetscRealConstant(4.76280860392779071450005445670259626e-01), PetscRealConstant(9.65797730691072592938714233251676219e-02), PetscRealConstant(4.03420226930892740706128576674832378e-01),
                                                       PetscRealConstant(2.01738606847679876375460361960982374e-01), PetscRealConstant(7.38541810184862102813760158811461421e-02), PetscRealConstant(5.22668605286154036967703260196889049e-01),
                                                       PetscRealConstant(1.54839700743861806136678287351062777e-01), PetscRealConstant(2.81574262923683986569954997616861800e-03), PetscRealConstant(6.87504855883039547860943875321705809e-01),
                                                       PetscRealConstant(4.12599150499363910905612310303035266e-01), PetscRealConstant(6.57982507340068014568378291938110591e-04), PetscRealConstant(1.74143716493932110174207001101991356e-01),
                                                       PetscRealConstant(3.88907275578065122503777130223325447e-02), PetscRealConstant(2.65757506562719879638491028852931511e-01), PetscRealConstant(6.56461038321667095860753545102403388e-01),
                                                       PetscRealConstant(5.60484795102133776336068745984629774e-03), PetscRealConstant(9.32413490352584072973462760783113604e-02), PetscRealConstant(8.95548955062698917175932349001996076e-01)};

static const PetscReal PetscDTJSTetQuad_11_weights[] = {PetscRealConstant(1.95857914481743313113933129279654444e-02), PetscRealConstant(4.50782604082890789716813586899831847e-03), PetscRealConstant(2.23556915696341690974696220354427655e-02),
                                                        PetscRealConstant(2.57648537970113466754844751745207165e-02), PetscRealConstant(2.20433814716772908345279421852120032e-03), PetscRealConstant(1.30666283293771650154511276742172310e-02),
                                                        PetscRealConstant(2.71503798840643440970646549312387047e-03), PetscRealConstant(1.09434850038889577767975396168568190e-02), PetscRealConstant(2.01399831555513238485315019170407470e-02),
                                                        PetscRealConstant(1.69898568881418487226867091490845889e-02), PetscRealConstant(7.03123607958550625344025264044546156e-03)};

static const PetscReal PetscDTJSTetQuad_11_orbits[] = {PetscRealConstant(2.99313092399342490908243331163353824e-01), PetscRealConstant(1.02060722801972527275270006509938504e-01), PetscRealConstant(3.26328439651817953665481357031455366e-02),
                                                       PetscRealConstant(9.02101468104454613900355592890563366e-01), PetscRealConstant(1.74204415484689165842632886057981188e-01), PetscRealConstant(3.25795584515310834157367113942018812e-01),
                                                       PetscRealConstant(9.87846241416250611482164391777335179e-02), PetscRealConstant(4.01215375858374938851783560822266506e-01), PetscRealConstant(5.70190512270035113070753541546662661e-03),
                                                       PetscRealConstant(4.94298094877299648869292464584533386e-01), PetscRealConstant(1.23120654974722356763782092214326742e-01), PetscRealConstant(2.64283437041718404668972836724373412e-02),
                                                       PetscRealConstant(7.27330346346383446005538531898909154e-01), PetscRealConstant(1.30038704855902367272099110040749027e-02), PetscRealConstant(1.70228073489264195767892943660134601e-01),
                                                       PetscRealConstant(8.03764185539555330777687234331715645e-01), PetscRealConstant(4.29354011719257392825603328584366854e-02), PetscRealConstant(2.95869387867032733404046195430771234e-01),
                                                       PetscRealConstant(6.18259809789115788030833138852355371e-01), PetscRealConstant(1.84424032047077767070452189644621614e-01), PetscRealConstant(9.12518190501428550081988686666400785e-02),
                                                       PetscRealConstant(5.39900116855701610850896752044116705e-01), PetscRealConstant(2.59169407464282648766059239269821351e-01), PetscRealConstant(2.62258654494751776134361354176169777e-02),
                                                       PetscRealConstant(4.55435319621959524854445386042740344e-01), PetscRealConstant(1.09775723659603060543295313946685958e-02), PetscRealConstant(5.35142000931459522849860509672867270e-01),
                                                       PetscRealConstant(1.12428560506761202459884472563621395e-01), PetscRealConstant(3.41451866195818968635925486368842690e-01)};

static const PetscReal PetscDTJSTetQuad_12_weights[] = {PetscRealConstant(2.34865540467100858061699997511519266e-02), PetscRealConstant(1.11349812445769958948485730885835810e-02), PetscRealConstant(2.37009589422591892905674108399882628e-02),
                                                        PetscRealConstant(1.35573658634295275430715278207959391e-02), PetscRealConstant(2.09872000319384457003784701431714745e-02), PetscRealConstant(2.01504152781904987944926544579769160e-03),
                                                        PetscRealConstant(1.16354265166474762147831354093581784e-03), PetscRealConstant(4.95051021527670456637523525477225238e-03), PetscRealConstant(3.14441900763650101945421916624314571e-03),
                                                        PetscRealConstant(5.98779604836226689777135644736997094e-03), PetscRealConstant(1.00661547318660254640630773456414107e-02), PetscRealConstant(2.46735278542358964260472868191281824e-03),
                                                        PetscRealConstant(1.30409381092721335316110462724777536e-02)};

static const PetscReal PetscDTJSTetQuad_12_orbits[] = {PetscRealConstant(2.13567994453301807730812961261982714e-01), PetscRealConstant(3.59296016640094576807561116214051859e-01), PetscRealConstant(8.08046995114734267380313311061391698e-02),
                                                       PetscRealConstant(7.57585901465579719785906006681582503e-01), PetscRealConstant(1.46089468527548534551522307943445217e-01), PetscRealConstant(5.61731594417354396345433076169664350e-01),
                                                       PetscRealConstant(6.40653770377988894682561229535949465e-02), PetscRealConstant(4.35934622962201110531743877046405066e-01), PetscRealConstant(1.27618304924601696389036090397308075e-01),
                                                       PetscRealConstant(3.72381695075398303610963909602691949e-01), PetscRealConstant(1.48147260674486495091545260163904669e-02), PetscRealConstant(2.76335370592957338059810474835788792e-01),
                                                       PetscRealConstant(6.94035177272145362921880473131430268e-01), PetscRealConstant(4.40679196756297958782695052431132130e-02), PetscRealConstant(5.78794387572494194848851423799238722e-04),
                                                       PetscRealConstant(9.11285366261167914048612138089974380e-01), PetscRealConstant(2.90048145551581954138829364951296073e-02), PetscRealConstant(1.49206534416718043128111887894580079e-01),
                                                       PetscRealConstant(7.92783836472965566044122239115160713e-01), PetscRealConstant(1.38412578801503596807210409364542654e-01), PetscRealConstant(1.44300697841704428868659684353294329e-03),
                                                       PetscRealConstant(7.21731835418575762096892584427381699e-01), PetscRealConstant(2.00268515666176705574924365215440301e-01), PetscRealConstant(1.15518352710014202501522112132873185e-02),
                                                       PetscRealConstant(3.42224047493723656914492380996241432e-01), PetscRealConstant(4.45955601569098217260431042575030957e-01), PetscRealConstant(2.54592045025154039512026671565452244e-01),
                                                       PetscRealConstant(7.29586319508262648615172545251039233e-02), PetscRealConstant(2.49516036359566065386874792626106153e-01), PetscRealConstant(4.22933286664453630239581281283337680e-01),
                                                       PetscRealConstant(3.93733865998405343741702908672717771e-01), PetscRealConstant(5.00181076151871020316060572619412013e-02), PetscRealConstant(2.39825470053956629529520808871593449e-03),
                                                       PetscRealConstant(5.53849771685867987931395825976625086e-01), PetscRealConstant(3.60873566665786373397454756288212742e-02), PetscRealConstant(2.51836782427111630726648434585676718e-01),
                                                       PetscRealConstant(1.13527231851907693272036544243703473e-01), PetscRealConstant(5.98548629054402038661569545541798601e-01)};

static const PetscReal PetscDTJSTetQuad_13_weights[] = {PetscRealConstant(1.14752237188552949009410130283608015e-03), PetscRealConstant(3.01431024236522929348773086557555489e-02), PetscRealConstant(1.29067164357852247584634418570865064e-02),
                                                        PetscRealConstant(9.56125376743033278508257118623976663e-03), PetscRealConstant(1.03798279723738678334111356072584738e-02), PetscRealConstant(6.82702864228816359452037208645418780e-04),
                                                        PetscRealConstant(1.18403628952306290720884790054052813e-02), PetscRealConstant(1.41619303873249891877010582452540688e-02), PetscRealConstant(7.83078577599447560353614564964616929e-03),
                                                        PetscRealConstant(1.23140471967413533842576962198085700e-02), PetscRealConstant(1.94230961055536304598844396294018138e-02), PetscRealConstant(3.54498648289785324449084770011726154e-03),
                                                        PetscRealConstant(4.29580370000235101354651138744464983e-03), PetscRealConstant(1.95227565480532059433123350748907002e-03), PetscRealConstant(3.02447323660018409539644706484296068e-03)};

static const PetscReal PetscDTJSTetQuad_13_orbits[] = {PetscRealConstant(2.02381678618097417199449373092872560e-02), PetscRealConstant(9.39285496414570774840165188072138235e-01), PetscRealConstant(2.89014735243526358108710236241785734e-01),
                                                       PetscRealConstant(1.32955794269420925673869291274642845e-01), PetscRealConstant(9.40287000821270704314641363984251393e-02), PetscRealConstant(7.17913899753618788705607590804724546e-01),
                                                       PetscRealConstant(1.97649854443725526440402195712018141e-01), PetscRealConstant(4.07050436668823420678793412863945602e-01), PetscRealConstant(4.04618967601836352613810419234450368e-02),
                                                       PetscRealConstant(4.59538103239816364738618958076554951e-01), PetscRealConstant(1.95148030644273542724719012608262279e-07), PetscRealConstant(4.99999804851969355726457275280987372e-01),
                                                       PetscRealConstant(6.75292649528024245298513076286528660e-02), PetscRealConstant(2.53044339890101707805162013978367153e-01), PetscRealConstant(6.11897130204293443135135370764327139e-01),
                                                       PetscRealConstant(1.36010514513202922608246268159525358e-01), PetscRealConstant(2.41148137093778224284305420761333205e-01), PetscRealConstant(4.86830833879815930499202042919616080e-01),
                                                       PetscRealConstant(2.78078345956370142681109982945460348e-01), PetscRealConstant(1.64647000523597211647006601553845326e-02), PetscRealConstant(4.27378608034899993473079373953694801e-01),
                                                       PetscRealConstant(1.96755019719286091705714891775106790e-01), PetscRealConstant(3.97370924646293509165094445105553891e-02), PetscRealConstant(5.66752868096798465672060771939231054e-01),
                                                       PetscRealConstant(3.86249862920349680910358878735096458e-01), PetscRealConstant(6.20197072419754249349933198659918753e-02), PetscRealConstant(1.65480566917325213244288922663815178e-01),
                                                       PetscRealConstant(2.35355190546527723661435331661532879e-02), PetscRealConstant(1.08660782083319879217019301192209607e-01), PetscRealConstant(8.44268179807374576050693632475483787e-01),
                                                       PetscRealConstant(5.44696497701916184414943626581518664e-01), PetscRealConstant(3.36210893074771947547195040242991110e-01), PetscRealConstant(3.50005986987981917775825658469054348e-03),
                                                       PetscRealConstant(1.15592549353432048860103076590799683e-01), PetscRealConstant(2.88616049407555045327589927600465483e-02), PetscRealConstant(6.85981630123515206927942029949330018e-01),
                                                       PetscRealConstant(1.05734346867289013307953540767985825e-02), PetscRealConstant(2.74583330249000387208503623213824856e-01), PetscRealConstant(1.54586646827380445511120238409928533e-01),
                                                       PetscRealConstant(7.35677246781859786541124837652850275e-01), PetscRealConstant(9.87023928216723348424135874422639998e-02), PetscRealConstant(1.10337135690874331053413364949572007e-02)};

static const PetscReal PetscDTJSTetQuad_14_weights[] = {PetscRealConstant(4.59391073376451758409377745552298574e-03), PetscRealConstant(3.49500702916066235281590992447064970e-03), PetscRealConstant(1.47651098919133681900026119295001588e-04),
                                                        PetscRealConstant(1.33714471632984070867978872987752359e-02), PetscRealConstant(9.05387794374588303108004923730133336e-03), PetscRealConstant(9.49086445586571419227190141035947529e-03),
                                                        PetscRealConstant(1.41340305941873464073605043272345276e-03), PetscRealConstant(1.82264413266411865508348442072625302e-02), PetscRealConstant(3.58765479290154033770331742232473897e-03),
                                                        PetscRealConstant(1.35528016344569898606577876966509338e-02), PetscRealConstant(1.80591995169698631038589870899996670e-02), PetscRealConstant(6.16445339689305403251469060107178069e-03),
                                                        PetscRealConstant(1.11086646032977339670705743800807424e-03), PetscRealConstant(9.65372901447633247653953716171050369e-03), PetscRealConstant(1.16690770799707707222301100322526282e-03),
                                                        PetscRealConstant(9.56338202413125003270838175728835864e-03), PetscRealConstant(5.71580845705437494121324412364308500e-03), PetscRealConstant(1.30100368553425259826656765419746344e-03),
                                                        PetscRealConstant(5.01058173302229544013612852605781050e-03)};

static const PetscReal PetscDTJSTetQuad_14_orbits[] = {PetscRealConstant(3.29815151784619308848524983559176420e-01), PetscRealConstant(1.05545446461420734544250493224707512e-02), PetscRealConstant(5.75382826897592025046227006486805949e-02),
                                                       PetscRealConstant(8.27385151930722392486131898053958185e-01), PetscRealConstant(5.85616861378350418958770770071940938e-03), PetscRealConstant(9.82431494158649487431236876897841755e-01),
                                                       PetscRealConstant(1.60555475847956640177434156561711819e-01), PetscRealConstant(5.18333572456130079467697530314864494e-01), PetscRealConstant(9.87396460740490867109647502032049088e-02),
                                                       PetscRealConstant(7.03781061777852739867105749390385261e-01), PetscRealConstant(2.08053196159726508005405227339905591e-01), PetscRealConstant(3.75840411520820475983784317980283202e-01),
                                                       PetscRealConstant(9.75202881222352376804435727060098529e-03), PetscRealConstant(4.90247971187776476231955642729399001e-01), PetscRealConstant(1.02939400115532590640058259441029175e-01),
                                                       PetscRealConstant(3.97060599884467409359941740558970825e-01), PetscRealConstant(3.79134634612151350082921714398731739e-02), PetscRealConstant(4.62086536538784864991707828560126844e-01),
                                                       PetscRealConstant(1.81426423816139620476309543821671173e-01), PetscRealConstant(3.18573576183860379523690456178328803e-01), PetscRealConstant(2.49909218863499831840327185899541446e-01),
                                                       PetscRealConstant(8.12427834353333738352121867712103187e-02), PetscRealConstant(4.18938778837666962484133441429706813e-01), PetscRealConstant(2.13263378061875731401306162829162301e-01),
                                                       PetscRealConstant(1.05965636264648208610107775651540981e-02), PetscRealConstant(5.62876680249783716336376896776521271e-01), PetscRealConstant(4.91812849401590528388203038538198451e-02),
                                                       PetscRealConstant(6.16845740566568984081206879400875527e-03), PetscRealConstant(8.95468972714016204481547323498351521e-01), PetscRealConstant(3.92862617970060138172363596564325800e-01),
                                                       PetscRealConstant(2.06635789296734658096357279018520239e-02), PetscRealConstant(1.93611185130206257845637078969496355e-01), PetscRealConstant(1.26176055325707094152972047972164324e-02),
                                                       PetscRealConstant(1.26902202407495768830569476700796608e-01), PetscRealConstant(8.47862586527362812338836113704770509e-01), PetscRealConstant(6.21400031176215310837594872604645842e-02),
                                                       PetscRealConstant(1.21618784348698988590981932760934538e-01), PetscRealConstant(5.76740617455094747867520921100667515e-01), PetscRealConstant(2.39500595078584732457737658877933375e-01),
                                                       PetscRealConstant(5.51794132118424634604427352763911049e-01), PetscRealConstant(3.48902296047024577218939682868824120e-01), PetscRealConstant(1.55221192232078715443159741457229829e-02),
                                                       PetscRealConstant(8.37814526113429166323169902215418675e-02), PetscRealConstant(1.78416406476545638547472567510741520e-02), PetscRealConstant(6.82238320168289338991076847310460225e-01),
                                                       PetscRealConstant(1.54792973131724710894712237050428727e-02), PetscRealConstant(2.84440741870883626064704672233422772e-01), PetscRealConstant(1.69539550700162253299539782400334502e-01),
                                                       PetscRealConstant(7.33998298658581071729530871867294952e-01), PetscRealConstant(1.77766027701427814331989704393484815e-02), PetscRealConstant(7.86855478711138935377303752930220944e-02)};

static const PetscReal PetscDTJSTetQuad_15_weights[] = {PetscRealConstant(6.81603969527324674012049544461426660e-04), PetscRealConstant(2.16098745603021041748403812419205609e-02), PetscRealConstant(2.07010480272175159030115796107577354e-02),
                                                        PetscRealConstant(1.62534701330056178033466254741417238e-03), PetscRealConstant(1.12971504708345545700906350994211498e-02), PetscRealConstant(2.39671240720764408194724052256353344e-03),
                                                        PetscRealConstant(1.09306869610134143960926453996215076e-03), PetscRealConstant(1.02423670299640157746790405994564388e-02), PetscRealConstant(5.97313384769970746396572269552465539e-03),
                                                        PetscRealConstant(7.48706481117913973338206913508543903e-03), PetscRealConstant(2.35960491439638664409521202642959545e-03), PetscRealConstant(1.50818443891602950415016251373361180e-03),
                                                        PetscRealConstant(1.12066578767699825196447482243425849e-03), PetscRealConstant(4.01595814320357938894741355506927957e-03), PetscRealConstant(6.77923910336355752631672912971601735e-03),
                                                        PetscRealConstant(9.51917830400532762527222599185739096e-03), PetscRealConstant(4.50473409097239278253232426596562669e-03), PetscRealConstant(2.93557437026861636128262437270301393e-03)};

static const PetscReal PetscDTJSTetQuad_15_orbits[] = {PetscRealConstant(1.69264215854722024114693024482665889e-02), PetscRealConstant(9.49220735243583392765592092655200209e-01), PetscRealConstant(2.83677925459572216187443720552609570e-01),
                                                       PetscRealConstant(1.48966223621283351437668838342171216e-01), PetscRealConstant(1.82198413997585852094486974715777590e-01), PetscRealConstant(4.53404758007242443716539075852667254e-01),
                                                       PetscRealConstant(1.45080051521845932816751102831273102e-02), PetscRealConstant(4.85491994847815406718324889716872714e-01), PetscRealConstant(1.42744143765856384872335148932243614e-01),
                                                       PetscRealConstant(3.57255856234143615127664851067756362e-01), PetscRealConstant(7.32172725619535350291242043189978828e-02), PetscRealConstant(7.69297055027926052278379654336939516e-02),
                                                       PetscRealConstant(7.76635749373300324713913625928310319e-01), PetscRealConstant(1.05655841048969891822346283835111870e-02), PetscRealConstant(2.22560655492434425795931648965691828e-01),
                                                       PetscRealConstant(7.56308176297771595839599094267285825e-01), PetscRealConstant(2.63797262668814663983594456612664749e-01), PetscRealConstant(5.57502224056597334385440242278166699e-02),
                                                       PetscRealConstant(4.16655252256710938594267062546853849e-01), PetscRealConstant(4.35490270299381726355942518324652052e-01), PetscRealConstant(1.77285326957036600496044721336236293e-02),
                                                       PetscRealConstant(1.11290926705532887238510491217072272e-01), PetscRealConstant(5.34725936418519328792030580085961408e-02), PetscRealConstant(3.48168280418735794075311324829971552e-01),
                                                       PetscRealConstant(5.44886532297560340166282559152836178e-01), PetscRealConstant(1.10530893958010027688940184304701867e-01), PetscRealConstant(9.46783414343936980608186659112342553e-03),
                                                       PetscRealConstant(7.69470377940540574816037764799472831e-01), PetscRealConstant(6.03093644077098648939697189103067287e-01), PetscRealConstant(4.10467051499107569632575859648805894e-02),
                                                       PetscRealConstant(3.53530726357509192130285439216570513e-01), PetscRealConstant(2.32892441548140196675978571548158340e-03), PetscRealConstant(2.93931933291708226330282107476917007e-02),
                                                       PetscRealConstant(9.20166732769525838290672375910482253e-02), PetscRealConstant(1.13255282696951232870378459957684219e-02), PetscRealConstant(8.67264605124181470250866705665491645e-01),
                                                       PetscRealConstant(7.07781487315597092657777317914365393e-01), PetscRealConstant(6.82262786800005214548121102599371966e-02), PetscRealConstant(2.01985796445785768379531613362804542e-01),
                                                       PetscRealConstant(2.20064375586166175078789584628928285e-02), PetscRealConstant(1.29580959767453386269647343026374211e-01), PetscRealConstant(1.89001555638617622410692369563993229e-01),
                                                       PetscRealConstant(6.13342154805922613834174867320733891e-01), PetscRealConstant(6.80753297880063774854854200888987170e-02), PetscRealConstant(4.69533300366267565556904669685107925e-01),
                                                       PetscRealConstant(3.05479966390601158178507145113897735e-01), PetscRealConstant(1.52471890009439790640408420236028178e-01), PetscRealConstant(7.25148432336914856241797649649661749e-02),
                                                       PetscRealConstant(5.77834626148275250558259263447902135e-01), PetscRealConstant(1.50914550082510530182667753200720545e-01), PetscRealConstant(2.60123083456407957555062857020538915e-01),
                                                       PetscRealConstant(1.11277403128062617040101263308383829e-02), PetscRealConstant(1.08219475368229327185066518743068468e-02), PetscRealConstant(3.36845065854764539406910256036738736e-01),
                                                       PetscRealConstant(2.34726033744109148278713227671302616e-01), PetscRealConstant(4.17606952864303379595869864417651806e-01)};

static const PetscReal PetscDTJSTetQuad_16_weights[] = {PetscRealConstant(5.37983858298516065686719468294245522e-03), PetscRealConstant(7.01790401073017132825545888807946098e-03), PetscRealConstant(1.43818547581035176366336380916732155e-02),
                                                        PetscRealConstant(2.52312003870799578966140525224535586e-03), PetscRealConstant(8.01934800400061160866756561201755553e-03), PetscRealConstant(1.15895883104973641696977979725414697e-02),
                                                        PetscRealConstant(4.67683104771332367545742678835934677e-03), PetscRealConstant(1.58488303109226409590587935665238239e-03), PetscRealConstant(5.79363375262222334485439755015268097e-03),
                                                        PetscRealConstant(3.54758209360422138352864816025589588e-03), PetscRealConstant(7.40423240283201788637846286488232573e-03), PetscRealConstant(2.04190854052774359959081195178396806e-04),
                                                        PetscRealConstant(2.97493884895423905155052722787918684e-03), PetscRealConstant(3.29650287499995980199546256410421923e-03), PetscRealConstant(8.79483052242390009169213030816965101e-03),
                                                        PetscRealConstant(8.00579875692989547830255457875478979e-04), PetscRealConstant(2.98977466250203656599586014642844275e-03), PetscRealConstant(1.09925631499624496998061463361878010e-03),
                                                        PetscRealConstant(5.85068778035721379175144888779587459e-03), PetscRealConstant(4.60570456765461642971619512172602468e-03), PetscRealConstant(5.23905263111409427794875314886047295e-03)};

static const PetscReal PetscDTJSTetQuad_16_orbits[] =
  {PetscRealConstant(3.29671473844060636193751622580311945e-01), PetscRealConstant(1.09855784678180914187451322590641180e-02), PetscRealConstant(1.12042104417378775579773552690857854e-01), PetscRealConstant(6.63873686747863673260679341927426498e-01),
   PetscRealConstant(2.80446025911092919173269687593749234e-01), PetscRealConstant(1.58661922266721242480190937218752321e-01), PetscRealConstant(3.94216444407616553018604131519433598e-02), PetscRealConstant(8.81735066677715034094418760544169945e-01),
   PetscRealConstant(7.49174185647675533193688765333785751e-02), PetscRealConstant(4.25082581435232446680631123466621425e-01), PetscRealConstant(1.64306897044365418515506116469900899e-01), PetscRealConstant(3.35693102955634581484493883530099101e-01),
   PetscRealConstant(4.90489875955667485170883668175519881e-02), PetscRealConstant(1.37214957228686101682297411143919227e-01), PetscRealConstant(7.64687067580180401283525855220976761e-01), PetscRealConstant(1.41260956830925339702338373039404428e-02),
   PetscRealConstant(2.32826804589425112895375012098521515e-01), PetscRealConstant(7.38921004044389819164157313293597570e-01), PetscRealConstant(6.23965205815432520865836574743627860e-02), PetscRealConstant(2.83241768307794686435655855044289852e-01),
   PetscRealConstant(5.91965190529118809391176830006984552e-01), PetscRealConstant(1.89095927569655977172247906006888765e-01), PetscRealConstant(1.28318740561182397007459320483039105e-02), PetscRealConstant(6.08976270804569805954758255937918576e-01),
   PetscRealConstant(2.75017600129544394870944330066281040e-01), PetscRealConstant(6.26938394214209016285570062626671607e-02), PetscRealConstant(3.87270960319490308629554333604770746e-01), PetscRealConstant(5.94489825256994551853672034278369085e-03),
   PetscRealConstant(3.72380593552354195475909098838604519e-02), PetscRealConstant(9.50872144139624689415335649430572178e-01), PetscRealConstant(1.18305807109994448023392273944827512e-01), PetscRealConstant(1.50942779491252284768085276904508511e-02),
   PetscRealConstant(7.48294107830885875476406924419894130e-01), PetscRealConstant(5.14635788788839503895574594393029037e-01), PetscRealConstant(8.01184612787250238048953852942912269e-02), PetscRealConstant(1.44436385136434173930382055768828157e-02),
   PetscRealConstant(3.90802111418792054906491814735796944e-01), PetscRealConstant(1.64573946837909856183654970811126247e-01), PetscRealConstant(3.10258549862727268546901994976003684e-01), PetscRealConstant(4.55216570069729186142325278547917771e-01),
   PetscRealConstant(6.99509332296336891271177556649522972e-02), PetscRealConstant(3.43586795014569576206991867406424949e-02), PetscRealConstant(1.08524080192898466764968597936310465e-01), PetscRealConstant(1.40154108506938346032777067732054494e-03),
   PetscRealConstant(8.55715699220575192154004444645726512e-01), PetscRealConstant(6.62531754485050930037006176614661627e-01), PetscRealConstant(2.48382498781495463293299396966356759e-01), PetscRealConstant(7.81025122458046022289548759571971950e-02),
   PetscRealConstant(1.09832344876490044407395504617843730e-02), PetscRealConstant(1.22689867800651884608501727445489081e-02), PetscRealConstant(3.96009121106703506298652333120052910e-01), PetscRealConstant(5.72940017617256207895076144067416494e-01),
   PetscRealConstant(1.87818744959750973454213500679816337e-02), PetscRealConstant(2.05460499132410512839593327986067141e-01), PetscRealConstant(6.36751619713730578761088065954736337e-02), PetscRealConstant(5.94619388007626904069056845456544433e-01),
   PetscRealConstant(1.36244950888589525215241019961914792e-01), PetscRealConstant(4.61067886079699428376878699683390460e-01), PetscRealConstant(1.75765046613910440614890565392664764e-01), PetscRealConstant(2.24413496345164821823661495612930269e-01),
   PetscRealConstant(1.38753570961225309184569239311014507e-01), PetscRealConstant(1.34478861029962906737425241719206151e-02), PetscRealConstant(4.77994253200670436360833070188359530e-01), PetscRealConstant(1.86418030042433712123975601553312469e-01),
   PetscRealConstant(3.22139830653899560841448804086407395e-01)};

static const PetscReal PetscDTJSTetQuad_17_weights[] = {PetscRealConstant(3.92454807291020635287068500512549058e-03), PetscRealConstant(6.42833941617463128015615519766899742e-04), PetscRealConstant(2.17788250978129430320991838278864163e-03),
                                                        PetscRealConstant(1.19163473929786227377591966682573909e-02), PetscRealConstant(4.71904138817525899126080399466511116e-03), PetscRealConstant(6.83716903349721752993856814496422544e-03),
                                                        PetscRealConstant(1.13412822743688746017401894786783238e-02), PetscRealConstant(1.81600141275345280330003807292572450e-03), PetscRealConstant(2.60360479293211051515953601951756666e-03),
                                                        PetscRealConstant(4.73664311026954100325339431398530867e-03), PetscRealConstant(6.31338382945050780134318392527540712e-03), PetscRealConstant(5.43493873669837423604083530292048025e-03),
                                                        PetscRealConstant(5.86385282138478766948340764490320481e-03), PetscRealConstant(1.08798872240526394989841483352133520e-03), PetscRealConstant(8.58256987114192099617237200085605976e-03),
                                                        PetscRealConstant(3.05458270663763250711743786914902538e-04), PetscRealConstant(4.25166225893997341796907353700757907e-03), PetscRealConstant(2.65502167995983810832455836329564492e-03),
                                                        PetscRealConstant(1.61326218249170774020753272387088405e-03), PetscRealConstant(3.92455730957853635090325212287525342e-03), PetscRealConstant(4.60545940641408535071076811381229105e-03),
                                                        PetscRealConstant(1.09881805530367614177425912739790242e-03), PetscRealConstant(1.84472317089358017346884924224286164e-03), PetscRealConstant(2.37526031456871745889131726835882546e-03),
                                                        PetscRealConstant(9.29242180133520251771241888623088154e-04), PetscRealConstant(7.63051786918880715761866017049646418e-03)};

static const PetscReal PetscDTJSTetQuad_17_orbits[] =
  {PetscRealConstant(1.09259411039139984302043019733651131e-01), PetscRealConstant(6.72221766882580047093870940799046644e-01), PetscRealConstant(1.70690533535099073523365856317209262e-02), PetscRealConstant(9.48792839939470277942990243104837176e-01),
   PetscRealConstant(6.03027644020867104114830058999256340e-02), PetscRealConstant(8.19091706793739868765550982300223080e-01), PetscRealConstant(1.80293677875248739642214391580291968e-01), PetscRealConstant(4.59118966374253781073356825259124120e-01),
   PetscRealConstant(2.07564249431992277088131545289347396e-01), PetscRealConstant(2.92435750568007722911868454710652580e-01), PetscRealConstant(6.35056187503617908531182081563440964e-02), PetscRealConstant(4.36494381249638209146881791843655916e-01),
   PetscRealConstant(1.42574094856983420921732006955251431e-01), PetscRealConstant(3.57425905143016579078267993044748594e-01), PetscRealConstant(1.52549896113581813718837868519469386e-02), PetscRealConstant(4.84745010388641818628116213148053043e-01),
   PetscRealConstant(2.81771746866182357500252130725188173e-01), PetscRealConstant(6.60562854593635408136647911947503545e-03), PetscRealConstant(4.29850877721698930918129259430148647e-01), PetscRealConstant(2.53279289661639381651196222608156324e-01),
   PetscRealConstant(1.46133745149742367958633916541105398e-01), PetscRealConstant(3.47307675526978868738973638242581905e-01), PetscRealConstant(1.19444683688799187246927678400752263e-01), PetscRealConstant(2.48147439408871188408747169111797980e-01),
   PetscRealConstant(5.12963193213530437097397474086697519e-01), PetscRealConstant(2.79697589217997761509484379702302820e-01), PetscRealConstant(3.65913065508665815096340370057012557e-02), PetscRealConstant(4.04013515013137895471397203589693165e-01),
   PetscRealConstant(5.91496500175591599981637713259445673e-02), PetscRealConstant(2.77150576803797882577406048917849418e-01), PetscRealConstant(6.04550123161083797426266408430261508e-01), PetscRealConstant(1.15664568797203920839153043400172301e-02),
   PetscRealConstant(3.37269323171396242558193990530211607e-01), PetscRealConstant(6.39597763069162973273975400789753960e-01), PetscRealConstant(2.54620094611861869597041610759358648e-01), PetscRealConstant(8.89921351196739032506975020657532138e-02),
   PetscRealConstant(4.01767675656602357555219276415529490e-01), PetscRealConstant(6.67291467786515853481064175679727188e-03), PetscRealConstant(8.33537700079728187021689887625021596e-02), PetscRealConstant(9.03300400636296864228209727723903279e-01),
   PetscRealConstant(5.95499636617362931095966623243527890e-02), PetscRealConstant(1.48873851460922566581649227631700344e-01), PetscRealConstant(7.32026221215604847199157447719594126e-01), PetscRealConstant(1.30804747131275973962074180251712376e-02),
   PetscRealConstant(9.56382942582894850917862638637074022e-02), PetscRealConstant(7.22931924610352705332786921047595817e-01), PetscRealConstant(1.68349306418230212179219397063525543e-01), PetscRealConstant(6.37655199341625239220695843087608842e-01),
   PetscRealConstant(6.03575153489387061494404457930833709e-02), PetscRealConstant(2.91364822313521822814437810086162517e-01), PetscRealConstant(1.06224629959142318154259010331452341e-02), PetscRealConstant(1.57506282408458374650048197748242449e-01),
   PetscRealConstant(5.72062966275327131865005559707619715e-01), PetscRealConstant(2.57535292518231455592465004725364003e-01), PetscRealConstant(1.28954587979830378924812378187737880e-02), PetscRealConstant(1.53096361222136753910831093649897460e-01),
   PetscRealConstant(5.98287161849954766885524105300981952e-01), PetscRealConstant(1.83725825608845276310314763040883026e-01), PetscRealConstant(6.48906513190632028933300380082375987e-02), PetscRealConstant(1.16550029704661223269551829881750465e-02),
   PetscRealConstant(8.72107792177225262258052443349678401e-02), PetscRealConstant(8.54056555574275557733965872116728726e-01), PetscRealConstant(4.70776622375357937132737005601283448e-02), PetscRealConstant(4.08532891016325614939977440036029953e-01),
   PetscRealConstant(4.13779968066191413674386054800463366e-01), PetscRealConstant(1.67207047717348825679077183741382743e-01), PetscRealConstant(1.04800932001341457065593214221239307e-02), PetscRealConstant(1.16793229924696388898229416445102637e-02),
   PetscRealConstant(3.90498958371942481846400324075089620e-01), PetscRealConstant(5.24215761942841459574125661835269028e-01), PetscRealConstant(7.36059566927464196896510724451310638e-02), PetscRealConstant(8.16368037123298165733860303389829971e-03),
   PetscRealConstant(7.73501740353471737894496040022555450e-01), PetscRealConstant(1.92880269650995401939670660384949598e-01), PetscRealConstant(2.54543096242998785084946965585966962e-02), PetscRealConstant(1.52988605503175154201768692204077682e-01),
   PetscRealConstant(5.60344049440815807627973687713152887e-02), PetscRealConstant(4.68278342626738936678030275406308819e-01), PetscRealConstant(3.22698646926004328357403663618298180e-01)};

static const PetscReal PetscDTJSTetQuad_18_weights[] = {PetscRealConstant(2.00718454233412734585333873200980135e-03), PetscRealConstant(9.60192204203791513646045766720456382e-03), PetscRealConstant(7.73573497825975279102564028073218421e-03),
                                                        PetscRealConstant(3.28678452379972103845344250277754384e-03), PetscRealConstant(1.09803614121466941816876524827349394e-03), PetscRealConstant(3.19487119443327947117224180014250563e-03),
                                                        PetscRealConstant(2.21603538408327051895500004151987826e-04), PetscRealConstant(6.33016880917855674128541322937397793e-05), PetscRealConstant(7.53994720556774010727096301414648990e-04),
                                                        PetscRealConstant(1.50219313011679751736505707116377572e-03), PetscRealConstant(1.79766153584026752798334633866299180e-03), PetscRealConstant(4.87609212890357716002236743630256898e-04),
                                                        PetscRealConstant(7.80422932342015197384087130434560645e-03), PetscRealConstant(2.60892137976190709177225018215589344e-03), PetscRealConstant(2.23099233623871920277033984267996366e-03),
                                                        PetscRealConstant(2.24587996416751252032385672787904845e-03), PetscRealConstant(1.26529773746282001630056191896357585e-03), PetscRealConstant(1.38544418124220362587605743809290549e-03),
                                                        PetscRealConstant(3.82474443232046390144486763547925828e-03), PetscRealConstant(4.89627037942950920504298401495130139e-03), PetscRealConstant(6.32954072879515135993141774989511026e-03),
                                                        PetscRealConstant(5.53451210428396213060302101936547872e-04), PetscRealConstant(3.33998682966357704881077198864956744e-03), PetscRealConstant(3.50655950361365020580246511273718923e-04),
                                                        PetscRealConstant(6.98393175819423166236980122430572121e-03), PetscRealConstant(1.27073564606703982731753399386491947e-03), PetscRealConstant(5.89877266403739242346120108150288171e-04),
                                                        PetscRealConstant(2.34157201123058436021423461999722627e-03), PetscRealConstant(3.24568917566687135820896881100435406e-03), PetscRealConstant(5.24868262125092391200806866888722257e-03),
                                                        PetscRealConstant(4.26638835880860884098162663404984899e-03), PetscRealConstant(5.06348041621166422659884590181532283e-03), PetscRealConstant(1.99458475017464140682155779640557756e-03),
                                                        PetscRealConstant(2.27199490829963298729770198941246681e-03), PetscRealConstant(4.83836682359874524608371935795288556e-03)};

static const PetscReal PetscDTJSTetQuad_18_orbits[] = {PetscRealConstant(2.06372181868120948318749944658600794e-01), PetscRealConstant(3.80883454395637155043750166024197641e-01), PetscRealConstant(1.62538794517640625068345357852045374e-01),
                                                       PetscRealConstant(5.12383616447078124794963926443863854e-01), PetscRealConstant(3.11626672825564289121982402923065739e-01), PetscRealConstant(6.51199815233071326340527912308027833e-02),
                                                       PetscRealConstant(3.30727916089031298440338109131745273e-01), PetscRealConstant(7.81625173290610467898567260476418059e-03), PetscRealConstant(3.37440820129950571884063917764807398e-02),
                                                       PetscRealConstant(8.98767753961014828434780824670557763e-01), PetscRealConstant(6.56813827842595411494079855233697355e-02), PetscRealConstant(8.02955851647221376551776043429890769e-01),
                                                       PetscRealConstant(1.16907242025971055247642972840050157e-02), PetscRealConstant(9.64927827392208683425707108147984968e-01), PetscRealConstant(1.94827085878520612152970036564656267e-01),
                                                       PetscRealConstant(3.05172914121479387847029963435343757e-01), PetscRealConstant(2.49817165341539947084005729389439354e-01), PetscRealConstant(2.50182834658460052915994270610560646e-01),
                                                       PetscRealConstant(1.33665229160562022806248448565313267e-02), PetscRealConstant(4.86633477083943797719375155143468664e-01), PetscRealConstant(2.49657656424114477442724513903074587e-01),
                                                       PetscRealConstant(2.50342343575885522557275486096925413e-01), PetscRealConstant(1.67548227745716064859051710377451748e-01), PetscRealConstant(3.32451772254283935140948289622548252e-01),
                                                       PetscRealConstant(1.67106402529453412004353369052872711e-01), PetscRealConstant(3.32893597470546587995646630947127289e-01), PetscRealConstant(1.05388998294129321240897436423353629e-01),
                                                       PetscRealConstant(3.94611001705870678759102563576646383e-01), PetscRealConstant(4.31772194136649418698291013081583722e-02), PetscRealConstant(4.56822780586335058130170898691841610e-01),
                                                       PetscRealConstant(3.31030676150442848293514333853143953e-02), PetscRealConstant(1.35275402130320086969094363421509184e-01), PetscRealConstant(7.98518462639591343372202769807862013e-01),
                                                       PetscRealConstant(1.94618578446767468622182415178971493e-01), PetscRealConstant(1.17187904704725294876226187321644666e-03), PetscRealConstant(6.09590964059417809806872907768840517e-01),
                                                       PetscRealConstant(1.32125212613111817485653979416452392e-02), PetscRealConstant(3.27896009814950325809839076206830607e-01), PetscRealConstant(6.45678947662427310693030127909878932e-01),
                                                       PetscRealConstant(1.22932072177059829730546772543971588e-01), PetscRealConstant(2.02839984315216983530532901543870647e-02), PetscRealConstant(7.33851857214358642185853164757669780e-01),
                                                       PetscRealConstant(6.19950609516837954943448529245469513e-02), PetscRealConstant(3.49896121962365311408820467809851079e-01), PetscRealConstant(5.26113756134267097602489826341054982e-01),
                                                       PetscRealConstant(8.40718754699169784473444514148846608e-02), PetscRealConstant(1.66683079695292380987655232932083465e-01), PetscRealConstant(6.65173169364873662117655864238147237e-01),
                                                       PetscRealConstant(7.86704887445389128372700669340646566e-03), PetscRealConstant(1.85917959122875153929739152036837755e-01), PetscRealConstant(7.98347943128217063502806834576349319e-01),
                                                       PetscRealConstant(4.21758249887123601697121963274899851e-02), PetscRealConstant(2.48270741150311715949928293233688308e-01), PetscRealConstant(6.67377608872263563710647314111331734e-01),
                                                       PetscRealConstant(8.68349187213883954904996522992908484e-03), PetscRealConstant(6.69810222676876433374571674830739906e-02), PetscRealConstant(9.15651993988034677564442902057067801e-01),
                                                       PetscRealConstant(1.11118536757620823976982383638687763e-01), PetscRealConstant(2.91841707798116234861810178091825384e-01), PetscRealConstant(4.85921218686642117184225054630799090e-01),
                                                       PetscRealConstant(6.37707896451840583443498386534063693e-02), PetscRealConstant(3.68546384560602231072732004278588595e-03), PetscRealConstant(7.16345464707679716112809071699034590e-01),
                                                       PetscRealConstant(2.16198281801530203232113769604773193e-01), PetscRealConstant(4.02409810322379786328969726798000604e-03), PetscRealConstant(9.14756397949306990084694677322455663e-02),
                                                       PetscRealConstant(8.55839914422549842229425038284057041e-01), PetscRealConstant(4.86603476792956608988157967157173608e-02), PetscRealConstant(4.16877459738526012345267236957306852e-01),
                                                       PetscRealConstant(1.32656374018403637077430667319396390e-01), PetscRealConstant(4.22322960380126731139616612508399860e-01), PetscRealConstant(2.81432058629436194376854832148968955e-02),
                                                       PetscRealConstant(2.46433022480167745391129718909880802e-01), PetscRealConstant(4.43919866927880962262848281512233020e-01), PetscRealConstant(2.80452676535755180261959134903376446e-01),
                                                       PetscRealConstant(2.91944340561961120840628646745097354e-02), PetscRealConstant(1.27120748807009606612856561916922459e-01), PetscRealConstant(2.39545088589519026438172051034056768e-01),
                                                       PetscRealConstant(3.87576712891715246022717054245588659e-01), PetscRealConstant(2.45757449711756120926254332803432114e-01), PetscRealConstant(2.13704906186185047717624929968670513e-01),
                                                       PetscRealConstant(1.65713088716877935143570668753089552e-01), PetscRealConstant(5.50342358559996214191857225563175647e-01), PetscRealConstant(7.02396465369408029469471757150643005e-02),
                                                       PetscRealConstant(3.29035301487797384467188976184934488e-01), PetscRealConstant(1.78877668602636590854162612799991449e-01), PetscRealConstant(4.25476392248098846047580051058754235e-01),
                                                       PetscRealConstant(6.66106376614671786310683599563198389e-02), PetscRealConstant(4.95031595694936929642574814441724134e-03), PetscRealConstant(3.34017611672610646004340708181325992e-01),
                                                       PetscRealConstant(4.72232135088027269209508028172701682e-01), PetscRealConstant(1.88799937282412715489725515501555073e-01), PetscRealConstant(7.84628836168125343141768324038601388e-03),
                                                       PetscRealConstant(5.45877300912638538803359284472137146e-01), PetscRealConstant(3.75226760820488455015823743012691152e-01), PetscRealConstant(7.10496499051917527493992892747856387e-02),
                                                       PetscRealConstant(1.29355753466201289322434213671704619e-01), PetscRealConstant(2.51043985900785126572041599813854357e-02), PetscRealConstant(5.92551607906288116712252571210830669e-01),
                                                       PetscRealConstant(2.52988240037432081308109055136079318e-01)};

static const PetscReal PetscDTJSTetQuad_19_weights[] = {PetscRealConstant(1.26365666192287401067772632110641285e-02), PetscRealConstant(3.07953606210537550982849722992834043e-03), PetscRealConstant(5.45532368298764456018330289328558257e-03),
                                                        PetscRealConstant(1.56487288993104951259447920575118156e-03), PetscRealConstant(7.73034573709155682117871572552498329e-03), PetscRealConstant(2.70532351880922854216354783975810505e-03),
                                                        PetscRealConstant(2.67447798014191000600029323277526913e-04), PetscRealConstant(3.87741329660919798169033596322656967e-03), PetscRealConstant(3.37610461771617898509336697822745796e-03),
                                                        PetscRealConstant(9.79159431508818556803387474552366119e-04), PetscRealConstant(1.43491143271919968064063280520772727e-03), PetscRealConstant(2.64855423617528482955965764857999120e-03),
                                                        PetscRealConstant(6.72842315239192915850119643116240325e-03), PetscRealConstant(3.58970994737473690293338398786512178e-03), PetscRealConstant(1.77418171800506805458797186448738342e-03),
                                                        PetscRealConstant(2.37723853447047321925151865011454041e-03), PetscRealConstant(1.68402110157927158896515442322086456e-04), PetscRealConstant(4.32568125842556391455183815556306504e-03),
                                                        PetscRealConstant(1.39799758095003238595635931521424104e-03), PetscRealConstant(4.80765432764613933705817773079763926e-03), PetscRealConstant(3.41541121049312623454888615620641921e-03),
                                                        PetscRealConstant(1.99855795711255503112751640222176143e-03), PetscRealConstant(2.41909942976997762405040111915260510e-03), PetscRealConstant(3.84525076532822721956066991414752038e-03),
                                                        PetscRealConstant(4.25521507362834764091760689169060258e-03), PetscRealConstant(5.27370978264900906987432720904472558e-04), PetscRealConstant(2.18961497588768268116337181920035733e-03),
                                                        PetscRealConstant(6.18789452994625153081174688726846977e-04), PetscRealConstant(1.61448711999203688850655800015666854e-03), PetscRealConstant(4.87104402303742035161736620862042517e-03),
                                                        PetscRealConstant(2.32638831835015346816523185300738960e-03)};

static const PetscReal PetscDTJSTetQuad_19_orbits[] = {PetscRealConstant(2.50000000000000000000000000000000000e-01), PetscRealConstant(9.62334679417011568284366181074556474e-02), PetscRealConstant(7.11299596174896529514690145677633082e-01),
                                                       PetscRealConstant(2.84071097118555506947602382063297172e-01), PetscRealConstant(1.47786708644333479157192853810108557e-01), PetscRealConstant(4.20121804976231002329434238106731865e-02),
                                                       PetscRealConstant(8.73963458507130699301169728567980429e-01), PetscRealConstant(1.29392501217952552624073997777263658e-01), PetscRealConstant(3.70607498782047447375926002222736318e-01),
                                                       PetscRealConstant(5.33931212533030608266273497502592927e-02), PetscRealConstant(1.25243762754007174088005057111476874e-01), PetscRealConstant(7.67969994739386704258740243388004564e-01),
                                                       PetscRealConstant(5.25055390691960340931789274984064082e-03), PetscRealConstant(1.66033925320529936975444991312217256e-01), PetscRealConstant(8.23464966865630856205919223188101467e-01),
                                                       PetscRealConstant(2.12899332369465902932548792145650826e-01), PetscRealConstant(1.03404599509332767929211126976758244e-01), PetscRealConstant(4.70796735751735426205691288731940105e-01),
                                                       PetscRealConstant(4.03413532597722963565337027162632292e-01), PetscRealConstant(5.98373001613519119461692336528203886e-02), PetscRealConstant(1.33335634643202160923156712021915070e-01),
                                                       PetscRealConstant(1.18881193081127158167390129704405555e-02), PetscRealConstant(4.22985793576684960248391123565036071e-01), PetscRealConstant(5.53237967807089608118130850494082797e-01),
                                                       PetscRealConstant(8.90311655120662751838887461984309422e-02), PetscRealConstant(1.38681537849572433920827897212871093e-02), PetscRealConstant(8.08069515190910206240139717881850990e-01),
                                                       PetscRealConstant(5.15167869589916011049924507263194495e-02), PetscRealConstant(4.09638389552526652731339770847596435e-01), PetscRealConstant(4.87328036529490145058675327699764654e-01),
                                                       PetscRealConstant(1.17999285229767087020608772527518712e-01), PetscRealConstant(2.46614994364408310901691337629303452e-01), PetscRealConstant(5.17386435176057515057091117315659075e-01),
                                                       PetscRealConstant(4.60851233492859025770438356523194529e-02), PetscRealConstant(2.78141431885612759807587332464970437e-01), PetscRealConstant(6.29688321415815435038324996230390705e-01),
                                                       PetscRealConstant(1.41018670809789817962482549785183563e-01), PetscRealConstant(8.17464994838945075466265008535057069e-03), PetscRealConstant(7.09788008432030913320372250344282272e-01),
                                                       PetscRealConstant(1.41103440869926651017091296292167901e-01), PetscRealConstant(1.32206241500249746879708884222166981e-01), PetscRealConstant(5.85586876759896951086108523193497169e-01),
                                                       PetscRealConstant(7.91186220482110832109344071689469691e-03), PetscRealConstant(3.03588380906193505525359129903307398e-02), PetscRealConstant(9.53817437499738432805277205575879869e-01),
                                                       PetscRealConstant(1.76101211470317416831835908189967419e-01), PetscRealConstant(2.46123958781684937098718637883837345e-01), PetscRealConstant(4.01673618277680229237609545736227841e-01),
                                                       PetscRealConstant(7.69412404114981468736095119295542084e-01), PetscRealConstant(4.53113744152098026534089037249865381e-02), PetscRealConstant(1.73649509094395699494867047219718714e-01),
                                                       PetscRealConstant(1.16267123754130291156289297597526870e-02), PetscRealConstant(1.13990734338976837313178978774510582e-01), PetscRealConstant(1.90246977030951145208262466013951478e-01),
                                                       PetscRealConstant(6.46733324641993985338705600076641331e-01), PetscRealConstant(4.90289639880780321398529551348966092e-02), PetscRealConstant(5.04522419718954228612767662391899867e-01),
                                                       PetscRealConstant(2.02588210731462079665360391509414541e-01), PetscRealConstant(2.40885806399041786834713274134854231e-01), PetscRealConstant(5.20035631505419048871586719638314209e-02),
                                                       PetscRealConstant(3.89934213793839356852842360892676039e-01), PetscRealConstant(6.28045986545769874289358059320424640e-02), PetscRealConstant(5.37610165624569084671668334225328922e-01),
                                                       PetscRealConstant(9.65102192701457104655349894995258364e-03), PetscRealConstant(1.02510197711690842901245484115249186e-02), PetscRealConstant(1.68903461106830139202222457428430926e-01),
                                                       PetscRealConstant(5.66619485332254873550618337489174164e-01), PetscRealConstant(2.54226033789745902957034656670870026e-01), PetscRealConstant(3.71470931462182352546434962218605890e-01),
                                                       PetscRealConstant(1.28280229882654556608461669361721500e-01), PetscRealConstant(2.17624703761110518025024869905748151e-01), PetscRealConstant(2.82624134894052572820078498513924434e-01),
                                                       PetscRealConstant(2.32373823125989240593181439337537644e-01), PetscRealConstant(3.75316430224833414077257154394333039e-01), PetscRealConstant(3.35824000603201264347698116273383887e-01),
                                                       PetscRealConstant(5.64857460459760809818632899947453939e-02), PetscRealConstant(2.82332391047721027989538581505126380e-02), PetscRealConstant(8.17663469329853506568359158167069854e-02),
                                                       PetscRealConstant(5.96822183459553092417912023505143017e-03), PetscRealConstant(8.84032192127647015620031105797728914e-01), PetscRealConstant(4.69137344292685867252157060138264393e-01),
                                                       PetscRealConstant(3.72721500887821039747961250703594662e-01), PetscRealConstant(1.47621010813019483138781884053249076e-01), PetscRealConstant(1.05201440064736098610998051048918466e-02),
                                                       PetscRealConstant(6.24115043425393373538120988958116517e-03), PetscRealConstant(2.88107701261745519010210649029694570e-01), PetscRealConstant(6.85243276500053688921054524868632670e-01),
                                                       PetscRealConstant(2.04078718039468583333536162120915344e-02), PetscRealConstant(2.54857100936454950835784643168830610e-01), PetscRealConstant(8.48367703048867278258339437197482592e-03),
                                                       PetscRealConstant(6.52960355187055007352828111335841043e-01), PetscRealConstant(8.36988668460013690288038511233535513e-02), PetscRealConstant(5.08122590657161730487600893694710316e-01),
                                                       PetscRealConstant(1.19312803621203324861426104189749821e-01), PetscRealConstant(3.22433225685784134072023986028614781e-01), PetscRealConstant(5.01313800358508105789490160869251117e-02),
                                                       PetscRealConstant(1.09499610637902078299257698776321968e-02), PetscRealConstant(4.19836920141742605999998444011424669e-01), PetscRealConstant(2.53710233110825822011069043675632865e-01),
                                                       PetscRealConstant(3.15502885683641364159006742435310290e-01)};

static const PetscReal PetscDTJSTetQuad_20_weights[] = {PetscRealConstant(7.22460638677953125688057267118388074e-03), PetscRealConstant(5.09453065099816957070877190430607196e-03), PetscRealConstant(5.40994420311206454803812963857048479e-03),
                                                        PetscRealConstant(5.53022706366710045476781238135894884e-03), PetscRealConstant(7.05275547991248137088859333881509075e-03), PetscRealConstant(1.29605575981647094698770484053693432e-03),
                                                        PetscRealConstant(3.98423484904060275073103866929560306e-03), PetscRealConstant(9.41566256470448221441914331900653009e-03), PetscRealConstant(1.51735221982129193752888403348129634e-03),
                                                        PetscRealConstant(4.37910411925277996739316075645192455e-04), PetscRealConstant(6.02307343271088684638251785437521914e-03), PetscRealConstant(3.65860946418625763940135995674861322e-03),
                                                        PetscRealConstant(7.12680537315513807090582881108913453e-04), PetscRealConstant(1.13701370311544463743732590873355497e-03), PetscRealConstant(2.14489776126748135789459632714038436e-03),
                                                        PetscRealConstant(2.88536238616404557699773037758687246e-03), PetscRealConstant(1.73195273598776120570488451013549391e-03), PetscRealConstant(1.00536281133077976123248388333204765e-03),
                                                        PetscRealConstant(5.24852290292943468844272147680139799e-03), PetscRealConstant(1.10139163390816894587624641653408711e-04), PetscRealConstant(2.93679144168776127243051797615682283e-03),
                                                        PetscRealConstant(1.52388305108322164632493838485877261e-03), PetscRealConstant(1.07164549065133126107536045539593706e-03), PetscRealConstant(8.58807344751119126849945476693810186e-04),
                                                        PetscRealConstant(3.04640408209070416066628687545933645e-03), PetscRealConstant(2.35762023120478372895100775896230820e-03), PetscRealConstant(1.81879082213871276109566173065374534e-03),
                                                        PetscRealConstant(1.87935069365603099127182033465762731e-03), PetscRealConstant(7.13626156376123428004633572633024049e-03), PetscRealConstant(3.14300233839860770690132887150071507e-03),
                                                        PetscRealConstant(3.11400037535878015814358354094884843e-04), PetscRealConstant(1.10655881472645182514945417087289586e-03), PetscRealConstant(4.64043636749354524434034804981239940e-04),
                                                        PetscRealConstant(1.44174199661241234146837650568853076e-03), PetscRealConstant(4.48479065685808809839544361660291348e-03), PetscRealConstant(1.51842603193734067684311991114888653e-03)};

static const PetscReal PetscDTJSTetQuad_20_orbits[] =
  {PetscRealConstant(2.96775959693413148684272357786254717e-01), PetscRealConstant(1.09672120919760553947182926641235898e-01), PetscRealConstant(1.20904797211218541480782303916034842e-01), PetscRealConstant(6.37285608366344375557653088251895425e-01),
   PetscRealConstant(3.17795907188104432779539637298202682e-01), PetscRealConstant(4.66122784356867016613810881053919047e-02), PetscRealConstant(2.01265571241478984303443113176420939e-01), PetscRealConstant(3.96203286275563047089670660470737159e-01),
   PetscRealConstant(1.67883896927288463392592228263384201e-01), PetscRealConstant(4.96348309218134609822223315209847398e-01), PetscRealConstant(3.62149396096894730973545915715727126e-02), PetscRealConstant(8.91355181170931580707936225285281844e-01),
   PetscRealConstant(5.26024496174837755586597644205805165e-02), PetscRealConstant(4.47397550382516224441340235579419478e-01), PetscRealConstant(1.95421443668695790463103814051975575e-01), PetscRealConstant(3.04578556331304209536896185948024425e-01),
   PetscRealConstant(3.22823054983951573504948717060226414e-02), PetscRealConstant(1.17282115634429462886374833938591713e-01), PetscRealConstant(8.18153273368780222412635422649363016e-01), PetscRealConstant(8.12651447051963846684892317335955673e-03),
   PetscRealConstant(1.67196393182821202525467567148017356e-01), PetscRealConstant(8.16550577876139520540834586505263527e-01), PetscRealConstant(1.85145952299434697652082297216572504e-01), PetscRealConstant(6.61101187666243024025368520038561524e-02),
   PetscRealConstant(5.63597976634506302293298553562998852e-01), PetscRealConstant(4.11077538201776996156578591660258502e-01), PetscRealConstant(4.96617390711715771989015408119062724e-02), PetscRealConstant(1.28183184525274430487941275867576693e-01),
   PetscRealConstant(1.00597974068544565321322282719338786e-02), PetscRealConstant(4.23243780355575569918200102588089921e-01), PetscRealConstant(5.56636624830715517017535440868042345e-01), PetscRealConstant(8.23016150372358808654616099827595418e-02),
   PetscRealConstant(1.11451887826779312232713688593139702e-02), PetscRealConstant(8.24251581142850307045805411175166964e-01), PetscRealConstant(3.80128286026646664960960656463154595e-02), PetscRealConstant(3.16682071355554741984651357616374917e-01),
   PetscRealConstant(6.07292271439115925023156511090994176e-01), PetscRealConstant(8.29781690579475784336759464975929943e-02), PetscRealConstant(1.92759120421416164612632499731862957e-01), PetscRealConstant(6.41284541462688678520015607272951054e-01),
   PetscRealConstant(3.23283014904537419774419087577518778e-02), PetscRealConstant(2.29089979311382163119031523743399970e-01), PetscRealConstant(7.06253417707710352926084658741096250e-01), PetscRealConstant(1.40652194017776224782212249407404105e-01),
   PetscRealConstant(4.06245917858537144207040023902169574e-03), PetscRealConstant(7.14633152785862178993505100946170099e-01), PetscRealConstant(1.13971943911291456700465896406911381e-01), PetscRealConstant(2.55190454908039763350473269106109779e-01),
   PetscRealConstant(5.16865657269377323248594938080067458e-01), PetscRealConstant(7.45357137717489582861251414256796924e-03), PetscRealConstant(2.51785631681118744612163047802891011e-02), PetscRealConstant(9.59914294077538333881558666934574972e-01),
   PetscRealConstant(1.11017126730268909191023113768111687e-01), PetscRealConstant(3.87258679060330998098427751610042820e-01), PetscRealConstant(3.90707067479131183519526020853733806e-01), PetscRealConstant(5.33376714273739233870594605155144999e-01),
   PetscRealConstant(5.31381050391376689806627178841042199e-02), PetscRealConstant(4.03716688019543088078118437435350508e-01), PetscRealConstant(9.76849266758000907062423952540025927e-03), PetscRealConstant(9.45051714627573827870414840210842245e-02),
   PetscRealConstant(9.43920742872811348161609591524131066e-02), PetscRealConstant(5.01546618875248734382189356109333072e-02), PetscRealConstant(7.60948092362436608958578621215569404e-01), PetscRealConstant(7.65395569227002337792953195198892840e-01),
   PetscRealConstant(5.50544516427295756199581157040645431e-02), PetscRealConstant(1.73889231182648863746395366002138966e-01), PetscRealConstant(5.66074794761922284069332309490365905e-03), PetscRealConstant(9.75172038222043828482829673714336402e-02),
   PetscRealConstant(1.79863730123430505725247675700842840e-01), PetscRealConstant(6.87957195278953020629578264158364066e-01), PetscRealConstant(3.46618707754120907968910927693594533e-02), PetscRealConstant(4.09503658617094357901529514085878133e-01),
   PetscRealConstant(2.12192054775214728281713016268651816e-01), PetscRealConstant(3.32173502503505011961638785079764853e-01), PetscRealConstant(4.61307841041859018551186845657051989e-02), PetscRealConstant(4.76555720750006934989676145153095172e-01),
   PetscRealConstant(1.29016151235196034494128395063510279e-01), PetscRealConstant(3.84472097641014194299099868730808936e-01), PetscRealConstant(9.95603037378283621709559105258561564e-03), PetscRealConstant(1.37608474867702027020167698611382934e-02),
   PetscRealConstant(1.61487322306611446325039333835524196e-01), PetscRealConstant(5.98270510801064131171630243886574179e-01), PetscRealConstant(2.26481319405554219801313652416763298e-01), PetscRealConstant(4.14350074140247024542261483210916325e-01),
   PetscRealConstant(1.05928307893985974757954028717881250e-01), PetscRealConstant(2.85301376246364107449617442124239591e-01), PetscRealConstant(1.94420241719402893250167045946962822e-01), PetscRealConstant(2.86408315525495328632721586343669524e-01),
   PetscRealConstant(2.04622932845680898244340052065565290e-01), PetscRealConstant(4.72890810394296518123352032139401350e-01), PetscRealConstant(3.60779412345272549995863294513638773e-02), PetscRealConstant(2.36158323301529800680613965749759226e-02),
   PetscRealConstant(7.44179686987701829886416658042872519e-02), PetscRealConstant(2.44216970783581534268718758923204448e-03), PetscRealConstant(8.99524029263241021600609750031504756e-01), PetscRealConstant(5.07874575928640318781773406619736005e-01),
   PetscRealConstant(2.93835235968678461146657380096360321e-01), PetscRealConstant(1.93910415738890888251895706747050764e-01), PetscRealConstant(4.37977236379033181967350653685295891e-03), PetscRealConstant(2.38861494051180749685397733700935801e-03),
   PetscRealConstant(2.89900491993130303260435705191387345e-01), PetscRealConstant(6.86752544617515373426747571296410988e-01), PetscRealConstant(2.09583484488425158159627461751923481e-02), PetscRealConstant(2.78009023348863848163063689101539619e-01),
   PetscRealConstant(6.92039552760895284534243255473137817e-03), PetscRealConstant(6.28408336767426032322679262236141627e-01), PetscRealConstant(8.66622443561011666689146161075873926e-02), PetscRealConstant(5.43113057490581538144136655514922005e-01),
   PetscRealConstant(1.05319106897215217010106378439771991e-01), PetscRealConstant(3.05317747020927880842940814752699215e-01), PetscRealConstant(4.62500885912753640028161512926068370e-02), PetscRealConstant(8.79232521925877358609174528034727290e-03),
   PetscRealConstant(3.38761570029296203845349050840480395e-01), PetscRealConstant(2.52195565894276094224986629833248037e-01), PetscRealConstant(4.00250538857168928343572574045924301e-01)};

static const PetscInt PetscDTJSTetQuad_max_degree = 20;

static const PetscInt PetscDTJSTetQuad_num_nodes[] = {1, 1, 4, 8, 14, 14, 24, 35, 46, 59, 81, 110, 168, 172, 204, 264, 304, 364, 436, 487, 552};

static const PetscInt PetscDTJSTetQuad_num_orbits[] = {1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 0, 0, 0, 2, 1, 0, 0, 0, 2, 1, 0, 0, 0, 3, 0, 1, 0, 1, 1, 1, 2, 0, 0,  4,  1, 2, 0, 1,  4,  1, 3, 0, 1,  2, 2,
                                                       5, 0, 0, 2, 3, 5, 1, 0, 3, 2, 4, 4, 0, 4, 2, 6, 3, 0, 6, 4, 5, 4, 0, 3, 2, 6, 7, 0, 4, 2, 7, 8, 0, 4, 4, 9, 9, 0, 7, 8, 10, 10, 1, 3, 1, 13, 13, 0, 6, 2, 13, 15};

static const PetscReal *PetscDTJSTetQuad_weights[] = {PetscDTJSTetQuad_1_weights,  PetscDTJSTetQuad_1_weights,  PetscDTJSTetQuad_2_weights,  PetscDTJSTetQuad_3_weights,  PetscDTJSTetQuad_4_weights,  PetscDTJSTetQuad_5_weights,
                                                      PetscDTJSTetQuad_6_weights,  PetscDTJSTetQuad_7_weights,  PetscDTJSTetQuad_8_weights,  PetscDTJSTetQuad_9_weights,  PetscDTJSTetQuad_10_weights, PetscDTJSTetQuad_11_weights,
                                                      PetscDTJSTetQuad_12_weights, PetscDTJSTetQuad_13_weights, PetscDTJSTetQuad_14_weights, PetscDTJSTetQuad_15_weights, PetscDTJSTetQuad_16_weights, PetscDTJSTetQuad_17_weights,
                                                      PetscDTJSTetQuad_18_weights, PetscDTJSTetQuad_19_weights, PetscDTJSTetQuad_20_weights};

static const PetscReal *PetscDTJSTetQuad_orbits[] = {PetscDTJSTetQuad_1_orbits,  PetscDTJSTetQuad_1_orbits,  PetscDTJSTetQuad_2_orbits,  PetscDTJSTetQuad_3_orbits,  PetscDTJSTetQuad_4_orbits,  PetscDTJSTetQuad_5_orbits,  PetscDTJSTetQuad_6_orbits,
                                                     PetscDTJSTetQuad_7_orbits,  PetscDTJSTetQuad_8_orbits,  PetscDTJSTetQuad_9_orbits,  PetscDTJSTetQuad_10_orbits, PetscDTJSTetQuad_11_orbits, PetscDTJSTetQuad_12_orbits, PetscDTJSTetQuad_13_orbits,
                                                     PetscDTJSTetQuad_14_orbits, PetscDTJSTetQuad_15_orbits, PetscDTJSTetQuad_16_orbits, PetscDTJSTetQuad_17_orbits, PetscDTJSTetQuad_18_orbits, PetscDTJSTetQuad_19_orbits, PetscDTJSTetQuad_20_orbits};

#endif // #define PETSCDTTETQUADRULES_H
