from typing import Any, ClassVar, List

from typing import overload
import mrpt.pymrpt.mrpt.config
import mrpt.pymrpt.mrpt.containers
import mrpt.pymrpt.mrpt.io
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.rtti
import mrpt.pymrpt.mrpt.serialization
CH_GRAY: TImageChannels
CH_RGB: TImageChannels
DEEP_COPY: copy_type_t
FAST_REF_OR_CONVERT_TO_GRAY: ctor_CImage_ref_or_gray
IMG_INTERP_AREA: TInterpolationMethod
IMG_INTERP_CUBIC: TInterpolationMethod
IMG_INTERP_LINEAR: TInterpolationMethod
IMG_INTERP_NN: TInterpolationMethod
SHALLOW_COPY: copy_type_t
cmGRAYSCALE: TColormap
cmHOT: TColormap
cmJET: TColormap
cmNONE: TColormap

class CCanvas:
    class TPenStyle:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        psDash: ClassVar[CCanvas.TPenStyle] = ...
        psDashDot: ClassVar[CCanvas.TPenStyle] = ...
        psDashDotDot: ClassVar[CCanvas.TPenStyle] = ...
        psDot: ClassVar[CCanvas.TPenStyle] = ...
        psSolid: ClassVar[CCanvas.TPenStyle] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    psDash: ClassVar[CCanvas.TPenStyle] = ...
    psDashDot: ClassVar[CCanvas.TPenStyle] = ...
    psDashDotDot: ClassVar[CCanvas.TPenStyle] = ...
    psDot: ClassVar[CCanvas.TPenStyle] = ...
    psSolid: ClassVar[CCanvas.TPenStyle] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CCanvas) -> None: ...
    def assign(self) -> CCanvas: ...
    @overload
    def drawCircle(self, x: int, y: int, radius: int) -> None: ...
    @overload
    def drawCircle(self, x: int, y: int, radius: int, color: TColor) -> None: ...
    @overload
    def drawCircle(self, x: int, y: int, radius: int, color: TColor, width: int) -> None: ...
    @overload
    def drawImage(self, x: int, y: int, img) -> None: ...
    @overload
    def drawImage(self, x: int, y: int, img, rotation: float, scale: float) -> None: ...
    @overload
    def drawMark(self, x0: int, y0: int, color: TColor, type: str) -> None: ...
    @overload
    def drawMark(self, x0: int, y0: int, color: TColor, type: str, size: int) -> None: ...
    @overload
    def drawMark(self, x0: int, y0: int, color: TColor, type: str, size: int, width: int) -> None: ...
    def ellipseGaussian(self, *args, **kwargs) -> Any: ...
    def filledRectangle(self, x0: int, y0: int, x1: int, y1: int, color: TColor) -> None: ...
    @overload
    def getHeight(self) -> int: ...
    @overload
    def getHeight() -> size_t: ...
    @overload
    def getWidth(self) -> int: ...
    @overload
    def getWidth() -> size_t: ...
    @overload
    def line(self, x0: int, y0: int, x1: int, y1: int, color: TColor) -> None: ...
    @overload
    def line(self, x0: int, y0: int, x1: int, y1: int, color: TColor, width: int) -> None: ...
    @overload
    def line(self, x0: int, y0: int, x1: int, y1: int, color: TColor, width: int, penStyle: CCanvas.TPenStyle) -> None: ...
    @overload
    def rectangle(self, x0: int, y0: int, x1: int, y1: int, color: TColor) -> None: ...
    @overload
    def rectangle(self, x0: int, y0: int, x1: int, y1: int, color: TColor, width: int) -> None: ...
    @overload
    def rectangle(anemptyrectangle, withoutfilling) -> Any: ...
    @overload
    def selectTextFont(self, fontName: str) -> None: ...
    @overload
    def selectTextFont(conststd) -> void: ...
    def setPixel(self, *args, **kwargs) -> Any: ...
    def textOut(self, x0: int, y0: int, str: str, color: TColor) -> None: ...
    @overload
    def triangle(self, x0: int, y0: int, size: int, color: TColor) -> None: ...
    @overload
    def triangle(self, x0: int, y0: int, size: int, color: TColor, inferior: bool) -> None: ...
    @overload
    def triangle(self, x0: int, y0: int, size: int, color: TColor, inferior: bool, width: int) -> None: ...

class CExceptionExternalImageNotFound:
    @overload
    def __init__(self, s: str) -> None: ...
    @overload
    def __init__(self, arg0: CExceptionExternalImageNotFound) -> None: ...
    @overload
    def __init__(self, arg0: CExceptionExternalImageNotFound) -> None: ...
    def assign(self) -> CExceptionExternalImageNotFound: ...

class CImage(mrpt.pymrpt.mrpt.serialization.CSerializable, CCanvas):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, nChannels: TImageChannels) -> None: ...
    @overload
    def __init__(self, other_img: CImage) -> None: ...
    @overload
    def __init__(self, img: CImage, copy_type: copy_type_t) -> None: ...
    @overload
    def __init__(self, arg0: CImage) -> None: ...
    @overload
    def __init__(self, arg0: CImage) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def DISABLE_JPEG_COMPRESSION(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def KLT_response(self, x: int, y: int, half_window_size: int) -> float: ...
    @overload
    def KLT_response() -> Any: ...
    def LoadFromFile(self, *args, **kwargs) -> Any: ...
    def SERIALIZATION_JPEG_QUALITY(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CImage: ...
    @overload
    def channelCount(self) -> int: ...
    @overload
    def channelCount() -> int: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def colorImage(self) -> CImage: ...
    @overload
    def colorImage(self, ret: CImage) -> None: ...
    @overload
    def colorImage(classmrpt) -> void: ...
    @overload
    def copyFromForceLoad(self, o: CImage) -> None: ...
    @overload
    def copyFromForceLoad(constclassmrpt) -> void: ...
    def correlate(self, *args, **kwargs) -> Any: ...
    def cross_correlation_FFT(self, *args, **kwargs) -> Any: ...
    @overload
    def drawCircle(self, x: int, y: int, radius: int) -> None: ...
    @overload
    def drawCircle(self, x: int, y: int, radius: int, color: TColor) -> None: ...
    @overload
    def drawCircle(self, x: int, y: int, radius: int, color: TColor, width: int) -> None: ...
    def drawImage(self, x: int, y: int, img: CImage) -> None: ...
    @overload
    def equalizeHist(self, out_img: CImage) -> None: ...
    @overload
    def equalizeHist(classmrpt) -> void: ...
    def extract_patch(self, *args, **kwargs) -> Any: ...
    def filledRectangle(self, x0: int, y0: int, x1: int, y1: int, color: TColor) -> None: ...
    @overload
    def filterGaussian(self, out_img: CImage) -> None: ...
    @overload
    def filterGaussian(self, out_img: CImage, W: int) -> None: ...
    @overload
    def filterGaussian(self, out_img: CImage, W: int, H: int) -> None: ...
    @overload
    def filterGaussian(self, out_img: CImage, W: int, H: int, sigma: float) -> None: ...
    @overload
    def filterMedian(self, out_img: CImage) -> None: ...
    @overload
    def filterMedian(self, out_img: CImage, W: int) -> None: ...
    @overload
    def filterMedian(classmrpt, int) -> void: ...
    @overload
    def flipHorizontal(self) -> None: ...
    @overload
    def flipHorizontal() -> void: ...
    @overload
    def flipVertical(self) -> None: ...
    @overload
    def flipVertical() -> void: ...
    @overload
    def forceLoad(self) -> None: ...
    @overload
    def forceLoad() -> void: ...
    @overload
    def getAsFloat(self, col: int, row: int, channel: int) -> float: ...
    @overload
    def getAsFloat(self, col: int, row: int) -> float: ...
    def getAsMatrix(self, *args, **kwargs) -> Any: ...
    def getAsMatrixTiled(self, *args, **kwargs) -> Any: ...
    def getAsRGBMatrices(self, *args, **kwargs) -> Any: ...
    def getChannelCount(self) -> TImageChannels: ...
    def getChannelsOrder(self) -> str: ...
    def getExternalStorageFile(self) -> str: ...
    @overload
    def getExternalStorageFileAbsolutePath(self, out_path: str) -> None: ...
    @overload
    def getExternalStorageFileAbsolutePath(std) -> void: ...
    @overload
    def getExternalStorageFileAbsolutePath(self) -> str: ...
    @overload
    def getHeight(self) -> int: ...
    @overload
    def getHeight() -> size_t: ...
    def getImagesPathBase(self, *args, **kwargs) -> Any: ...
    @overload
    def getMaxAsFloat(self) -> float: ...
    @overload
    def getMaxAsFloat() -> float: ...
    def getPixelDepth(self) -> PixelDepth: ...
    @overload
    def getRowStride(self) -> int: ...
    @overload
    def getRowStride() -> size_t: ...
    @overload
    def getSize(self, s: TPixelCoord) -> None: ...
    @overload
    def getSize(structmrpt) -> void: ...
    @overload
    def getSize(self) -> TPixelCoord: ...
    @overload
    def getWidth(self) -> int: ...
    @overload
    def getWidth() -> size_t: ...
    @overload
    def grayscale(self) -> CImage: ...
    @overload
    def grayscale(self, ret: CImage) -> bool: ...
    @overload
    def grayscale(classmrpt) -> bool: ...
    @overload
    def isColor(self) -> bool: ...
    @overload
    def isColor() -> bool: ...
    @overload
    def isEmpty(self) -> bool: ...
    @overload
    def isEmpty() -> bool: ...
    @overload
    def isExternallyStored(self) -> bool: ...
    @overload
    def isExternallyStored() -> bool: ...
    @overload
    def isOriginTopLeft(self) -> bool: ...
    @overload
    def isOriginTopLeft() -> bool: ...
    def joinImagesHorz(self, im1: CImage, im2: CImage) -> None: ...
    @overload
    def line(self, x0: int, y0: int, x1: int, y1: int, color: TColor) -> None: ...
    @overload
    def line(self, x0: int, y0: int, x1: int, y1: int, color: TColor, width: int) -> None: ...
    @overload
    def line(self, x0: int, y0: int, x1: int, y1: int, color: TColor, width: int, penStyle: CCanvas.TPenStyle) -> None: ...
    @overload
    def loadFromFile(self, fileName: str) -> bool: ...
    @overload
    def loadFromFile(self, fileName: str, isColor: int) -> bool: ...
    @overload
    def loadFromFile(conststd, int) -> bool: ...
    @overload
    def loadFromMemoryBuffer(self, width: int, height: int, color: bool, rawpixels: int) -> None: ...
    @overload
    def loadFromMemoryBuffer(self, width: int, height: int, color: bool, rawpixels: int, swapRedBlue: bool) -> None: ...
    @overload
    def loadFromMemoryBuffer(self, width: int, height: int, bytesPerRow: int, red: int, green: int, blue: int) -> None: ...
    @overload
    def loadFromStreamAsJPEG(self, in: mrpt.pymrpt.mrpt.io.CStream) -> None: ...
    @overload
    def loadFromStreamAsJPEG(classmrpt) -> void: ...
    def loadTGA(self, *args, **kwargs) -> Any: ...
    def makeDeepCopy(self) -> CImage: ...
    def makeShallowCopy(self) -> CImage: ...
    @overload
    def normalize(self) -> None: ...
    @overload
    def normalize() -> void: ...
    @overload
    def ptrLine(self, row: int) -> int: ...
    @overload
    def ptrLine(self, row: int) -> int: ...
    def rectifyImageInPlace(self, mapX: capsule, mapY: capsule) -> None: ...
    def resize(self, *args, **kwargs) -> Any: ...
    @overload
    def rotateImage(self, out_img: CImage, ang: float, cx: int, cy: int) -> None: ...
    @overload
    def rotateImage(self, out_img: CImage, ang: float, cx: int, cy: int, scale: float) -> None: ...
    @overload
    def saveToFile(self, fileName: str) -> bool: ...
    @overload
    def saveToFile(self, fileName: str, jpeg_quality: int) -> bool: ...
    @overload
    def saveToFile(conststd, int) -> bool: ...
    @overload
    def saveToStreamAsJPEG(self, out: mrpt.pymrpt.mrpt.io.CStream) -> None: ...
    @overload
    def saveToStreamAsJPEG(self, out: mrpt.pymrpt.mrpt.io.CStream, jpeg_quality: int) -> None: ...
    @overload
    def saveToStreamAsJPEG(classmrpt, constint) -> void: ...
    @overload
    def scaleDouble(self, interp: TInterpolationMethod) -> CImage: ...
    @overload
    def scaleDouble(self, out_image: CImage, interp: TInterpolationMethod) -> None: ...
    @overload
    def scaleDouble(classmrpt, enummrpt) -> void: ...
    @overload
    def scaleHalf(self, interp: TInterpolationMethod) -> CImage: ...
    @overload
    def scaleHalf(self, out_image: CImage, interp: TInterpolationMethod) -> bool: ...
    @overload
    def scaleHalf(classmrpt, enummrpt) -> bool: ...
    @overload
    def scaleImage(self, out_img: CImage, width: int, height: int) -> None: ...
    @overload
    def scaleImage(self, out_img: CImage, width: int, height: int, interp: TInterpolationMethod) -> None: ...
    @overload
    def setExternalStorage(self, fileName: str) -> None: ...
    @overload
    def setExternalStorage(conststd) -> void: ...
    def setImagesPathBase(self, *args, **kwargs) -> Any: ...
    def setPixel(self, *args, **kwargs) -> Any: ...
    @overload
    def swap(self, o: CImage) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...
    @overload
    def swapRB(self) -> None: ...
    @overload
    def swapRB() -> void: ...
    @overload
    def undistort(self, out_img: CImage, cameraParams: TCamera) -> None: ...
    @overload
    def undistort(classmrpt, constclassmrpt) -> void: ...
    @overload
    def unload(self) -> None: ...
    @overload
    def unload() -> void: ...
    def update_patch(self, patch: CImage, col: int, row: int) -> None: ...
    def __call__(self, *args, **kwargs) -> Any: ...

class DistortionModel:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kannala_brandt: ClassVar[DistortionModel] = ...
    none: ClassVar[DistortionModel] = ...
    plumb_bob: ClassVar[DistortionModel] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class PixelDepth:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    D16S: ClassVar[PixelDepth] = ...
    D16U: ClassVar[PixelDepth] = ...
    D32F: ClassVar[PixelDepth] = ...
    D32S: ClassVar[PixelDepth] = ...
    D64F: ClassVar[PixelDepth] = ...
    D8S: ClassVar[PixelDepth] = ...
    D8U: ClassVar[PixelDepth] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TCamera(mrpt.pymrpt.mrpt.serialization.CSerializable):
    cameraName: str
    dist: List[float[8]]
    distortion: DistortionModel
    focalLengthMeters: float
    intrinsicParams: Any
    ncols: int
    nrows: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TCamera) -> None: ...
    @overload
    def __init__(self, arg0: TCamera) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def FromYAML(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asYAML(self) -> mrpt.pymrpt.mrpt.containers.yaml: ...
    def assign(self) -> TCamera: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def cx(self) -> float: ...
    @overload
    def cx() -> double: ...
    @overload
    def cx(self, val: float) -> None: ...
    @overload
    def cx(double) -> void: ...
    @overload
    def cy(self) -> float: ...
    @overload
    def cy() -> double: ...
    @overload
    def cy(self, val: float) -> None: ...
    @overload
    def cy(double) -> void: ...
    def dumpAsText(self) -> str: ...
    @overload
    def fx(self) -> float: ...
    @overload
    def fx() -> double: ...
    @overload
    def fx(self, val: float) -> None: ...
    @overload
    def fx(double) -> void: ...
    @overload
    def fy(self) -> float: ...
    @overload
    def fy() -> double: ...
    @overload
    def fy(self, val: float) -> None: ...
    @overload
    def fy(double) -> void: ...
    def getDistortionParamsAsRowVector(self, *args, **kwargs) -> Any: ...
    @overload
    def k1(self) -> float: ...
    @overload
    def k1() -> double: ...
    @overload
    def k1(self, val: float) -> None: ...
    @overload
    def k1(double) -> void: ...
    @overload
    def k2(self) -> float: ...
    @overload
    def k2() -> double: ...
    @overload
    def k2(self, val: float) -> None: ...
    @overload
    def k2(double) -> void: ...
    @overload
    def k3(self) -> float: ...
    @overload
    def k3() -> double: ...
    @overload
    def k3(self, val: float) -> None: ...
    @overload
    def k3(double) -> void: ...
    @overload
    def k4(self) -> float: ...
    @overload
    def k4() -> double: ...
    @overload
    def k4(self, val: float) -> None: ...
    @overload
    def k4(double) -> void: ...
    @overload
    def k5(self) -> float: ...
    @overload
    def k5() -> double: ...
    @overload
    def k5(self, val: float) -> None: ...
    @overload
    def k5(double) -> void: ...
    @overload
    def k6(self) -> float: ...
    @overload
    def k6() -> double: ...
    @overload
    def k6(self, val: float) -> None: ...
    @overload
    def k6(double) -> void: ...
    @overload
    def loadFromConfigFile(self, section: str, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadFromConfigFile(conststd, constclassmrpt) -> void: ...
    @overload
    def loadFromConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    @overload
    def p1(self) -> float: ...
    @overload
    def p1() -> double: ...
    @overload
    def p1(self, val: float) -> None: ...
    @overload
    def p1(double) -> void: ...
    @overload
    def p2(self) -> float: ...
    @overload
    def p2() -> double: ...
    @overload
    def p2(self, val: float) -> None: ...
    @overload
    def p2(double) -> void: ...
    @overload
    def saveToConfigFile(self, section: str, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def saveToConfigFile(conststd, classmrpt) -> void: ...
    def scaleToResolution(self, new_ncols: int, new_nrows: int) -> None: ...
    def setDistortionKannalaBrandt(self, k1_: float, k2_: float, k3_: float, k4_: float) -> None: ...
    @overload
    def setDistortionPlumbBob(self, k1_: float, k2_: float, p1_: float, p2_: float) -> None: ...
    @overload
    def setDistortionPlumbBob(self, k1_: float, k2_: float, p1_: float, p2_: float, k3_: float) -> None: ...
    def setIntrinsicParamsFromValues(self, fx: float, fy: float, cx: float, cy: float) -> None: ...

class TColor:
    A: int
    B: int
    G: int
    R: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, r: int, g: int, b: int) -> None: ...
    @overload
    def __init__(self, r: int, g: int, b: int, alpha: int) -> None: ...
    @overload
    def __init__(self, color_RGB_24bit: int) -> None: ...
    @overload
    def __init__(self, color_RGB_24bit: int, alpha: int) -> None: ...
    @overload
    def __init__(self, arg0: TColor) -> None: ...
    def assign(self, other: TColor) -> TColor: ...
    def black(self, *args, **kwargs) -> Any: ...
    def blue(self, *args, **kwargs) -> Any: ...
    def gray(self, *args, **kwargs) -> Any: ...
    def green(self, *args, **kwargs) -> Any: ...
    def red(self, *args, **kwargs) -> Any: ...
    def white(self, *args, **kwargs) -> Any: ...
    def __iadd__(self, other: TColor) -> TColor: ...
    def __isub__(self, other: TColor) -> TColor: ...

class TColorf:
    A: float
    B: float
    G: float
    R: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, r: float, g: float, b: float) -> None: ...
    @overload
    def __init__(self, r: float, g: float, b: float, alpha: float) -> None: ...
    @overload
    def __init__(self, col: TColor) -> None: ...
    @overload
    def __init__(self, arg0: TColorf) -> None: ...
    def asTColor(self) -> TColor: ...
    def assign(self) -> TColorf: ...

class TColormap:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    cmGRAYSCALE: ClassVar[TColormap] = ...
    cmHOT: ClassVar[TColormap] = ...
    cmJET: ClassVar[TColormap] = ...
    cmNONE: ClassVar[TColormap] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TImageChannels:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    CH_GRAY: ClassVar[TImageChannels] = ...
    CH_RGB: ClassVar[TImageChannels] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TInterpolationMethod:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    IMG_INTERP_AREA: ClassVar[TInterpolationMethod] = ...
    IMG_INTERP_CUBIC: ClassVar[TInterpolationMethod] = ...
    IMG_INTERP_LINEAR: ClassVar[TInterpolationMethod] = ...
    IMG_INTERP_NN: ClassVar[TInterpolationMethod] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TPixelCoord:
    __hash__: ClassVar[None] = ...
    x: int
    y: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, _x: int, _y: int) -> None: ...
    @overload
    def __init__(self, arg0: TPixelCoord) -> None: ...
    def assign(self) -> TPixelCoord: ...
    def __eq__(self, o: TPixelCoord) -> bool: ...

class TPixelCoordf:
    x: float
    y: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, _x: float, _y: float) -> None: ...
    @overload
    def __init__(self, arg0: TPixelCoordf) -> None: ...
    def assign(self) -> TPixelCoordf: ...

class TStereoCamera(mrpt.pymrpt.mrpt.serialization.CSerializable):
    leftCamera: TCamera
    rightCamera: TCamera
    rightCameraPose: mrpt.pymrpt.mrpt.math.TPose3DQuat
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TStereoCamera) -> None: ...
    @overload
    def __init__(self, arg0: TStereoCamera) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> TStereoCamera: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def dumpAsText(self) -> str: ...
    @overload
    def loadFromConfigFile(self, section: str, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase) -> None: ...
    @overload
    def loadFromConfigFile(conststd, constclassmrpt) -> void: ...
    @overload
    def loadFromConfigFile(self, cfg: mrpt.pymrpt.mrpt.config.CConfigFileBase, section: str) -> None: ...
    @overload
    def loadFromConfigFile(constclassmrpt, conststd) -> void: ...
    def saveToConfigFile(self, *args, **kwargs) -> Any: ...
    def scaleToResolution(self, new_ncols: int, new_nrows: int) -> None: ...

class copy_type_t:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    DEEP_COPY: ClassVar[copy_type_t] = ...
    SHALLOW_COPY: ClassVar[copy_type_t] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ctor_CImage_ref_or_gray:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    FAST_REF_OR_CONVERT_TO_GRAY: ClassVar[ctor_CImage_ref_or_gray] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

@overload
def colormap(color_map: TColormap, color_index: float, r: float, g: float, b: float) -> None: ...
@overload
def colormap(color_map: TColormap, color_index: float) -> TColor: ...
def hot2rgb(color_index: float, r: float, g: float, b: float) -> None: ...
def hsv2rgb(h: float, s: float, v: float, r: float, g: float, b: float) -> None: ...
def jet2rgb(color_index: float, r: float, g: float, b: float) -> None: ...
def rgb2hsv(r: float, g: float, b: float, h: float, s: float, v: float) -> None: ...
