/*
 * Copyright 2015 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DEBUGHELPERS_P_H
#define DEBUGHELPERS_P_H

#include <QtCore/QString>

// if qt 6
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
#include <QEventPoint>
#endif

class QMouseEvent;
class QTouchEvent;

// if qt 6
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
QString touchPointStateToString(QEventPoint::State state);
#else
QString touchPointStateToString(Qt::TouchPointState state);
#endif
QString touchEventToString(const QTouchEvent *ev);
QString mouseEventToString(const QMouseEvent *ev);

#endif // DEBUGHELPERS_P_H
