The EmitC dialect allows to convert operations from other MLIR dialects to EmitC
ops. Those can be translated to C/C++ via the Cpp emitter.

The following convention is followed:

*   If template arguments are passed to an `emitc.call_opaque` operation, C++ is
    generated.
*   If tensors are used, C++ is generated.
*   If multiple return values are used within in a functions or an
    `emitc.call_opaque` operation, C++11 is required.
*   If floating-point type template arguments are passed to an `emitc.call_opaque`
    operation, C++20 is required.
*   If `ssize_t` is used, then the code requires the POSIX header `sys/types.h`
    or any of the C++ headers in which the type is defined.
*   If `_Float16` is used, the code requires the support of C additional
    floating types.
*   If `__bf16` is used, the code requires a compiler that supports it, such as 
    GCC or Clang.
*   If `emitc.array` with a dimension of size zero is used, then the code
    requires [a GCC extension](https://gcc.gnu.org/onlinedocs/gcc/Zero-Length.html).
*   Else the generated code is compatible with C99.

These restrictions are neither inherent to the EmitC dialect itself nor to the
Cpp emitter and therefore need to be considered while implementing conversions.

Type conversions are provided for the MLIR type `index` into the unsigned `size_t`
type and its signed counterpart `ptrdiff_t`. Conversions between these two types
are only valid if the `index`-typed values are within 
`[PTRDIFF_MIN, PTRDIFF_MAX]`.

After the conversion, C/C++ code can be emitted with `mlir-translate`. The tool
supports translating MLIR to C/C++ by passing `-mlir-to-cpp`. Furthermore, code
with variables declared at top can be generated by passing the additional
argument `-declare-variables-at-top`.

Besides operations part of the EmitC dialect, the Cpp targets supports
translating the following operations:

*   'cf' Dialect
    *   `cf.br`
    *   `cf.cond_br`
*   'func' Dialect
    *   `func.call`
    *   `func.func`
    *   `func.return`
