; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -ppc-reduce-cr-logicals -verify-machineinstrs -tail-dup-placement=false < %s | FileCheck %s
; RUN: llc -ppc-reduce-cr-logicals -verify-machineinstrs \
; RUN:   -mattr=-isel < %s | FileCheck --check-prefix=CHECK-NO-ISEL %s
target datalayout = "E-m:e-i64:64-n32:64"
target triple = "powerpc64-unknown-linux-gnu"

; FIXME: We should check the operands to the cr* logical operation itself, but
; unfortunately, FileCheck does not yet understand how to do arithmetic, so we
; can't do so without introducing a register-allocation dependency.

define signext i32 @testi32slt(i32 signext %c1, i32 signext %c2, i32 signext %c3, i32 signext %c4, i32 signext %a1, i32 signext %a2) #0 {
; CHECK-LABEL: testi32slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw 5, 6
; CHECK-NEXT:    cmpw 1, 3, 4
; CHECK-NEXT:    crandc 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi32slt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 5, 6
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB0_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB0_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB0_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i32 %c3, %c4
  %cmp3tmp = icmp eq i32 %c1, %c2
  %cmp3 = icmp slt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i32 %a1, i32 %a2
  ret i32 %cond

}

define signext i32 @testi32ult(i32 signext %c1, i32 signext %c2, i32 signext %c3, i32 signext %c4, i32 signext %a1, i32 signext %a2) #0 {
; CHECK-LABEL: testi32ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw 5, 6
; CHECK-NEXT:    cmpw 1, 3, 4
; CHECK-NEXT:    crandc 20, 2, 6
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi32ult:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 5, 6
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB1_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB1_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB1_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i32 %c3, %c4
  %cmp3tmp = icmp eq i32 %c1, %c2
  %cmp3 = icmp ult i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i32 %a1, i32 %a2
  ret i32 %cond

}

define signext i32 @testi32sle(i32 signext %c1, i32 signext %c2, i32 signext %c3, i32 signext %c4, i32 signext %a1, i32 signext %a2) #0 {
; CHECK-LABEL: testi32sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw 5, 6
; CHECK-NEXT:    cmpw 1, 3, 4
; CHECK-NEXT:    crorc 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi32sle:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 5, 6
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB2_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB2_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB2_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i32 %c3, %c4
  %cmp3tmp = icmp eq i32 %c1, %c2
  %cmp3 = icmp sle i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i32 %a1, i32 %a2
  ret i32 %cond

}

define signext i32 @testi32ule(i32 signext %c1, i32 signext %c2, i32 signext %c3, i32 signext %c4, i32 signext %a1, i32 signext %a2) #0 {
; CHECK-LABEL: testi32ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw 5, 6
; CHECK-NEXT:    cmpw 1, 3, 4
; CHECK-NEXT:    crorc 20, 2, 6
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi32ule:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 5, 6
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB3_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB3_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB3_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i32 %c3, %c4
  %cmp3tmp = icmp eq i32 %c1, %c2
  %cmp3 = icmp ule i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i32 %a1, i32 %a2
  ret i32 %cond

}

define signext i32 @testi32eq(i32 signext %c1, i32 signext %c2, i32 signext %c3, i32 signext %c4, i32 signext %a1, i32 signext %a2) #0 {
; CHECK-LABEL: testi32eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw 5, 6
; CHECK-NEXT:    cmpw 1, 3, 4
; CHECK-NEXT:    creqv 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi32eq:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 5, 6
; CHECK-NO-ISEL-NEXT:    cmpw 1, 3, 4
; CHECK-NO-ISEL-NEXT:    creqv 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 20, .LBB4_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB4_2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i32 %c3, %c4
  %cmp3tmp = icmp eq i32 %c1, %c2
  %cmp3 = icmp eq i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i32 %a1, i32 %a2
  ret i32 %cond

}

define signext i32 @testi32sge(i32 signext %c1, i32 signext %c2, i32 signext %c3, i32 signext %c4, i32 signext %a1, i32 signext %a2) #0 {
; CHECK-LABEL: testi32sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw 5, 6
; CHECK-NEXT:    cmpw 1, 3, 4
; CHECK-NEXT:    crorc 20, 2, 6
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi32sge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 5, 6
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB5_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB5_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB5_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i32 %c3, %c4
  %cmp3tmp = icmp eq i32 %c1, %c2
  %cmp3 = icmp sge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i32 %a1, i32 %a2
  ret i32 %cond

}

define signext i32 @testi32uge(i32 signext %c1, i32 signext %c2, i32 signext %c3, i32 signext %c4, i32 signext %a1, i32 signext %a2) #0 {
; CHECK-LABEL: testi32uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw 5, 6
; CHECK-NEXT:    cmpw 1, 3, 4
; CHECK-NEXT:    crorc 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi32uge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 5, 6
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB6_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB6_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB6_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i32 %c3, %c4
  %cmp3tmp = icmp eq i32 %c1, %c2
  %cmp3 = icmp uge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i32 %a1, i32 %a2
  ret i32 %cond

}

define signext i32 @testi32sgt(i32 signext %c1, i32 signext %c2, i32 signext %c3, i32 signext %c4, i32 signext %a1, i32 signext %a2) #0 {
; CHECK-LABEL: testi32sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw 5, 6
; CHECK-NEXT:    cmpw 1, 3, 4
; CHECK-NEXT:    crandc 20, 2, 6
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi32sgt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 5, 6
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB7_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB7_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB7_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i32 %c3, %c4
  %cmp3tmp = icmp eq i32 %c1, %c2
  %cmp3 = icmp sgt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i32 %a1, i32 %a2
  ret i32 %cond

}

define signext i32 @testi32ugt(i32 signext %c1, i32 signext %c2, i32 signext %c3, i32 signext %c4, i32 signext %a1, i32 signext %a2) #0 {
; CHECK-LABEL: testi32ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw 5, 6
; CHECK-NEXT:    cmpw 1, 3, 4
; CHECK-NEXT:    crandc 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi32ugt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 5, 6
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB8_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB8_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB8_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i32 %c3, %c4
  %cmp3tmp = icmp eq i32 %c1, %c2
  %cmp3 = icmp ugt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i32 %a1, i32 %a2
  ret i32 %cond

}

define signext i32 @testi32ne(i32 signext %c1, i32 signext %c2, i32 signext %c3, i32 signext %c4, i32 signext %a1, i32 signext %a2) #0 {
; CHECK-LABEL: testi32ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw 5, 6
; CHECK-NEXT:    cmpw 1, 3, 4
; CHECK-NEXT:    crxor 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi32ne:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpw 5, 6
; CHECK-NO-ISEL-NEXT:    cmpw 1, 3, 4
; CHECK-NO-ISEL-NEXT:    crxor 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 20, .LBB9_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB9_2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i32 %c3, %c4
  %cmp3tmp = icmp eq i32 %c1, %c2
  %cmp3 = icmp ne i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i32 %a1, i32 %a2
  ret i32 %cond

}

define i64 @testi64slt(i64 %c1, i64 %c2, i64 %c3, i64 %c4, i64 %a1, i64 %a2) #0 {
; CHECK-LABEL: testi64slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpd 5, 6
; CHECK-NEXT:    cmpd 1, 3, 4
; CHECK-NEXT:    crandc 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi64slt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 5, 6
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB10_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB10_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB10_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i64 %c3, %c4
  %cmp3tmp = icmp eq i64 %c1, %c2
  %cmp3 = icmp slt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i64 %a1, i64 %a2
  ret i64 %cond

}

define i64 @testi64ult(i64 %c1, i64 %c2, i64 %c3, i64 %c4, i64 %a1, i64 %a2) #0 {
; CHECK-LABEL: testi64ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpd 5, 6
; CHECK-NEXT:    cmpd 1, 3, 4
; CHECK-NEXT:    crandc 20, 2, 6
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi64ult:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 5, 6
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB11_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB11_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB11_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i64 %c3, %c4
  %cmp3tmp = icmp eq i64 %c1, %c2
  %cmp3 = icmp ult i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i64 %a1, i64 %a2
  ret i64 %cond

}

define i64 @testi64sle(i64 %c1, i64 %c2, i64 %c3, i64 %c4, i64 %a1, i64 %a2) #0 {
; CHECK-LABEL: testi64sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpd 5, 6
; CHECK-NEXT:    cmpd 1, 3, 4
; CHECK-NEXT:    crorc 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi64sle:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 5, 6
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB12_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB12_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB12_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i64 %c3, %c4
  %cmp3tmp = icmp eq i64 %c1, %c2
  %cmp3 = icmp sle i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i64 %a1, i64 %a2
  ret i64 %cond

}

define i64 @testi64ule(i64 %c1, i64 %c2, i64 %c3, i64 %c4, i64 %a1, i64 %a2) #0 {
; CHECK-LABEL: testi64ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpd 5, 6
; CHECK-NEXT:    cmpd 1, 3, 4
; CHECK-NEXT:    crorc 20, 2, 6
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi64ule:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 5, 6
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB13_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB13_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB13_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i64 %c3, %c4
  %cmp3tmp = icmp eq i64 %c1, %c2
  %cmp3 = icmp ule i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i64 %a1, i64 %a2
  ret i64 %cond

}

define i64 @testi64eq(i64 %c1, i64 %c2, i64 %c3, i64 %c4, i64 %a1, i64 %a2) #0 {
; CHECK-LABEL: testi64eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpd 5, 6
; CHECK-NEXT:    cmpd 1, 3, 4
; CHECK-NEXT:    creqv 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi64eq:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 5, 6
; CHECK-NO-ISEL-NEXT:    cmpd 1, 3, 4
; CHECK-NO-ISEL-NEXT:    creqv 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 20, .LBB14_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB14_2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i64 %c3, %c4
  %cmp3tmp = icmp eq i64 %c1, %c2
  %cmp3 = icmp eq i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i64 %a1, i64 %a2
  ret i64 %cond

}

define i64 @testi64sge(i64 %c1, i64 %c2, i64 %c3, i64 %c4, i64 %a1, i64 %a2) #0 {
; CHECK-LABEL: testi64sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpd 5, 6
; CHECK-NEXT:    cmpd 1, 3, 4
; CHECK-NEXT:    crorc 20, 2, 6
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi64sge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 5, 6
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB15_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB15_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB15_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i64 %c3, %c4
  %cmp3tmp = icmp eq i64 %c1, %c2
  %cmp3 = icmp sge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i64 %a1, i64 %a2
  ret i64 %cond

}

define i64 @testi64uge(i64 %c1, i64 %c2, i64 %c3, i64 %c4, i64 %a1, i64 %a2) #0 {
; CHECK-LABEL: testi64uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpd 5, 6
; CHECK-NEXT:    cmpd 1, 3, 4
; CHECK-NEXT:    crorc 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi64uge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 5, 6
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB16_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB16_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB16_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i64 %c3, %c4
  %cmp3tmp = icmp eq i64 %c1, %c2
  %cmp3 = icmp uge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i64 %a1, i64 %a2
  ret i64 %cond

}

define i64 @testi64sgt(i64 %c1, i64 %c2, i64 %c3, i64 %c4, i64 %a1, i64 %a2) #0 {
; CHECK-LABEL: testi64sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpd 5, 6
; CHECK-NEXT:    cmpd 1, 3, 4
; CHECK-NEXT:    crandc 20, 2, 6
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi64sgt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 5, 6
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB17_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB17_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB17_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i64 %c3, %c4
  %cmp3tmp = icmp eq i64 %c1, %c2
  %cmp3 = icmp sgt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i64 %a1, i64 %a2
  ret i64 %cond

}

define i64 @testi64ugt(i64 %c1, i64 %c2, i64 %c3, i64 %c4, i64 %a1, i64 %a2) #0 {
; CHECK-LABEL: testi64ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpd 5, 6
; CHECK-NEXT:    cmpd 1, 3, 4
; CHECK-NEXT:    crandc 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi64ugt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 5, 6
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB18_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB18_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB18_3: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i64 %c3, %c4
  %cmp3tmp = icmp eq i64 %c1, %c2
  %cmp3 = icmp ugt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i64 %a1, i64 %a2
  ret i64 %cond

}

define i64 @testi64ne(i64 %c1, i64 %c2, i64 %c3, i64 %c4, i64 %a1, i64 %a2) #0 {
; CHECK-LABEL: testi64ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpd 5, 6
; CHECK-NEXT:    cmpd 1, 3, 4
; CHECK-NEXT:    crxor 20, 6, 2
; CHECK-NEXT:    isel 3, 7, 8, 20
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testi64ne:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    cmpd 5, 6
; CHECK-NO-ISEL-NEXT:    cmpd 1, 3, 4
; CHECK-NO-ISEL-NEXT:    crxor 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 20, .LBB19_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    mr 7, 8
; CHECK-NO-ISEL-NEXT:  .LBB19_2: # %entry
; CHECK-NO-ISEL-NEXT:    mr 3, 7
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = icmp eq i64 %c3, %c4
  %cmp3tmp = icmp eq i64 %c1, %c2
  %cmp3 = icmp ne i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, i64 %a1, i64 %a2
  ret i64 %cond

}

define float @testfloatslt(float %c1, float %c2, float %c3, float %c4, float %a1, float %a2) #0 {
; CHECK-LABEL: testfloatslt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB20_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 12, 2, .LBB20_3
; CHECK-NEXT:  .LBB20_2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB20_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testfloatslt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB20_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB20_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB20_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp slt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, float %a1, float %a2
  ret float %cond

}

define float @testfloatult(float %c1, float %c2, float %c3, float %c4, float %a1, float %a2) #0 {
; CHECK-LABEL: testfloatult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB21_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 4, 2, .LBB21_3
; CHECK-NEXT:  .LBB21_2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB21_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testfloatult:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB21_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB21_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB21_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ult i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, float %a1, float %a2
  ret float %cond

}

define float @testfloatsle(float %c1, float %c2, float %c3, float %c4, float %a1, float %a2) #0 {
; CHECK-LABEL: testfloatsle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB22_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 12, 2, .LBB22_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB22_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testfloatsle:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB22_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB22_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB22_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp sle i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, float %a1, float %a2
  ret float %cond

}

define float @testfloatule(float %c1, float %c2, float %c3, float %c4, float %a1, float %a2) #0 {
; CHECK-LABEL: testfloatule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB23_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 4, 2, .LBB23_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB23_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testfloatule:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB23_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB23_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB23_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ule i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, float %a1, float %a2
  ret float %cond

}

define float @testfloateq(float %c1, float %c2, float %c3, float %c4, float %a1, float %a2) #0 {
; CHECK-LABEL: testfloateq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    fcmpu 1, 1, 2
; CHECK-NEXT:    creqv 20, 6, 2
; CHECK-NEXT:    bc 12, 20, .LBB24_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB24_2: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testfloateq:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 1, 2
; CHECK-NO-ISEL-NEXT:    creqv 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 20, .LBB24_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB24_2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp eq i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, float %a1, float %a2
  ret float %cond

}

define float @testfloatsge(float %c1, float %c2, float %c3, float %c4, float %a1, float %a2) #0 {
; CHECK-LABEL: testfloatsge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB25_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 4, 2, .LBB25_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB25_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testfloatsge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB25_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB25_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB25_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp sge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, float %a1, float %a2
  ret float %cond

}

define float @testfloatuge(float %c1, float %c2, float %c3, float %c4, float %a1, float %a2) #0 {
; CHECK-LABEL: testfloatuge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB26_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 12, 2, .LBB26_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB26_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testfloatuge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB26_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB26_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB26_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp uge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, float %a1, float %a2
  ret float %cond

}

define float @testfloatsgt(float %c1, float %c2, float %c3, float %c4, float %a1, float %a2) #0 {
; CHECK-LABEL: testfloatsgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB27_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 4, 2, .LBB27_3
; CHECK-NEXT:  .LBB27_2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB27_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testfloatsgt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB27_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB27_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB27_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp sgt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, float %a1, float %a2
  ret float %cond

}

define float @testfloatugt(float %c1, float %c2, float %c3, float %c4, float %a1, float %a2) #0 {
; CHECK-LABEL: testfloatugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB28_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 12, 2, .LBB28_3
; CHECK-NEXT:  .LBB28_2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB28_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testfloatugt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB28_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB28_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB28_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ugt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, float %a1, float %a2
  ret float %cond

}

define float @testfloatne(float %c1, float %c2, float %c3, float %c4, float %a1, float %a2) #0 {
; CHECK-LABEL: testfloatne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    fcmpu 1, 1, 2
; CHECK-NEXT:    crxor 20, 6, 2
; CHECK-NEXT:    bc 12, 20, .LBB29_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB29_2: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testfloatne:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 1, 2
; CHECK-NO-ISEL-NEXT:    crxor 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 20, .LBB29_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB29_2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ne i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, float %a1, float %a2
  ret float %cond

}

define double @testdoubleslt(double %c1, double %c2, double %c3, double %c4, double %a1, double %a2) #0 {
; CHECK-LABEL: testdoubleslt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB30_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 12, 2, .LBB30_3
; CHECK-NEXT:  .LBB30_2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB30_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testdoubleslt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB30_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB30_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB30_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq double %c3, %c4
  %cmp3tmp = fcmp oeq double %c1, %c2
  %cmp3 = icmp slt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, double %a1, double %a2
  ret double %cond

}

define double @testdoubleult(double %c1, double %c2, double %c3, double %c4, double %a1, double %a2) #0 {
; CHECK-LABEL: testdoubleult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB31_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 4, 2, .LBB31_3
; CHECK-NEXT:  .LBB31_2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB31_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testdoubleult:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB31_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB31_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB31_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq double %c3, %c4
  %cmp3tmp = fcmp oeq double %c1, %c2
  %cmp3 = icmp ult i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, double %a1, double %a2
  ret double %cond

}

define double @testdoublesle(double %c1, double %c2, double %c3, double %c4, double %a1, double %a2) #0 {
; CHECK-LABEL: testdoublesle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB32_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 12, 2, .LBB32_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB32_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testdoublesle:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB32_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB32_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB32_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq double %c3, %c4
  %cmp3tmp = fcmp oeq double %c1, %c2
  %cmp3 = icmp sle i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, double %a1, double %a2
  ret double %cond

}

define double @testdoubleule(double %c1, double %c2, double %c3, double %c4, double %a1, double %a2) #0 {
; CHECK-LABEL: testdoubleule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB33_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 4, 2, .LBB33_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB33_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testdoubleule:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB33_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB33_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB33_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq double %c3, %c4
  %cmp3tmp = fcmp oeq double %c1, %c2
  %cmp3 = icmp ule i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, double %a1, double %a2
  ret double %cond

}

define double @testdoubleeq(double %c1, double %c2, double %c3, double %c4, double %a1, double %a2) #0 {
; CHECK-LABEL: testdoubleeq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    fcmpu 1, 1, 2
; CHECK-NEXT:    creqv 20, 6, 2
; CHECK-NEXT:    bc 12, 20, .LBB34_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB34_2: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testdoubleeq:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 1, 2
; CHECK-NO-ISEL-NEXT:    creqv 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 20, .LBB34_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB34_2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq double %c3, %c4
  %cmp3tmp = fcmp oeq double %c1, %c2
  %cmp3 = icmp eq i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, double %a1, double %a2
  ret double %cond

}

define double @testdoublesge(double %c1, double %c2, double %c3, double %c4, double %a1, double %a2) #0 {
; CHECK-LABEL: testdoublesge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB35_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 4, 2, .LBB35_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB35_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testdoublesge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB35_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB35_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB35_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq double %c3, %c4
  %cmp3tmp = fcmp oeq double %c1, %c2
  %cmp3 = icmp sge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, double %a1, double %a2
  ret double %cond

}

define double @testdoubleuge(double %c1, double %c2, double %c3, double %c4, double %a1, double %a2) #0 {
; CHECK-LABEL: testdoubleuge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB36_3
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 12, 2, .LBB36_3
; CHECK-NEXT:  # %bb.2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB36_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testdoubleuge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB36_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB36_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB36_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq double %c3, %c4
  %cmp3tmp = fcmp oeq double %c1, %c2
  %cmp3 = icmp uge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, double %a1, double %a2
  ret double %cond

}

define double @testdoublesgt(double %c1, double %c2, double %c3, double %c4, double %a1, double %a2) #0 {
; CHECK-LABEL: testdoublesgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB37_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 4, 2, .LBB37_3
; CHECK-NEXT:  .LBB37_2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB37_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testdoublesgt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB37_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB37_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB37_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq double %c3, %c4
  %cmp3tmp = fcmp oeq double %c1, %c2
  %cmp3 = icmp sgt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, double %a1, double %a2
  ret double %cond

}

define double @testdoubleugt(double %c1, double %c2, double %c3, double %c4, double %a1, double %a2) #0 {
; CHECK-LABEL: testdoubleugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB38_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bc 12, 2, .LBB38_3
; CHECK-NEXT:  .LBB38_2: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB38_3: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testdoubleugt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB38_3
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB38_3
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
; CHECK-NO-ISEL-NEXT:  .LBB38_3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq double %c3, %c4
  %cmp3tmp = fcmp oeq double %c1, %c2
  %cmp3 = icmp ugt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, double %a1, double %a2
  ret double %cond

}

define double @testdoublene(double %c1, double %c2, double %c3, double %c4, double %a1, double %a2) #0 {
; CHECK-LABEL: testdoublene:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    fcmpu 1, 1, 2
; CHECK-NEXT:    crxor 20, 6, 2
; CHECK-NEXT:    bc 12, 20, .LBB39_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fmr 5, 6
; CHECK-NEXT:  .LBB39_2: # %entry
; CHECK-NEXT:    fmr 1, 5
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testdoublene:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 1, 2
; CHECK-NO-ISEL-NEXT:    crxor 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bc 12, 20, .LBB39_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 5, 6
; CHECK-NO-ISEL-NEXT:  .LBB39_2: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 5
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq double %c3, %c4
  %cmp3tmp = fcmp oeq double %c1, %c2
  %cmp3 = icmp ne i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, double %a1, double %a2
  ret double %cond

}

define <4 x float> @testv4floatslt(float %c1, float %c2, float %c3, float %c4, <4 x float> %a1, <4 x float> %a2) #0 {
; CHECK-LABEL: testv4floatslt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB40_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  .LBB40_2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv4floatslt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB40_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  .LBB40_2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp slt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <4 x float> %a1, <4 x float> %a2
  ret <4 x float> %cond

}

define <4 x float> @testv4floatult(float %c1, float %c2, float %c3, float %c4, <4 x float> %a1, <4 x float> %a2) #0 {
; CHECK-LABEL: testv4floatult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB41_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  .LBB41_2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv4floatult:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB41_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  .LBB41_2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ult i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <4 x float> %a1, <4 x float> %a2
  ret <4 x float> %cond

}

define <4 x float> @testv4floatsle(float %c1, float %c2, float %c3, float %c4, <4 x float> %a1, <4 x float> %a2) #0 {
; CHECK-LABEL: testv4floatsle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  # %bb.2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv4floatsle:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp sle i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <4 x float> %a1, <4 x float> %a2
  ret <4 x float> %cond

}

define <4 x float> @testv4floatule(float %c1, float %c2, float %c3, float %c4, <4 x float> %a1, <4 x float> %a2) #0 {
; CHECK-LABEL: testv4floatule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  # %bb.2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv4floatule:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ule i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <4 x float> %a1, <4 x float> %a2
  ret <4 x float> %cond

}

define <4 x float> @testv4floateq(float %c1, float %c2, float %c3, float %c4, <4 x float> %a1, <4 x float> %a2) #0 {
; CHECK-LABEL: testv4floateq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    fcmpu 1, 1, 2
; CHECK-NEXT:    creqv 20, 6, 2
; CHECK-NEXT:    bclr 12, 20, 0
; CHECK-NEXT:  # %bb.1: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv4floateq:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 1, 2
; CHECK-NO-ISEL-NEXT:    creqv 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 20, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp eq i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <4 x float> %a1, <4 x float> %a2
  ret <4 x float> %cond

}

define <4 x float> @testv4floatsge(float %c1, float %c2, float %c3, float %c4, <4 x float> %a1, <4 x float> %a2) #0 {
; CHECK-LABEL: testv4floatsge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  # %bb.2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv4floatsge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp sge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <4 x float> %a1, <4 x float> %a2
  ret <4 x float> %cond

}

define <4 x float> @testv4floatuge(float %c1, float %c2, float %c3, float %c4, <4 x float> %a1, <4 x float> %a2) #0 {
; CHECK-LABEL: testv4floatuge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  # %bb.2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv4floatuge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp uge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <4 x float> %a1, <4 x float> %a2
  ret <4 x float> %cond

}

define <4 x float> @testv4floatsgt(float %c1, float %c2, float %c3, float %c4, <4 x float> %a1, <4 x float> %a2) #0 {
; CHECK-LABEL: testv4floatsgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB47_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  .LBB47_2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv4floatsgt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB47_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  .LBB47_2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp sgt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <4 x float> %a1, <4 x float> %a2
  ret <4 x float> %cond

}

define <4 x float> @testv4floatugt(float %c1, float %c2, float %c3, float %c4, <4 x float> %a1, <4 x float> %a2) #0 {
; CHECK-LABEL: testv4floatugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB48_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  .LBB48_2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv4floatugt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB48_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  .LBB48_2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ugt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <4 x float> %a1, <4 x float> %a2
  ret <4 x float> %cond

}

define <4 x float> @testv4floatne(float %c1, float %c2, float %c3, float %c4, <4 x float> %a1, <4 x float> %a2) #0 {
; CHECK-LABEL: testv4floatne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    fcmpu 1, 1, 2
; CHECK-NEXT:    crxor 20, 6, 2
; CHECK-NEXT:    bclr 12, 20, 0
; CHECK-NEXT:  # %bb.1: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv4floatne:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 1, 2
; CHECK-NO-ISEL-NEXT:    crxor 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 20, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ne i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <4 x float> %a1, <4 x float> %a2
  ret <4 x float> %cond

}

define ppc_fp128 @testppc_fp128eq(ppc_fp128 %c1, ppc_fp128 %c2, ppc_fp128 %c3, ppc_fp128 %c4, ppc_fp128 %a1, ppc_fp128 %a2) #0 {
; CHECK-LABEL: testppc_fp128eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 6, 8
; CHECK-NEXT:    fcmpu 1, 5, 7
; CHECK-NEXT:    crand 20, 6, 2
; CHECK-NEXT:    fcmpu 0, 2, 4
; CHECK-NEXT:    fcmpu 1, 1, 3
; CHECK-NEXT:    crand 21, 6, 2
; CHECK-NEXT:    crxor 20, 21, 20
; CHECK-NEXT:    bc 12, 20, .LBB50_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fmr 11, 9
; CHECK-NEXT:  .LBB50_2: # %entry
; CHECK-NEXT:    bc 12, 20, .LBB50_4
; CHECK-NEXT:  # %bb.3: # %entry
; CHECK-NEXT:    fmr 12, 10
; CHECK-NEXT:  .LBB50_4: # %entry
; CHECK-NEXT:    fmr 1, 11
; CHECK-NEXT:    fmr 2, 12
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testppc_fp128eq:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 6, 8
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 5, 7
; CHECK-NO-ISEL-NEXT:    crand 20, 6, 2
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 2, 4
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 1, 3
; CHECK-NO-ISEL-NEXT:    crand 21, 6, 2
; CHECK-NO-ISEL-NEXT:    crxor 20, 21, 20
; CHECK-NO-ISEL-NEXT:    bc 12, 20, .LBB50_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 11, 9
; CHECK-NO-ISEL-NEXT:  .LBB50_2: # %entry
; CHECK-NO-ISEL-NEXT:    bc 12, 20, .LBB50_4
; CHECK-NO-ISEL-NEXT:  # %bb.3: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 12, 10
; CHECK-NO-ISEL-NEXT:  .LBB50_4: # %entry
; CHECK-NO-ISEL-NEXT:    fmr 1, 11
; CHECK-NO-ISEL-NEXT:    fmr 2, 12
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq ppc_fp128 %c3, %c4
  %cmp3tmp = fcmp oeq ppc_fp128 %c1, %c2
  %cmp3 = icmp eq i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, ppc_fp128 %a1, ppc_fp128 %a2
  ret ppc_fp128 %cond

; FIXME: Because of the way that the late SELECT_* pseudo-instruction expansion
; works, we end up with two blocks with the same predicate. These could be
; combined.

}

define <2 x double> @testv2doubleslt(float %c1, float %c2, float %c3, float %c4, <2 x double> %a1, <2 x double> %a2) #0 {
; CHECK-LABEL: testv2doubleslt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB51_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  .LBB51_2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv2doubleslt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB51_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  .LBB51_2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp slt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <2 x double> %a1, <2 x double> %a2
  ret <2 x double> %cond

}

define <2 x double> @testv2doubleult(float %c1, float %c2, float %c3, float %c4, <2 x double> %a1, <2 x double> %a2) #0 {
; CHECK-LABEL: testv2doubleult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB52_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  .LBB52_2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv2doubleult:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB52_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  .LBB52_2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ult i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <2 x double> %a1, <2 x double> %a2
  ret <2 x double> %cond

}

define <2 x double> @testv2doublesle(float %c1, float %c2, float %c3, float %c4, <2 x double> %a1, <2 x double> %a2) #0 {
; CHECK-LABEL: testv2doublesle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  # %bb.2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv2doublesle:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp sle i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <2 x double> %a1, <2 x double> %a2
  ret <2 x double> %cond

}

define <2 x double> @testv2doubleule(float %c1, float %c2, float %c3, float %c4, <2 x double> %a1, <2 x double> %a2) #0 {
; CHECK-LABEL: testv2doubleule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  # %bb.2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv2doubleule:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ule i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <2 x double> %a1, <2 x double> %a2
  ret <2 x double> %cond

}

define <2 x double> @testv2doubleeq(float %c1, float %c2, float %c3, float %c4, <2 x double> %a1, <2 x double> %a2) #0 {
; CHECK-LABEL: testv2doubleeq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    fcmpu 1, 1, 2
; CHECK-NEXT:    creqv 20, 6, 2
; CHECK-NEXT:    bclr 12, 20, 0
; CHECK-NEXT:  # %bb.1: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv2doubleeq:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 1, 2
; CHECK-NO-ISEL-NEXT:    creqv 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 20, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp eq i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <2 x double> %a1, <2 x double> %a2
  ret <2 x double> %cond

}

define <2 x double> @testv2doublesge(float %c1, float %c2, float %c3, float %c4, <2 x double> %a1, <2 x double> %a2) #0 {
; CHECK-LABEL: testv2doublesge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  # %bb.2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv2doublesge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp sge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <2 x double> %a1, <2 x double> %a2
  ret <2 x double> %cond

}

define <2 x double> @testv2doubleuge(float %c1, float %c2, float %c3, float %c4, <2 x double> %a1, <2 x double> %a2) #0 {
; CHECK-LABEL: testv2doubleuge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  # %bb.2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv2doubleuge:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  # %bb.2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp uge i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <2 x double> %a1, <2 x double> %a2
  ret <2 x double> %cond

}

define <2 x double> @testv2doublesgt(float %c1, float %c2, float %c3, float %c4, <2 x double> %a1, <2 x double> %a2) #0 {
; CHECK-LABEL: testv2doublesgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 4, 2, .LBB58_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 4, 2, 0
; CHECK-NEXT:  .LBB58_2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv2doublesgt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 4, 2, .LBB58_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 4, 2, 0
; CHECK-NO-ISEL-NEXT:  .LBB58_2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp sgt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <2 x double> %a1, <2 x double> %a2
  ret <2 x double> %cond

}

define <2 x double> @testv2doubleugt(float %c1, float %c2, float %c3, float %c4, <2 x double> %a1, <2 x double> %a2) #0 {
; CHECK-LABEL: testv2doubleugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    bc 12, 2, .LBB59_2
; CHECK-NEXT:  # %bb.1: # %entry
; CHECK-NEXT:    fcmpu 0, 1, 2
; CHECK-NEXT:    bclr 12, 2, 0
; CHECK-NEXT:  .LBB59_2: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv2doubleugt:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    bc 12, 2, .LBB59_2
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 1, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 2, 0
; CHECK-NO-ISEL-NEXT:  .LBB59_2: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ugt i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <2 x double> %a1, <2 x double> %a2
  ret <2 x double> %cond

}

define <2 x double> @testv2doublene(float %c1, float %c2, float %c3, float %c4, <2 x double> %a1, <2 x double> %a2) #0 {
; CHECK-LABEL: testv2doublene:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcmpu 0, 3, 4
; CHECK-NEXT:    fcmpu 1, 1, 2
; CHECK-NEXT:    crxor 20, 6, 2
; CHECK-NEXT:    bclr 12, 20, 0
; CHECK-NEXT:  # %bb.1: # %select.false
; CHECK-NEXT:    vmr 2, 3
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: testv2doublene:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    fcmpu 0, 3, 4
; CHECK-NO-ISEL-NEXT:    fcmpu 1, 1, 2
; CHECK-NO-ISEL-NEXT:    crxor 20, 6, 2
; CHECK-NO-ISEL-NEXT:    bclr 12, 20, 0
; CHECK-NO-ISEL-NEXT:  # %bb.1: # %select.false
; CHECK-NO-ISEL-NEXT:    vmr 2, 3
; CHECK-NO-ISEL-NEXT:    blr
entry:
  %cmp1 = fcmp oeq float %c3, %c4
  %cmp3tmp = fcmp oeq float %c1, %c2
  %cmp3 = icmp ne i1 %cmp3tmp, %cmp1
  %cond = select i1 %cmp3, <2 x double> %a1, <2 x double> %a2
  ret <2 x double> %cond

}

attributes #0 = { nounwind readnone "target-cpu"="pwr7" }

