; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512fp16 -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=CHECK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16 -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=CHECK

declare <8 x half> @llvm.experimental.constrained.fadd.v8f16(<8 x half>, <8 x half>, metadata, metadata)
declare <8 x half> @llvm.experimental.constrained.fsub.v8f16(<8 x half>, <8 x half>, metadata, metadata)
declare <8 x half> @llvm.experimental.constrained.fmul.v8f16(<8 x half>, <8 x half>, metadata, metadata)
declare <8 x half> @llvm.experimental.constrained.fdiv.v8f16(<8 x half>, <8 x half>, metadata, metadata)
declare <8 x half> @llvm.experimental.constrained.sqrt.v8f16(<8 x half>, metadata, metadata)
declare half @llvm.experimental.constrained.fptrunc.f16.f32(float, metadata, metadata)
declare half @llvm.experimental.constrained.fptrunc.f16.f64(double, metadata, metadata)
declare <2 x half> @llvm.experimental.constrained.fptrunc.v2f16.v2f32(<2 x float>, metadata, metadata)
declare <4 x half> @llvm.experimental.constrained.fptrunc.v4f16.v4f32(<4 x float>, metadata, metadata)
declare <2 x half> @llvm.experimental.constrained.fptrunc.v2f16.v2f64(<2 x double>, metadata, metadata)
declare float @llvm.experimental.constrained.fpext.f32.f16(half, metadata)
declare double @llvm.experimental.constrained.fpext.f64.f16(half, metadata)
declare <2 x float> @llvm.experimental.constrained.fpext.v2f32.v2f16(<2 x half>, metadata)
declare <4 x float> @llvm.experimental.constrained.fpext.v4f32.v4f16(<4 x half>, metadata)
declare <2 x double> @llvm.experimental.constrained.fpext.v2f64.v2f16(<2 x half>, metadata)
declare <8 x half> @llvm.experimental.constrained.fma.v8f16(<8 x half>, <8 x half>, <8 x half>, metadata, metadata)

define <8 x half> @f2(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaddph %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x half> @llvm.experimental.constrained.fadd.v8f16(<8 x half> %a, <8 x half> %b,
                                                                   metadata !"round.dynamic",
                                                                   metadata !"fpexcept.strict") #0
  ret <8 x half> %ret
}

define <8 x half> @f4(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsubph %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x half> @llvm.experimental.constrained.fsub.v8f16(<8 x half> %a, <8 x half> %b,
                                                                   metadata !"round.dynamic",
                                                                   metadata !"fpexcept.strict") #0
  ret <8 x half> %ret
}

define <8 x half> @f6(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmulph %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x half> @llvm.experimental.constrained.fmul.v8f16(<8 x half> %a, <8 x half> %b,
                                                                   metadata !"round.dynamic",
                                                                   metadata !"fpexcept.strict") #0
  ret <8 x half> %ret
}

define <8 x half> @f8(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vdivph %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x half> @llvm.experimental.constrained.fdiv.v8f16(<8 x half> %a, <8 x half> %b,
                                                                   metadata !"round.dynamic",
                                                                   metadata !"fpexcept.strict") #0
  ret <8 x half> %ret
}

define <8 x half> @f10(<8 x half> %a) #0 {
; CHECK-LABEL: f10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsqrtph %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %sqrt = call <8 x half> @llvm.experimental.constrained.sqrt.v8f16(
                              <8 x half> %a,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #0
  ret <8 x half > %sqrt
}

define <8 x half> @f11(<2 x double> %a0, <8 x half> %a1) #0 {
; CHECK-LABEL: f11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtsd2sh %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vmovsh %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ext = extractelement <2 x double> %a0, i32 0
  %cvt = call half @llvm.experimental.constrained.fptrunc.f16.f64(double %ext,
                                                                  metadata !"round.dynamic",
                                                                  metadata !"fpexcept.strict") #0
  %res = insertelement <8 x half> %a1, half %cvt, i32 0
  ret <8 x half> %res
}

define <2 x double> @f12(<2 x double> %a0, <8 x half> %a1) #0 {
; CHECK-LABEL: f12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtsh2sd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; CHECK-NEXT:    ret{{[l|q]}}
  %ext = extractelement <8 x half> %a1, i32 0
  %cvt = call double @llvm.experimental.constrained.fpext.f64.f16(half %ext,
                                                                  metadata !"fpexcept.strict") #0
  %res = insertelement <2 x double> %a0, double %cvt, i32 0
  ret <2 x double> %res
}

define <8 x half> @f13(<8 x half> %a, <8 x half> %b, <8 x half> %c) #0 {
; CHECK-LABEL: f13:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ph %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = call <8 x half> @llvm.experimental.constrained.fma.v8f16(<8 x half> %a, <8 x half> %b, <8 x half> %c,
                                                                  metadata !"round.dynamic",
                                                                  metadata !"fpexcept.strict") #0
  ret <8 x half> %res
}

define <2 x double> @f15(<2 x half> %a) #0 {
; CHECK-LABEL: f15:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2pd %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x double> @llvm.experimental.constrained.fpext.v2f64.v2f16(
                                <2 x half> %a,
                                metadata !"fpexcept.strict") #0
  ret <2 x double> %ret
}

define <2 x half> @f16(<2 x double> %a) #0 {
; CHECK-LABEL: f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtpd2ph %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x half> @llvm.experimental.constrained.fptrunc.v2f16.v2f64(
                                <2 x double> %a,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #0
  ret <2 x half> %ret
}

define <8 x half> @f17(<4 x float> %a0, <8 x half> %a1) #0 {
; CHECK-LABEL: f17:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtss2sh %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vmovsh %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ext = extractelement <4 x float> %a0, i32 0
  %cvt = call half @llvm.experimental.constrained.fptrunc.f16.f32(float %ext,
                                                                  metadata !"round.dynamic",
                                                                  metadata !"fpexcept.strict") #0
  %res = insertelement <8 x half> %a1, half %cvt, i32 0
  ret <8 x half> %res
}

define <4 x float> @f18(<4 x float> %a0, <8 x half> %a1) #0 {
; CHECK-LABEL: f18:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtsh2ss %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vmovss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; CHECK-NEXT:    ret{{[l|q]}}
  %ext = extractelement <8 x half> %a1, i32 0
  %cvt = call float @llvm.experimental.constrained.fpext.f32.f16(half %ext,
                                                                  metadata !"fpexcept.strict") #0
  %res = insertelement <4 x float> %a0, float %cvt, i32 0
  ret <4 x float> %res
}

define <2 x float> @f19(<2 x half> %a) #0 {
; CHECK-LABEL: f19:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2,3]
; CHECK-NEXT:    vcvtph2psx %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x float> @llvm.experimental.constrained.fpext.v2f32.v2f16(
                                <2 x half> %a,
                                metadata !"fpexcept.strict") #0
  ret <2 x float> %ret
}

define <4 x float> @f20(<4 x half> %a) #0 {
; CHECK-LABEL: f20:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2psx %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x float> @llvm.experimental.constrained.fpext.v4f32.v4f16(
                                <4 x half> %a,
                                metadata !"fpexcept.strict") #0
  ret <4 x float> %ret
}

define <2 x half> @f21(<2 x float> %a) #0 {
; CHECK-LABEL: f21:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; CHECK-NEXT:    vcvtps2phx %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <2 x half> @llvm.experimental.constrained.fptrunc.v2f16.v2f32(
                                <2 x float> %a,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #0
  ret <2 x half> %ret
}

define <4 x half> @f22(<4 x float> %a) #0 {
; CHECK-LABEL: f22:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtps2phx %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <4 x half> @llvm.experimental.constrained.fptrunc.v4f16.v4f32(
                                <4 x float> %a,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #0
  ret <4 x half> %ret
}

attributes #0 = { strictfp }
