; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu | FileCheck %s

; Check that multiple instances of 64-bit constants encodable as
; 32-bit immediates are merged for code size savings.

; Immediates with multiple users should not be pulled into instructions when
; optimizing for code size (but 8-bit immediates are exceptions).

define i1 @imm_multiple_users(i64 %a, ptr %b) optsize {
; CHECK-LABEL: imm_multiple_users:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq $-1, (%rsi)
; CHECK-NEXT:    cmpq $-1, %rdi
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  store i64 -1, ptr %b, align 8
  %cmp = icmp eq i64 %a, -1
  ret i1 %cmp
}

define i1 @imm_multiple_users_pgso(i64 %a, ptr %b) !prof !14 {
; CHECK-LABEL: imm_multiple_users_pgso:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq $-1, (%rsi)
; CHECK-NEXT:    cmpq $-1, %rdi
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  store i64 -1, ptr %b, align 8
  %cmp = icmp eq i64 %a, -1
  ret i1 %cmp
}

declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i1)

; Inlined memsets requiring multiple same-sized stores should be lowered using
; the register, rather than immediate, form of stores when optimizing for
; code size.
define void @memset_zero(ptr noalias nocapture %D) optsize {
; CHECK-LABEL: memset_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    movq %rax, 7(%rdi)
; CHECK-NEXT:    movq %rax, (%rdi)
; CHECK-NEXT:    retq
  tail call void @llvm.memset.p0.i64(ptr %D, i8 0, i64 15, i1 false)
  ret void
}

define void @memset_zero_pgso(ptr noalias nocapture %D) !prof !14 {
; CHECK-LABEL: memset_zero_pgso:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    movq %rax, 7(%rdi)
; CHECK-NEXT:    movq %rax, (%rdi)
; CHECK-NEXT:    retq
  tail call void @llvm.memset.p0.i64(ptr %D, i8 0, i64 15, i1 false)
  ret void
}

!llvm.module.flags = !{!0}
!0 = !{i32 1, !"ProfileSummary", !1}
!1 = !{!2, !3, !4, !5, !6, !7, !8, !9}
!2 = !{!"ProfileFormat", !"InstrProf"}
!3 = !{!"TotalCount", i64 10000}
!4 = !{!"MaxCount", i64 10}
!5 = !{!"MaxInternalCount", i64 1}
!6 = !{!"MaxFunctionCount", i64 1000}
!7 = !{!"NumCounts", i64 3}
!8 = !{!"NumFunctions", i64 3}
!9 = !{!"DetailedSummary", !10}
!10 = !{!11, !12, !13}
!11 = !{i32 10000, i64 100, i32 1}
!12 = !{i32 999000, i64 100, i32 1}
!13 = !{i32 999999, i64 1, i32 2}
!14 = !{!"function_entry_count", i64 0}
