
2020-11-19 Triage Log

This was a relatively mixed week, with some very large performance wins balanced out by a relatively large range of benchmarks seeing small performance regressions. 

The winner this week for largest performance improvement was [#78826](https://github.com/rust-lang/rust/issues/78826) which saw huge gains in the relatively new derive stress benchmark.

Triage done by **@rylev**.
Revision range: [cf9cf7c923eb01146971429044f216a3ca905e06..c919f490bbcd2b29b74016101f7ec71aaa24bdbb](https://perf.rust-lang.org/?start=cf9cf7c923eb01146971429044f216a3ca905e06&end=c919f490bbcd2b29b74016101f7ec71aaa24bdbb&absolute=false&stat=instructions%3Au)

5 Regressions, 5 Improvements, 2 Mixed

6 rollups had perfomance impacts (3 negative, 1 positive, 2 mixed)

#### Regressions

[#76256](https://github.com/rust-lang/rust/issues/76256)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=7f5a42b073dc2bee2aa625052eb066ee07072048&end=9722952f0bed5815cb22cb4878be09fb39f92804&stat=instructions:u) (up to 1.4% on `incr-unchanged` builds of `externs-check`)
- Changes to the serialization of span end line/column.
- This regresses performance slightly but is a necessary correctness fix that was affecting incremental builds (see the linked PR for many related issues). The performance lost here is balanced out by a related change to the [hashing algorithm](https://github.com/rust-lang/rust/pull/77476) introduced previously.

[#78998](https://github.com/rust-lang/rust/issues/78998)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=9722952f0bed5815cb22cb4878be09fb39f92804&end=e80ee05bfc135d7d800f3fcc89bc005d6858cd9b&stat=instructions:u) (up to 1.2% on `incr-unchanged` builds of `deep-vector-check`)
- Rollup
- Most likely introduced by [#78836](https://github.com/rust-lang/rust/pull/78836) (Implement destructuring assignment for structs and slices)

[#79065](https://github.com/rust-lang/rust/issues/79065)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=361c4ea22486557ec50c4fc6a93d60e7476ecbea&end=75042566d1c90d912f22e4db43b6d3af98447986&stat=instructions:u) (up to 2.9% on `full` builds of `deeply-nested-async-check`)
- Rollup

[#78801](https://github.com/rust-lang/rust/issues/78801)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=9b2b02a840f358bcadef5c3ae861d2852da20b3d&end=b5c37e86ff1782923e3abfbf5491dd383fcf827d&stat=instructions:u) (up to 2.3% on `full` builds of `inflate-check`)
- Initial implementation of precise capture analysis in closures

[#79128](https://github.com/rust-lang/rust/issues/79128)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=54508a26eb0595eb8417a4643f2ee572d6ca33d3&end=efcb3b39203a0d54269ca274601b8f73207fe10d&stat=instructions:u) (up to 2.5% on `full` builds of `ctfe-stress-4-check`)
- Rollup
- The affected benchmark is prone to noise, so it's not sure that this is an actual regression.

#### Improvements

[#78826](https://github.com/rust-lang/rust/issues/78826)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f036a8f3bee55ea7566ac7a631ad3193696204b4&end=a38f8fb674e6a0a6fc358655c6ce6069235f621a&stat=instructions:u) (up to -49.0% on `incr-unchanged` builds of `derive-check`)
- Change how macro_rules scopes are tracked during expansion so that they do not grow to big.
- This was particularly helpful in the new derive stress test benchmark, but yielded improvements in several other benchmarks.

[#78825](https://github.com/rust-lang/rust/issues/78825)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=38030ffb4e735b26260848b744c0910a5641e1db&end=d4ea0b3e46a0303d5802b632e88ba1ba84d9d16f&stat=instructions:u) (up to -1.5% on `incr-patched: println` builds of `coercions-debug`)
- Changes several usages of `unwrap_or` to `unwrap_or_else` so that the else case is lazily evaluated.

[#78956](https://github.com/rust-lang/rust/issues/78956)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5404efc28a0cddee103ef6396c48ea71ff9631c8&end=77180db6f81ffdacd14545f1df0a5db55dac1706&stat=instructions:u) (up to -1.1% on `incr-patched: println` builds of `coercions-debug`)
- Rollup

[#78313](https://github.com/rust-lang/rust/issues/78313)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c6a6105bccd5599daf0ecef40c4b5ffa175fc1c1&end=9b2b02a840f358bcadef5c3ae861d2852da20b3d&stat=instructions:u) (up to -2.1% on `full` builds of `inflate-check`)
- Internal refactor ([proposed here](https://github.com/rust-lang/compiler-team/issues/371)) where `TypeFoldable` takes self by value instead of reference.

[#78779](https://github.com/rust-lang/rust/issues/78779)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=efcb3b39203a0d54269ca274601b8f73207fe10d&end=e0ef0fc392963438af5f0343bf7caa46fb9c3ec3&stat=instructions:u) (up to -2.0% on `full` builds of `inflate-check`)
- Internal refactoring which introduces `BreakTy` in `TypeVisitor`.

#### Mixed

[#78920](https://github.com/rust-lang/rust/issues/78920)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=cf9cf7c923eb01146971429044f216a3ca905e06&end=38030ffb4e735b26260848b744c0910a5641e1db&stat=instructions:u) (up to -2.5% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo-opt`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=cf9cf7c923eb01146971429044f216a3ca905e06&end=38030ffb4e735b26260848b744c0910a5641e1db&stat=instructions:u) (up to 1.5% on `incr-patched: println` builds of `coercions-debug`)
- Rollup

[#79104](https://github.com/rust-lang/rust/issues/79104)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f5230fbf76bafd86ee4376a0e26e551df8d17fec&end=c6a6105bccd5599daf0ecef40c4b5ffa175fc1c1&stat=instructions:u) (up to 6.5% on `full` builds of `keccak-opt`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f5230fbf76bafd86ee4376a0e26e551df8d17fec&end=c6a6105bccd5599daf0ecef40c4b5ffa175fc1c1&stat=instructions:u) (up to -2.1% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo-debug`)
- Rollup

#### Nags requiring follow up

No nags this week.


