#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mupdf/fitz.h"
#include "mupdf/ucdn.h"

const char *script_name[] = {
	"UCDN_SCRIPT_COMMON",
	"UCDN_SCRIPT_LATIN",
	"UCDN_SCRIPT_GREEK",
	"UCDN_SCRIPT_CYRILLIC",
	"UCDN_SCRIPT_ARMENIAN",
	"UCDN_SCRIPT_HEBREW",
	"UCDN_SCRIPT_ARABIC",
	"UCDN_SCRIPT_SYRIAC",
	"UCDN_SCRIPT_THAANA",
	"UCDN_SCRIPT_DEVANAGARI",
	"UCDN_SCRIPT_BENGALI",
	"UCDN_SCRIPT_GURMUKHI",
	"UCDN_SCRIPT_GUJARATI",
	"UCDN_SCRIPT_ORIYA",
	"UCDN_SCRIPT_TAMIL",
	"UCDN_SCRIPT_TELUGU",
	"UCDN_SCRIPT_KANNADA",
	"UCDN_SCRIPT_MALAYALAM",
	"UCDN_SCRIPT_SINHALA",
	"UCDN_SCRIPT_THAI",
	"UCDN_SCRIPT_LAO",
	"UCDN_SCRIPT_TIBETAN",
	"UCDN_SCRIPT_MYANMAR",
	"UCDN_SCRIPT_GEORGIAN",
	"UCDN_SCRIPT_HANGUL",
	"UCDN_SCRIPT_ETHIOPIC",
	"UCDN_SCRIPT_CHEROKEE",
	"UCDN_SCRIPT_CANADIAN_ABORIGINAL",
	"UCDN_SCRIPT_OGHAM",
	"UCDN_SCRIPT_RUNIC",
	"UCDN_SCRIPT_KHMER",
	"UCDN_SCRIPT_MONGOLIAN",
	"UCDN_SCRIPT_HIRAGANA",
	"UCDN_SCRIPT_KATAKANA",
	"UCDN_SCRIPT_BOPOMOFO",
	"UCDN_SCRIPT_HAN",
	"UCDN_SCRIPT_YI",
	"UCDN_SCRIPT_OLD_ITALIC",
	"UCDN_SCRIPT_GOTHIC",
	"UCDN_SCRIPT_DESERET",
	"UCDN_SCRIPT_INHERITED",
	"UCDN_SCRIPT_TAGALOG",
	"UCDN_SCRIPT_HANUNOO",
	"UCDN_SCRIPT_BUHID",
	"UCDN_SCRIPT_TAGBANWA",
	"UCDN_SCRIPT_LIMBU",
	"UCDN_SCRIPT_TAI_LE",
	"UCDN_SCRIPT_LINEAR_B",
	"UCDN_SCRIPT_UGARITIC",
	"UCDN_SCRIPT_SHAVIAN",
	"UCDN_SCRIPT_OSMANYA",
	"UCDN_SCRIPT_CYPRIOT",
	"UCDN_SCRIPT_BRAILLE",
	"UCDN_SCRIPT_BUGINESE",
	"UCDN_SCRIPT_COPTIC",
	"UCDN_SCRIPT_NEW_TAI_LUE",
	"UCDN_SCRIPT_GLAGOLITIC",
	"UCDN_SCRIPT_TIFINAGH",
	"UCDN_SCRIPT_SYLOTI_NAGRI",
	"UCDN_SCRIPT_OLD_PERSIAN",
	"UCDN_SCRIPT_KHAROSHTHI",
	"UCDN_SCRIPT_BALINESE",
	"UCDN_SCRIPT_CUNEIFORM",
	"UCDN_SCRIPT_PHOENICIAN",
	"UCDN_SCRIPT_PHAGS_PA",
	"UCDN_SCRIPT_NKO",
	"UCDN_SCRIPT_SUNDANESE",
	"UCDN_SCRIPT_LEPCHA",
	"UCDN_SCRIPT_OL_CHIKI",
	"UCDN_SCRIPT_VAI",
	"UCDN_SCRIPT_SAURASHTRA",
	"UCDN_SCRIPT_KAYAH_LI",
	"UCDN_SCRIPT_REJANG",
	"UCDN_SCRIPT_LYCIAN",
	"UCDN_SCRIPT_CARIAN",
	"UCDN_SCRIPT_LYDIAN",
	"UCDN_SCRIPT_CHAM",
	"UCDN_SCRIPT_TAI_THAM",
	"UCDN_SCRIPT_TAI_VIET",
	"UCDN_SCRIPT_AVESTAN",
	"UCDN_SCRIPT_EGYPTIAN_HIEROGLYPHS",
	"UCDN_SCRIPT_SAMARITAN",
	"UCDN_SCRIPT_LISU",
	"UCDN_SCRIPT_BAMUM",
	"UCDN_SCRIPT_JAVANESE",
	"UCDN_SCRIPT_MEETEI_MAYEK",
	"UCDN_SCRIPT_IMPERIAL_ARAMAIC",
	"UCDN_SCRIPT_OLD_SOUTH_ARABIAN",
	"UCDN_SCRIPT_INSCRIPTIONAL_PARTHIAN",
	"UCDN_SCRIPT_INSCRIPTIONAL_PAHLAVI",
	"UCDN_SCRIPT_OLD_TURKIC",
	"UCDN_SCRIPT_KAITHI",
	"UCDN_SCRIPT_BATAK",
	"UCDN_SCRIPT_BRAHMI",
	"UCDN_SCRIPT_MANDAIC",
	"UCDN_SCRIPT_CHAKMA",
	"UCDN_SCRIPT_MEROITIC_CURSIVE",
	"UCDN_SCRIPT_MEROITIC_HIEROGLYPHS",
	"UCDN_SCRIPT_MIAO",
	"UCDN_SCRIPT_SHARADA",
	"UCDN_SCRIPT_SORA_SOMPENG",
	"UCDN_SCRIPT_TAKRI",
	"UCDN_SCRIPT_UNKNOWN",
	"UCDN_SCRIPT_BASSA_VAH",
	"UCDN_SCRIPT_CAUCASIAN_ALBANIAN",
	"UCDN_SCRIPT_DUPLOYAN",
	"UCDN_SCRIPT_ELBASAN",
	"UCDN_SCRIPT_GRANTHA",
	"UCDN_SCRIPT_KHOJKI",
	"UCDN_SCRIPT_KHUDAWADI",
	"UCDN_SCRIPT_LINEAR_A",
	"UCDN_SCRIPT_MAHAJANI",
	"UCDN_SCRIPT_MANICHAEAN",
	"UCDN_SCRIPT_MENDE_KIKAKUI",
	"UCDN_SCRIPT_MODI",
	"UCDN_SCRIPT_MRO",
	"UCDN_SCRIPT_NABATAEAN",
	"UCDN_SCRIPT_OLD_NORTH_ARABIAN",
	"UCDN_SCRIPT_OLD_PERMIC",
	"UCDN_SCRIPT_PAHAWH_HMONG",
	"UCDN_SCRIPT_PALMYRENE",
	"UCDN_SCRIPT_PAU_CIN_HAU",
	"UCDN_SCRIPT_PSALTER_PAHLAVI",
	"UCDN_SCRIPT_SIDDHAM",
	"UCDN_SCRIPT_TIRHUTA",
	"UCDN_SCRIPT_WARANG_CITI",
	"UCDN_SCRIPT_AHOM",
	"UCDN_SCRIPT_ANATOLIAN_HIEROGLYPHS",
	"UCDN_SCRIPT_HATRAN",
	"UCDN_SCRIPT_MULTANI",
	"UCDN_SCRIPT_OLD_HUNGARIAN",
	"UCDN_SCRIPT_SIGNWRITING",
	"UCDN_SCRIPT_ADLAM",
	"UCDN_SCRIPT_BHAIKSUKI",
	"UCDN_SCRIPT_MARCHEN",
	"UCDN_SCRIPT_NEWA",
	"UCDN_SCRIPT_OSAGE",
	"UCDN_SCRIPT_TANGUT",
	"UCDN_SCRIPT_MASARAM_GONDI",
	"UCDN_SCRIPT_NUSHU",
	"UCDN_SCRIPT_SOYOMBO",
	"UCDN_SCRIPT_ZANABAZAR_SQUARE",
	"UCDN_SCRIPT_DOGRA",
	"UCDN_SCRIPT_GUNJALA_GONDI",
	"UCDN_SCRIPT_HANIFI_ROHINGYA",
	"UCDN_SCRIPT_MAKASAR",
	"UCDN_SCRIPT_MEDEFAIDRIN",
	"UCDN_SCRIPT_OLD_SOGDIAN",
	"UCDN_SCRIPT_SOGDIAN",
	"UCDN_SCRIPT_ELYMAIC",
	"UCDN_SCRIPT_NANDINAGARI",
	"UCDN_SCRIPT_NYIAKENG_PUACHUE_HMONG",
	"UCDN_SCRIPT_WANCHO",
	"UCDN_SCRIPT_CHORASMIAN",
	"UCDN_SCRIPT_DIVES_AKURU",
	"UCDN_SCRIPT_KHITAN_SMALL_SCRIPT",
	"UCDN_SCRIPT_YEZIDI",
	"UCDN_SCRIPT_VITHKUQI",
	"UCDN_SCRIPT_OLD_UYGHUR",
	"UCDN_SCRIPT_CYPRO_MINOAN",
	"UCDN_SCRIPT_TANGSA",
	"UCDN_SCRIPT_TOTO",
	"UCDN_SCRIPT_KAWI",
	"UCDN_SCRIPT_NAG_MUNDARI",
	"UCDN_SCRIPT_TODHRI",
	"UCDN_SCRIPT_GARAY",
	"UCDN_SCRIPT_TULU_TIGALARI",
	"UCDN_SCRIPT_SUNUWAR",
	"UCDN_SCRIPT_GURUNG_KHEMA",
	"UCDN_SCRIPT_KIRAT_RAI",
	"UCDN_SCRIPT_OL_ONAL",
};

int
main(int argc, char **argv)
{
	int sn[UCDN_LAST_SCRIPT+1];
	int b, c, i, k, s;

	printf("static const int ucdn_block_script[256] = {\n");

	for (b = 0; b < 0x10000; b += 256) {
		memset(sn, 0, sizeof sn);
		for (c = b; c < b + 256; ++c) {
			s = ucdn_get_script(c);
			if (s != UCDN_SCRIPT_COMMON && s != UCDN_SCRIPT_UNKNOWN)
				sn[s]++;
		}
		s = 0;
		for (i = 0; i <= UCDN_LAST_SCRIPT; ++i)
			if (sn[i] > sn[s])
				s = i;
		printf("\t%s, /* U+%04X */\n", script_name[s], b);
	}

	printf("};\n");
}
