// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAcknowledgeJob struct {
}

func (*validateOpAcknowledgeJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcknowledgeJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcknowledgeJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcknowledgeJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAcknowledgeThirdPartyJob struct {
}

func (*validateOpAcknowledgeThirdPartyJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcknowledgeThirdPartyJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcknowledgeThirdPartyJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcknowledgeThirdPartyJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateCustomActionType struct {
}

func (*validateOpCreateCustomActionType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateCustomActionType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateCustomActionTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateCustomActionTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePipeline struct {
}

func (*validateOpCreatePipeline) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePipeline) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePipelineInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePipelineInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteCustomActionType struct {
}

func (*validateOpDeleteCustomActionType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteCustomActionType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteCustomActionTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteCustomActionTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeletePipeline struct {
}

func (*validateOpDeletePipeline) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeletePipeline) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeletePipelineInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeletePipelineInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteWebhook struct {
}

func (*validateOpDeleteWebhook) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteWebhook) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteWebhookInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteWebhookInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisableStageTransition struct {
}

func (*validateOpDisableStageTransition) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisableStageTransition) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisableStageTransitionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisableStageTransitionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnableStageTransition struct {
}

func (*validateOpEnableStageTransition) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnableStageTransition) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableStageTransitionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableStageTransitionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetActionType struct {
}

func (*validateOpGetActionType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetActionType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetActionTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetActionTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetJobDetails struct {
}

func (*validateOpGetJobDetails) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetJobDetails) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetJobDetailsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetJobDetailsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPipelineExecution struct {
}

func (*validateOpGetPipelineExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPipelineExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPipelineExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPipelineExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPipeline struct {
}

func (*validateOpGetPipeline) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPipeline) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPipelineInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPipelineInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPipelineState struct {
}

func (*validateOpGetPipelineState) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPipelineState) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPipelineStateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPipelineStateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetThirdPartyJobDetails struct {
}

func (*validateOpGetThirdPartyJobDetails) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetThirdPartyJobDetails) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetThirdPartyJobDetailsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetThirdPartyJobDetailsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListActionExecutions struct {
}

func (*validateOpListActionExecutions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListActionExecutions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListActionExecutionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListActionExecutionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListPipelineExecutions struct {
}

func (*validateOpListPipelineExecutions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListPipelineExecutions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListPipelineExecutionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListPipelineExecutionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPollForJobs struct {
}

func (*validateOpPollForJobs) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPollForJobs) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PollForJobsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPollForJobsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPollForThirdPartyJobs struct {
}

func (*validateOpPollForThirdPartyJobs) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPollForThirdPartyJobs) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PollForThirdPartyJobsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPollForThirdPartyJobsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutActionRevision struct {
}

func (*validateOpPutActionRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutActionRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutActionRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutActionRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutApprovalResult struct {
}

func (*validateOpPutApprovalResult) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutApprovalResult) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutApprovalResultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutApprovalResultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutJobFailureResult struct {
}

func (*validateOpPutJobFailureResult) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutJobFailureResult) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutJobFailureResultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutJobFailureResultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutJobSuccessResult struct {
}

func (*validateOpPutJobSuccessResult) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutJobSuccessResult) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutJobSuccessResultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutJobSuccessResultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutThirdPartyJobFailureResult struct {
}

func (*validateOpPutThirdPartyJobFailureResult) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutThirdPartyJobFailureResult) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutThirdPartyJobFailureResultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutThirdPartyJobFailureResultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutThirdPartyJobSuccessResult struct {
}

func (*validateOpPutThirdPartyJobSuccessResult) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutThirdPartyJobSuccessResult) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutThirdPartyJobSuccessResultInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutThirdPartyJobSuccessResultInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutWebhook struct {
}

func (*validateOpPutWebhook) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutWebhook) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutWebhookInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutWebhookInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRetryStageExecution struct {
}

func (*validateOpRetryStageExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRetryStageExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RetryStageExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRetryStageExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartPipelineExecution struct {
}

func (*validateOpStartPipelineExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartPipelineExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartPipelineExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartPipelineExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopPipelineExecution struct {
}

func (*validateOpStopPipelineExecution) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopPipelineExecution) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopPipelineExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopPipelineExecutionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateActionType struct {
}

func (*validateOpUpdateActionType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateActionType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateActionTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateActionTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePipeline struct {
}

func (*validateOpUpdatePipeline) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePipeline) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePipelineInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePipelineInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAcknowledgeJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcknowledgeJob{}, middleware.After)
}

func addOpAcknowledgeThirdPartyJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcknowledgeThirdPartyJob{}, middleware.After)
}

func addOpCreateCustomActionTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateCustomActionType{}, middleware.After)
}

func addOpCreatePipelineValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePipeline{}, middleware.After)
}

func addOpDeleteCustomActionTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteCustomActionType{}, middleware.After)
}

func addOpDeletePipelineValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeletePipeline{}, middleware.After)
}

func addOpDeleteWebhookValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteWebhook{}, middleware.After)
}

func addOpDisableStageTransitionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisableStageTransition{}, middleware.After)
}

func addOpEnableStageTransitionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnableStageTransition{}, middleware.After)
}

func addOpGetActionTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetActionType{}, middleware.After)
}

func addOpGetJobDetailsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetJobDetails{}, middleware.After)
}

func addOpGetPipelineExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPipelineExecution{}, middleware.After)
}

func addOpGetPipelineValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPipeline{}, middleware.After)
}

func addOpGetPipelineStateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPipelineState{}, middleware.After)
}

func addOpGetThirdPartyJobDetailsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetThirdPartyJobDetails{}, middleware.After)
}

func addOpListActionExecutionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListActionExecutions{}, middleware.After)
}

func addOpListPipelineExecutionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListPipelineExecutions{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPollForJobsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPollForJobs{}, middleware.After)
}

func addOpPollForThirdPartyJobsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPollForThirdPartyJobs{}, middleware.After)
}

func addOpPutActionRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutActionRevision{}, middleware.After)
}

func addOpPutApprovalResultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutApprovalResult{}, middleware.After)
}

func addOpPutJobFailureResultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutJobFailureResult{}, middleware.After)
}

func addOpPutJobSuccessResultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutJobSuccessResult{}, middleware.After)
}

func addOpPutThirdPartyJobFailureResultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutThirdPartyJobFailureResult{}, middleware.After)
}

func addOpPutThirdPartyJobSuccessResultValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutThirdPartyJobSuccessResult{}, middleware.After)
}

func addOpPutWebhookValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutWebhook{}, middleware.After)
}

func addOpRetryStageExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRetryStageExecution{}, middleware.After)
}

func addOpStartPipelineExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartPipelineExecution{}, middleware.After)
}

func addOpStopPipelineExecutionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopPipelineExecution{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateActionTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateActionType{}, middleware.After)
}

func addOpUpdatePipelineValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePipeline{}, middleware.After)
}

func validateActionConfigurationProperty(v *types.ActionConfigurationProperty) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionConfigurationProperty"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionConfigurationPropertyList(v []types.ActionConfigurationProperty) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionConfigurationPropertyList"}
	for i := range v {
		if err := validateActionConfigurationProperty(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionDeclaration(v *types.ActionDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionDeclaration"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.ActionTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionTypeId"))
	} else if v.ActionTypeId != nil {
		if err := validateActionTypeId(v.ActionTypeId); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(smithy.InvalidParamsError))
		}
	}
	if v.OutputArtifacts != nil {
		if err := validateOutputArtifactList(v.OutputArtifacts); err != nil {
			invalidParams.AddNested("OutputArtifacts", err.(smithy.InvalidParamsError))
		}
	}
	if v.InputArtifacts != nil {
		if err := validateInputArtifactList(v.InputArtifacts); err != nil {
			invalidParams.AddNested("InputArtifacts", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionRevision(v *types.ActionRevision) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionRevision"}
	if v.RevisionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionId"))
	}
	if v.RevisionChangeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionChangeId"))
	}
	if v.Created == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Created"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionTypeArtifactDetails(v *types.ActionTypeArtifactDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionTypeArtifactDetails"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionTypeDeclaration(v *types.ActionTypeDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionTypeDeclaration"}
	if v.Executor == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Executor"))
	} else if v.Executor != nil {
		if err := validateActionTypeExecutor(v.Executor); err != nil {
			invalidParams.AddNested("Executor", err.(smithy.InvalidParamsError))
		}
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	} else if v.Id != nil {
		if err := validateActionTypeIdentifier(v.Id); err != nil {
			invalidParams.AddNested("Id", err.(smithy.InvalidParamsError))
		}
	}
	if v.InputArtifactDetails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputArtifactDetails"))
	} else if v.InputArtifactDetails != nil {
		if err := validateActionTypeArtifactDetails(v.InputArtifactDetails); err != nil {
			invalidParams.AddNested("InputArtifactDetails", err.(smithy.InvalidParamsError))
		}
	}
	if v.OutputArtifactDetails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputArtifactDetails"))
	} else if v.OutputArtifactDetails != nil {
		if err := validateActionTypeArtifactDetails(v.OutputArtifactDetails); err != nil {
			invalidParams.AddNested("OutputArtifactDetails", err.(smithy.InvalidParamsError))
		}
	}
	if v.Permissions != nil {
		if err := validateActionTypePermissions(v.Permissions); err != nil {
			invalidParams.AddNested("Permissions", err.(smithy.InvalidParamsError))
		}
	}
	if v.Properties != nil {
		if err := validateActionTypeProperties(v.Properties); err != nil {
			invalidParams.AddNested("Properties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionTypeExecutor(v *types.ActionTypeExecutor) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionTypeExecutor"}
	if v.Configuration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Configuration"))
	} else if v.Configuration != nil {
		if err := validateExecutorConfiguration(v.Configuration); err != nil {
			invalidParams.AddNested("Configuration", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionTypeId(v *types.ActionTypeId) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionTypeId"}
	if len(v.Category) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Category"))
	}
	if len(v.Owner) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Owner"))
	}
	if v.Provider == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Provider"))
	}
	if v.Version == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Version"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionTypeIdentifier(v *types.ActionTypeIdentifier) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionTypeIdentifier"}
	if len(v.Category) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Category"))
	}
	if v.Owner == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Owner"))
	}
	if v.Provider == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Provider"))
	}
	if v.Version == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Version"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionTypePermissions(v *types.ActionTypePermissions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionTypePermissions"}
	if v.AllowedAccounts == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AllowedAccounts"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionTypeProperties(v []types.ActionTypeProperty) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionTypeProperties"}
	for i := range v {
		if err := validateActionTypeProperty(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionTypeProperty(v *types.ActionTypeProperty) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionTypeProperty"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateApprovalResult(v *types.ApprovalResult) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApprovalResult"}
	if v.Summary == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Summary"))
	}
	if len(v.Status) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Status"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateArtifactDetails(v *types.ArtifactDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ArtifactDetails"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateArtifactStore(v *types.ArtifactStore) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ArtifactStore"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Location == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Location"))
	}
	if v.EncryptionKey != nil {
		if err := validateEncryptionKey(v.EncryptionKey); err != nil {
			invalidParams.AddNested("EncryptionKey", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateArtifactStoreMap(v map[string]types.ArtifactStore) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ArtifactStoreMap"}
	for key := range v {
		value := v[key]
		if err := validateArtifactStore(&value); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBlockerDeclaration(v *types.BlockerDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BlockerDeclaration"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCurrentRevision(v *types.CurrentRevision) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CurrentRevision"}
	if v.Revision == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Revision"))
	}
	if v.ChangeIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChangeIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEncryptionKey(v *types.EncryptionKey) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EncryptionKey"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateExecutorConfiguration(v *types.ExecutorConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ExecutorConfiguration"}
	if v.LambdaExecutorConfiguration != nil {
		if err := validateLambdaExecutorConfiguration(v.LambdaExecutorConfiguration); err != nil {
			invalidParams.AddNested("LambdaExecutorConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFailureDetails(v *types.FailureDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FailureDetails"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Message == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Message"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGitConfiguration(v *types.GitConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GitConfiguration"}
	if v.SourceActionName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceActionName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputArtifact(v *types.InputArtifact) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputArtifact"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputArtifactList(v []types.InputArtifact) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputArtifactList"}
	for i := range v {
		if err := validateInputArtifact(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLambdaExecutorConfiguration(v *types.LambdaExecutorConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LambdaExecutorConfiguration"}
	if v.LambdaFunctionArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LambdaFunctionArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutputArtifact(v *types.OutputArtifact) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OutputArtifact"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOutputArtifactList(v []types.OutputArtifact) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OutputArtifactList"}
	for i := range v {
		if err := validateOutputArtifact(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePipelineDeclaration(v *types.PipelineDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PipelineDeclaration"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.ArtifactStore != nil {
		if err := validateArtifactStore(v.ArtifactStore); err != nil {
			invalidParams.AddNested("ArtifactStore", err.(smithy.InvalidParamsError))
		}
	}
	if v.ArtifactStores != nil {
		if err := validateArtifactStoreMap(v.ArtifactStores); err != nil {
			invalidParams.AddNested("ArtifactStores", err.(smithy.InvalidParamsError))
		}
	}
	if v.Stages == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Stages"))
	} else if v.Stages != nil {
		if err := validatePipelineStageDeclarationList(v.Stages); err != nil {
			invalidParams.AddNested("Stages", err.(smithy.InvalidParamsError))
		}
	}
	if v.Triggers != nil {
		if err := validatePipelineTriggerDeclarationList(v.Triggers); err != nil {
			invalidParams.AddNested("Triggers", err.(smithy.InvalidParamsError))
		}
	}
	if v.Variables != nil {
		if err := validatePipelineVariableDeclarationList(v.Variables); err != nil {
			invalidParams.AddNested("Variables", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePipelineStageDeclarationList(v []types.StageDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PipelineStageDeclarationList"}
	for i := range v {
		if err := validateStageDeclaration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePipelineTriggerDeclaration(v *types.PipelineTriggerDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PipelineTriggerDeclaration"}
	if len(v.ProviderType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ProviderType"))
	}
	if v.GitConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GitConfiguration"))
	} else if v.GitConfiguration != nil {
		if err := validateGitConfiguration(v.GitConfiguration); err != nil {
			invalidParams.AddNested("GitConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePipelineTriggerDeclarationList(v []types.PipelineTriggerDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PipelineTriggerDeclarationList"}
	for i := range v {
		if err := validatePipelineTriggerDeclaration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePipelineVariable(v *types.PipelineVariable) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PipelineVariable"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePipelineVariableDeclaration(v *types.PipelineVariableDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PipelineVariableDeclaration"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePipelineVariableDeclarationList(v []types.PipelineVariableDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PipelineVariableDeclarationList"}
	for i := range v {
		if err := validatePipelineVariableDeclaration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePipelineVariableList(v []types.PipelineVariable) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PipelineVariableList"}
	for i := range v {
		if err := validatePipelineVariable(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSourceRevisionOverride(v *types.SourceRevisionOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SourceRevisionOverride"}
	if v.ActionName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionName"))
	}
	if len(v.RevisionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionType"))
	}
	if v.RevisionValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RevisionValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSourceRevisionOverrideList(v []types.SourceRevisionOverride) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SourceRevisionOverrideList"}
	for i := range v {
		if err := validateSourceRevisionOverride(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStageActionDeclarationList(v []types.ActionDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StageActionDeclarationList"}
	for i := range v {
		if err := validateActionDeclaration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStageBlockerDeclarationList(v []types.BlockerDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StageBlockerDeclarationList"}
	for i := range v {
		if err := validateBlockerDeclaration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStageDeclaration(v *types.StageDeclaration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StageDeclaration"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Blockers != nil {
		if err := validateStageBlockerDeclarationList(v.Blockers); err != nil {
			invalidParams.AddNested("Blockers", err.(smithy.InvalidParamsError))
		}
	}
	if v.Actions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Actions"))
	} else if v.Actions != nil {
		if err := validateStageActionDeclarationList(v.Actions); err != nil {
			invalidParams.AddNested("Actions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWebhookDefinition(v *types.WebhookDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WebhookDefinition"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.TargetPipeline == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetPipeline"))
	}
	if v.TargetAction == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetAction"))
	}
	if v.Filters == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Filters"))
	} else if v.Filters != nil {
		if err := validateWebhookFilters(v.Filters); err != nil {
			invalidParams.AddNested("Filters", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Authentication) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Authentication"))
	}
	if v.AuthenticationConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AuthenticationConfiguration"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWebhookFilterRule(v *types.WebhookFilterRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WebhookFilterRule"}
	if v.JsonPath == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JsonPath"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWebhookFilters(v []types.WebhookFilterRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WebhookFilters"}
	for i := range v {
		if err := validateWebhookFilterRule(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcknowledgeJobInput(v *AcknowledgeJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcknowledgeJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if v.Nonce == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Nonce"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcknowledgeThirdPartyJobInput(v *AcknowledgeThirdPartyJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcknowledgeThirdPartyJobInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if v.Nonce == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Nonce"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateCustomActionTypeInput(v *CreateCustomActionTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateCustomActionTypeInput"}
	if len(v.Category) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Category"))
	}
	if v.Provider == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Provider"))
	}
	if v.Version == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Version"))
	}
	if v.ConfigurationProperties != nil {
		if err := validateActionConfigurationPropertyList(v.ConfigurationProperties); err != nil {
			invalidParams.AddNested("ConfigurationProperties", err.(smithy.InvalidParamsError))
		}
	}
	if v.InputArtifactDetails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputArtifactDetails"))
	} else if v.InputArtifactDetails != nil {
		if err := validateArtifactDetails(v.InputArtifactDetails); err != nil {
			invalidParams.AddNested("InputArtifactDetails", err.(smithy.InvalidParamsError))
		}
	}
	if v.OutputArtifactDetails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputArtifactDetails"))
	} else if v.OutputArtifactDetails != nil {
		if err := validateArtifactDetails(v.OutputArtifactDetails); err != nil {
			invalidParams.AddNested("OutputArtifactDetails", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePipelineInput(v *CreatePipelineInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePipelineInput"}
	if v.Pipeline == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Pipeline"))
	} else if v.Pipeline != nil {
		if err := validatePipelineDeclaration(v.Pipeline); err != nil {
			invalidParams.AddNested("Pipeline", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteCustomActionTypeInput(v *DeleteCustomActionTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteCustomActionTypeInput"}
	if len(v.Category) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Category"))
	}
	if v.Provider == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Provider"))
	}
	if v.Version == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Version"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeletePipelineInput(v *DeletePipelineInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeletePipelineInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteWebhookInput(v *DeleteWebhookInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteWebhookInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisableStageTransitionInput(v *DisableStageTransitionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisableStageTransitionInput"}
	if v.PipelineName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineName"))
	}
	if v.StageName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StageName"))
	}
	if len(v.TransitionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("TransitionType"))
	}
	if v.Reason == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Reason"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableStageTransitionInput(v *EnableStageTransitionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableStageTransitionInput"}
	if v.PipelineName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineName"))
	}
	if v.StageName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StageName"))
	}
	if len(v.TransitionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("TransitionType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetActionTypeInput(v *GetActionTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetActionTypeInput"}
	if len(v.Category) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Category"))
	}
	if v.Owner == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Owner"))
	}
	if v.Provider == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Provider"))
	}
	if v.Version == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Version"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetJobDetailsInput(v *GetJobDetailsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetJobDetailsInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPipelineExecutionInput(v *GetPipelineExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPipelineExecutionInput"}
	if v.PipelineName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineName"))
	}
	if v.PipelineExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineExecutionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPipelineInput(v *GetPipelineInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPipelineInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPipelineStateInput(v *GetPipelineStateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPipelineStateInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetThirdPartyJobDetailsInput(v *GetThirdPartyJobDetailsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetThirdPartyJobDetailsInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListActionExecutionsInput(v *ListActionExecutionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListActionExecutionsInput"}
	if v.PipelineName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListPipelineExecutionsInput(v *ListPipelineExecutionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListPipelineExecutionsInput"}
	if v.PipelineName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPollForJobsInput(v *PollForJobsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PollForJobsInput"}
	if v.ActionTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionTypeId"))
	} else if v.ActionTypeId != nil {
		if err := validateActionTypeId(v.ActionTypeId); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPollForThirdPartyJobsInput(v *PollForThirdPartyJobsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PollForThirdPartyJobsInput"}
	if v.ActionTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionTypeId"))
	} else if v.ActionTypeId != nil {
		if err := validateActionTypeId(v.ActionTypeId); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutActionRevisionInput(v *PutActionRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutActionRevisionInput"}
	if v.PipelineName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineName"))
	}
	if v.StageName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StageName"))
	}
	if v.ActionName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionName"))
	}
	if v.ActionRevision == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionRevision"))
	} else if v.ActionRevision != nil {
		if err := validateActionRevision(v.ActionRevision); err != nil {
			invalidParams.AddNested("ActionRevision", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutApprovalResultInput(v *PutApprovalResultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutApprovalResultInput"}
	if v.PipelineName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineName"))
	}
	if v.StageName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StageName"))
	}
	if v.ActionName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionName"))
	}
	if v.Result == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Result"))
	} else if v.Result != nil {
		if err := validateApprovalResult(v.Result); err != nil {
			invalidParams.AddNested("Result", err.(smithy.InvalidParamsError))
		}
	}
	if v.Token == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Token"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutJobFailureResultInput(v *PutJobFailureResultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutJobFailureResultInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if v.FailureDetails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FailureDetails"))
	} else if v.FailureDetails != nil {
		if err := validateFailureDetails(v.FailureDetails); err != nil {
			invalidParams.AddNested("FailureDetails", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutJobSuccessResultInput(v *PutJobSuccessResultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutJobSuccessResultInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if v.CurrentRevision != nil {
		if err := validateCurrentRevision(v.CurrentRevision); err != nil {
			invalidParams.AddNested("CurrentRevision", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutThirdPartyJobFailureResultInput(v *PutThirdPartyJobFailureResultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutThirdPartyJobFailureResultInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.FailureDetails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FailureDetails"))
	} else if v.FailureDetails != nil {
		if err := validateFailureDetails(v.FailureDetails); err != nil {
			invalidParams.AddNested("FailureDetails", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutThirdPartyJobSuccessResultInput(v *PutThirdPartyJobSuccessResultInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutThirdPartyJobSuccessResultInput"}
	if v.JobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobId"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.CurrentRevision != nil {
		if err := validateCurrentRevision(v.CurrentRevision); err != nil {
			invalidParams.AddNested("CurrentRevision", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutWebhookInput(v *PutWebhookInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutWebhookInput"}
	if v.Webhook == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Webhook"))
	} else if v.Webhook != nil {
		if err := validateWebhookDefinition(v.Webhook); err != nil {
			invalidParams.AddNested("Webhook", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRetryStageExecutionInput(v *RetryStageExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetryStageExecutionInput"}
	if v.PipelineName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineName"))
	}
	if v.StageName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StageName"))
	}
	if v.PipelineExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineExecutionId"))
	}
	if len(v.RetryMode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RetryMode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartPipelineExecutionInput(v *StartPipelineExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartPipelineExecutionInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Variables != nil {
		if err := validatePipelineVariableList(v.Variables); err != nil {
			invalidParams.AddNested("Variables", err.(smithy.InvalidParamsError))
		}
	}
	if v.SourceRevisions != nil {
		if err := validateSourceRevisionOverrideList(v.SourceRevisions); err != nil {
			invalidParams.AddNested("SourceRevisions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopPipelineExecutionInput(v *StopPipelineExecutionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopPipelineExecutionInput"}
	if v.PipelineName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineName"))
	}
	if v.PipelineExecutionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PipelineExecutionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateActionTypeInput(v *UpdateActionTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateActionTypeInput"}
	if v.ActionType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionType"))
	} else if v.ActionType != nil {
		if err := validateActionTypeDeclaration(v.ActionType); err != nil {
			invalidParams.AddNested("ActionType", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePipelineInput(v *UpdatePipelineInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePipelineInput"}
	if v.Pipeline == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Pipeline"))
	} else if v.Pipeline != nil {
		if err := validatePipelineDeclaration(v.Pipeline); err != nil {
			invalidParams.AddNested("Pipeline", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
