// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Column in configured table that can be used in aggregate function in query.
type AggregateColumn struct {

	// Column names in configured table of aggregate columns.
	//
	// This member is required.
	ColumnNames []string

	// Aggregation function that can be applied to aggregate column in query.
	//
	// This member is required.
	Function AggregateFunctionName

	noSmithyDocumentSerde
}

// Constraint on query output removing output rows that do not meet a minimum
// number of distinct values of a specified column.
type AggregationConstraint struct {

	// Column in aggregation constraint for which there must be a minimum number of
	// distinct values in an output row for it to be in the query output.
	//
	// This member is required.
	ColumnName *string

	// The minimum number of distinct values that an output row must be an aggregation
	// of. Minimum threshold of distinct values for a specified column that must exist
	// in an output row for it to be in the query output.
	//
	// This member is required.
	Minimum *int32

	// The type of aggregation the constraint allows. The only valid value is
	// currently `COUNT_DISTINCT`.
	//
	// This member is required.
	Type AggregationType

	noSmithyDocumentSerde
}

// Optional. The member who can query can provide this placeholder for a literal
// data value in an analysis template.
type AnalysisParameter struct {

	// The name of the parameter. The name must use only alphanumeric, underscore (_),
	// or hyphen (-) characters but cannot start or end with a hyphen.
	//
	// This member is required.
	Name *string

	// The type of parameter.
	//
	// This member is required.
	Type ParameterType

	// Optional. The default value that is applied in the analysis template. The
	// member who can query can override this value in the query editor.
	DefaultValue *string

	noSmithyDocumentSerde
}

// A specification about how data from the configured table can be used in a query.
type AnalysisRule struct {

	// The unique ID for the associated collaboration.
	//
	// This member is required.
	CollaborationId *string

	// The time the analysis rule was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The name for the analysis rule.
	//
	// This member is required.
	Name *string

	// A policy that describes the associated data usage limitations.
	//
	// This member is required.
	Policy AnalysisRulePolicy

	// The type of analysis rule.
	//
	// This member is required.
	Type AnalysisRuleType

	// The time the analysis rule was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// A type of analysis rule that enables query structure and specified queries that
// produce aggregate statistics.
type AnalysisRuleAggregation struct {

	// The columns that query runners are allowed to use in aggregation queries.
	//
	// This member is required.
	AggregateColumns []AggregateColumn

	// The columns that query runners are allowed to select, group by, or filter by.
	//
	// This member is required.
	DimensionColumns []string

	// Columns in configured table that can be used in join statements and/or as
	// aggregate columns. They can never be outputted directly.
	//
	// This member is required.
	JoinColumns []string

	// Columns that must meet a specific threshold value (after an aggregation
	// function is applied to it) for each output row to be returned.
	//
	// This member is required.
	OutputConstraints []AggregationConstraint

	// Set of scalar functions that are allowed to be used on dimension columns and
	// the output of aggregation of metrics.
	//
	// This member is required.
	ScalarFunctions []ScalarFunctions

	// Which logical operators (if any) are to be used in an INNER JOIN match
	// condition. Default is AND .
	AllowedJoinOperators []JoinOperator

	// Control that requires member who runs query to do a join with their configured
	// table and/or other configured table in query.
	JoinRequired JoinRequiredOption

	noSmithyDocumentSerde
}

// A type of analysis rule that enables the table owner to approve custom SQL
// queries on their configured tables. It supports differential privacy.
type AnalysisRuleCustom struct {

	// The analysis templates that are allowed by the custom analysis rule.
	//
	// This member is required.
	AllowedAnalyses []string

	// The Amazon Web Services accounts that are allowed to query by the custom
	// analysis rule. Required when allowedAnalyses is ANY_QUERY .
	AllowedAnalysisProviders []string

	// The differential privacy configuration.
	DifferentialPrivacy *DifferentialPrivacyConfiguration

	noSmithyDocumentSerde
}

// A type of analysis rule that enables row-level analysis.
type AnalysisRuleList struct {

	// Columns that can be used to join a configured table with the table of the
	// member who can query and other members' configured tables.
	//
	// This member is required.
	JoinColumns []string

	// Columns that can be listed in the output.
	//
	// This member is required.
	ListColumns []string

	// The logical operators (if any) that are to be used in an INNER JOIN match
	// condition. Default is AND .
	AllowedJoinOperators []JoinOperator

	noSmithyDocumentSerde
}

// Controls on the query specifications that can be run on configured table.
//
// The following types satisfy this interface:
//
//	AnalysisRulePolicyMemberV1
type AnalysisRulePolicy interface {
	isAnalysisRulePolicy()
}

// Controls on the query specifications that can be run on configured table.
type AnalysisRulePolicyMemberV1 struct {
	Value AnalysisRulePolicyV1

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyMemberV1) isAnalysisRulePolicy() {}

// Controls on the query specifications that can be run on configured table.
//
// The following types satisfy this interface:
//
//	AnalysisRulePolicyV1MemberAggregation
//	AnalysisRulePolicyV1MemberCustom
//	AnalysisRulePolicyV1MemberList
type AnalysisRulePolicyV1 interface {
	isAnalysisRulePolicyV1()
}

// Analysis rule type that enables only aggregation queries on a configured table.
type AnalysisRulePolicyV1MemberAggregation struct {
	Value AnalysisRuleAggregation

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyV1MemberAggregation) isAnalysisRulePolicyV1() {}

// Analysis rule type that enables custom SQL queries on a configured table.
type AnalysisRulePolicyV1MemberCustom struct {
	Value AnalysisRuleCustom

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyV1MemberCustom) isAnalysisRulePolicyV1() {}

// Analysis rule type that enables only list queries on a configured table.
type AnalysisRulePolicyV1MemberList struct {
	Value AnalysisRuleList

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyV1MemberList) isAnalysisRulePolicyV1() {}

// A relation within an analysis.
type AnalysisSchema struct {

	// The tables referenced in the analysis schema.
	ReferencedTables []string

	noSmithyDocumentSerde
}

// The structure that defines the body of the analysis template.
//
// The following types satisfy this interface:
//
//	AnalysisSourceMemberText
type AnalysisSource interface {
	isAnalysisSource()
}

// The query text.
type AnalysisSourceMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*AnalysisSourceMemberText) isAnalysisSource() {}

// The analysis template.
type AnalysisTemplate struct {

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the analysis template’s associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID for the associated collaboration of the analysis template.
	//
	// This member is required.
	CollaborationId *string

	// The time that the analysis template was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The format of the analysis template.
	//
	// This member is required.
	Format AnalysisFormat

	// The identifier for the analysis template.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the member who created the analysis template.
	//
	// This member is required.
	MembershipArn *string

	// The identifier of a member who created the analysis template.
	//
	// This member is required.
	MembershipId *string

	// The name of the analysis template.
	//
	// This member is required.
	Name *string

	// The entire schema object.
	//
	// This member is required.
	Schema *AnalysisSchema

	// The source of the analysis template.
	//
	// This member is required.
	Source AnalysisSource

	// The time that the analysis template was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The parameters of the analysis template.
	AnalysisParameters []AnalysisParameter

	// The description of the analysis template.
	Description *string

	noSmithyDocumentSerde
}

// The metadata of the analysis template.
type AnalysisTemplateSummary struct {

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the analysis template summary’s associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier for the collaboration that the analysis template summary
	// belongs to. Currently accepts collaboration ID.
	//
	// This member is required.
	CollaborationId *string

	// The time that the analysis template summary was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier of the analysis template.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the member who created the analysis template.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for a membership resource.
	//
	// This member is required.
	MembershipId *string

	// The name of the analysis template.
	//
	// This member is required.
	Name *string

	// The time that the analysis template summary was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the analysis template.
	Description *string

	noSmithyDocumentSerde
}

// Details of errors thrown by the call to retrieve multiple analysis templates
// within a collaboration by their identifiers.
type BatchGetCollaborationAnalysisTemplateError struct {

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// This member is required.
	Arn *string

	// An error code for the error.
	//
	// This member is required.
	Code *string

	// A description of why the call failed.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// An error describing why a schema could not be fetched.
type BatchGetSchemaError struct {

	// An error code for the error.
	//
	// This member is required.
	Code *string

	// An error message for the error.
	//
	// This member is required.
	Message *string

	// An error name for the error.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The multi-party data share environment. The collaboration contains metadata
// about its purpose and participants.
type Collaboration struct {

	// The unique ARN for the collaboration.
	//
	// This member is required.
	Arn *string

	// The time when the collaboration was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// A display name of the collaboration creator.
	//
	// This member is required.
	CreatorDisplayName *string

	// The unique ID for the collaboration.
	//
	// This member is required.
	Id *string

	// The status of a member in a collaboration.
	//
	// This member is required.
	MemberStatus MemberStatus

	// A human-readable identifier provided by the collaboration owner. Display names
	// are not unique.
	//
	// This member is required.
	Name *string

	// An indicator as to whether query logging has been enabled or disabled for the
	// collaboration.
	//
	// This member is required.
	QueryLogStatus CollaborationQueryLogStatus

	// The time the collaboration metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The settings for client-side encryption for cryptographic computing.
	DataEncryptionMetadata *DataEncryptionMetadata

	// A description of the collaboration provided by the collaboration owner.
	Description *string

	// The unique ARN for your membership within the collaboration.
	MembershipArn *string

	// The unique ID for your membership within the collaboration.
	MembershipId *string

	noSmithyDocumentSerde
}

// The analysis template within a collaboration.
type CollaborationAnalysisTemplate struct {

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the analysis template’s associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier for the collaboration that the analysis templates belong
	// to. Currently accepts collaboration ID.
	//
	// This member is required.
	CollaborationId *string

	// The time that the analysis template within a collaboration was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The format of the analysis template in the collaboration.
	//
	// This member is required.
	Format AnalysisFormat

	// The identifier of the analysis template.
	//
	// This member is required.
	Id *string

	// The name of the analysis template.
	//
	// This member is required.
	Name *string

	// The entire schema object.
	//
	// This member is required.
	Schema *AnalysisSchema

	// The source of the analysis template within a collaboration.
	//
	// This member is required.
	Source AnalysisSource

	// The time that the analysis template in the collaboration was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The analysis parameters that have been specified in the analysis template.
	AnalysisParameters []AnalysisParameter

	// The description of the analysis template.
	Description *string

	noSmithyDocumentSerde
}

// The metadata of the analysis template within a collaboration.
type CollaborationAnalysisTemplateSummary struct {

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the analysis template’s associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier for the collaboration that the analysis templates belong
	// to. Currently accepts collaboration ID.
	//
	// This member is required.
	CollaborationId *string

	// The time that the summary of the analysis template in a collaboration was
	// created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The identifier of the analysis template.
	//
	// This member is required.
	Id *string

	// The name of the analysis template.
	//
	// This member is required.
	Name *string

	// The time that the summary of the analysis template in the collaboration was
	// last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the analysis template.
	Description *string

	noSmithyDocumentSerde
}

// The configured audience model association within a collaboration.
type CollaborationConfiguredAudienceModelAssociation struct {

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the configured audience model's associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier for the collaboration that the configured audience model
	// associations belong to. Accepts collaboration ID.
	//
	// This member is required.
	CollaborationId *string

	// The Amazon Resource Name (ARN) of the configure audience model.
	//
	// This member is required.
	ConfiguredAudienceModelArn *string

	// The time at which the configured audience model association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Only supports
	// AWS account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The identifier of the configured audience model association.
	//
	// This member is required.
	Id *string

	// The name of the configured audience model association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the configured audience model association.
	Description *string

	noSmithyDocumentSerde
}

// A summary of the configured audience model association in the collaboration.
type CollaborationConfiguredAudienceModelAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the configured audience model's associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier for the collaboration that the configured audience model
	// associations belong to. Accepts collaboration ID.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the configured audience model association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Only supports
	// AWS account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The identifier of the configured audience model association.
	//
	// This member is required.
	Id *string

	// The name of the configured audience model association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the configured audience model association.
	Description *string

	noSmithyDocumentSerde
}

// A summary of the collaboration privacy budgets. This summary includes the
// collaboration information, creation information, epsilon provided, and utility
// in terms of aggregations.
type CollaborationPrivacyBudgetSummary struct {

	// The includes epsilon provided and utility in terms of aggregations.
	//
	// This member is required.
	Budget PrivacyBudget

	// The ARN of the collaboration that includes this privacy budget.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that includes this privacy budget.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the privacy budget was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the account that created this privacy budget.
	//
	// This member is required.
	CreatorAccountId *string

	// The unique identifier of the collaboration privacy budget.
	//
	// This member is required.
	Id *string

	// The ARN of the collaboration privacy budget template.
	//
	// This member is required.
	PrivacyBudgetTemplateArn *string

	// The unique identifier of the collaboration privacy budget template.
	//
	// This member is required.
	PrivacyBudgetTemplateId *string

	// The type of privacy budget template.
	//
	// This member is required.
	Type PrivacyBudgetType

	// The most recent time at which the privacy budget was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// An array that specifies the information for a collaboration's privacy budget
// template.
type CollaborationPrivacyBudgetTemplate struct {

	// The ARN of the collaboration privacy budget template.
	//
	// This member is required.
	Arn *string

	// How often the privacy budget refreshes. If you plan to regularly bring new data
	// into the collaboration, use CALENDAR_MONTH to automatically get a new privacy
	// budget for the collaboration every calendar month. Choosing this option allows
	// arbitrary amounts of information to be revealed about rows of the data when
	// repeatedly queried across refreshes. Avoid choosing this if the same rows will
	// be repeatedly queried between privacy budget refreshes.
	//
	// This member is required.
	AutoRefresh PrivacyBudgetTemplateAutoRefresh

	// The ARN of the collaboration that includes this collaboration privacy budget
	// template.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that includes this collaboration
	// privacy budget template.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the collaboration privacy budget template was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the account that created this collaboration privacy
	// budget template.
	//
	// This member is required.
	CreatorAccountId *string

	// The unique identifier of the collaboration privacy budget template.
	//
	// This member is required.
	Id *string

	// Specifies the epsilon and noise parameters for the privacy budget template.
	//
	// This member is required.
	Parameters PrivacyBudgetTemplateParametersOutput

	// The type of privacy budget template.
	//
	// This member is required.
	PrivacyBudgetType PrivacyBudgetType

	// The most recent time at which the collaboration privacy budget template was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// A summary of the collaboration's privacy budget template. This summary includes
// information about who created the privacy budget template and what
// collaborations it belongs to.
type CollaborationPrivacyBudgetTemplateSummary struct {

	// The ARN of the collaboration privacy budget template.
	//
	// This member is required.
	Arn *string

	// The ARN of the collaboration that contains this collaboration privacy budget
	// template.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that contains this collaboration
	// privacy budget template.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the collaboration privacy budget template was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the account that created this collaboration privacy
	// budget template.
	//
	// This member is required.
	CreatorAccountId *string

	// The unique identifier of the collaboration privacy budget template.
	//
	// This member is required.
	Id *string

	// The type of the privacy budget template.
	//
	// This member is required.
	PrivacyBudgetType PrivacyBudgetType

	// The most recent time at which the collaboration privacy budget template was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The metadata of the collaboration.
type CollaborationSummary struct {

	// The ARN of the collaboration.
	//
	// This member is required.
	Arn *string

	// The time when the collaboration was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The display name of the collaboration creator.
	//
	// This member is required.
	CreatorDisplayName *string

	// The identifier for the collaboration.
	//
	// This member is required.
	Id *string

	// The status of a member in a collaboration.
	//
	// This member is required.
	MemberStatus MemberStatus

	// A human-readable identifier provided by the collaboration owner. Display names
	// are not unique.
	//
	// This member is required.
	Name *string

	// The time the collaboration metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The ARN of a member in a collaboration.
	MembershipArn *string

	// The identifier of a member in a collaboration.
	MembershipId *string

	noSmithyDocumentSerde
}

// A column within a schema relation, derived from the underlying Glue table.
type Column struct {

	// The name of the column.
	//
	// This member is required.
	Name *string

	// The type of the column.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// Details about the configured audience model association.
type ConfiguredAudienceModelAssociation struct {

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the collaboration that contains this
	// configured audience model association.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier of the collaboration that contains this configured audience
	// model association.
	//
	// This member is required.
	CollaborationId *string

	// The Amazon Resource Name (ARN) of the configured audience model that was used
	// for this configured audience model association.
	//
	// This member is required.
	ConfiguredAudienceModelArn *string

	// The time at which the configured audience model association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// A unique identifier of the configured audience model association.
	//
	// This member is required.
	Id *string

	// When TRUE , indicates that the resource policy for the configured audience model
	// resource being associated is configured for Clean Rooms to manage permissions
	// related to the given collaboration. When FALSE , indicates that the configured
	// audience model resource owner will manage permissions related to the given
	// collaboration.
	//
	// This member is required.
	ManageResourcePolicies *bool

	// The Amazon Resource Name (ARN) of the membership that contains this configured
	// audience model association.
	//
	// This member is required.
	MembershipArn *string

	// A unique identifier for the membership that contains this configured audience
	// model association.
	//
	// This member is required.
	MembershipId *string

	// The name of the configured audience model association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the configured audience model association.
	Description *string

	noSmithyDocumentSerde
}

// A summary of the configured audience model association.
type ConfiguredAudienceModelAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the collaboration that contains the
	// configured audience model association.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier of the collaboration that configured audience model is
	// associated with.
	//
	// This member is required.
	CollaborationId *string

	// The Amazon Resource Name (ARN) of the configured audience model that was used
	// for this configured audience model association.
	//
	// This member is required.
	ConfiguredAudienceModelArn *string

	// The time at which the configured audience model association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// A unique identifier of the configured audience model association.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the membership that contains the configured
	// audience model association.
	//
	// This member is required.
	MembershipArn *string

	// A unique identifier of the membership that contains the configured audience
	// model association.
	//
	// This member is required.
	MembershipId *string

	// The name of the configured audience model association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the configured audience model association.
	Description *string

	noSmithyDocumentSerde
}

// A table that has been configured for use in a collaboration.
type ConfiguredTable struct {

	// The columns within the underlying Glue table that can be utilized within
	// collaborations.
	//
	// This member is required.
	AllowedColumns []string

	// The analysis method for the configured table. The only valid value is currently
	// `DIRECT_QUERY`.
	//
	// This member is required.
	AnalysisMethod AnalysisMethod

	// The types of analysis rules associated with this configured table. Currently,
	// only one analysis rule may be associated with a configured table.
	//
	// This member is required.
	AnalysisRuleTypes []ConfiguredTableAnalysisRuleType

	// The unique ARN for the configured table.
	//
	// This member is required.
	Arn *string

	// The time the configured table was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the configured table.
	//
	// This member is required.
	Id *string

	// A name for the configured table.
	//
	// This member is required.
	Name *string

	// The Glue table that this configured table represents.
	//
	// This member is required.
	TableReference TableReference

	// The time the configured table was last updated
	//
	// This member is required.
	UpdateTime *time.Time

	// A description for the configured table.
	Description *string

	noSmithyDocumentSerde
}

// A configured table analysis rule, which limits how data for this table can be
// used.
type ConfiguredTableAnalysisRule struct {

	// The unique ARN for the configured table.
	//
	// This member is required.
	ConfiguredTableArn *string

	// The unique ID for the configured table.
	//
	// This member is required.
	ConfiguredTableId *string

	// The time the configured table analysis rule was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The policy that controls SQL query rules.
	//
	// This member is required.
	Policy ConfiguredTableAnalysisRulePolicy

	// The type of configured table analysis rule.
	//
	// This member is required.
	Type ConfiguredTableAnalysisRuleType

	// The time the configured table analysis rule was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Controls on the query specifications that can be run on a configured table.
//
// The following types satisfy this interface:
//
//	ConfiguredTableAnalysisRulePolicyMemberV1
type ConfiguredTableAnalysisRulePolicy interface {
	isConfiguredTableAnalysisRulePolicy()
}

// Controls on the query specifications that can be run on a configured table.
type ConfiguredTableAnalysisRulePolicyMemberV1 struct {
	Value ConfiguredTableAnalysisRulePolicyV1

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyMemberV1) isConfiguredTableAnalysisRulePolicy() {}

// Controls on the query specifications that can be run on a configured table.
//
// The following types satisfy this interface:
//
//	ConfiguredTableAnalysisRulePolicyV1MemberAggregation
//	ConfiguredTableAnalysisRulePolicyV1MemberCustom
//	ConfiguredTableAnalysisRulePolicyV1MemberList
type ConfiguredTableAnalysisRulePolicyV1 interface {
	isConfiguredTableAnalysisRulePolicyV1()
}

// Analysis rule type that enables only aggregation queries on a configured table.
type ConfiguredTableAnalysisRulePolicyV1MemberAggregation struct {
	Value AnalysisRuleAggregation

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyV1MemberAggregation) isConfiguredTableAnalysisRulePolicyV1() {
}

// A type of analysis rule that enables the table owner to approve custom SQL
// queries on their configured tables. It supports differential privacy.
type ConfiguredTableAnalysisRulePolicyV1MemberCustom struct {
	Value AnalysisRuleCustom

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyV1MemberCustom) isConfiguredTableAnalysisRulePolicyV1() {}

// Analysis rule type that enables only list queries on a configured table.
type ConfiguredTableAnalysisRulePolicyV1MemberList struct {
	Value AnalysisRuleList

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyV1MemberList) isConfiguredTableAnalysisRulePolicyV1() {}

// A configured table association links a configured table to a collaboration.
type ConfiguredTableAssociation struct {

	// The unique ARN for the configured table association.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the configured table that the association refers to.
	//
	// This member is required.
	ConfiguredTableArn *string

	// The unique ID for the configured table that the association refers to.
	//
	// This member is required.
	ConfiguredTableId *string

	// The time the configured table association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the configured table association.
	//
	// This member is required.
	Id *string

	// The unique ARN for the membership this configured table association belongs to.
	//
	// This member is required.
	MembershipArn *string

	// The unique ID for the membership this configured table association belongs to.
	//
	// This member is required.
	MembershipId *string

	// The name of the configured table association, in lowercase. The table is
	// identified by this name when running protected queries against the underlying
	// data.
	//
	// This member is required.
	Name *string

	// The service will assume this role to access catalog metadata and query the
	// table.
	//
	// This member is required.
	RoleArn *string

	// The time the configured table association was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// A description of the configured table association.
	Description *string

	noSmithyDocumentSerde
}

// The configured table association summary for the objects listed by the request.
type ConfiguredTableAssociationSummary struct {

	// The unique ARN for the configured table association.
	//
	// This member is required.
	Arn *string

	// The unique configured table ID that this configured table association refers to.
	//
	// This member is required.
	ConfiguredTableId *string

	// The time the configured table association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the configured table association.
	//
	// This member is required.
	Id *string

	// The unique ARN for the membership that the configured table association belongs
	// to.
	//
	// This member is required.
	MembershipArn *string

	// The unique ID for the membership that the configured table association belongs
	// to.
	//
	// This member is required.
	MembershipId *string

	// The name of the configured table association. The table is identified by this
	// name when running Protected Queries against the underlying data.
	//
	// This member is required.
	Name *string

	// The time the configured table association was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The configured table summary for the objects listed by the request.
type ConfiguredTableSummary struct {

	// The analysis method for the configured tables. The only valid value is
	// currently `DIRECT_QUERY`.
	//
	// This member is required.
	AnalysisMethod AnalysisMethod

	// The types of analysis rules associated with this configured table.
	//
	// This member is required.
	AnalysisRuleTypes []ConfiguredTableAnalysisRuleType

	// The unique ARN of the configured table.
	//
	// This member is required.
	Arn *string

	// The time the configured table was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID of the configured table.
	//
	// This member is required.
	Id *string

	// The name of the configured table.
	//
	// This member is required.
	Name *string

	// The time the configured table was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The settings for client-side encryption for cryptographic computing.
type DataEncryptionMetadata struct {

	// Indicates whether encrypted tables can contain cleartext data ( TRUE ) or are to
	// cryptographically process every column ( FALSE ).
	//
	// This member is required.
	AllowCleartext *bool

	// Indicates whether Fingerprint columns can contain duplicate entries ( TRUE ) or
	// are to contain only non-repeated values ( FALSE ).
	//
	// This member is required.
	AllowDuplicates *bool

	// Indicates whether Fingerprint columns can be joined on any other Fingerprint
	// column with a different name ( TRUE ) or can only be joined on Fingerprint
	// columns of the same name ( FALSE ).
	//
	// This member is required.
	AllowJoinsOnColumnsWithDifferentNames *bool

	// Indicates whether NULL values are to be copied as NULL to encrypted tables ( TRUE
	// ) or cryptographically processed ( FALSE ).
	//
	// This member is required.
	PreserveNulls *bool

	noSmithyDocumentSerde
}

// Specifies the name of the column that contains the unique identifier of your
// users, whose privacy you want to protect.
type DifferentialPrivacyColumn struct {

	// The name of the column, such as user_id, that contains the unique identifier of
	// your users, whose privacy you want to protect. If you want to turn on
	// differential privacy for two or more tables in a collaboration, you must
	// configure the same column as the user identifier column in both analysis rules.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Specifies the unique identifier for your users.
type DifferentialPrivacyConfiguration struct {

	// The name of the column (such as user_id) that contains the unique identifier of
	// your users whose privacy you want to protect. If you want to turn on diﬀerential
	// privacy for two or more tables in a collaboration, you must conﬁgure the same
	// column as the user identiﬁer column in both analysis rules.
	//
	// This member is required.
	Columns []DifferentialPrivacyColumn

	noSmithyDocumentSerde
}

// An array that contains the sensitivity parameters.
type DifferentialPrivacyParameters struct {

	// Provides the sensitivity parameters that you can use to better understand the
	// total amount of noise in query results.
	//
	// This member is required.
	SensitivityParameters []DifferentialPrivacySensitivityParameters

	noSmithyDocumentSerde
}

// Provides an estimate of the number of aggregation functions that the member who
// can query can run given the epsilon and noise parameters.
type DifferentialPrivacyPreviewAggregation struct {

	// The maximum number of aggregations that the member who can query can run given
	// the epsilon and noise parameters.
	//
	// This member is required.
	MaxCount *int32

	// The type of aggregation function.
	//
	// This member is required.
	Type DifferentialPrivacyAggregationType

	noSmithyDocumentSerde
}

// The epsilon and noise parameters that you want to preview.
type DifferentialPrivacyPreviewParametersInput struct {

	// The epsilon value that you want to preview.
	//
	// This member is required.
	Epsilon *int32

	// Noise added per query is measured in terms of the number of users whose
	// contributions you want to obscure. This value governs the rate at which the
	// privacy budget is depleted.
	//
	// This member is required.
	UsersNoisePerQuery *int32

	noSmithyDocumentSerde
}

// Specifies the configured epsilon value and the utility in terms of total
// aggregations, as well as the remaining aggregations available.
type DifferentialPrivacyPrivacyBudget struct {

	// This information includes the configured epsilon value and the utility in terms
	// of total aggregations, as well as the remaining aggregations.
	//
	// This member is required.
	Aggregations []DifferentialPrivacyPrivacyBudgetAggregation

	// The epsilon value that you configured.
	//
	// This member is required.
	Epsilon *int32

	noSmithyDocumentSerde
}

// Information about the total number of aggregations, as well as the remaining
// aggregations.
type DifferentialPrivacyPrivacyBudgetAggregation struct {

	// The maximum number of aggregation functions that you can perform with the given
	// privacy budget.
	//
	// This member is required.
	MaxCount *int32

	// The remaining number of aggregation functions that can be run with the
	// available privacy budget.
	//
	// This member is required.
	RemainingCount *int32

	// The different types of aggregation functions that you can perform.
	//
	// This member is required.
	Type DifferentialPrivacyAggregationType

	noSmithyDocumentSerde
}

// Information about the number of aggregation functions that the member who can
// query can run given the epsilon and noise parameters.
type DifferentialPrivacyPrivacyImpact struct {

	// The number of aggregation functions that you can perform.
	//
	// This member is required.
	Aggregations []DifferentialPrivacyPreviewAggregation

	noSmithyDocumentSerde
}

// Provides the sensitivity parameters.
type DifferentialPrivacySensitivityParameters struct {

	// The aggregation expression that was run.
	//
	// This member is required.
	AggregationExpression *string

	// The type of aggregation function that was run.
	//
	// This member is required.
	AggregationType DifferentialPrivacyAggregationType

	// The maximum number of rows contributed by a user in a SQL query.
	//
	// This member is required.
	UserContributionLimit *int32

	// The upper bound of the aggregation expression.
	MaxColumnValue *float32

	// The lower bound of the aggregation expression.
	MinColumnValue *float32

	noSmithyDocumentSerde
}

// The epsilon and noise parameter values that you want to use for the
// differential privacy template.
type DifferentialPrivacyTemplateParametersInput struct {

	// The epsilon value that you want to use.
	//
	// This member is required.
	Epsilon *int32

	// Noise added per query is measured in terms of the number of users whose
	// contributions you want to obscure. This value governs the rate at which the
	// privacy budget is depleted.
	//
	// This member is required.
	UsersNoisePerQuery *int32

	noSmithyDocumentSerde
}

// The epsilon and noise parameter values that were used for the differential
// privacy template.
type DifferentialPrivacyTemplateParametersOutput struct {

	// The epsilon value that you specified.
	//
	// This member is required.
	Epsilon *int32

	// Noise added per query is measured in terms of the number of users whose
	// contributions you want to obscure. This value governs the rate at which the
	// privacy budget is depleted.
	//
	// This member is required.
	UsersNoisePerQuery *int32

	noSmithyDocumentSerde
}

// The epsilon and noise parameter values that you want to update in the
// differential privacy template.
type DifferentialPrivacyTemplateUpdateParameters struct {

	// The updated epsilon value that you want to use.
	Epsilon *int32

	// The updated value of noise added per query. It is measured in terms of the
	// number of users whose contributions you want to obscure. This value governs the
	// rate at which the privacy budget is depleted.
	UsersNoisePerQuery *int32

	noSmithyDocumentSerde
}

// A reference to a table within an Glue data catalog.
type GlueTableReference struct {

	// The name of the database the Glue table belongs to.
	//
	// This member is required.
	DatabaseName *string

	// The name of the Glue table.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// The membership object.
type Membership struct {

	// The unique ARN for the membership.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the membership's associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	CollaborationCreatorAccountId *string

	// The display name of the collaboration creator.
	//
	// This member is required.
	CollaborationCreatorDisplayName *string

	// The unique ID for the membership's collaboration.
	//
	// This member is required.
	CollaborationId *string

	// The name of the membership's collaboration.
	//
	// This member is required.
	CollaborationName *string

	// The time when the membership was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID of the membership.
	//
	// This member is required.
	Id *string

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	MemberAbilities []MemberAbility

	// The payment responsibilities accepted by the collaboration member.
	//
	// This member is required.
	PaymentConfiguration *MembershipPaymentConfiguration

	// An indicator as to whether query logging has been enabled or disabled for the
	// membership.
	//
	// This member is required.
	QueryLogStatus MembershipQueryLogStatus

	// The status of the membership.
	//
	// This member is required.
	Status MembershipStatus

	// The time the membership metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The default protected query result configuration as specified by the member who
	// can receive results.
	DefaultResultConfiguration *MembershipProtectedQueryResultConfiguration

	noSmithyDocumentSerde
}

// An object representing the payment responsibilities accepted by the
// collaboration member.
type MembershipPaymentConfiguration struct {

	// The payment responsibilities accepted by the collaboration member for query
	// compute costs.
	//
	// This member is required.
	QueryCompute *MembershipQueryComputePaymentConfig

	noSmithyDocumentSerde
}

// Contains configurations for protected query results.
//
// The following types satisfy this interface:
//
//	MembershipProtectedQueryOutputConfigurationMemberS3
type MembershipProtectedQueryOutputConfiguration interface {
	isMembershipProtectedQueryOutputConfiguration()
}

// Contains the configuration to write the query results to S3.
type MembershipProtectedQueryOutputConfigurationMemberS3 struct {
	Value ProtectedQueryS3OutputConfiguration

	noSmithyDocumentSerde
}

func (*MembershipProtectedQueryOutputConfigurationMemberS3) isMembershipProtectedQueryOutputConfiguration() {
}

// Contains configurations for protected query results.
type MembershipProtectedQueryResultConfiguration struct {

	// Configuration for protected query results.
	//
	// This member is required.
	OutputConfiguration MembershipProtectedQueryOutputConfiguration

	// The unique ARN for an IAM role that is used by Clean Rooms to write protected
	// query results to the result location, given by the member who can receive
	// results.
	RoleArn *string

	noSmithyDocumentSerde
}

// An object representing the payment responsibilities accepted by the
// collaboration member for query compute costs.
type MembershipQueryComputePaymentConfig struct {

	// Indicates whether the collaboration member has accepted to pay for query
	// compute costs ( TRUE ) or has not accepted to pay for query compute costs ( FALSE
	// ). If the collaboration creator has not specified anyone to pay for query
	// compute costs, then the member who can query is the default payer. An error
	// message is returned for the following reasons:
	//   - If you set the value to FALSE but you are responsible to pay for query
	//   compute costs.
	//   - If you set the value to TRUE but you are not responsible to pay for query
	//   compute costs.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// The membership object listed by the request.
type MembershipSummary struct {

	// The unique ARN for the membership.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the membership's associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// The identifier of the Amazon Web Services principal that created the
	// collaboration. Currently only supports Amazon Web Services account ID.
	//
	// This member is required.
	CollaborationCreatorAccountId *string

	// The display name of the collaboration creator.
	//
	// This member is required.
	CollaborationCreatorDisplayName *string

	// The unique ID for the membership's collaboration.
	//
	// This member is required.
	CollaborationId *string

	// The name for the membership's collaboration.
	//
	// This member is required.
	CollaborationName *string

	// The time when the membership was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the membership's collaboration.
	//
	// This member is required.
	Id *string

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	MemberAbilities []MemberAbility

	// The payment responsibilities accepted by the collaboration member.
	//
	// This member is required.
	PaymentConfiguration *MembershipPaymentConfiguration

	// The status of the membership.
	//
	// This member is required.
	Status MembershipStatus

	// The time the membership metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Basic metadata used to construct a new member.
type MemberSpecification struct {

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	AccountId *string

	// The member's display name.
	//
	// This member is required.
	DisplayName *string

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	MemberAbilities []MemberAbility

	// The collaboration member's payment responsibilities set by the collaboration
	// creator. If the collaboration creator hasn't speciﬁed anyone as the member
	// paying for query compute costs, then the member who can query is the default
	// payer.
	PaymentConfiguration *PaymentConfiguration

	noSmithyDocumentSerde
}

// The member object listed by the request.
type MemberSummary struct {

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	Abilities []MemberAbility

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	AccountId *string

	// The time when the member was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The member's display name.
	//
	// This member is required.
	DisplayName *string

	// The collaboration member's payment responsibilities set by the collaboration
	// creator.
	//
	// This member is required.
	PaymentConfiguration *PaymentConfiguration

	// The status of the member.
	//
	// This member is required.
	Status MemberStatus

	// The time the member metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The unique ARN for the member's associated membership, if present.
	MembershipArn *string

	// The unique ID for the member's associated membership, if present.
	MembershipId *string

	noSmithyDocumentSerde
}

// An object representing the collaboration member's payment responsibilities set
// by the collaboration creator.
type PaymentConfiguration struct {

	// The collaboration member's payment responsibilities set by the collaboration
	// creator for query compute costs.
	//
	// This member is required.
	QueryCompute *QueryComputePaymentConfig

	noSmithyDocumentSerde
}

// Specifies the updated epsilon and noise parameters to preview. The preview
// allows you to see how the maximum number of each type of aggregation function
// would change with the new parameters.
//
// The following types satisfy this interface:
//
//	PreviewPrivacyImpactParametersInputMemberDifferentialPrivacy
type PreviewPrivacyImpactParametersInput interface {
	isPreviewPrivacyImpactParametersInput()
}

// An array that specifies the epsilon and noise parameters.
type PreviewPrivacyImpactParametersInputMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyPreviewParametersInput

	noSmithyDocumentSerde
}

func (*PreviewPrivacyImpactParametersInputMemberDifferentialPrivacy) isPreviewPrivacyImpactParametersInput() {
}

// The epsilon parameter value and number of each aggregation function that you
// can perform.
//
// The following types satisfy this interface:
//
//	PrivacyBudgetMemberDifferentialPrivacy
type PrivacyBudget interface {
	isPrivacyBudget()
}

// An object that specifies the epsilon parameter and the utility in terms of
// total aggregations, as well as the remaining aggregations available.
type PrivacyBudgetMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyPrivacyBudget

	noSmithyDocumentSerde
}

func (*PrivacyBudgetMemberDifferentialPrivacy) isPrivacyBudget() {}

// An array that summaries the specified privacy budget. This summary includes
// collaboration information, creation information, membership information, and
// privacy budget information.
type PrivacyBudgetSummary struct {

	// The provided privacy budget.
	//
	// This member is required.
	Budget PrivacyBudget

	// The ARN of the collaboration that contains this privacy budget.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that contains this privacy budget.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the privacy budget was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the privacy budget.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the member who created the privacy budget
	// summary.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for a membership resource.
	//
	// This member is required.
	MembershipId *string

	// The ARN of the privacy budget template.
	//
	// This member is required.
	PrivacyBudgetTemplateArn *string

	// The unique identifier of the privacy budget template.
	//
	// This member is required.
	PrivacyBudgetTemplateId *string

	// Specifies the type of the privacy budget.
	//
	// This member is required.
	Type PrivacyBudgetType

	// The most recent time at which the privacy budget was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// An object that defines the privacy budget template.
type PrivacyBudgetTemplate struct {

	// The ARN of the privacy budget template.
	//
	// This member is required.
	Arn *string

	// How often the privacy budget refreshes. If you plan to regularly bring new data
	// into the collaboration, use CALENDAR_MONTH to automatically get a new privacy
	// budget for the collaboration every calendar month. Choosing this option allows
	// arbitrary amounts of information to be revealed about rows of the data when
	// repeatedly queried across refreshes. Avoid choosing this if the same rows will
	// be repeatedly queried between privacy budget refreshes.
	//
	// This member is required.
	AutoRefresh PrivacyBudgetTemplateAutoRefresh

	// The ARN of the collaboration that contains this privacy budget template.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID of the collaboration that contains this privacy budget template.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the privacy budget template was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the privacy budget template.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the member who created the privacy budget
	// template.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for a membership resource.
	//
	// This member is required.
	MembershipId *string

	// Specifies the epislon and noise parameters for the privacy budget template.
	//
	// This member is required.
	Parameters PrivacyBudgetTemplateParametersOutput

	// Specifies the type of the privacy budget template.
	//
	// This member is required.
	PrivacyBudgetType PrivacyBudgetType

	// The most recent time at which the privacy budget template was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The epsilon and noise parameters that you want to use for the privacy budget
// template.
//
// The following types satisfy this interface:
//
//	PrivacyBudgetTemplateParametersInputMemberDifferentialPrivacy
type PrivacyBudgetTemplateParametersInput interface {
	isPrivacyBudgetTemplateParametersInput()
}

// An object that specifies the epsilon and noise parameters.
type PrivacyBudgetTemplateParametersInputMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyTemplateParametersInput

	noSmithyDocumentSerde
}

func (*PrivacyBudgetTemplateParametersInputMemberDifferentialPrivacy) isPrivacyBudgetTemplateParametersInput() {
}

// The epsilon and noise parameters that were used in the privacy budget template.
//
// The following types satisfy this interface:
//
//	PrivacyBudgetTemplateParametersOutputMemberDifferentialPrivacy
type PrivacyBudgetTemplateParametersOutput interface {
	isPrivacyBudgetTemplateParametersOutput()
}

// The epsilon and noise parameters.
type PrivacyBudgetTemplateParametersOutputMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyTemplateParametersOutput

	noSmithyDocumentSerde
}

func (*PrivacyBudgetTemplateParametersOutputMemberDifferentialPrivacy) isPrivacyBudgetTemplateParametersOutput() {
}

// A summary of the privacy budget template. The summary includes membership
// information, collaboration information, and creation information.
type PrivacyBudgetTemplateSummary struct {

	// The ARN of the privacy budget template.
	//
	// This member is required.
	Arn *string

	// The ARN of the collaboration that contains this privacy budget template.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID of the collaboration that contains this privacy budget template.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the privacy budget template was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the privacy budget template.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the member who created the privacy budget
	// template.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for a membership resource.
	//
	// This member is required.
	MembershipId *string

	// The type of the privacy budget template.
	//
	// This member is required.
	PrivacyBudgetType PrivacyBudgetType

	// The most recent time at which the privacy budget template was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The epsilon and noise parameters that you want to update in the privacy budget
// template.
//
// The following types satisfy this interface:
//
//	PrivacyBudgetTemplateUpdateParametersMemberDifferentialPrivacy
type PrivacyBudgetTemplateUpdateParameters interface {
	isPrivacyBudgetTemplateUpdateParameters()
}

// An object that specifies the new values for the epsilon and noise parameters.
type PrivacyBudgetTemplateUpdateParametersMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyTemplateUpdateParameters

	noSmithyDocumentSerde
}

func (*PrivacyBudgetTemplateUpdateParametersMemberDifferentialPrivacy) isPrivacyBudgetTemplateUpdateParameters() {
}

// Provides an estimate of the number of aggregation functions that the member who
// can query can run given the epsilon and noise parameters.
//
// The following types satisfy this interface:
//
//	PrivacyImpactMemberDifferentialPrivacy
type PrivacyImpact interface {
	isPrivacyImpact()
}

// An object that lists the number and type of aggregation functions you can
// perform.
type PrivacyImpactMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyPrivacyImpact

	noSmithyDocumentSerde
}

func (*PrivacyImpactMemberDifferentialPrivacy) isPrivacyImpact() {}

// The parameters for an Clean Rooms protected query.
type ProtectedQuery struct {

	// The time at which the protected query was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier for a protected query instance.
	//
	// This member is required.
	Id *string

	// The ARN of the membership.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for the membership.
	//
	// This member is required.
	MembershipId *string

	// The status of the query.
	//
	// This member is required.
	Status ProtectedQueryStatus

	// The sensitivity parameters of the differential privacy results of the protected
	// query.
	DifferentialPrivacy *DifferentialPrivacyParameters

	// An error thrown by the protected query.
	Error *ProtectedQueryError

	// The result of the protected query.
	Result *ProtectedQueryResult

	// Contains any details needed to write the query results.
	ResultConfiguration *ProtectedQueryResultConfiguration

	// The protected query SQL parameters.
	SqlParameters *ProtectedQuerySQLParameters

	// Statistics about protected query execution.
	Statistics *ProtectedQueryStatistics

	noSmithyDocumentSerde
}

// Details of errors thrown by the protected query.
type ProtectedQueryError struct {

	// An error code for the error.
	//
	// This member is required.
	Code *string

	// A description of why the query failed.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Contains details about the protected query output.
//
// The following types satisfy this interface:
//
//	ProtectedQueryOutputMemberMemberList
//	ProtectedQueryOutputMemberS3
type ProtectedQueryOutput interface {
	isProtectedQueryOutput()
}

// The list of member Amazon Web Services account(s) that received the results of
// the query.
type ProtectedQueryOutputMemberMemberList struct {
	Value []ProtectedQuerySingleMemberOutput

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputMemberMemberList) isProtectedQueryOutput() {}

// If present, the output for a protected query with an `S3` output type.
type ProtectedQueryOutputMemberS3 struct {
	Value ProtectedQueryS3Output

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputMemberS3) isProtectedQueryOutput() {}

// Contains configuration details for protected query output.
//
// The following types satisfy this interface:
//
//	ProtectedQueryOutputConfigurationMemberS3
type ProtectedQueryOutputConfiguration interface {
	isProtectedQueryOutputConfiguration()
}

// Required configuration for a protected query with an `S3` output type.
type ProtectedQueryOutputConfigurationMemberS3 struct {
	Value ProtectedQueryS3OutputConfiguration

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputConfigurationMemberS3) isProtectedQueryOutputConfiguration() {}

// Details about the query results.
type ProtectedQueryResult struct {

	// The output of the protected query.
	//
	// This member is required.
	Output ProtectedQueryOutput

	noSmithyDocumentSerde
}

// Contains configurations for protected query results.
type ProtectedQueryResultConfiguration struct {

	// Configuration for protected query results.
	//
	// This member is required.
	OutputConfiguration ProtectedQueryOutputConfiguration

	noSmithyDocumentSerde
}

// Contains output information for protected queries with an S3 output type.
type ProtectedQueryS3Output struct {

	// The S3 location of the result.
	//
	// This member is required.
	Location *string

	noSmithyDocumentSerde
}

// Contains the configuration to write the query results to S3.
type ProtectedQueryS3OutputConfiguration struct {

	// The S3 bucket to unload the protected query results.
	//
	// This member is required.
	Bucket *string

	// Intended file format of the result.
	//
	// This member is required.
	ResultFormat ResultFormat

	// The S3 prefix to unload the protected query results.
	KeyPrefix *string

	noSmithyDocumentSerde
}

// Details about the member who received the query result.
type ProtectedQuerySingleMemberOutput struct {

	// The Amazon Web Services account ID of the member in the collaboration who can
	// receive results for the query.
	//
	// This member is required.
	AccountId *string

	noSmithyDocumentSerde
}

// The parameters for the SQL type Protected Query.
type ProtectedQuerySQLParameters struct {

	// The Amazon Resource Name (ARN) associated with the analysis template within a
	// collaboration.
	AnalysisTemplateArn *string

	// The protected query SQL parameters.
	Parameters map[string]string

	// The query string to be submitted.
	QueryString *string

	noSmithyDocumentSerde
}

// Contains statistics about the execution of the protected query.
type ProtectedQueryStatistics struct {

	// The duration of the Protected Query, from creation until query completion.
	TotalDurationInMillis *int64

	noSmithyDocumentSerde
}

// The protected query summary for the objects listed by the request.
type ProtectedQuerySummary struct {

	// The time the protected query was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID of the protected query.
	//
	// This member is required.
	Id *string

	// The unique ARN for the membership that initiated the protected query.
	//
	// This member is required.
	MembershipArn *string

	// The unique ID for the membership that initiated the protected query.
	//
	// This member is required.
	MembershipId *string

	// The status of the protected query. Value values are `SUBMITTED`, `STARTED`,
	// `CANCELLED`, `CANCELLING`, `FAILED`, `SUCCESS`, `TIMED_OUT`.
	//
	// This member is required.
	Status ProtectedQueryStatus

	noSmithyDocumentSerde
}

// An object representing the collaboration member's payment responsibilities set
// by the collaboration creator for query compute costs.
type QueryComputePaymentConfig struct {

	// Indicates whether the collaboration creator has configured the collaboration
	// member to pay for query compute costs ( TRUE ) or has not configured the
	// collaboration member to pay for query compute costs ( FALSE ). Exactly one
	// member can be configured to pay for query compute costs. An error is returned if
	// the collaboration creator sets a TRUE value for more than one member in the
	// collaboration. If the collaboration creator hasn't specified anyone as the
	// member paying for query compute costs, then the member who can query is the
	// default payer. An error is returned if the collaboration creator sets a FALSE
	// value for the member who can query.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// A schema is a relation within a collaboration.
type Schema struct {

	// The analysis rule types associated with the schema. Currently, only one entry
	// is present.
	//
	// This member is required.
	AnalysisRuleTypes []AnalysisRuleType

	// The unique ARN for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationId *string

	// The columns for the relation this schema represents.
	//
	// This member is required.
	Columns []Column

	// The time the schema was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique account ID for the Amazon Web Services account that owns the schema.
	//
	// This member is required.
	CreatorAccountId *string

	// A description for the schema.
	//
	// This member is required.
	Description *string

	// A name for the schema. The schema relation is referred to by this name when
	// queried by a protected query.
	//
	// This member is required.
	Name *string

	// The partition keys for the dataset underlying this schema.
	//
	// This member is required.
	PartitionKeys []Column

	// The type of schema. The only valid value is currently `TABLE`.
	//
	// This member is required.
	Type SchemaType

	// The time the schema was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The analysis method for the schema. The only valid value is currently
	// DIRECT_QUERY.
	AnalysisMethod AnalysisMethod

	noSmithyDocumentSerde
}

// The schema summary for the objects listed by the request.
type SchemaSummary struct {

	// The types of analysis rules that are associated with this schema object.
	//
	// This member is required.
	AnalysisRuleTypes []AnalysisRuleType

	// The unique ARN for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationId *string

	// The time the schema object was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique account ID for the Amazon Web Services account that owns the schema.
	//
	// This member is required.
	CreatorAccountId *string

	// The name for the schema object.
	//
	// This member is required.
	Name *string

	// The type of schema object. The only valid schema type is currently `TABLE`.
	//
	// This member is required.
	Type SchemaType

	// The time the schema object was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The analysis method for the associated schema. The only valid value is
	// currently `DIRECT_QUERY`.
	AnalysisMethod AnalysisMethod

	noSmithyDocumentSerde
}

// A pointer to the dataset that underlies this table. Currently, this can only be
// an Glue table.
//
// The following types satisfy this interface:
//
//	TableReferenceMemberGlue
type TableReference interface {
	isTableReference()
}

// If present, a reference to the Glue table referred to by this table reference.
type TableReferenceMemberGlue struct {
	Value GlueTableReference

	noSmithyDocumentSerde
}

func (*TableReferenceMemberGlue) isTableReference() {}

// Describes validation errors for specific input parameters.
type ValidationExceptionField struct {

	// A message for the input validation error.
	//
	// This member is required.
	Message *string

	// The name of the input parameter.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAnalysisRulePolicy()                          {}
func (*UnknownUnionMember) isAnalysisRulePolicyV1()                        {}
func (*UnknownUnionMember) isAnalysisSource()                              {}
func (*UnknownUnionMember) isConfiguredTableAnalysisRulePolicy()           {}
func (*UnknownUnionMember) isConfiguredTableAnalysisRulePolicyV1()         {}
func (*UnknownUnionMember) isMembershipProtectedQueryOutputConfiguration() {}
func (*UnknownUnionMember) isPreviewPrivacyImpactParametersInput()         {}
func (*UnknownUnionMember) isPrivacyBudget()                               {}
func (*UnknownUnionMember) isPrivacyBudgetTemplateParametersInput()        {}
func (*UnknownUnionMember) isPrivacyBudgetTemplateParametersOutput()       {}
func (*UnknownUnionMember) isPrivacyBudgetTemplateUpdateParameters()       {}
func (*UnknownUnionMember) isPrivacyImpact()                               {}
func (*UnknownUnionMember) isProtectedQueryOutput()                        {}
func (*UnknownUnionMember) isProtectedQueryOutputConfiguration()           {}
func (*UnknownUnionMember) isTableReference()                              {}
