macro(CopyLibpackDirectories)
    # Copy libpack dependency directories to build folder for user as part of overall build process
    if(FREECAD_COPY_DEPEND_DIRS_TO_BUILD)
        message(STATUS "Copying libpack dependency directories to build directory...")
        file(COPY ${FREECAD_LIBPACK_DIR}/bin/assistant.exe DESTINATION ${CMAKE_BINARY_DIR}/bin)
        file(COPY ${FREECAD_LIBPACK_DIR}/bin/qt.conf DESTINATION ${CMAKE_BINARY_DIR}/bin)
        file(COPY ${FREECAD_LIBPACK_DIR}/plugins/platforms DESTINATION ${CMAKE_BINARY_DIR}/bin)
        file(COPY ${FREECAD_LIBPACK_DIR}/plugins/imageformats DESTINATION ${CMAKE_BINARY_DIR}/bin)
        file(COPY ${FREECAD_LIBPACK_DIR}/plugins/iconengines DESTINATION ${CMAKE_BINARY_DIR}/bin)
        file(COPY ${FREECAD_LIBPACK_DIR}/plugins/sqldrivers DESTINATION ${CMAKE_BINARY_DIR}/bin)
        file(COPY ${FREECAD_LIBPACK_DIR}/plugins/styles DESTINATION ${CMAKE_BINARY_DIR}/bin)
        if(NOT FREECAD_LIBPACK_VERSION VERSION_GREATER_EQUAL "3.0.0")
            file(COPY ${FREECAD_LIBPACK_DIR}/plugins/printsupport DESTINATION ${CMAKE_BINARY_DIR}/bin)
        endif()
        if(FREECAD_LIBPACK_VERSION VERSION_GREATER_EQUAL "3.0.0")
            file(COPY ${FREECAD_LIBPACK_DIR}/plugins/tls DESTINATION ${CMAKE_BINARY_DIR}/bin)
        endif()
        file(COPY ${FREECAD_LIBPACK_DIR}/resources DESTINATION ${CMAKE_BINARY_DIR})
        message(STATUS "... end copying.\n=======================================\n")
    endif()

    if(COPY_LIBPACK_BIN_TO_BUILD)
        if(FREECAD_COPY_LIBPACK_BIN_TO_BUILD)
            message("Copying LibPack 'bin' directory to build 'bin' directory...")
            file(COPY ${FREECAD_LIBPACK_DIR}/bin DESTINATION ${CMAKE_BINARY_DIR})
            if(FREECAD_LIBPACK_VERSION VERSION_GREATER_EQUAL "3.0.0")
                message("Copying DLLs from LibPack 'lib' directory to build 'bin' directory...")
                file(GLOB DLLS ${FREECAD_LIBPACK_DIR}/lib/*.dll)
                file(COPY ${DLLS} DESTINATION ${CMAKE_BINARY_DIR}/bin)
                file(GLOB DLLS ${FREECAD_LIBPACK_DIR}/bin/Lib/site-packages/shiboken6/shiboken*.dll)
                file(COPY ${DLLS} DESTINATION ${CMAKE_BINARY_DIR}/bin)
                file(GLOB DLLS ${FREECAD_LIBPACK_DIR}/bin/Lib/site-packages/PySide6/pyside6*.dll)
                file(COPY ${DLLS} DESTINATION ${CMAKE_BINARY_DIR}/bin)
            endif()
            message(STATUS "   ... done.")
        endif()
        if(FREECAD_COPY_PLUGINS_BIN_TO_BUILD)
            message(STATUS "=======================================\n"
                           "Copying plugins to build directory.")
            file(COPY ${FREECAD_LIBPACK_DIR}/plugins/imageformats DESTINATION ${CMAKE_BINARY_DIR}/bin)
            file(COPY ${FREECAD_LIBPACK_DIR}/plugins/platforms DESTINATION ${CMAKE_BINARY_DIR}/bin)
            file(COPY ${FREECAD_LIBPACK_DIR}/plugins/styles DESTINATION ${CMAKE_BINARY_DIR}/bin)
            file(COPY ${FREECAD_LIBPACK_DIR}/resources DESTINATION ${CMAKE_BINARY_DIR})
            file(WRITE ${CMAKE_BINARY_DIR}/bin/qt.conf "[Paths]\nPrefix=..\n")
        endif()
    endif()

    if(FREECAD_INSTALL_DEPEND_DIRS)
        # Test install command for installing/copying directories
        message(STATUS "=======================================")
        install(DIRECTORY ${FREECAD_LIBPACK_DIR}/plugins/platforms DESTINATION ${CMAKE_INSTALL_PREFIX}/bin)
        install(DIRECTORY ${FREECAD_LIBPACK_DIR}/plugins/imageformats DESTINATION ${CMAKE_INSTALL_PREFIX}/bin)
        install(DIRECTORY ${FREECAD_LIBPACK_DIR}/plugins/iconengines DESTINATION ${CMAKE_INSTALL_PREFIX}/bin)
        install(DIRECTORY ${FREECAD_LIBPACK_DIR}/plugins/sqldrivers DESTINATION ${CMAKE_INSTALL_PREFIX}/bin)
        install(DIRECTORY ${FREECAD_LIBPACK_DIR}/plugins/styles DESTINATION ${CMAKE_INSTALL_PREFIX}/bin)
        if(NOT FREECAD_LIBPACK_VERSION VERSION_GREATER_EQUAL "3.0.0")
            install(DIRECTORY ${FREECAD_LIBPACK_DIR}/plugins/printsupport DESTINATION ${CMAKE_INSTALL_PREFIX}/bin)
        endif()
        if(FREECAD_LIBPACK_VERSION VERSION_GREATER_EQUAL "3.0.0")
            install(DIRECTORY ${FREECAD_LIBPACK_DIR}/plugins/tls DESTINATION ${CMAKE_INSTALL_PREFIX}/bin)
        endif()
        install(DIRECTORY ${FREECAD_LIBPACK_DIR}/resources DESTINATION ${CMAKE_INSTALL_PREFIX})
        install(DIRECTORY ${FREECAD_LIBPACK_DIR}/bin DESTINATION ${CMAKE_INSTALL_PREFIX})
        install(DIRECTORY ${FREECAD_LIBPACK_DIR}/lib DESTINATION ${CMAKE_INSTALL_PREFIX} FILES_MATCHING PATTERN "*.dll")
        if(FREECAD_LIBPACK_VERSION VERSION_GREATER_EQUAL "3.0.0")
            # Trailing slashes make sure that cMake extracts the files from the directory, rather than taking the
            # directory with it
            install(DIRECTORY ${FREECAD_LIBPACK_DIR}/lib/ DESTINATION ${CMAKE_INSTALL_PREFIX}/bin FILES_MATCHING PATTERN "*.dll")
            install(DIRECTORY ${FREECAD_LIBPACK_DIR}/bin/Lib/site-packages/shiboken6/ DESTINATION ${CMAKE_INSTALL_PREFIX}/bin FILES_MATCHING PATTERN "shiboken*.dll")
            install(DIRECTORY ${FREECAD_LIBPACK_DIR}/bin/Lib/site-packages/PySide6/ DESTINATION ${CMAKE_INSTALL_PREFIX}/bin FILES_MATCHING PATTERN "pyside6*.dll")
        endif()
        message(STATUS "Created install commands for INSTALL target.\n")
    endif()
endmacro()
