"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindDefaultRuleTypes = bindDefaultRuleTypes;
exports.bindDefaultRulesAndFunctions = bindDefaultRulesAndFunctions;
const file_list_1 = require("../predefined-functions/file-list");
const file_1 = require("./file");
const oracle_1 = require("./oracle");
const phony_1 = require("./phony");
const self_tracking_1 = require("./self-tracking");
const task_1 = require("./task");
function bindDefaultRuleTypes(cfg, dir) {
    return {
        ...(0, oracle_1.Oracle)(dir),
        ...(0, file_1.File)(cfg, dir),
        ...(0, task_1.Task)(dir),
        ...(0, phony_1.Phony)(dir),
        SelfTracking: (0, self_tracking_1.SelfTracking)(dir)
    };
}
function bindDefaultRulesAndFunctions(cfg, dir) {
    const implF = (0, file_1.ImplicitFileRules)(cfg, dir);
    const FileList = (0, file_list_1.BindFileList)(implF.ds);
    return {
        rules: {
            ...implF
        },
        predefinedFuncs: {
            FileList
        }
    };
}
