/*
 * SPDX-FileCopyrightText: 2017~2017 CSSlayer <wengxt@gmail.com>
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */

#include "qtkey.h"

#include <QHash>
#include <QString>
#include <ctype.h>
#include <qnamespace.h>
#include <unordered_map>
#include <xkbcommon/xkbcommon.h>

const std::unordered_map<uint32_t, int> &KeyTbl() {
    static std::unordered_map<uint32_t, int> keyTbl{
        std::make_pair(XKB_KEY_KP_Space, Qt::Key_Space),
        std::make_pair(XKB_KEY_KP_Tab, Qt::Key_Tab),
        std::make_pair(XKB_KEY_KP_Enter, Qt::Key_Enter),
        std::make_pair(XKB_KEY_KP_F1, Qt::Key_F1),
        std::make_pair(XKB_KEY_KP_F2, Qt::Key_F2),
        std::make_pair(XKB_KEY_KP_F3, Qt::Key_F3),
        std::make_pair(XKB_KEY_KP_F4, Qt::Key_F4),
        std::make_pair(XKB_KEY_KP_Home, Qt::Key_Home),
        std::make_pair(XKB_KEY_KP_Left, Qt::Key_Left),
        std::make_pair(XKB_KEY_KP_Up, Qt::Key_Up),
        std::make_pair(XKB_KEY_KP_Right, Qt::Key_Right),
        std::make_pair(XKB_KEY_KP_Down, Qt::Key_Down),
        std::make_pair(XKB_KEY_KP_Page_Up, Qt::Key_PageUp),
        std::make_pair(XKB_KEY_KP_Page_Down, Qt::Key_PageDown),
        std::make_pair(XKB_KEY_KP_End, Qt::Key_End),
        std::make_pair(XKB_KEY_KP_Begin, Qt::Key_Clear),
        std::make_pair(XKB_KEY_KP_Insert, Qt::Key_Insert),
        std::make_pair(XKB_KEY_KP_Delete, Qt::Key_Delete),
        std::make_pair(XKB_KEY_KP_Equal, Qt::Key_Equal),
        std::make_pair(XKB_KEY_KP_Multiply, Qt::Key_multiply),
        std::make_pair(XKB_KEY_KP_Add, Qt::Key_Plus),
        std::make_pair(XKB_KEY_KP_Separator, Qt::Key_Comma),
        std::make_pair(XKB_KEY_KP_Subtract, Qt::Key_Minus),
        std::make_pair(XKB_KEY_KP_Decimal, Qt::Key_Period),
        std::make_pair(XKB_KEY_KP_Divide, Qt::Key_Slash),

        std::make_pair(XKB_KEY_KP_0, Qt::Key_0),
        std::make_pair(XKB_KEY_KP_1, Qt::Key_1),
        std::make_pair(XKB_KEY_KP_2, Qt::Key_2),
        std::make_pair(XKB_KEY_KP_3, Qt::Key_3),
        std::make_pair(XKB_KEY_KP_4, Qt::Key_4),
        std::make_pair(XKB_KEY_KP_5, Qt::Key_5),
        std::make_pair(XKB_KEY_KP_6, Qt::Key_6),
        std::make_pair(XKB_KEY_KP_7, Qt::Key_7),
        std::make_pair(XKB_KEY_KP_8, Qt::Key_8),
        std::make_pair(XKB_KEY_KP_9, Qt::Key_9),

        std::make_pair(XKB_KEY_Escape, Qt::Key_Escape),
        std::make_pair(XKB_KEY_Tab, Qt::Key_Tab),
        std::make_pair(XKB_KEY_ISO_Left_Tab, Qt::Key_Backtab),
        std::make_pair(XKB_KEY_BackSpace, Qt::Key_Backspace),
        std::make_pair(XKB_KEY_Return, Qt::Key_Return),
        std::make_pair(XKB_KEY_KP_Enter, Qt::Key_Enter),
        std::make_pair(XKB_KEY_Insert, Qt::Key_Insert),
        std::make_pair(XKB_KEY_Delete, Qt::Key_Delete),
        std::make_pair(XKB_KEY_Clear, Qt::Key_Delete),
        std::make_pair(XKB_KEY_Pause, Qt::Key_Pause),
        std::make_pair(XKB_KEY_Print, Qt::Key_Print),
        std::make_pair(XKB_KEY_Sys_Req, Qt::Key_SysReq),
        std::make_pair(0x1005FF60, Qt::Key_SysReq),
        std::make_pair(0x1007ff00, Qt::Key_SysReq),

        std::make_pair(XKB_KEY_Home, Qt::Key_Home),
        std::make_pair(XKB_KEY_End, Qt::Key_End),
        std::make_pair(XKB_KEY_Left, Qt::Key_Left),
        std::make_pair(XKB_KEY_Up, Qt::Key_Up),
        std::make_pair(XKB_KEY_Right, Qt::Key_Right),
        std::make_pair(XKB_KEY_Down, Qt::Key_Down),
        std::make_pair(XKB_KEY_Page_Up, Qt::Key_PageUp),
        std::make_pair(XKB_KEY_Page_Down, Qt::Key_PageDown),
        std::make_pair(XKB_KEY_Shift_L, Qt::Key_Shift),
        std::make_pair(XKB_KEY_Shift_R, Qt::Key_Shift),
        std::make_pair(XKB_KEY_Shift_Lock, Qt::Key_Shift),
        std::make_pair(XKB_KEY_Control_L, Qt::Key_Control),
        std::make_pair(XKB_KEY_Control_R, Qt::Key_Control),
        std::make_pair(XKB_KEY_Meta_L, Qt::Key_Meta),
        std::make_pair(XKB_KEY_Meta_R, Qt::Key_Meta),
        std::make_pair(XKB_KEY_Alt_L, Qt::Key_Alt),
        std::make_pair(XKB_KEY_Alt_R, Qt::Key_Alt),
        std::make_pair(XKB_KEY_Caps_Lock, Qt::Key_CapsLock),
        std::make_pair(XKB_KEY_Num_Lock, Qt::Key_NumLock),
        std::make_pair(XKB_KEY_Scroll_Lock, Qt::Key_ScrollLock),
        std::make_pair(XKB_KEY_F1, Qt::Key_F1),
        std::make_pair(XKB_KEY_F2, Qt::Key_F2),
        std::make_pair(XKB_KEY_F3, Qt::Key_F3),
        std::make_pair(XKB_KEY_F4, Qt::Key_F4),
        std::make_pair(XKB_KEY_F5, Qt::Key_F5),
        std::make_pair(XKB_KEY_F6, Qt::Key_F6),
        std::make_pair(XKB_KEY_F7, Qt::Key_F7),
        std::make_pair(XKB_KEY_F8, Qt::Key_F8),
        std::make_pair(XKB_KEY_F9, Qt::Key_F9),
        std::make_pair(XKB_KEY_F10, Qt::Key_F10),
        std::make_pair(XKB_KEY_F11, Qt::Key_F11),
        std::make_pair(XKB_KEY_F12, Qt::Key_F12),
        std::make_pair(XKB_KEY_F13, Qt::Key_F13),
        std::make_pair(XKB_KEY_F14, Qt::Key_F14),
        std::make_pair(XKB_KEY_F15, Qt::Key_F15),
        std::make_pair(XKB_KEY_F16, Qt::Key_F16),
        std::make_pair(XKB_KEY_F17, Qt::Key_F17),
        std::make_pair(XKB_KEY_F18, Qt::Key_F18),
        std::make_pair(XKB_KEY_F19, Qt::Key_F19),
        std::make_pair(XKB_KEY_F20, Qt::Key_F20),
        std::make_pair(XKB_KEY_F21, Qt::Key_F21),
        std::make_pair(XKB_KEY_F22, Qt::Key_F22),
        std::make_pair(XKB_KEY_F23, Qt::Key_F23),
        std::make_pair(XKB_KEY_F24, Qt::Key_F24),
        std::make_pair(XKB_KEY_F25, Qt::Key_F25),
        std::make_pair(XKB_KEY_F26, Qt::Key_F26),
        std::make_pair(XKB_KEY_F27, Qt::Key_F27),
        std::make_pair(XKB_KEY_F28, Qt::Key_F28),
        std::make_pair(XKB_KEY_F29, Qt::Key_F29),
        std::make_pair(XKB_KEY_F30, Qt::Key_F30),
        std::make_pair(XKB_KEY_F31, Qt::Key_F31),
        std::make_pair(XKB_KEY_F32, Qt::Key_F32),
        std::make_pair(XKB_KEY_F33, Qt::Key_F33),
        std::make_pair(XKB_KEY_F34, Qt::Key_F34),
        std::make_pair(XKB_KEY_F35, Qt::Key_F35),
        std::make_pair(XKB_KEY_Super_L, Qt::Key_Super_L),
        std::make_pair(XKB_KEY_Super_R, Qt::Key_Super_R),
        std::make_pair(XKB_KEY_Menu, Qt::Key_Menu),
        std::make_pair(XKB_KEY_Hyper_L, Qt::Key_Hyper_L),
        std::make_pair(XKB_KEY_Hyper_R, Qt::Key_Hyper_R),
        std::make_pair(XKB_KEY_Help, Qt::Key_Help),
        std::make_pair(XKB_KEY_ISO_Level3_Shift, Qt::Key_AltGr),
        std::make_pair(XKB_KEY_Multi_key, Qt::Key_Multi_key),
        std::make_pair(XKB_KEY_Codeinput, Qt::Key_Codeinput),
        std::make_pair(XKB_KEY_SingleCandidate, Qt::Key_SingleCandidate),
        std::make_pair(XKB_KEY_MultipleCandidate, Qt::Key_MultipleCandidate),
        std::make_pair(XKB_KEY_PreviousCandidate, Qt::Key_PreviousCandidate),
        std::make_pair(XKB_KEY_Mode_switch, Qt::Key_Mode_switch),
        std::make_pair(XKB_KEY_script_switch, Qt::Key_Mode_switch),
        std::make_pair(XKB_KEY_Kanji, Qt::Key_Kanji),
        std::make_pair(XKB_KEY_Muhenkan, Qt::Key_Muhenkan),
        std::make_pair(XKB_KEY_Henkan, Qt::Key_Henkan),
        std::make_pair(XKB_KEY_Romaji, Qt::Key_Romaji),
        std::make_pair(XKB_KEY_Hiragana, Qt::Key_Hiragana),
        std::make_pair(XKB_KEY_Katakana, Qt::Key_Katakana),
        std::make_pair(XKB_KEY_Hiragana_Katakana, Qt::Key_Hiragana_Katakana),
        std::make_pair(XKB_KEY_Zenkaku, Qt::Key_Zenkaku),
        std::make_pair(XKB_KEY_Hankaku, Qt::Key_Hankaku),
        std::make_pair(XKB_KEY_Zenkaku_Hankaku, Qt::Key_Zenkaku_Hankaku),
        std::make_pair(XKB_KEY_Touroku, Qt::Key_Touroku),
        std::make_pair(XKB_KEY_Massyo, Qt::Key_Massyo),
        std::make_pair(XKB_KEY_Kana_Lock, Qt::Key_Kana_Lock),
        std::make_pair(XKB_KEY_Kana_Shift, Qt::Key_Kana_Shift),
        std::make_pair(XKB_KEY_Eisu_Shift, Qt::Key_Eisu_Shift),
        std::make_pair(XKB_KEY_Eisu_toggle, Qt::Key_Eisu_toggle),
        std::make_pair(XKB_KEY_Kanji_Bangou, Qt::Key_Codeinput),
        std::make_pair(XKB_KEY_Zen_Koho, Qt::Key_MultipleCandidate),
        std::make_pair(XKB_KEY_Mae_Koho, Qt::Key_PreviousCandidate),
        std::make_pair(XKB_KEY_Hangul, Qt::Key_Hangul),
        std::make_pair(XKB_KEY_Hangul_Start, Qt::Key_Hangul_Start),
        std::make_pair(XKB_KEY_Hangul_End, Qt::Key_Hangul_End),
        std::make_pair(XKB_KEY_Hangul_Hanja, Qt::Key_Hangul_Hanja),
        std::make_pair(XKB_KEY_Hangul_Jamo, Qt::Key_Hangul_Jamo),
        std::make_pair(XKB_KEY_Hangul_Romaja, Qt::Key_Hangul_Romaja),
        std::make_pair(XKB_KEY_Hangul_Codeinput, Qt::Key_Codeinput),
        std::make_pair(XKB_KEY_Hangul_Jeonja, Qt::Key_Hangul_Jeonja),
        std::make_pair(XKB_KEY_Hangul_Banja, Qt::Key_Hangul_Banja),
        std::make_pair(XKB_KEY_Hangul_PreHanja, Qt::Key_Hangul_PreHanja),
        std::make_pair(XKB_KEY_Hangul_PostHanja, Qt::Key_Hangul_PostHanja),
        std::make_pair(XKB_KEY_Hangul_SingleCandidate, Qt::Key_SingleCandidate),
        std::make_pair(XKB_KEY_Hangul_MultipleCandidate,
                       Qt::Key_MultipleCandidate),
        std::make_pair(XKB_KEY_Hangul_PreviousCandidate,
                       Qt::Key_PreviousCandidate),
        std::make_pair(XKB_KEY_Hangul_Special, Qt::Key_Hangul_Special),
        std::make_pair(XKB_KEY_Hangul_switch, Qt::Key_Mode_switch),
        std::make_pair(XKB_KEY_dead_grave, Qt::Key_Dead_Grave),
        std::make_pair(XKB_KEY_dead_acute, Qt::Key_Dead_Acute),
        std::make_pair(XKB_KEY_dead_circumflex, Qt::Key_Dead_Circumflex),
        std::make_pair(XKB_KEY_dead_tilde, Qt::Key_Dead_Tilde),
        std::make_pair(XKB_KEY_dead_macron, Qt::Key_Dead_Macron),
        std::make_pair(XKB_KEY_dead_breve, Qt::Key_Dead_Breve),
        std::make_pair(XKB_KEY_dead_abovedot, Qt::Key_Dead_Abovedot),
        std::make_pair(XKB_KEY_dead_diaeresis, Qt::Key_Dead_Diaeresis),
        std::make_pair(XKB_KEY_dead_abovering, Qt::Key_Dead_Abovering),
        std::make_pair(XKB_KEY_dead_doubleacute, Qt::Key_Dead_Doubleacute),
        std::make_pair(XKB_KEY_dead_caron, Qt::Key_Dead_Caron),
        std::make_pair(XKB_KEY_dead_cedilla, Qt::Key_Dead_Cedilla),
        std::make_pair(XKB_KEY_dead_ogonek, Qt::Key_Dead_Ogonek),
        std::make_pair(XKB_KEY_dead_iota, Qt::Key_Dead_Iota),
        std::make_pair(XKB_KEY_dead_voiced_sound, Qt::Key_Dead_Voiced_Sound),
        std::make_pair(XKB_KEY_dead_semivoiced_sound,
                       Qt::Key_Dead_Semivoiced_Sound),
        std::make_pair(XKB_KEY_dead_belowdot, Qt::Key_Dead_Belowdot),
        std::make_pair(XKB_KEY_dead_hook, Qt::Key_Dead_Hook),
        std::make_pair(XKB_KEY_dead_horn, Qt::Key_Dead_Horn),
        std::make_pair(XKB_KEY_XF86Back, Qt::Key_Back),
        std::make_pair(XKB_KEY_XF86Forward, Qt::Key_Forward),
        std::make_pair(XKB_KEY_XF86Stop, Qt::Key_Stop),
        std::make_pair(XKB_KEY_XF86Refresh, Qt::Key_Refresh),
        std::make_pair(XKB_KEY_XF86AudioLowerVolume, Qt::Key_VolumeDown),
        std::make_pair(XKB_KEY_XF86AudioMute, Qt::Key_VolumeMute),
        std::make_pair(XKB_KEY_XF86AudioRaiseVolume, Qt::Key_VolumeUp),
        std::make_pair(XKB_KEY_XF86AudioPlay, Qt::Key_MediaPlay),
        std::make_pair(XKB_KEY_XF86AudioStop, Qt::Key_MediaStop),
        std::make_pair(XKB_KEY_XF86AudioPrev, Qt::Key_MediaPrevious),
        std::make_pair(XKB_KEY_XF86AudioNext, Qt::Key_MediaNext),
        std::make_pair(XKB_KEY_XF86AudioRecord, Qt::Key_MediaRecord),
        std::make_pair(XKB_KEY_XF86AudioPause, Qt::Key_MediaPause),
        std::make_pair(XKB_KEY_XF86HomePage, Qt::Key_HomePage),
        std::make_pair(XKB_KEY_XF86Favorites, Qt::Key_Favorites),
        std::make_pair(XKB_KEY_XF86Search, Qt::Key_Search),
        std::make_pair(XKB_KEY_XF86Standby, Qt::Key_Standby),
        std::make_pair(XKB_KEY_XF86OpenURL, Qt::Key_OpenUrl),
        std::make_pair(XKB_KEY_XF86Mail, Qt::Key_LaunchMail),
        std::make_pair(XKB_KEY_XF86AudioMedia, Qt::Key_LaunchMedia),
        std::make_pair(XKB_KEY_XF86MyComputer, Qt::Key_Launch0),
        std::make_pair(XKB_KEY_XF86Calculator, Qt::Key_Launch1),
        std::make_pair(XKB_KEY_XF86Launch0, Qt::Key_Launch2),
        std::make_pair(XKB_KEY_XF86Launch1, Qt::Key_Launch3),
        std::make_pair(XKB_KEY_XF86Launch2, Qt::Key_Launch4),
        std::make_pair(XKB_KEY_XF86Launch3, Qt::Key_Launch5),
        std::make_pair(XKB_KEY_XF86Launch4, Qt::Key_Launch6),
        std::make_pair(XKB_KEY_XF86Launch5, Qt::Key_Launch7),
        std::make_pair(XKB_KEY_XF86Launch6, Qt::Key_Launch8),
        std::make_pair(XKB_KEY_XF86Launch7, Qt::Key_Launch9),
        std::make_pair(XKB_KEY_XF86Launch8, Qt::Key_LaunchA),
        std::make_pair(XKB_KEY_XF86Launch9, Qt::Key_LaunchB),
        std::make_pair(XKB_KEY_XF86LaunchA, Qt::Key_LaunchC),
        std::make_pair(XKB_KEY_XF86LaunchB, Qt::Key_LaunchD),
        std::make_pair(XKB_KEY_XF86LaunchC, Qt::Key_LaunchE),
        std::make_pair(XKB_KEY_XF86LaunchD, Qt::Key_LaunchF),
        std::make_pair(XKB_KEY_XF86MonBrightnessUp, Qt::Key_MonBrightnessUp),
        std::make_pair(XKB_KEY_XF86MonBrightnessDown,
                       Qt::Key_MonBrightnessDown),
        std::make_pair(XKB_KEY_XF86KbdLightOnOff, Qt::Key_KeyboardLightOnOff),
        std::make_pair(XKB_KEY_XF86KbdBrightnessUp,
                       Qt::Key_KeyboardBrightnessUp),
        std::make_pair(XKB_KEY_XF86KbdBrightnessDown,
                       Qt::Key_KeyboardBrightnessDown),
        std::make_pair(XKB_KEY_XF86PowerOff, Qt::Key_PowerOff),
        std::make_pair(XKB_KEY_XF86WakeUp, Qt::Key_WakeUp),
        std::make_pair(XKB_KEY_XF86Eject, Qt::Key_Eject),
        std::make_pair(XKB_KEY_XF86ScreenSaver, Qt::Key_ScreenSaver),
        std::make_pair(XKB_KEY_XF86WWW, Qt::Key_WWW),
        std::make_pair(XKB_KEY_XF86Memo, Qt::Key_Memo),
        std::make_pair(XKB_KEY_XF86LightBulb, Qt::Key_LightBulb),
        std::make_pair(XKB_KEY_XF86Shop, Qt::Key_Shop),
        std::make_pair(XKB_KEY_XF86History, Qt::Key_History),
        std::make_pair(XKB_KEY_XF86AddFavorite, Qt::Key_AddFavorite),
        std::make_pair(XKB_KEY_XF86HotLinks, Qt::Key_HotLinks),
        std::make_pair(XKB_KEY_XF86BrightnessAdjust, Qt::Key_BrightnessAdjust),
        std::make_pair(XKB_KEY_XF86Finance, Qt::Key_Finance),
        std::make_pair(XKB_KEY_XF86Community, Qt::Key_Community),
        std::make_pair(XKB_KEY_XF86AudioRewind, Qt::Key_AudioRewind),
        std::make_pair(XKB_KEY_XF86BackForward, Qt::Key_BackForward),
        std::make_pair(XKB_KEY_XF86ApplicationLeft, Qt::Key_ApplicationLeft),
        std::make_pair(XKB_KEY_XF86ApplicationRight, Qt::Key_ApplicationRight),
        std::make_pair(XKB_KEY_XF86Book, Qt::Key_Book),
        std::make_pair(XKB_KEY_XF86CD, Qt::Key_CD),
        std::make_pair(XKB_KEY_XF86Calculater, Qt::Key_Calculator),
        std::make_pair(XKB_KEY_XF86ToDoList, Qt::Key_ToDoList),
        std::make_pair(XKB_KEY_XF86ClearGrab, Qt::Key_ClearGrab),
        std::make_pair(XKB_KEY_XF86Close, Qt::Key_Close),
        std::make_pair(XKB_KEY_XF86Copy, Qt::Key_Copy),
        std::make_pair(XKB_KEY_XF86Cut, Qt::Key_Cut),
        std::make_pair(XKB_KEY_XF86Display, Qt::Key_Display),
        std::make_pair(XKB_KEY_XF86DOS, Qt::Key_DOS),
        std::make_pair(XKB_KEY_XF86Documents, Qt::Key_Documents),
        std::make_pair(XKB_KEY_XF86Excel, Qt::Key_Excel),
        std::make_pair(XKB_KEY_XF86Explorer, Qt::Key_Explorer),
        std::make_pair(XKB_KEY_XF86Game, Qt::Key_Game),
        std::make_pair(XKB_KEY_XF86Go, Qt::Key_Go),
        std::make_pair(XKB_KEY_XF86iTouch, Qt::Key_iTouch),
        std::make_pair(XKB_KEY_XF86LogOff, Qt::Key_LogOff),
        std::make_pair(XKB_KEY_XF86Market, Qt::Key_Market),
        std::make_pair(XKB_KEY_XF86Meeting, Qt::Key_Meeting),
        std::make_pair(XKB_KEY_XF86MenuKB, Qt::Key_MenuKB),
        std::make_pair(XKB_KEY_XF86MenuPB, Qt::Key_MenuPB),
        std::make_pair(XKB_KEY_XF86MySites, Qt::Key_MySites),
        std::make_pair(XKB_KEY_XF86News, Qt::Key_News),
        std::make_pair(XKB_KEY_XF86OfficeHome, Qt::Key_OfficeHome),
        std::make_pair(XKB_KEY_XF86Option, Qt::Key_Option),
        std::make_pair(XKB_KEY_XF86Paste, Qt::Key_Paste),
        std::make_pair(XKB_KEY_XF86Phone, Qt::Key_Phone),
        std::make_pair(XKB_KEY_XF86Calendar, Qt::Key_Calendar),
        std::make_pair(XKB_KEY_XF86Reply, Qt::Key_Reply),
        std::make_pair(XKB_KEY_XF86Reload, Qt::Key_Reload),
        std::make_pair(XKB_KEY_XF86RotateWindows, Qt::Key_RotateWindows),
        std::make_pair(XKB_KEY_XF86RotationPB, Qt::Key_RotationPB),
        std::make_pair(XKB_KEY_XF86RotationKB, Qt::Key_RotationKB),
        std::make_pair(XKB_KEY_XF86Save, Qt::Key_Save),
        std::make_pair(XKB_KEY_XF86Send, Qt::Key_Send),
        std::make_pair(XKB_KEY_XF86Spell, Qt::Key_Spell),
        std::make_pair(XKB_KEY_XF86SplitScreen, Qt::Key_SplitScreen),
        std::make_pair(XKB_KEY_XF86Support, Qt::Key_Support),
        std::make_pair(XKB_KEY_XF86TaskPane, Qt::Key_TaskPane),
        std::make_pair(XKB_KEY_XF86Terminal, Qt::Key_Terminal),
        std::make_pair(XKB_KEY_XF86Tools, Qt::Key_Tools),
        std::make_pair(XKB_KEY_XF86Travel, Qt::Key_Travel),
        std::make_pair(XKB_KEY_XF86Video, Qt::Key_Video),
        std::make_pair(XKB_KEY_XF86Word, Qt::Key_Word),
        std::make_pair(XKB_KEY_XF86Xfer, Qt::Key_Xfer),
        std::make_pair(XKB_KEY_XF86ZoomIn, Qt::Key_ZoomIn),
        std::make_pair(XKB_KEY_XF86ZoomOut, Qt::Key_ZoomOut),
        std::make_pair(XKB_KEY_XF86Away, Qt::Key_Away),
        std::make_pair(XKB_KEY_XF86Messenger, Qt::Key_Messenger),
        std::make_pair(XKB_KEY_XF86WebCam, Qt::Key_WebCam),
        std::make_pair(XKB_KEY_XF86MailForward, Qt::Key_MailForward),
        std::make_pair(XKB_KEY_XF86Pictures, Qt::Key_Pictures),
        std::make_pair(XKB_KEY_XF86Music, Qt::Key_Music),
        std::make_pair(XKB_KEY_XF86Battery, Qt::Key_Battery),
        std::make_pair(XKB_KEY_XF86Bluetooth, Qt::Key_Bluetooth),
        std::make_pair(XKB_KEY_XF86WLAN, Qt::Key_WLAN),
        std::make_pair(XKB_KEY_XF86UWB, Qt::Key_UWB),
        std::make_pair(XKB_KEY_XF86AudioForward, Qt::Key_AudioForward),
        std::make_pair(XKB_KEY_XF86AudioRepeat, Qt::Key_AudioRepeat),
        std::make_pair(XKB_KEY_XF86AudioRandomPlay, Qt::Key_AudioRandomPlay),
        std::make_pair(XKB_KEY_XF86Subtitle, Qt::Key_Subtitle),
        std::make_pair(XKB_KEY_XF86AudioCycleTrack, Qt::Key_AudioCycleTrack),
        std::make_pair(XKB_KEY_XF86Time, Qt::Key_Time),
        std::make_pair(XKB_KEY_XF86Hibernate, Qt::Key_Hibernate),
        std::make_pair(XKB_KEY_XF86View, Qt::Key_View),
        std::make_pair(XKB_KEY_XF86TopMenu, Qt::Key_TopMenu),
        std::make_pair(XKB_KEY_XF86PowerDown, Qt::Key_PowerDown),
        std::make_pair(XKB_KEY_XF86Suspend, Qt::Key_Suspend),
        std::make_pair(XKB_KEY_XF86ContrastAdjust, Qt::Key_ContrastAdjust),

        std::make_pair(XKB_KEY_XF86LaunchE, Qt::Key_LaunchG),
        std::make_pair(XKB_KEY_XF86LaunchF, Qt::Key_LaunchH),

        std::make_pair(XKB_KEY_XF86Select, Qt::Key_Select),
        std::make_pair(XKB_KEY_Cancel, Qt::Key_Cancel),
        std::make_pair(XKB_KEY_Execute, Qt::Key_Execute),
        std::make_pair(XKB_KEY_XF86Sleep, Qt::Key_Sleep),
    };
    return keyTbl;
}

int keysymToQtKey(uint32_t key) {
    auto iter = KeyTbl().find(key);
    if (iter != KeyTbl().end()) {
        return iter->second;
    }
    return 0;
}

int keysymToQtKey(uint32_t keysym, const QString &text) {
    int code = 0;
    if (keysym < 128) {
        // upper-case key, if known
        code = isprint((int)keysym) ? toupper((int)keysym) : 0;
    } else if (text.length() == 1 && text.unicode()->unicode() > 0x1f &&
               text.unicode()->unicode() != 0x7f &&
               !(keysym >= XKB_KEY_dead_grave &&
                 keysym <= XKB_KEY_dead_currency)) {
        code = text.unicode()->toUpper().unicode();
    } else {
        // any other keys
        code = keysymToQtKey(keysym);
    }

    return code;
}
