/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

using GLib;

[GtkTemplate (ui = "/org/gnome/DejaDup/ServerAddressHelp.ui")]
class ServerAddressHelp : Gtk.Box
{
  [GtkChild]
  unowned Gtk.Label address_header;
  [GtkChild]
  unowned Gtk.Label protocol_header;
  [GtkChild]
  unowned Gtk.Label prefix_header;

  construct {
    // Set these attributes here, because at the time of writing, Blueprint
    // does not support pango attributes.
    // https://gitlab.gnome.org/GNOME/blueprint-compiler/-/issues/203
    var bold = Pango.AttrList.from_string("weight bold");
    address_header.attributes = bold;
    protocol_header.attributes = bold;
    prefix_header.attributes = bold;
  }
}
