# Contributing

The "YAML-LibYAML" Project needs your help!

Please consider being a contributor. This file contains instructions that will
help you be an effective contributor to the Project.

## GitHub

The code for this Project is hosted at GitHub. The URL is:

  https://github.com/ingydotnet/yaml-libyaml-pm

You can get the code with this command:

  git clone https://github.com/ingydotnet/yaml-libyaml-pm

If you've found a bug or a missing feature that you would like the author to
know about, report it here:

  https://github.com/ingydotnet/yaml-libyaml-pm/issues

or fix it and submit a pull request here:

  https://github.com/ingydotnet/yaml-libyaml-pm/pulls

See these links for help on interacting with GitHub:

* https://help.github.com/
* https://help.github.com/articles/creating-a-pull-request

## IRC

YAML-LibYAML has an IRC channel where you can find real people to help you:

  irc.perl.org#yaml

Join the channel. Join the team!


    Thanks in advance,

## Commits

Try to follow these guidelines:

* Commit messages
  * Short commit message headline (if possible, up to 60 characters)
  * Blank line before message body
  * Message should be like: "Add foo ...", "Fix ..."
* Git workflow
  * Every branch will be rebased before merging it with --no-ff
  * No merging of master into feature branch
  * User branches might be heavily rebased/reordered/squashed because
    we like a clean history

## Code

* No Tabs please
* No trailing whitespace please
* Look at existing code for formatting ;-)

